'use strict';

var ngApp = angular.module('myNgApp', ['ngSanitize']);

ngApp.controller('AppCtrl', ['$scope', '$http', '$timeout', '$sce', function($scope, $http, $timeout, $sce)
{
  $scope.showPageNoDiv = true;
  $scope.documents = [];
  $scope.document = {};
  $scope.pageQueue = [];
  $scope.noOfPageToLoad = 2;
  $scope.references = [];
  $scope.filter = {};
  $scope.filter.exactMatch = false;
  $scope.filter.showSecondaryLabel = false;
  $scope.filterData = [];
  $scope.triggerFocused = false;
  $scope.triggerFocusedElement = "";

  $scope.viewerData = [{"EntityName":"Awilco Drilling PLC","DocumentName":"Annual Report_12/31/2021","FileName":"213800GETNUFDN7CEI51-2021-12-31.zip","Version":3,"RoundVersion":2,"HasSecoundaryLang":false,"IsPortalEnabled":"true","IsBrandingEnabled":"false","IsBrandingEnabledInViewer":"false","LogoName":"","EntityGeography":5}];
  $scope.factData = [{"Id":1813162,"FileId":4141,"Sequence":1,"PageIdentifier":"aab0fcb3-84a2-438a-988e-bebc6fdc4663","ElementIdentifier":"bb6d61e4-2cd4-4576-ae4c-558aa49fe181","ElementType":2,"TagName":"ifrs-full:AddressOfRegisteredOfficeOfEntity","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"3rd Floor 11-12 St James&#8217;s Square London SW1Y 4LB ","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Address of entity's registered office","Documentation":"The address at which the entity's office is registered.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813161,"FileId":4141,"Sequence":2,"PageIdentifier":"1c0a06fc-9964-4207-ac4e-43c262210160","ElementIdentifier":"af801833-5d0c-4575-b1ae-207ae438583b","ElementType":2,"TagName":"ifrs-full:DescriptionOfNatureOfEntitysOperationsAndPrincipalActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"The principal activity of the Company and its subsidiaries (&#8216;the Group&#8217;) prior to year-end was to operate the drilling rigs. During the year, the WilPhoenix was in drilling operations for its clients, Serica Energy and Ithaca Oil and Gas Energy.  As noted above, since contractual arrangement to sell both rigs during Q2 2022, the principal activity of the Group is to continue the arbitration processes with Keppel FELS shipyard.   ","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of nature of entity's operations and principal activities","Documentation":"The description of the nature of the entity's operations and principal activities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813160,"FileId":4141,"Sequence":3,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"87607517-bcd2-40bc-befa-c5a8147ac4f3","ElementType":1,"TagName":"ifrs-full:Revenue","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"33,077","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Revenue","Documentation":"The income arising in the course of an entity's ordinary activities. Income is increases in assets, or decreases in liabilities, that result in increases in equity, other than those relating to contributions from holders of equity claims.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813175,"FileId":4141,"Sequence":4,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"36728825-d1f9-4f6a-9acd-e1bb210d23d8","ElementType":1,"TagName":"ifrs-full:Revenue","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"25,602","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Revenue","Documentation":"The income arising in the course of an entity's ordinary activities. Income is increases in assets, or decreases in liabilities, that result in increases in equity, other than those relating to contributions from holders of equity claims.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813212,"FileId":4141,"Sequence":5,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"ca400ce6-ff96-49c3-82d7-84691b6054e2","ElementType":1,"TagName":"ifrs-full:CostOfSales","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"33,986","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cost of sales","Documentation":"The amount of costs relating to expenses directly or indirectly attributed to the goods or services sold, which may include, but are not limited to, costs previously included in the measurement of inventory that has now been sold, unallocated production overheads and abnormal amounts of production costs of inventories.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813247,"FileId":4141,"Sequence":6,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"8336620d-cc8a-4c47-88c7-73a3217f79ac","ElementType":1,"TagName":"ifrs-full:CostOfSales","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"33,460","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cost of sales","Documentation":"The amount of costs relating to expenses directly or indirectly attributed to the goods or services sold, which may include, but are not limited to, costs previously included in the measurement of inventory that has now been sold, unallocated production overheads and abnormal amounts of production costs of inventories.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813213,"FileId":4141,"Sequence":7,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"07428ddd-d8d3-4033-bc5a-f8c1a07697ef","ElementType":1,"TagName":"ifrs-full:ImpairmentLoss","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"48,120","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Impairment loss","Documentation":"The amount recognised as a reduction of the carrying amount of an asset or cash-generating unit to its recoverable amount. [Refer: Carrying amount [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813263,"FileId":4141,"Sequence":8,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"1f21a82f-1023-4105-949e-3813dd420e4d","ElementType":1,"TagName":"ifrs-full:ImpairmentLoss","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"145,171","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Impairment loss","Documentation":"The amount recognised as a reduction of the carrying amount of an asset or cash-generating unit to its recoverable amount. [Refer: Carrying amount [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813262,"FileId":4141,"Sequence":9,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"a7547e90-f911-4a0d-87b7-fa36294a3905","ElementType":1,"TagName":"ifrs-full:GrossProfit","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"49,029","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Gross profit","Documentation":"The amount of revenue less cost of sales. [Refer: Cost of sales; Revenue]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813261,"FileId":4141,"Sequence":10,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"50865fae-8596-4c1e-b446-9672f9ec8217","ElementType":1,"TagName":"ifrs-full:GrossProfit","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"153,029","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Gross profit","Documentation":"The amount of revenue less cost of sales. [Refer: Cost of sales; Revenue]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813260,"FileId":4141,"Sequence":11,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"732e6144-c399-43eb-a6ac-d23842a7a969","ElementType":1,"TagName":"ifrs-full:GeneralAndAdministrativeExpense","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"12,235","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"General and administrative expense","Documentation":"The amount of expense relating to general and administrative activities of the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813259,"FileId":4141,"Sequence":12,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"d5ab55d9-802b-4fe3-b622-e896f88cb8eb","ElementType":1,"TagName":"ifrs-full:GeneralAndAdministrativeExpense","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"14,887","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"General and administrative expense","Documentation":"The amount of expense relating to general and administrative activities of the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813258,"FileId":4141,"Sequence":13,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"54774d51-d5de-450e-b36d-2e72614101e2","ElementType":1,"TagName":"ifrs-full:ProfitLossFromOperatingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"61,264","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Profit (loss) from operating activities","Documentation":"The profit (loss) from operating activities of the entity. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813264,"FileId":4141,"Sequence":14,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"a0e84537-37c2-4051-979e-d2c7afdd2b26","ElementType":1,"TagName":"ifrs-full:ProfitLossFromOperatingActivities","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"167,916","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Profit (loss) from operating activities","Documentation":"The profit (loss) from operating activities of the entity. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813257,"FileId":4141,"Sequence":15,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"8f330ceb-5621-45d0-ac20-3510dbafbd1b","ElementType":1,"TagName":"ifrs-full:FinanceIncome","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Finance income","Documentation":"The amount of income associated with interest and other financing activities of the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813255,"FileId":4141,"Sequence":16,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"1e7fda97-3ff1-4656-853d-bfa29c763781","ElementType":1,"TagName":"ifrs-full:FinanceIncome","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"386","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Finance income","Documentation":"The amount of income associated with interest and other financing activities of the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813254,"FileId":4141,"Sequence":17,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"65388cd4-1ed3-47c5-b356-efc7650f3d1e","ElementType":1,"TagName":"ifrs-full:FinanceCosts","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"1,441","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Finance costs","Documentation":"The amount of costs associated with financing activities of the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813253,"FileId":4141,"Sequence":18,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"6818d5f2-9e4f-4b6c-91e9-35f0d9cb01a0","ElementType":1,"TagName":"ifrs-full:FinanceCosts","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"35","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Finance costs","Documentation":"The amount of costs associated with financing activities of the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813252,"FileId":4141,"Sequence":19,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"9141bd03-01c4-4de6-85f4-57cac3346e09","ElementType":1,"TagName":"ifrs-full:OtherExpenseByFunction","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"4","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Other expense, by function","Documentation":"The amount of expenses that the entity does not separately disclose in the same statement or note when the entity uses the 'function of expense' form for its analysis of expenses.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813251,"FileId":4141,"Sequence":20,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"fbbc2441-e7e9-42ad-a7f5-178dd607d874","ElementType":1,"TagName":"ifrs-full:OtherExpenseByFunction","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Other expense, by function","Documentation":"The amount of expenses that the entity does not separately disclose in the same statement or note when the entity uses the 'function of expense' form for its analysis of expenses.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813250,"FileId":4141,"Sequence":21,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"f9430e22-d286-4180-9fba-ec7b205e0f5e","ElementType":1,"TagName":"ifrs-full:GainsLossesOnExchangeDifferencesOnTranslationRecognisedInProfitOrLoss","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"254","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Foreign exchange gain (loss)","Documentation":"The amount of exchange differences recognised in profit or loss that arise from foreign currency transactions, excluding those arising on financial instruments measured at fair value through profit or loss in accordance with IFRS 9. [Refer: At fair value [member]; Financial instruments, class [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813256,"FileId":4141,"Sequence":22,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"11f0c4b6-11d1-4bdb-a974-ed426fdff619","ElementType":1,"TagName":"ifrs-full:GainsLossesOnExchangeDifferencesOnTranslationRecognisedInProfitOrLoss","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"131","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Foreign exchange gain (loss)","Documentation":"The amount of exchange differences recognised in profit or loss that arise from foreign currency transactions, excluding those arising on financial instruments measured at fair value through profit or loss in accordance with IFRS 9. [Refer: At fair value [member]; Financial instruments, class [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813266,"FileId":4141,"Sequence":23,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"e9f842ab-9c67-49e6-9b19-4ab33fd639b8","ElementType":1,"TagName":"ifrs-full:ProfitLossBeforeTax","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"62,963","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Profit (loss) before tax","Documentation":"The profit (loss) before tax expense or income. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813274,"FileId":4141,"Sequence":24,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"aa1e2e9b-b584-4c44-9566-003663ad6d91","ElementType":1,"TagName":"ifrs-full:ProfitLossBeforeTax","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"167,696","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Profit (loss) before tax","Documentation":"The profit (loss) before tax expense or income. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813267,"FileId":4141,"Sequence":25,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"809905b6-3e9e-4022-81ed-14539f013b57","ElementType":1,"TagName":"ifrs-full:IncomeTaxExpenseContinuingOperations","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"9,266","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Tax expense (income)","Documentation":"The aggregate amount included in the determination of profit (loss) for the period in respect of current tax and deferred tax. [Refer: Current tax expense (income); Deferred tax expense (income)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813281,"FileId":4141,"Sequence":26,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"04cc8489-b437-404a-8543-cb74e625e54b","ElementType":1,"TagName":"ifrs-full:IncomeTaxExpenseContinuingOperations","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"161","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Tax expense (income)","Documentation":"The aggregate amount included in the determination of profit (loss) for the period in respect of current tax and deferred tax. [Refer: Current tax expense (income); Deferred tax expense (income)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813280,"FileId":4141,"Sequence":27,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"c2f83e41-4938-4dbc-8cca-c37eaad0f991","ElementType":1,"TagName":"ifrs-full:ProfitLoss","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"72,229","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Profit (loss)","Documentation":"The total of income less expenses from continuing and discontinued operations, excluding the components of other comprehensive income. [Refer: Other comprehensive income]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813279,"FileId":4141,"Sequence":28,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"d391b659-2bef-43fa-96f7-d5b48422965c","ElementType":1,"TagName":"ifrs-full:ProfitLoss","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"167,857","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Profit (loss)","Documentation":"The total of income less expenses from continuing and discontinued operations, excluding the components of other comprehensive income. [Refer: Other comprehensive income]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813278,"FileId":4141,"Sequence":29,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"c7f04488-8de3-4149-9ce3-decbc48f3e2a","ElementType":1,"TagName":"ifrs-full:BasicAndDilutedEarningsLossPerShare","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD_per_Share","CurrencyName":"Ugandan Shilling","Decimal":"4","Scale":"-2","Value":"1.32","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"shares","Sign":"-","IsHiddenElement":false,"Label":"Basic and diluted earnings (loss) per share","Documentation":"The amount of earnings per share when the basic and diluted measurements are equal. [Refer: Basic earnings (loss) per share; Diluted earnings (loss) per share]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"","Type":"num:perShareItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813277,"FileId":4141,"Sequence":30,"PageIdentifier":"ab7cac4a-e2ef-4a1b-a4b5-af251c33aa68","ElementIdentifier":"4463d691-ad34-4cac-915c-43ffe36aa814","ElementType":1,"TagName":"ifrs-full:BasicAndDilutedEarningsLossPerShare","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD_per_Share","CurrencyName":"Ugandan Shilling","Decimal":"4","Scale":"-2","Value":"3.08","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"shares","Sign":"-","IsHiddenElement":false,"Label":"Basic and diluted earnings (loss) per share","Documentation":"The amount of earnings per share when the basic and diluted measurements are equal. [Refer: Basic earnings (loss) per share; Diluted earnings (loss) per share]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"","Type":"num:perShareItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813276,"FileId":4141,"Sequence":31,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"8c34ae14-fffa-4989-abfd-41072056a66e","ElementType":1,"TagName":"ifrs-full:PropertyPlantAndEquipment","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"15,764","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Property, plant and equipment","Documentation":"The amount of tangible assets that: (a) are held for use in the production or supply of goods or services, for rental to others, or for administrative purposes; and (b) are expected to be used during more than one period.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813282,"FileId":4141,"Sequence":32,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"314af1e5-4394-481e-b08b-760d1a259ca8","ElementType":1,"TagName":"ifrs-full:PropertyPlantAndEquipment","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"66,800","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Property, plant and equipment","Documentation":"The amount of tangible assets that: (a) are held for use in the production or supply of goods or services, for rental to others, or for administrative purposes; and (b) are expected to be used during more than one period.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813275,"FileId":4141,"Sequence":33,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"10b57a72-5309-4b83-955f-d85f109e9c30","ElementType":1,"TagName":"ifrs-full:RightofuseAssets","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Right-of-use assets","Documentation":"The amount of assets that represent a lessee's right to use an underlying asset for the lease term. Underlying asset is an asset that is the subject of a lease, for which the right to use that asset has been provided by a lessor to a lessee.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813273,"FileId":4141,"Sequence":34,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"e5664748-0ae2-4091-aa61-434bc5de5bee","ElementType":1,"TagName":"ifrs-full:RightofuseAssets","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"1,096","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Right-of-use assets","Documentation":"The amount of assets that represent a lessee's right to use an underlying asset for the lease term. Underlying asset is an asset that is the subject of a lease, for which the right to use that asset has been provided by a lessor to a lessee.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813272,"FileId":4141,"Sequence":35,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"ef9ae4c4-cb22-4d14-9436-7f0c94ad678e","ElementType":1,"TagName":"ifrs-full:DeferredTaxAssets","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Deferred tax assets","Documentation":"The amounts of income taxes recoverable in future periods in respect of: (a) deductible temporary differences; (b) the carryforward of unused tax losses; and (c) the carryforward of unused tax credits. [Refer: Temporary differences [member]; Unused tax credits [member]; Unused tax losses [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813271,"FileId":4141,"Sequence":36,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"704eb8bb-325e-4d5c-95d5-8f0c575ddb8e","ElementType":1,"TagName":"ifrs-full:DeferredTaxAssets","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"16","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Deferred tax assets","Documentation":"The amounts of income taxes recoverable in future periods in respect of: (a) deductible temporary differences; (b) the carryforward of unused tax losses; and (c) the carryforward of unused tax credits. [Refer: Temporary differences [member]; Unused tax credits [member]; Unused tax losses [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813270,"FileId":4141,"Sequence":37,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"0ca90c4a-c09a-45c5-8ad4-949017e4ecb3","ElementType":1,"TagName":"ifrs-full:NoncurrentAssets","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"15,764","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Non-current assets","Documentation":"The amount of assets that do not meet the definition of current assets. [Refer: Current assets]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813269,"FileId":4141,"Sequence":38,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"19bb0c4f-d739-4c93-b652-64a8222f485e","ElementType":1,"TagName":"ifrs-full:NoncurrentAssets","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"67,912","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Non-current assets","Documentation":"The amount of assets that do not meet the definition of current assets. [Refer: Current assets]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813268,"FileId":4141,"Sequence":39,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"69c5fb49-a71f-4a79-8a18-cbb8500246ab","ElementType":1,"TagName":"ifrs-full:Inventories","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"115","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current inventories","Documentation":"The amount of current inventories. [Refer: Inventories]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813249,"FileId":4141,"Sequence":40,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"b168d9b8-778f-41b4-b0ea-774b1d6f88e3","ElementType":1,"TagName":"ifrs-full:Inventories","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"3,026","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current inventories","Documentation":"The amount of current inventories. [Refer: Inventories]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813265,"FileId":4141,"Sequence":41,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"4d7a7001-60bf-405f-a95f-0e345a44559c","ElementType":1,"TagName":"ifrs-full:TradeAndOtherCurrentReceivables","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"662","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Trade and other current receivables","Documentation":"The amount of current trade receivables and current other receivables. [Refer: Current trade receivables; Other current receivables]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813248,"FileId":4141,"Sequence":42,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"cbf30f8a-b6b3-450c-9147-3043020bc9fe","ElementType":1,"TagName":"ifrs-full:TradeAndOtherCurrentReceivables","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"6,411","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Trade and other current receivables","Documentation":"The amount of current trade receivables and current other receivables. [Refer: Current trade receivables; Other current receivables]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813229,"FileId":4141,"Sequence":43,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"58a2e632-59c0-4819-addf-44c35fb12b91","ElementType":1,"TagName":"ifrs-full:CashAndCashEquivalents","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"9,685","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cash and cash equivalents","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813227,"FileId":4141,"Sequence":44,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"71d22fae-53ce-4830-ac00-521b43382151","ElementType":1,"TagName":"ifrs-full:CashAndCashEquivalents","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"14,738","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cash and cash equivalents","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813226,"FileId":4141,"Sequence":45,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"00baba91-4e33-4746-bab2-358b43e62815","ElementType":1,"TagName":"ifrs-full:CurrentAssets","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"10,462","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current assets","Documentation":"The amount of assets that the entity (a) expects to realise or intends to sell or consume in its normal operating cycle; (b) holds primarily for the purpose of trading; (c) expects to realise within twelve months after the reporting period; or (d) classifies as cash or cash equivalents (as defined in IAS 7) unless the asset is restricted from being exchanged or used to settle a liability for at least twelve months after the reporting period. [Refer: Assets]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813225,"FileId":4141,"Sequence":46,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"0cef75c2-97c5-4e06-aca8-7ae15967643e","ElementType":1,"TagName":"ifrs-full:CurrentAssets","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"24,175","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current assets","Documentation":"The amount of assets that the entity (a) expects to realise or intends to sell or consume in its normal operating cycle; (b) holds primarily for the purpose of trading; (c) expects to realise within twelve months after the reporting period; or (d) classifies as cash or cash equivalents (as defined in IAS 7) unless the asset is restricted from being exchanged or used to settle a liability for at least twelve months after the reporting period. [Refer: Assets]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813224,"FileId":4141,"Sequence":47,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"a4f6d636-d0e7-44c0-962a-e4f005f0d4d6","ElementType":1,"TagName":"ifrs-full:Assets","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"26,226","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Assets","Documentation":"The amount of a present economic resource controlled by the entity as a result of past events. Economic resource is a right that has the potential to produce economic benefits.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813223,"FileId":4141,"Sequence":48,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"ce592be7-8c95-4423-88bb-a10d02ff96d2","ElementType":1,"TagName":"ifrs-full:Assets","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"92,087","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Assets","Documentation":"The amount of a present economic resource controlled by the entity as a result of past events. Economic resource is a right that has the potential to produce economic benefits.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813222,"FileId":4141,"Sequence":49,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"fe3cd5fd-d337-4d6b-bca2-247006cb8830","ElementType":1,"TagName":"ifrs-full:TradeAndOtherCurrentPayables","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"4,550","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Trade and other current payables","Documentation":"The amount of current trade payables and current other payables. [Refer: Current trade payables; Other current payables]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813228,"FileId":4141,"Sequence":50,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"c22f1a0b-940a-455c-b496-4c75f95a3c89","ElementType":1,"TagName":"ifrs-full:TradeAndOtherCurrentPayables","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"6,294","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Trade and other current payables","Documentation":"The amount of current trade payables and current other payables. [Refer: Current trade payables; Other current payables]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813221,"FileId":4141,"Sequence":51,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"d3b0f573-2a09-47de-9a98-924c02b1c561","ElementType":1,"TagName":"ifrs-full:CurrentProvisions","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"1,100","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current provisions","Documentation":"The amount of current provisions. [Refer: Provisions]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813219,"FileId":4141,"Sequence":52,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"bc7e8262-4c53-47a5-8058-e2c6ad850836","ElementType":1,"TagName":"ifrs-full:CurrentProvisions","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"1,573","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current provisions","Documentation":"The amount of current provisions. [Refer: Provisions]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813218,"FileId":4141,"Sequence":53,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"6b67700e-3761-4a25-9d82-3c1897c265e4","ElementType":1,"TagName":"ifrs-full:CurrentTaxLiabilitiesCurrent","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"9,251","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current tax liabilities, current","Documentation":"The current amount of current tax liabilities. [Refer: Current tax liabilities]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813217,"FileId":4141,"Sequence":54,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"6f793345-9088-47a1-918a-51ad0b452952","ElementType":1,"TagName":"ifrs-full:CurrentTaxLiabilitiesCurrent","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"66","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current tax liabilities, current","Documentation":"The current amount of current tax liabilities. [Refer: Current tax liabilities]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813216,"FileId":4141,"Sequence":55,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"e842b6cd-feb8-40b8-8165-d66d0655c0b9","ElementType":1,"TagName":"ifrs-full:CurrentLiabilities","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"14,901","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current liabilities","Documentation":"The amount of liabilities that: (a) the entity expects to settle in its normal operating cycle; (b) the entity holds primarily for the purpose of trading; (c) are due to be settled within twelve months after the reporting period; or (d) the entity does not have an unconditional right to defer settlement for at least twelve months after the reporting period.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813215,"FileId":4141,"Sequence":56,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"bb7fd2ee-b6b0-4ef1-9351-0b46d181cfec","ElementType":1,"TagName":"ifrs-full:CurrentLiabilities","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"7,933","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current liabilities","Documentation":"The amount of liabilities that: (a) the entity expects to settle in its normal operating cycle; (b) the entity holds primarily for the purpose of trading; (c) are due to be settled within twelve months after the reporting period; or (d) the entity does not have an unconditional right to defer settlement for at least twelve months after the reporting period.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813214,"FileId":4141,"Sequence":57,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"45467c14-140c-4eca-9afc-159d493a0e8a","ElementType":1,"TagName":"ifrs-full:NoncurrentPayables","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"426","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Trade and other non-current payables","Documentation":"The amount of non-current trade payables and non-current other payables. [Refer: Other non-current payables; Non-current trade payables]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813220,"FileId":4141,"Sequence":58,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"7c8ad9c3-c3bc-4d2a-be15-e82119b4bbbe","ElementType":1,"TagName":"ifrs-full:NoncurrentPayables","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"1,026","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Trade and other non-current payables","Documentation":"The amount of non-current trade payables and non-current other payables. [Refer: Other non-current payables; Non-current trade payables]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813230,"FileId":4141,"Sequence":59,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"17da021c-b671-498c-93af-ec3cae942af0","ElementType":1,"TagName":"ifrs-full:NoncurrentLiabilities","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"426","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Non-current liabilities","Documentation":"The amount of liabilities that do not meet the definition of current liabilities. [Refer: Current liabilities]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813238,"FileId":4141,"Sequence":60,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"72c3b986-4c59-40f3-aecf-3dcf3fdd3cc2","ElementType":1,"TagName":"ifrs-full:NoncurrentLiabilities","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"1,026","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Non-current liabilities","Documentation":"The amount of liabilities that do not meet the definition of current liabilities. [Refer: Current liabilities]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813231,"FileId":4141,"Sequence":61,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"24f25041-de32-42d2-8750-8da04ca68380","ElementType":1,"TagName":"ifrs-full:Liabilities","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"15,327","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Liabilities","Documentation":"The amount of a present obligation of the entity to transfer an economic resource as a result of past events. Economic resource is a right that has the potential to produce economic benefits.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813245,"FileId":4141,"Sequence":62,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"7ff8d3df-0af6-49d4-bca7-643e143b52b8","ElementType":1,"TagName":"ifrs-full:Liabilities","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"8,959","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Liabilities","Documentation":"The amount of a present obligation of the entity to transfer an economic resource as a result of past events. Economic resource is a right that has the potential to produce economic benefits.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813244,"FileId":4141,"Sequence":63,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"88d73552-1ece-40fd-b975-39febe862724","ElementType":1,"TagName":"ifrs-full:NetAssetsLiabilities","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"10,899","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Assets (liabilities)","Documentation":"The amount of assets less the amount of liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813243,"FileId":4141,"Sequence":64,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"4419f30e-e5df-41c7-bb30-7f08d25710a3","ElementType":1,"TagName":"ifrs-full:NetAssetsLiabilities","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"83,128","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Assets (liabilities)","Documentation":"The amount of assets less the amount of liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813242,"FileId":4141,"Sequence":65,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"eb88368e-97bc-4eec-93cd-607c187a68a9","ElementType":1,"TagName":"ifrs-full:IssuedCapital","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"525","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Issued capital","Documentation":"The nominal value of capital issued.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813241,"FileId":4141,"Sequence":66,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"b847b36a-fe6e-4ab7-b8b5-1b8880beb682","ElementType":1,"TagName":"ifrs-full:IssuedCapital","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"525","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Issued capital","Documentation":"The nominal value of capital issued.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813240,"FileId":4141,"Sequence":67,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"2328d759-cbe1-4ffd-b104-f2ee2185529a","ElementType":1,"TagName":"ifrs-full:SharePremium","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"218,381","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Share premium","Documentation":"The amount received or receivable from the issuance of the entity's shares in excess of nominal value.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813246,"FileId":4141,"Sequence":68,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"a04cd052-343e-400a-a67f-8fd091bb8218","ElementType":1,"TagName":"ifrs-full:SharePremium","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"218,381","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Share premium","Documentation":"The amount received or receivable from the issuance of the entity's shares in excess of nominal value.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813239,"FileId":4141,"Sequence":69,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"a838107b-5f0d-4851-8ad5-984e49cbd7e7","ElementType":1,"TagName":"ifrs-full:RetainedEarnings","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"208,007","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Retained earnings","Documentation":"A component of equity representing the entity's cumulative undistributed earnings or deficit.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813237,"FileId":4141,"Sequence":70,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"80672e8a-b397-45d0-b778-d3b80c957186","ElementType":1,"TagName":"ifrs-full:RetainedEarnings","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"135,778","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Retained earnings","Documentation":"A component of equity representing the entity's cumulative undistributed earnings or deficit.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813236,"FileId":4141,"Sequence":71,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"19b94b50-d1c6-4d49-b603-0f218298568a","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"10,899","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813235,"FileId":4141,"Sequence":72,"PageIdentifier":"5d3dabfc-280d-4e46-ad5b-39f7bae3ad68","ElementIdentifier":"d13898c0-eb39-41d6-b720-0720246f67f7","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"83,128","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813234,"FileId":4141,"Sequence":73,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"fa9456ba-2a5f-47ba-a17b-fec4c9fd50a0","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2019_IssuedCapitalMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2019","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"525","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:IssuedCapitalMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813233,"FileId":4141,"Sequence":74,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"31e84402-eca2-44fe-b0ff-2b4cc8bfd61b","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2019_SharePremiumMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2019","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"218,381","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:SharePremiumMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813232,"FileId":4141,"Sequence":75,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"d9cf393a-1059-402a-9188-b34c85f8d43a","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2019_RetainedEarningsMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2019","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"32,079","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:RetainedEarningsMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813141,"FileId":4141,"Sequence":76,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"55abc92f-b285-4a61-ba6a-a9544260be75","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2019","Period":"31-Dec-2019","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"250,985","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813163,"FileId":4141,"Sequence":77,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"d721f870-6085-4b22-b4dd-6f77ea39e0d3","ElementType":1,"TagName":"ifrs-full:ComprehensiveIncome","ContextRef":"P01_01_2020To12_31_2020_RetainedEarningsMemberifrsfullComponentsOfEquityAxis","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"167,857","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:RetainedEarningsMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Comprehensive income","Documentation":"The amount of change in equity resulting from transactions and other events, other than those changes resulting from transactions with owners in their capacity as owners.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813164,"FileId":4141,"Sequence":78,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"57f1d9fd-de95-43ee-9df6-44ff50516445","ElementType":1,"TagName":"ifrs-full:ComprehensiveIncome","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"167,857","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Comprehensive income","Documentation":"The amount of change in equity resulting from transactions and other events, other than those changes resulting from transactions with owners in their capacity as owners.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813165,"FileId":4141,"Sequence":79,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"a26e8184-16f5-4dac-ae4a-b1eec5943da3","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2020_IssuedCapitalMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"525","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:IssuedCapitalMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813167,"FileId":4141,"Sequence":80,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"ec2a7b4b-150e-430f-ba61-d94227a127f6","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2020_SharePremiumMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"218,381","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:SharePremiumMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813174,"FileId":4141,"Sequence":81,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"8dd6515f-c6c2-418f-ab8a-b7b28f728e7d","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2020_RetainedEarningsMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"135,778","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:RetainedEarningsMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813168,"FileId":4141,"Sequence":82,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"b6809a9b-67c1-45b6-b801-6aaec05e42ab","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"83,128","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813169,"FileId":4141,"Sequence":83,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"f35004f5-c8a6-44f3-9957-7019646e77c1","ElementType":1,"TagName":"ifrs-full:ComprehensiveIncome","ContextRef":"P01_01_2021To12_31_2021_IssuedCapitalMemberifrsfullComponentsOfEquityAxis","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:IssuedCapitalMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Comprehensive income","Documentation":"The amount of change in equity resulting from transactions and other events, other than those changes resulting from transactions with owners in their capacity as owners.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813170,"FileId":4141,"Sequence":84,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"4211582e-5592-4073-baa0-64e81fa8bbca","ElementType":1,"TagName":"ifrs-full:ComprehensiveIncome","ContextRef":"P01_01_2021To12_31_2021_SharePremiumMemberifrsfullComponentsOfEquityAxis","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:SharePremiumMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Comprehensive income","Documentation":"The amount of change in equity resulting from transactions and other events, other than those changes resulting from transactions with owners in their capacity as owners.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813171,"FileId":4141,"Sequence":85,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"c697dfbf-df82-491f-b91a-e4969c2e30a9","ElementType":1,"TagName":"ifrs-full:ComprehensiveIncome","ContextRef":"P01_01_2021To12_31_2021_RetainedEarningsMemberifrsfullComponentsOfEquityAxis","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"72,229","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:RetainedEarningsMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Comprehensive income","Documentation":"The amount of change in equity resulting from transactions and other events, other than those changes resulting from transactions with owners in their capacity as owners.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813172,"FileId":4141,"Sequence":86,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"89d5ef60-99b9-4245-85bd-cd9a7b1520a9","ElementType":1,"TagName":"ifrs-full:ComprehensiveIncome","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"72,229","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Comprehensive income","Documentation":"The amount of change in equity resulting from transactions and other events, other than those changes resulting from transactions with owners in their capacity as owners.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813173,"FileId":4141,"Sequence":87,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"09dfd8b3-1462-46d3-b038-2e9511545062","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2021_IssuedCapitalMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"525","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:IssuedCapitalMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813159,"FileId":4141,"Sequence":88,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"ce9dab37-148c-4755-b227-ba531cc48492","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2021_SharePremiumMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"218,381","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:SharePremiumMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813166,"FileId":4141,"Sequence":89,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"8b2e4ef4-9aa9-4fb0-868c-33c060c099c7","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2021_RetainedEarningsMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"208,007","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:RetainedEarningsMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813158,"FileId":4141,"Sequence":90,"PageIdentifier":"696c7216-f74e-4250-b4bf-08165b75a755","ElementIdentifier":"3f367a0e-08c8-440f-bf78-7c02b6e2edb2","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"10,899","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813148,"FileId":4141,"Sequence":91,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"7dc6f062-9c0b-4078-8027-33883d26faf9","ElementType":1,"TagName":"ifrs-full:ProfitLossBeforeTax","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"62,963","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Profit (loss) before tax","Documentation":"The profit (loss) before tax expense or income. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813142,"FileId":4141,"Sequence":92,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"1aca217a-b037-4608-97d2-487c302cea2a","ElementType":1,"TagName":"ifrs-full:ProfitLossBeforeTax","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"167,696","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Profit (loss) before tax","Documentation":"The profit (loss) before tax expense or income. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813143,"FileId":4141,"Sequence":93,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"b51ed686-93e5-444c-afee-f91a8ed13c2d","ElementType":1,"TagName":"ifrs-full:AdjustmentsForDepreciationExpense","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"6,241","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for depreciation expense","Documentation":"Adjustments for depreciation expense to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813144,"FileId":4141,"Sequence":94,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"8da57188-88bc-421a-a327-3538c4d8530d","ElementType":1,"TagName":"ifrs-full:AdjustmentsForDepreciationExpense","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"10,302","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for depreciation expense","Documentation":"Adjustments for depreciation expense to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813145,"FileId":4141,"Sequence":95,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"e3f7c33c-cc1f-4ab2-8311-5c0be1548d6f","ElementType":1,"TagName":"ifrs-full:AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"48,120","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for impairment loss (reversal of impairment loss) recognised in profit or loss","Documentation":"Adjustments for impairment loss (reversal of impairment loss) recognised in profit or loss to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Impairment loss (reversal of impairment loss) recognised in profit or loss]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813146,"FileId":4141,"Sequence":96,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"89dc0475-e568-434f-a7ba-2ca36188bd01","ElementType":1,"TagName":"ifrs-full:AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"145,171","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for impairment loss (reversal of impairment loss) recognised in profit or loss","Documentation":"Adjustments for impairment loss (reversal of impairment loss) recognised in profit or loss to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Impairment loss (reversal of impairment loss) recognised in profit or loss]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813147,"FileId":4141,"Sequence":97,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"b5153ad6-6db8-475c-b763-06955533ac74","ElementType":1,"TagName":"awlcf:AdjustmentsForInventoryWriteOff","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"3,026","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments For Inventory Write Off","Documentation":"Adjustments For Inventory Write Off.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"false","Nillable":"true","SubstitutionGroup":"xbrli:item","IsReferenceExist":false,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":1},{"Id":1813149,"FileId":4141,"Sequence":98,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"6353967e-d473-4629-8f0f-8d9a288210ad","ElementType":1,"TagName":"awlcf:AdjustmentsForInventoryWriteOff","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"1,620","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments For Inventory Write Off","Documentation":"Adjustments For Inventory Write Off.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"false","Nillable":"true","SubstitutionGroup":"xbrli:item","IsReferenceExist":false,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":1},{"Id":1813156,"FileId":4141,"Sequence":99,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"86b26c4a-4fe9-467d-b644-3a0a757f0724","ElementType":1,"TagName":"ifrs-full:AdjustmentsForFinanceIncomeCost","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"1,441","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Adjustments for finance income (cost)","Documentation":"Adjustments for net finance income or cost to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Finance income (cost); Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813150,"FileId":4141,"Sequence":100,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"da7a51f2-efe0-45a8-b540-c2a0ac7502e0","ElementType":1,"TagName":"ifrs-full:AdjustmentsForFinanceIncomeCost","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"351","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for finance income (cost)","Documentation":"Adjustments for net finance income or cost to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Finance income (cost); Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813151,"FileId":4141,"Sequence":101,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"89395785-a0e2-4a90-9903-27b3c10d11af","ElementType":1,"TagName":"ifrs-full:AdjustmentsForSharebasedPayments","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"114","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Adjustments for share-based payments","Documentation":"Adjustments for share-based payments to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813152,"FileId":4141,"Sequence":102,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"7b964907-d9c6-48d6-8742-a53fde63b40f","ElementType":1,"TagName":"ifrs-full:AdjustmentsForSharebasedPayments","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"532","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Adjustments for share-based payments","Documentation":"Adjustments for share-based payments to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813153,"FileId":4141,"Sequence":103,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"5dde138b-0e0e-4545-9864-99c3664be133","ElementType":1,"TagName":"ifrs-full:AdjustmentsForDecreaseIncreaseInTradeAndOtherReceivables","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"3,486","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for decrease (increase) in trade and other receivables","Documentation":"Adjustments for decrease (increase) in trade and other receivables to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Trade and other receivables; Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813154,"FileId":4141,"Sequence":104,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"af995ef4-2986-4d47-a647-fb5c50451c8c","ElementType":1,"TagName":"ifrs-full:AdjustmentsForDecreaseIncreaseInTradeAndOtherReceivables","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"5,385","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for decrease (increase) in trade and other receivables","Documentation":"Adjustments for decrease (increase) in trade and other receivables to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Trade and other receivables; Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813155,"FileId":4141,"Sequence":105,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"793ff5ce-a6f5-4f3c-b151-71aa0a132aad","ElementType":1,"TagName":"ifrs-full:AdjustmentsForDecreaseIncreaseInInventories","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"115","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Adjustments for decrease (increase) in inventories","Documentation":"Adjustments for decrease (increase) in inventories to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Inventories; Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813157,"FileId":4141,"Sequence":106,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"01323ffe-ff9a-410a-9217-f9ab34268cab","ElementType":1,"TagName":"ifrs-full:AdjustmentsForDecreaseIncreaseInInventories","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"300","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for decrease (increase) in inventories","Documentation":"Adjustments for decrease (increase) in inventories to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Inventories; Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813176,"FileId":4141,"Sequence":107,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"e8e832e6-5e2c-40f0-9237-0aa7b8320d9a","ElementType":1,"TagName":"ifrs-full:AdjustmentsForDecreaseIncreaseInOtherOperatingReceivables","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"2,249","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for decrease (increase) in other operating receivables","Documentation":"Adjustments for decrease (increase) in other operating receivables to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813193,"FileId":4141,"Sequence":108,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"df0b69bc-00ab-4804-8100-5b7e0fcdc940","ElementType":1,"TagName":"ifrs-full:AdjustmentsForDecreaseIncreaseInOtherOperatingReceivables","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"2,058","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Adjustments for decrease (increase) in other operating receivables","Documentation":"Adjustments for decrease (increase) in other operating receivables to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813177,"FileId":4141,"Sequence":109,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"e836a0e4-bde7-4bc5-a5f8-1824d8040e3a","ElementType":1,"TagName":"ifrs-full:AdjustmentsForIncreaseDecreaseInTradeAccountPayable","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"3,605","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Adjustments for increase (decrease) in trade accounts payable","Documentation":"Adjustments for increase (decrease) in trade accounts payable to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813196,"FileId":4141,"Sequence":110,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"ec743783-be56-4ba6-8eb8-20db680e31fd","ElementType":1,"TagName":"ifrs-full:AdjustmentsForIncreaseDecreaseInTradeAccountPayable","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"878","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for increase (decrease) in trade accounts payable","Documentation":"Adjustments for increase (decrease) in trade accounts payable to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813197,"FileId":4141,"Sequence":111,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"4d9b76c3-dfb2-4775-9a9c-7f1dd17e7201","ElementType":1,"TagName":"ifrs-full:InterestPaidClassifiedAsOperatingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"53","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Interest paid, classified as operating activities","Documentation":"The cash outflow for interest paid, classified as operating activities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813198,"FileId":4141,"Sequence":112,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"9dff8750-a252-4a94-ba09-e4bf72ac1ac7","ElementType":1,"TagName":"ifrs-full:InterestPaidClassifiedAsOperatingActivities","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"35","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Interest paid, classified as operating activities","Documentation":"The cash outflow for interest paid, classified as operating activities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813199,"FileId":4141,"Sequence":113,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"c26c12be-59b3-409e-8a49-a07f52816700","ElementType":1,"TagName":"ifrs-full:InterestReceivedClassifiedAsOperatingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Interest received, classified as operating activities","Documentation":"The cash inflow from interest received, classified as operating activities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813200,"FileId":4141,"Sequence":114,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"664ff63d-174b-440f-8ae3-682f52fe94e8","ElementType":1,"TagName":"ifrs-full:InterestReceivedClassifiedAsOperatingActivities","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"386","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Interest received, classified as operating activities","Documentation":"The cash inflow from interest received, classified as operating activities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813201,"FileId":4141,"Sequence":115,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"b1aa7f4c-c727-4735-8f68-6ce8de6312ee","ElementType":1,"TagName":"ifrs-full:IncomeTaxesPaidClassifiedAsOperatingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"65","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Income taxes paid, classified as operating activities","Documentation":"The cash outflow for income taxes paid, classified as operating activities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813203,"FileId":4141,"Sequence":116,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"803d74b0-a44e-4bfd-8281-58674e675949","ElementType":1,"TagName":"ifrs-full:IncomeTaxesPaidClassifiedAsOperatingActivities","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"74","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Income taxes paid, classified as operating activities","Documentation":"The cash outflow for income taxes paid, classified as operating activities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813210,"FileId":4141,"Sequence":117,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"e45fec8f-34f8-4bcc-84ee-61611463139d","ElementType":1,"TagName":"ifrs-full:CashFlowsFromUsedInOperatingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"2,352","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Cash flows from (used in) operating activities","Documentation":"The cash flows from (used in) operating activities, which are the principal revenue-producing activities of the entity and other activities that are not investing or financing activities. [Refer: Revenue]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813204,"FileId":4141,"Sequence":118,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"5eae3ba3-eead-4fa0-937d-67ea5ea1c327","ElementType":1,"TagName":"ifrs-full:CashFlowsFromUsedInOperatingActivities","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"6,704","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Cash flows from (used in) operating activities","Documentation":"The cash flows from (used in) operating activities, which are the principal revenue-producing activities of the entity and other activities that are not investing or financing activities. [Refer: Revenue]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813205,"FileId":4141,"Sequence":119,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"03cf1948-f0d5-4fd2-82a7-b944bc171c5c","ElementType":1,"TagName":"ifrs-full:PurchaseOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"2,229","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Purchase of property, plant and equipment, classified as investing activities","Documentation":"The cash outflow for the purchases of property, plant and equipment, classified as investing activities. [Refer: Property, plant and equipment]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813206,"FileId":4141,"Sequence":120,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"5110770d-c3ae-42de-9762-8d1db41fd759","ElementType":1,"TagName":"ifrs-full:PurchaseOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"19,316","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Purchase of property, plant and equipment, classified as investing activities","Documentation":"The cash outflow for the purchases of property, plant and equipment, classified as investing activities. [Refer: Property, plant and equipment]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813207,"FileId":4141,"Sequence":121,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"7b09d7d4-4d07-4952-9f47-f5ec9a81670e","ElementType":1,"TagName":"ifrs-full:ProceedsFromSalesOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Proceeds from sales of property, plant and equipment, classified as investing activities","Documentation":"The cash inflow from sales of property, plant and equipment, classified as investing activities. [Refer: Property, plant and equipment]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813208,"FileId":4141,"Sequence":122,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"bc6408d5-9d94-4d2f-880d-9ff87ddcd18f","ElementType":1,"TagName":"ifrs-full:ProceedsFromSalesOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"29","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Proceeds from sales of property, plant and equipment, classified as investing activities","Documentation":"The cash inflow from sales of property, plant and equipment, classified as investing activities. [Refer: Property, plant and equipment]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813209,"FileId":4141,"Sequence":123,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"ff31906c-d719-4b8a-804f-c3735c6f920d","ElementType":1,"TagName":"ifrs-full:CashFlowsFromUsedInInvestingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"2,229","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Cash flows from (used in) investing activities","Documentation":"The cash flows from (used in) investing activities, which are the acquisition and disposal of long-term assets and other investments not included in cash equivalents.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813195,"FileId":4141,"Sequence":124,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"e47e47bb-8b57-4f5f-b281-4398dcfcd174","ElementType":1,"TagName":"ifrs-full:CashFlowsFromUsedInInvestingActivities","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"19,287","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Cash flows from (used in) investing activities","Documentation":"The cash flows from (used in) investing activities, which are the acquisition and disposal of long-term assets and other investments not included in cash equivalents.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813202,"FileId":4141,"Sequence":125,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"f06816d8-c6f4-411e-b076-c2ebc1e8ddfc","ElementType":1,"TagName":"ifrs-full:PaymentsOfLeaseLiabilitiesClassifiedAsFinancingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"472","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Payments of lease liabilities, classified as financing activities","Documentation":"The cash outflow for payment of lease liabilities, classified as financing activities. [Refer: Lease liabilities]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813194,"FileId":4141,"Sequence":126,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"5657730b-0ee5-43c4-b0c1-6c08a0d50cf8","ElementType":1,"TagName":"ifrs-full:PaymentsOfLeaseLiabilitiesClassifiedAsFinancingActivities","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"520","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Payments of lease liabilities, classified as financing activities","Documentation":"The cash outflow for payment of lease liabilities, classified as financing activities. [Refer: Lease liabilities]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813184,"FileId":4141,"Sequence":127,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"34aa3f2d-d3c5-40e9-ba23-1fd22a0c98bd","ElementType":1,"TagName":"ifrs-full:CashFlowsFromUsedInFinancingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"472","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Cash flows from (used in) financing activities","Documentation":"The cash flows from (used in) financing activities, which are activities that result in changes in the size and composition of the contributed equity and borrowings of the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813178,"FileId":4141,"Sequence":128,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"2f766696-1126-49b3-8ced-ab9b70b71fe4","ElementType":1,"TagName":"ifrs-full:CashFlowsFromUsedInFinancingActivities","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"520","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Cash flows from (used in) financing activities","Documentation":"The cash flows from (used in) financing activities, which are activities that result in changes in the size and composition of the contributed equity and borrowings of the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813179,"FileId":4141,"Sequence":129,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"fe068911-29fb-41c2-aa2b-6edb66cecc3a","ElementType":1,"TagName":"ifrs-full:IncreaseDecreaseInCashAndCashEquivalents","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"5,053","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Increase (decrease) in cash and cash equivalents","Documentation":"The increase (decrease) in cash and cash equivalents. [Refer: Cash and cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813180,"FileId":4141,"Sequence":130,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"476026d3-a792-40e5-87f5-2ec5ba213c2c","ElementType":1,"TagName":"ifrs-full:IncreaseDecreaseInCashAndCashEquivalents","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"26,380","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Increase (decrease) in cash and cash equivalents","Documentation":"The increase (decrease) in cash and cash equivalents. [Refer: Cash and cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813181,"FileId":4141,"Sequence":131,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"f7414714-891a-400a-be41-a54351e9622c","ElementType":1,"TagName":"ifrs-full:EffectOfExchangeRateChangesOnCashAndCashEquivalents","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Effect of exchange rate changes on cash and cash equivalents","Documentation":"The effect of exchange rate changes on cash and cash equivalents held or due in a foreign currency. [Refer: Cash and cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813182,"FileId":4141,"Sequence":132,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"f054196f-2edf-41db-9f45-9fed68db5451","ElementType":1,"TagName":"ifrs-full:EffectOfExchangeRateChangesOnCashAndCashEquivalents","ContextRef":"P01_01_2020To12_31_2020","Period":"01-Jan-2020 - 31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"131","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Effect of exchange rate changes on cash and cash equivalents","Documentation":"The effect of exchange rate changes on cash and cash equivalents held or due in a foreign currency. [Refer: Cash and cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813183,"FileId":4141,"Sequence":133,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"3ec7f022-7b36-4632-b3a7-72b277e0968b","ElementType":1,"TagName":"ifrs-full:CashAndCashEquivalents","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"14,738","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cash and cash equivalents","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813185,"FileId":4141,"Sequence":134,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"09af48da-a37c-4735-bbf8-280b2fca2165","ElementType":1,"TagName":"ifrs-full:CashAndCashEquivalents","ContextRef":"PAsOn12_31_2019","Period":"31-Dec-2019","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"41,249","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cash and cash equivalents","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813192,"FileId":4141,"Sequence":135,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"e16a68ef-c56a-4ba8-8c95-608dcba4f65f","ElementType":1,"TagName":"ifrs-full:CashAndCashEquivalents","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"9,685","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cash and cash equivalents","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813186,"FileId":4141,"Sequence":136,"PageIdentifier":"d6860767-fd36-4a7d-b2bc-d993e891cf80","ElementIdentifier":"074abee0-f4dc-4b4e-ab16-8f11eca87c72","ElementType":1,"TagName":"ifrs-full:CashAndCashEquivalents","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"14,738","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cash and cash equivalents","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813187,"FileId":4141,"Sequence":137,"PageIdentifier":"740a2da9-29cf-4113-84c5-0b2071850da1","ElementIdentifier":"13263ec7-8f85-4ce3-a57a-3eea9c133b87","ElementType":2,"TagName":"ifrs-full:NameOfParentEntity","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Awilco  Drilling  PLC","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Name of parent entity","Documentation":"The name of the entity's parent. [Refer: Parent [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813188,"FileId":4141,"Sequence":138,"PageIdentifier":"740a2da9-29cf-4113-84c5-0b2071850da1","ElementIdentifier":"f37a0bc5-291c-4e61-82f0-fbaba6a7bbb7","ElementType":2,"TagName":"ifrs-full:NameOfReportingEntityOrOtherMeansOfIdentification","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Awilco  Drilling  PLC","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Name of reporting entity or other means of identification","Documentation":"The name of the reporting entity or other means of identification.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813189,"FileId":4141,"Sequence":139,"PageIdentifier":"740a2da9-29cf-4113-84c5-0b2071850da1","ElementIdentifier":"604600b9-5add-474a-a7ce-1315ad2e6059","ElementType":2,"TagName":"ifrs-full:LegalFormOfEntity","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"PLC","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Legal form of entity","Documentation":"Information about the legal structure under which the entity operates.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813190,"FileId":4141,"Sequence":140,"PageIdentifier":"740a2da9-29cf-4113-84c5-0b2071850da1","ElementIdentifier":"4079d976-b460-4f21-bffe-f9d608df55af","ElementType":2,"TagName":"ifrs-full:DateOfEndOfReportingPeriod2013","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"31 December 2021","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Date of end of reporting period","Documentation":"The date of the end of the reporting period.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:dateItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813191,"FileId":4141,"Sequence":141,"PageIdentifier":"740a2da9-29cf-4113-84c5-0b2071850da1","ElementIdentifier":"27b493ef-1344-4a38-a64d-a592a58d46fe","ElementType":2,"TagName":"ifrs-full:DomicileOfEntity","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"United Kingdom","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Domicile of entity","Documentation":"The country of domicile of the entity. [Refer: Country of domicile [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813211,"FileId":4141,"Sequence":142,"PageIdentifier":"740a2da9-29cf-4113-84c5-0b2071850da1","ElementIdentifier":"9f9114fa-15d4-4f0d-ac79-7588949d6974","ElementType":2,"TagName":"ifrs-full:CountryOfIncorporation","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"United Kingdom","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Country of incorporation","Documentation":"The country in which the entity is incorporated.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0},{"Id":1813283,"FileId":4141,"Sequence":143,"PageIdentifier":"740a2da9-29cf-4113-84c5-0b2071850da1","ElementIdentifier":"6dfe8a2c-2494-4640-82bc-1effcd20e069","ElementType":2,"TagName":"ifrs-full:PrincipalPlaceOfBusiness","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"2 Kingshill Park, Westhill, Aberdeenshire, AB32 6FL.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Principal place of business","Documentation":"The place where an entity principally conducts operations.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0}];
  $scope.presentationData = [{"Id":"http://awilcodrilling.com/role/CoverPage","ParentId":"","Name":"1001 - Disclosure - Cover Page","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"CoverPage_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags_727660","ParentId":"http://awilcodrilling.com/role/CoverPage","Name":"esef_cor:NotesAccountingPoliciesAndMandatoryTags","Order":"","Label":"Notes, accounting policies and mandatory tags – this item MUST be used as a starting point for markups of disclosures in the notes to the financial statements","Documentation":"","PeriodType":"instant","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"CoverPage_loc_ifrs-full_NameOfReportingEntityOrOtherMeansOfIdentification_727662","ParentId":"CoverPage_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags_727660","Name":"ifrs-full:NameOfReportingEntityOrOtherMeansOfIdentification","Order":"1","Label":"Name of reporting entity or other means of identification","Documentation":"The name of the reporting entity or other means of identification.","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"CoverPage_loc_ifrs-full_PrincipalPlaceOfBusiness_727667","ParentId":"CoverPage_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags_727660","Name":"ifrs-full:PrincipalPlaceOfBusiness","Order":"2","Label":"Principal place of business","Documentation":"The place where an entity principally conducts operations.","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"CoverPage_loc_ifrs-full_AddressOfRegisteredOfficeOfEntity_727666","ParentId":"CoverPage_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags_727660","Name":"ifrs-full:AddressOfRegisteredOfficeOfEntity","Order":"3","Label":"Address of entity's registered office","Documentation":"The address at which the entity's office is registered.","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"CoverPage_loc_ifrs-full_CountryOfIncorporation_727665","ParentId":"CoverPage_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags_727660","Name":"ifrs-full:CountryOfIncorporation","Order":"4","Label":"Country of incorporation","Documentation":"The country in which the entity is incorporated.","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"CoverPage_loc_ifrs-full_NameOfParentEntity_727669","ParentId":"CoverPage_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags_727660","Name":"ifrs-full:NameOfParentEntity","Order":"5","Label":"Name of parent entity","Documentation":"The name of the entity's parent. [Refer: Parent [member]]","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"CoverPage_loc_ifrs-full_DescriptionOfNatureOfEntitysOperationsAndPrincipalActivities_727668","ParentId":"CoverPage_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags_727660","Name":"ifrs-full:DescriptionOfNatureOfEntitysOperationsAndPrincipalActivities","Order":"6","Label":"Description of nature of entity's operations and principal activities","Documentation":"The description of the nature of the entity's operations and principal activities.","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"CoverPage_loc_ifrs-full_DateOfEndOfReportingPeriod2013_727671","ParentId":"CoverPage_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags_727660","Name":"ifrs-full:DateOfEndOfReportingPeriod2013","Order":"7","Label":"Date of end of reporting period","Documentation":"The date of the end of the reporting period.","PeriodType":"duration","Balance":"","Type":"xbrli:dateItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"CoverPage_loc_ifrs-full_DomicileOfEntity_727663","ParentId":"CoverPage_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags_727660","Name":"ifrs-full:DomicileOfEntity","Order":"8","Label":"Domicile of entity","Documentation":"The country of domicile of the entity. [Refer: Country of domicile [member]]","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"CoverPage_loc_ifrs-full_LegalFormOfEntity_727664","ParentId":"CoverPage_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags_727660","Name":"ifrs-full:LegalFormOfEntity","Order":"9","Label":"Legal form of entity","Documentation":"Information about the legal structure under which the entity operates.","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"http://awilcodrilling.com/role/GroupStatementOfComprehensiveIncome","ParentId":"","Name":"1002 - Statement - Group statement of comprehensive income","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract_727564","ParentId":"http://awilcodrilling.com/role/GroupStatementOfComprehensiveIncome","Name":"ifrs-full:IncomeStatementAbstract","Order":"","Label":"Profit or loss placeholder - this item MUST be used as a starting point for the statement of profit or loss if the statement of profit or loss is disclosed separately","Documentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_Revenue_727565","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract_727564","Name":"ifrs-full:Revenue","Order":"1","Label":"Revenue","Documentation":"The income arising in the course of an entity's ordinary activities. Income is increases in assets, or decreases in liabilities, that result in increases in equity, other than those relating to contributions from holders of equity claims.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_CostOfSales_727566","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract_727564","Name":"ifrs-full:CostOfSales","Order":"2","Label":"Cost of sales","Documentation":"The amount of costs relating to expenses directly or indirectly attributed to the goods or services sold, which may include, but are not limited to, costs previously included in the measurement of inventory that has now been sold, unallocated production overheads and abnormal amounts of production costs of inventories.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ImpairmentLoss_727567","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract_727564","Name":"ifrs-full:ImpairmentLoss","Order":"3","Label":"Impairment loss","Documentation":"The amount recognised as a reduction of the carrying amount of an asset or cash-generating unit to its recoverable amount. [Refer: Carrying amount [member]]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GrossProfit_727568","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract_727564","Name":"ifrs-full:GrossProfit","Order":"4","Label":"Gross profit","Documentation":"The amount of revenue less cost of sales. [Refer: Cost of sales; Revenue]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GeneralAndAdministrativeExpense_727569","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract_727564","Name":"ifrs-full:GeneralAndAdministrativeExpense","Order":"5","Label":"General and administrative expense","Documentation":"The amount of expense relating to general and administrative activities of the entity.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossFromOperatingActivities_727570","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract_727564","Name":"ifrs-full:ProfitLossFromOperatingActivities","Order":"6","Label":"Profit (loss) from operating activities","Documentation":"The profit (loss) from operating activities of the entity. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_FinanceIncome_727571","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract_727564","Name":"ifrs-full:FinanceIncome","Order":"7","Label":"Finance income","Documentation":"The amount of income associated with interest and other financing activities of the entity.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_FinanceCosts_727572","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract_727564","Name":"ifrs-full:FinanceCosts","Order":"8","Label":"Finance costs","Documentation":"The amount of costs associated with financing activities of the entity.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_OtherExpenseByFunction_727573","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract_727564","Name":"ifrs-full:OtherExpenseByFunction","Order":"9","Label":"Other expense, by function","Documentation":"The amount of expenses that the entity does not separately disclose in the same statement or note when the entity uses the 'function of expense' form for its analysis of expenses.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GainsLossesOnExchangeDifferencesOnTranslationRecognisedInProfitOrLoss_727574","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract_727564","Name":"ifrs-full:GainsLossesOnExchangeDifferencesOnTranslationRecognisedInProfitOrLoss","Order":"10","Label":"Foreign exchange gain (loss)","Documentation":"The amount of exchange differences recognised in profit or loss that arise from foreign currency transactions, excluding those arising on financial instruments measured at fair value through profit or loss in accordance with IFRS 9. [Refer: At fair value [member]; Financial instruments, class [member]]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossBeforeTax_727576","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract_727564","Name":"ifrs-full:ProfitLossBeforeTax","Order":"11","Label":"Profit (loss) before tax","Documentation":"The profit (loss) before tax expense or income. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeTaxExpenseContinuingOperations_727580","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract_727564","Name":"ifrs-full:IncomeTaxExpenseContinuingOperations","Order":"12","Label":"Tax expense (income)","Documentation":"The aggregate amount included in the determination of profit (loss) for the period in respect of current tax and deferred tax. [Refer: Current tax expense (income); Deferred tax expense (income)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLoss_727577","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract_727564","Name":"ifrs-full:ProfitLoss","Order":"13","Label":"Profit (loss)","Documentation":"The total of income less expenses from continuing and discontinued operations, excluding the components of other comprehensive income. [Refer: Other comprehensive income]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_BasicAndDilutedEarningsLossPerShare_727579","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract_727564","Name":"ifrs-full:BasicAndDilutedEarningsLossPerShare","Order":"14","Label":"Basic and diluted earnings (loss) per share","Documentation":"The amount of earnings per share when the basic and diluted measurements are equal. [Refer: Basic earnings (loss) per share; Diluted earnings (loss) per share]","PeriodType":"duration","Balance":"","Type":"num:perShareItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"http://awilcodrilling.com/role/GroupStatementOfFinancialPosition","ParentId":"","Name":"1003 - Statement - Group statement of financial position","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_StatementOfFinancialPositionAbstract_727582","ParentId":"http://awilcodrilling.com/role/GroupStatementOfFinancialPosition","Name":"ifrs-full:StatementOfFinancialPositionAbstract","Order":"","Label":"Statement of financial position placeholder - this item MUST be used as a starting point for the statement of financial position","Documentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_AssetsAbstract_727597","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_StatementOfFinancialPositionAbstract_727582","Name":"ifrs-full:AssetsAbstract","Order":"1","Label":"Assets [abstract]","Documentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssetsAbstract_727583","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_AssetsAbstract_727597","Name":"ifrs-full:NoncurrentAssetsAbstract","Order":"2","Label":"Non-current assets [abstract]","Documentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_PropertyPlantAndEquipment_727584","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssetsAbstract_727583","Name":"ifrs-full:PropertyPlantAndEquipment","Order":"3","Label":"Property, plant and equipment","Documentation":"The amount of tangible assets that: (a) are held for use in the production or supply of goods or services, for rental to others, or for administrative purposes; and (b) are expected to be used during more than one period.","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_RightofuseAssets_727585","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssetsAbstract_727583","Name":"ifrs-full:RightofuseAssets","Order":"4","Label":"Right-of-use assets","Documentation":"The amount of assets that represent a lessee's right to use an underlying asset for the lease term. Underlying asset is an asset that is the subject of a lease, for which the right to use that asset has been provided by a lessor to a lessee.","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_DeferredTaxAssets_727586","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssetsAbstract_727583","Name":"ifrs-full:DeferredTaxAssets","Order":"5","Label":"Deferred tax assets","Documentation":"The amounts of income taxes recoverable in future periods in respect of: (a) deductible temporary differences; (b) the carryforward of unused tax losses; and (c) the carryforward of unused tax credits. [Refer: Temporary differences [member]; Unused tax credits [member]; Unused tax losses [member]]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssets_727593","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssetsAbstract_727583","Name":"ifrs-full:NoncurrentAssets","Order":"6","Label":"Total non-current assets","Documentation":"The amount of assets that do not meet the definition of current assets. [Refer: Current assets]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssetsAbstract_727587","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_AssetsAbstract_727597","Name":"ifrs-full:CurrentAssetsAbstract","Order":"7","Label":"Current assets [abstract]","Documentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_Inventories_727588","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssetsAbstract_727587","Name":"ifrs-full:Inventories","Order":"8","Label":"Current inventories","Documentation":"The amount of current inventories. [Refer: Inventories]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_TradeAndOtherCurrentReceivables_727590","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssetsAbstract_727587","Name":"ifrs-full:TradeAndOtherCurrentReceivables","Order":"9","Label":"Trade and other current receivables","Documentation":"The amount of current trade receivables and current other receivables. [Refer: Current trade receivables; Other current receivables]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CashAndCashEquivalents_727591","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssetsAbstract_727587","Name":"ifrs-full:CashAndCashEquivalents","Order":"10","Label":"Cash and cash equivalents","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssets_727595","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssetsAbstract_727587","Name":"ifrs-full:CurrentAssets","Order":"11","Label":"Total current assets","Documentation":"The amount of assets that the entity (a) expects to realise or intends to sell or consume in its normal operating cycle; (b) holds primarily for the purpose of trading; (c) expects to realise within twelve months after the reporting period; or (d) classifies as cash or cash equivalents (as defined in IAS 7) unless the asset is restricted from being exchanged or used to settle a liability for at least twelve months after the reporting period. [Refer: Assets]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_Assets_727599","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_AssetsAbstract_727597","Name":"ifrs-full:Assets","Order":"12","Label":"Total assets","Documentation":"The amount of a present economic resource controlled by the entity as a result of past events. Economic resource is a right that has the potential to produce economic benefits.","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_LiabilitiesAbstract_727601","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_StatementOfFinancialPositionAbstract_727582","Name":"ifrs-full:LiabilitiesAbstract","Order":"13","Label":"Liabilities [abstract]","Documentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilitiesAbstract_727602","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_LiabilitiesAbstract_727601","Name":"ifrs-full:CurrentLiabilitiesAbstract","Order":"14","Label":"Current liabilities [abstract]","Documentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_TradeAndOtherCurrentPayables_727603","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilitiesAbstract_727602","Name":"ifrs-full:TradeAndOtherCurrentPayables","Order":"15","Label":"Trade and other current payables","Documentation":"The amount of current trade payables and current other payables. [Refer: Current trade payables; Other current payables]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentProvisions_727604","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilitiesAbstract_727602","Name":"ifrs-full:CurrentProvisions","Order":"16","Label":"Current provisions","Documentation":"The amount of current provisions. [Refer: Provisions]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentTaxLiabilitiesCurrent_727606","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilitiesAbstract_727602","Name":"ifrs-full:CurrentTaxLiabilitiesCurrent","Order":"17","Label":"Current tax liabilities, current","Documentation":"The current amount of current tax liabilities. [Refer: Current tax liabilities]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilities_727609","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilitiesAbstract_727602","Name":"ifrs-full:CurrentLiabilities","Order":"18","Label":"Total current liabilities","Documentation":"The amount of liabilities that: (a) the entity expects to settle in its normal operating cycle; (b) the entity holds primarily for the purpose of trading; (c) are due to be settled within twelve months after the reporting period; or (d) the entity does not have an unconditional right to defer settlement for at least twelve months after the reporting period.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentLiabilitiesAbstract_727607","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_LiabilitiesAbstract_727601","Name":"ifrs-full:NoncurrentLiabilitiesAbstract","Order":"19","Label":"Non-current liabilities [abstract]","Documentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentPayables_727608","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentLiabilitiesAbstract_727607","Name":"ifrs-full:NoncurrentPayables","Order":"20","Label":"Trade and other non-current payables","Documentation":"The amount of non-current trade payables and non-current other payables. [Refer: Other non-current payables; Non-current trade payables]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentLiabilities_727610","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentLiabilitiesAbstract_727607","Name":"ifrs-full:NoncurrentLiabilities","Order":"21","Label":"Total non-current liabilities","Documentation":"The amount of liabilities that do not meet the definition of current liabilities. [Refer: Current liabilities]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_Liabilities_727611","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_LiabilitiesAbstract_727601","Name":"ifrs-full:Liabilities","Order":"22","Label":"Total liabilities","Documentation":"The amount of a present obligation of the entity to transfer an economic resource as a result of past events. Economic resource is a right that has the potential to produce economic benefits.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NetAssetsLiabilities_727644","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_StatementOfFinancialPositionAbstract_727582","Name":"ifrs-full:NetAssetsLiabilities","Order":"23","Label":"Assets (liabilities)","Documentation":"The amount of assets less the amount of liabilities.","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_EquityAbstract_727613","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_StatementOfFinancialPositionAbstract_727582","Name":"ifrs-full:EquityAbstract","Order":"24","Label":"Equity [abstract]","Documentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_IssuedCapital_727614","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_EquityAbstract_727613","Name":"ifrs-full:IssuedCapital","Order":"25","Label":"Issued capital","Documentation":"The nominal value of capital issued.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_SharePremium_727615","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_EquityAbstract_727613","Name":"ifrs-full:SharePremium","Order":"26","Label":"Share premium","Documentation":"The amount received or receivable from the issuance of the entity's shares in excess of nominal value.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_RetainedEarnings_727616","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_EquityAbstract_727613","Name":"ifrs-full:RetainedEarnings","Order":"27","Label":"Retained earnings","Documentation":"A component of equity representing the entity's cumulative undistributed earnings or deficit.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_Equity_727618","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_EquityAbstract_727613","Name":"ifrs-full:Equity","Order":"28","Label":"Total equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"http://awilcodrilling.com/role/GroupStatementOfChangesInEquity","ParentId":"","Name":"1004 - Statement - Group statement of changes in equity","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityAbstract_727646","ParentId":"http://awilcodrilling.com/role/GroupStatementOfChangesInEquity","Name":"ifrs-full:StatementOfChangesInEquityAbstract","Order":"","Label":"Statement of changes in equity placeholder - this item MUST be used as a starting point for the statement of changes in equity","Documentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityTable_727647","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityAbstract_727646","Name":"ifrs-full:StatementOfChangesInEquityTable","Order":"1","Label":"Statement of changes in equity [table]","Documentation":"Schedule disclosing information related to changes in equity.","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrldt:hypercubeItem","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_ComponentsOfEquityAxis_727648","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityTable_727647","Name":"ifrs-full:ComponentsOfEquityAxis","Order":"2","Label":"Components of equity [axis]","Documentation":"The axis of a table defines the relationship between the domain members or categories in the table and the line items or concepts that complete the table.","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrldt:dimensionItem","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_EquityMember_727649","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_ComponentsOfEquityAxis_727648","Name":"ifrs-full:EquityMember","Order":"3","Label":"Equity [member]","Documentation":"This member stands for the residual interest in the assets of the entity after deducting all its liabilities. It also represents the standard value for the 'Components of equity' axis if no other member is used.","PeriodType":"duration","Balance":"","Type":"nonnum:domainItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_IssuedCapitalMember_727650","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_EquityMember_727649","Name":"ifrs-full:IssuedCapitalMember","Order":"4","Label":"Issued capital [member]","Documentation":"This member stands for a component of equity representing issued capital.","PeriodType":"duration","Balance":"","Type":"nonnum:domainItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_SharePremiumMember_727651","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_EquityMember_727649","Name":"ifrs-full:SharePremiumMember","Order":"5","Label":"Share premium [member]","Documentation":"This member stands for the amount received or receivable from issuance of the entity's shares in excess of nominal value.","PeriodType":"duration","Balance":"","Type":"nonnum:domainItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_RetainedEarningsMember_727652","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_EquityMember_727649","Name":"ifrs-full:RetainedEarningsMember","Order":"6","Label":"Retained earnings [member]","Documentation":"This member stands for a component of equity representing an entity's cumulative undistributed earnings or deficit.","PeriodType":"duration","Balance":"","Type":"nonnum:domainItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityLineItems_727653","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityTable_727647","Name":"ifrs-full:StatementOfChangesInEquityLineItems","Order":"7","Label":"Statement of changes in equity [line items]","Documentation":"Line items represent concepts included in a table. These concepts are used to disclose reportable information associated with domain members defined in one or many axes of the table.","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_Equity_727655","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityLineItems_727653","Name":"ifrs-full:Equity","Order":"8","Label":"Equity at beginning of period","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"periodStartLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_ComprehensiveIncome_727659","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityLineItems_727653","Name":"ifrs-full:ComprehensiveIncome","Order":"9","Label":"Total comprehensive income","Documentation":"The amount of change in equity resulting from transactions and other events, other than those changes resulting from transactions with owners in their capacity as owners.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_Equity_727661","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityLineItems_727653","Name":"ifrs-full:Equity","Order":"10","Label":"Equity at end of period","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"periodEndLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"http://awilcodrilling.com/role/GroupStatementOfCashFlows","ParentId":"","Name":"1005 - Statement - Group statement of cash flows","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_StatementOfCashFlowsAbstract_727592","ParentId":"http://awilcodrilling.com/role/GroupStatementOfCashFlows","Name":"ifrs-full:StatementOfCashFlowsAbstract","Order":"","Label":"Statement of cash flows placeholder - this item MUST be used as a starting point for the statement of cash flows","Documentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract_727594","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_StatementOfCashFlowsAbstract_727592","Name":"ifrs-full:CashFlowsFromUsedInOperatingActivitiesAbstract","Order":"1","Label":"Cash flows from (used in) operating activities [abstract]","Documentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_ProfitLossBeforeTax_727596","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract_727594","Name":"ifrs-full:ProfitLossBeforeTax","Order":"2","Label":"Profit (loss) before tax","Documentation":"The profit (loss) before tax expense or income. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForReconcileProfitLossAbstract_727598","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract_727594","Name":"ifrs-full:AdjustmentsForReconcileProfitLossAbstract","Order":"3","Label":"Adjustments to reconcile profit (loss) [abstract]","Documentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForDepreciationExpense_727605","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForReconcileProfitLossAbstract_727598","Name":"ifrs-full:AdjustmentsForDepreciationExpense","Order":"4","Label":"Adjustments for depreciation expense","Documentation":"Adjustments for depreciation expense to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss_727612","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForReconcileProfitLossAbstract_727598","Name":"ifrs-full:AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","Order":"5","Label":"Adjustments for impairment loss (reversal of impairment loss) recognised in profit or loss","Documentation":"Adjustments for impairment loss (reversal of impairment loss) recognised in profit or loss to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Impairment loss (reversal of impairment loss) recognised in profit or loss]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_awlcf_AdjustmentsForInventoryWriteOff_728812","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForReconcileProfitLossAbstract_727598","Name":"awlcf:AdjustmentsForInventoryWriteOff","Order":"6","Label":"Adjustments For Inventory Write Off","Documentation":"Adjustments For Inventory Write Off.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"false","Nillable":"true","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":1},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForFinanceIncomeCost_727617","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForReconcileProfitLossAbstract_727598","Name":"ifrs-full:AdjustmentsForFinanceIncomeCost","Order":"7","Label":"Adjustments for finance income (cost)","Documentation":"Adjustments for net finance income or cost to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Finance income (cost); Profit (loss)]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForSharebasedPayments_727619","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForReconcileProfitLossAbstract_727598","Name":"ifrs-full:AdjustmentsForSharebasedPayments","Order":"8","Label":"Adjustments for share-based payments","Documentation":"Adjustments for share-based payments to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForDecreaseIncreaseInTradeAndOtherReceivables_727620","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract_727594","Name":"ifrs-full:AdjustmentsForDecreaseIncreaseInTradeAndOtherReceivables","Order":"9","Label":"Adjustments for decrease (increase) in trade and other receivables","Documentation":"Adjustments for decrease (increase) in trade and other receivables to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Trade and other receivables; Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForDecreaseIncreaseInInventories_727621","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract_727594","Name":"ifrs-full:AdjustmentsForDecreaseIncreaseInInventories","Order":"10","Label":"Adjustments for decrease (increase) in inventories","Documentation":"Adjustments for decrease (increase) in inventories to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Inventories; Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForDecreaseIncreaseInOtherOperatingReceivables_727622","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract_727594","Name":"ifrs-full:AdjustmentsForDecreaseIncreaseInOtherOperatingReceivables","Order":"11","Label":"Adjustments for decrease (increase) in other operating receivables","Documentation":"Adjustments for decrease (increase) in other operating receivables to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForIncreaseDecreaseInTradeAccountPayable_727623","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract_727594","Name":"ifrs-full:AdjustmentsForIncreaseDecreaseInTradeAccountPayable","Order":"12","Label":"Adjustments for increase (decrease) in trade accounts payable","Documentation":"Adjustments for increase (decrease) in trade accounts payable to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_InterestPaidClassifiedAsOperatingActivities_727624","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract_727594","Name":"ifrs-full:InterestPaidClassifiedAsOperatingActivities","Order":"13","Label":"Interest paid, classified as operating activities","Documentation":"The cash outflow for interest paid, classified as operating activities.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_InterestReceivedClassifiedAsOperatingActivities_727625","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract_727594","Name":"ifrs-full:InterestReceivedClassifiedAsOperatingActivities","Order":"14","Label":"Interest received, classified as operating activities","Documentation":"The cash inflow from interest received, classified as operating activities.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_IncomeTaxesPaidClassifiedAsOperatingActivities_727628","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract_727594","Name":"ifrs-full:IncomeTaxesPaidClassifiedAsOperatingActivities","Order":"15","Label":"Income taxes paid, classified as operating activities","Documentation":"The cash outflow for income taxes paid, classified as operating activities.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities_727630","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract_727594","Name":"ifrs-full:CashFlowsFromUsedInOperatingActivities","Order":"16","Label":"Net cash flows from (used in) operating activities","Documentation":"The cash flows from (used in) operating activities, which are the principal revenue-producing activities of the entity and other activities that are not investing or financing activities. [Refer: Revenue]","PeriodType":"duration","Balance":"","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInInvestingActivitiesAbstract_727631","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_StatementOfCashFlowsAbstract_727592","Name":"ifrs-full:CashFlowsFromUsedInInvestingActivitiesAbstract","Order":"17","Label":"Cash flows from (used in) investing activities [abstract]","Documentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_PurchaseOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities_727632","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInInvestingActivitiesAbstract_727631","Name":"ifrs-full:PurchaseOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","Order":"18","Label":"Purchase of property, plant and equipment, classified as investing activities","Documentation":"The cash outflow for the purchases of property, plant and equipment, classified as investing activities. [Refer: Property, plant and equipment]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_ProceedsFromSalesOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities_727633","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInInvestingActivitiesAbstract_727631","Name":"ifrs-full:ProceedsFromSalesOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","Order":"19","Label":"Proceeds from sales of property, plant and equipment, classified as investing activities","Documentation":"The cash inflow from sales of property, plant and equipment, classified as investing activities. [Refer: Property, plant and equipment]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInInvestingActivities_727634","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInInvestingActivitiesAbstract_727631","Name":"ifrs-full:CashFlowsFromUsedInInvestingActivities","Order":"20","Label":"Net cash flows from (used in) investing activities","Documentation":"The cash flows from (used in) investing activities, which are the acquisition and disposal of long-term assets and other investments not included in cash equivalents.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivitiesAbstract_727635","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_StatementOfCashFlowsAbstract_727592","Name":"ifrs-full:CashFlowsFromUsedInFinancingActivitiesAbstract","Order":"21","Label":"Cash flows from (used in) financing activities [abstract]","Documentation":"","PeriodType":"duration","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_PaymentsOfLeaseLiabilitiesClassifiedAsFinancingActivities_727638","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivitiesAbstract_727635","Name":"ifrs-full:PaymentsOfLeaseLiabilitiesClassifiedAsFinancingActivities","Order":"22","Label":"Payments of lease liabilities, classified as financing activities","Documentation":"The cash outflow for payment of lease liabilities, classified as financing activities. [Refer: Lease liabilities]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivities_727639","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivitiesAbstract_727635","Name":"ifrs-full:CashFlowsFromUsedInFinancingActivities","Order":"23","Label":"Net cash flows from (used in) financing activities","Documentation":"The cash flows from (used in) financing activities, which are activities that result in changes in the size and composition of the contributed equity and borrowings of the entity.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_IncreaseDecreaseInCashAndCashEquivalents_727640","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_StatementOfCashFlowsAbstract_727592","Name":"ifrs-full:IncreaseDecreaseInCashAndCashEquivalents","Order":"24","Label":"Net increase (decrease) in cash and cash equivalents","Documentation":"The increase (decrease) in cash and cash equivalents. [Refer: Cash and cash equivalents]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_EffectOfExchangeRateChangesOnCashAndCashEquivalents_727641","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_StatementOfCashFlowsAbstract_727592","Name":"ifrs-full:EffectOfExchangeRateChangesOnCashAndCashEquivalents","Order":"25","Label":"Effect of exchange rate changes on cash and cash equivalents","Documentation":"The effect of exchange rate changes on cash and cash equivalents held or due in a foreign currency. [Refer: Cash and cash equivalents]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashAndCashEquivalents_727642","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_StatementOfCashFlowsAbstract_727592","Name":"ifrs-full:CashAndCashEquivalents","Order":"26","Label":"Cash and cash equivalents at beginning of period","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"periodStartLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashAndCashEquivalents_727643","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_StatementOfCashFlowsAbstract_727592","Name":"ifrs-full:CashAndCashEquivalents","Order":"27","Label":"Cash and cash equivalents at end of period","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"periodEndLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0}];
  $scope.calculationData = [{"Id":"http://awilcodrilling.com/role/GroupStatementOfComprehensiveIncome","ParentId":"","Name":"1002 - Statement - Group statement of comprehensive income","Weight":"","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLoss","ParentId":"http://awilcodrilling.com/role/GroupStatementOfComprehensiveIncome","Name":"ifrs-full:ProfitLoss","Weight":"","Order":"","Label":"Profit (loss)","Documentation":"The total of income less expenses from continuing and discontinued operations, excluding the components of other comprehensive income. [Refer: Other comprehensive income]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossBeforeTax","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLoss","Name":"ifrs-full:ProfitLossBeforeTax","Weight":"1","Order":"1","Label":"Profit (loss) before tax","Documentation":"The profit (loss) before tax expense or income. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossFromOperatingActivities","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossBeforeTax","Name":"ifrs-full:ProfitLossFromOperatingActivities","Weight":"1","Order":"2","Label":"Profit (loss) from operating activities","Documentation":"The profit (loss) from operating activities of the entity. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GrossProfit","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossFromOperatingActivities","Name":"ifrs-full:GrossProfit","Weight":"1","Order":"3","Label":"Gross profit","Documentation":"The amount of revenue less cost of sales. [Refer: Cost of sales; Revenue]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_Revenue","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GrossProfit","Name":"ifrs-full:Revenue","Weight":"1","Order":"4","Label":"Revenue","Documentation":"The income arising in the course of an entity's ordinary activities. Income is increases in assets, or decreases in liabilities, that result in increases in equity, other than those relating to contributions from holders of equity claims.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_CostOfSales","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GrossProfit","Name":"ifrs-full:CostOfSales","Weight":"-1","Order":"5","Label":"Cost of sales","Documentation":"The amount of costs relating to expenses directly or indirectly attributed to the goods or services sold, which may include, but are not limited to, costs previously included in the measurement of inventory that has now been sold, unallocated production overheads and abnormal amounts of production costs of inventories.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ImpairmentLoss","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GrossProfit","Name":"ifrs-full:ImpairmentLoss","Weight":"-1","Order":"6","Label":"Impairment loss","Documentation":"The amount recognised as a reduction of the carrying amount of an asset or cash-generating unit to its recoverable amount. [Refer: Carrying amount [member]]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GeneralAndAdministrativeExpense","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossFromOperatingActivities","Name":"ifrs-full:GeneralAndAdministrativeExpense","Weight":"-1","Order":"7","Label":"General and administrative expense","Documentation":"The amount of expense relating to general and administrative activities of the entity.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_FinanceIncome","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossBeforeTax","Name":"ifrs-full:FinanceIncome","Weight":"1","Order":"8","Label":"Finance income","Documentation":"The amount of income associated with interest and other financing activities of the entity.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_FinanceCosts","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossBeforeTax","Name":"ifrs-full:FinanceCosts","Weight":"-1","Order":"9","Label":"Finance costs","Documentation":"The amount of costs associated with financing activities of the entity.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_OtherExpenseByFunction","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossBeforeTax","Name":"ifrs-full:OtherExpenseByFunction","Weight":"-1","Order":"10","Label":"Other expense, by function","Documentation":"The amount of expenses that the entity does not separately disclose in the same statement or note when the entity uses the 'function of expense' form for its analysis of expenses.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GainsLossesOnExchangeDifferencesOnTranslationRecognisedInProfitOrLoss","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossBeforeTax","Name":"ifrs-full:GainsLossesOnExchangeDifferencesOnTranslationRecognisedInProfitOrLoss","Weight":"1","Order":"11","Label":"Foreign exchange gain (loss)","Documentation":"The amount of exchange differences recognised in profit or loss that arise from foreign currency transactions, excluding those arising on financial instruments measured at fair value through profit or loss in accordance with IFRS 9. [Refer: At fair value [member]; Financial instruments, class [member]]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeTaxExpenseContinuingOperations","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLoss","Name":"ifrs-full:IncomeTaxExpenseContinuingOperations","Weight":"-1","Order":"12","Label":"Tax expense (income)","Documentation":"The aggregate amount included in the determination of profit (loss) for the period in respect of current tax and deferred tax. [Refer: Current tax expense (income); Deferred tax expense (income)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"http://awilcodrilling.com/role/GroupStatementOfFinancialPosition","ParentId":"","Name":"1003 - Statement - Group statement of financial position","Weight":"","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_Equity","ParentId":"http://awilcodrilling.com/role/GroupStatementOfFinancialPosition","Name":"ifrs-full:Equity","Weight":"","Order":"","Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_IssuedCapital","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_Equity","Name":"ifrs-full:IssuedCapital","Weight":"1","Order":"1","Label":"Issued capital","Documentation":"The nominal value of capital issued.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_SharePremium","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_Equity","Name":"ifrs-full:SharePremium","Weight":"1","Order":"2","Label":"Share premium","Documentation":"The amount received or receivable from the issuance of the entity's shares in excess of nominal value.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_RetainedEarnings","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_Equity","Name":"ifrs-full:RetainedEarnings","Weight":"1","Order":"3","Label":"Retained earnings","Documentation":"A component of equity representing the entity's cumulative undistributed earnings or deficit.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NetAssetsLiabilities","ParentId":"http://awilcodrilling.com/role/GroupStatementOfFinancialPosition","Name":"ifrs-full:NetAssetsLiabilities","Weight":"","Order":"","Label":"Assets (liabilities)","Documentation":"The amount of assets less the amount of liabilities.","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_Assets","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NetAssetsLiabilities","Name":"ifrs-full:Assets","Weight":"1","Order":"4","Label":"Assets","Documentation":"The amount of a present economic resource controlled by the entity as a result of past events. Economic resource is a right that has the potential to produce economic benefits.","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssets","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_Assets","Name":"ifrs-full:NoncurrentAssets","Weight":"1","Order":"5","Label":"Non-current assets","Documentation":"The amount of assets that do not meet the definition of current assets. [Refer: Current assets]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_PropertyPlantAndEquipment","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssets","Name":"ifrs-full:PropertyPlantAndEquipment","Weight":"1","Order":"6","Label":"Property, plant and equipment","Documentation":"The amount of tangible assets that: (a) are held for use in the production or supply of goods or services, for rental to others, or for administrative purposes; and (b) are expected to be used during more than one period.","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_RightofuseAssets","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssets","Name":"ifrs-full:RightofuseAssets","Weight":"1","Order":"7","Label":"Right-of-use assets","Documentation":"The amount of assets that represent a lessee's right to use an underlying asset for the lease term. Underlying asset is an asset that is the subject of a lease, for which the right to use that asset has been provided by a lessor to a lessee.","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_DeferredTaxAssets","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssets","Name":"ifrs-full:DeferredTaxAssets","Weight":"1","Order":"8","Label":"Deferred tax assets","Documentation":"The amounts of income taxes recoverable in future periods in respect of: (a) deductible temporary differences; (b) the carryforward of unused tax losses; and (c) the carryforward of unused tax credits. [Refer: Temporary differences [member]; Unused tax credits [member]; Unused tax losses [member]]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssets","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_Assets","Name":"ifrs-full:CurrentAssets","Weight":"1","Order":"9","Label":"Current assets","Documentation":"The amount of assets that the entity (a) expects to realise or intends to sell or consume in its normal operating cycle; (b) holds primarily for the purpose of trading; (c) expects to realise within twelve months after the reporting period; or (d) classifies as cash or cash equivalents (as defined in IAS 7) unless the asset is restricted from being exchanged or used to settle a liability for at least twelve months after the reporting period. [Refer: Assets]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_Inventories","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssets","Name":"ifrs-full:Inventories","Weight":"1","Order":"10","Label":"Current inventories","Documentation":"The amount of current inventories. [Refer: Inventories]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_TradeAndOtherCurrentReceivables","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssets","Name":"ifrs-full:TradeAndOtherCurrentReceivables","Weight":"1","Order":"11","Label":"Trade and other current receivables","Documentation":"The amount of current trade receivables and current other receivables. [Refer: Current trade receivables; Other current receivables]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CashAndCashEquivalents","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssets","Name":"ifrs-full:CashAndCashEquivalents","Weight":"1","Order":"12","Label":"Cash and cash equivalents","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_Liabilities","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NetAssetsLiabilities","Name":"ifrs-full:Liabilities","Weight":"-1","Order":"13","Label":"Liabilities","Documentation":"The amount of a present obligation of the entity to transfer an economic resource as a result of past events. Economic resource is a right that has the potential to produce economic benefits.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilities","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_Liabilities","Name":"ifrs-full:CurrentLiabilities","Weight":"1","Order":"14","Label":"Current liabilities","Documentation":"The amount of liabilities that: (a) the entity expects to settle in its normal operating cycle; (b) the entity holds primarily for the purpose of trading; (c) are due to be settled within twelve months after the reporting period; or (d) the entity does not have an unconditional right to defer settlement for at least twelve months after the reporting period.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_TradeAndOtherCurrentPayables","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilities","Name":"ifrs-full:TradeAndOtherCurrentPayables","Weight":"1","Order":"15","Label":"Trade and other current payables","Documentation":"The amount of current trade payables and current other payables. [Refer: Current trade payables; Other current payables]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentProvisions","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilities","Name":"ifrs-full:CurrentProvisions","Weight":"1","Order":"16","Label":"Current provisions","Documentation":"The amount of current provisions. [Refer: Provisions]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentTaxLiabilitiesCurrent","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilities","Name":"ifrs-full:CurrentTaxLiabilitiesCurrent","Weight":"1","Order":"17","Label":"Current tax liabilities, current","Documentation":"The current amount of current tax liabilities. [Refer: Current tax liabilities]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentLiabilities","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_Liabilities","Name":"ifrs-full:NoncurrentLiabilities","Weight":"1","Order":"18","Label":"Non-current liabilities","Documentation":"The amount of liabilities that do not meet the definition of current liabilities. [Refer: Current liabilities]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentPayables","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentLiabilities","Name":"ifrs-full:NoncurrentPayables","Weight":"1","Order":"19","Label":"Trade and other non-current payables","Documentation":"The amount of non-current trade payables and non-current other payables. [Refer: Other non-current payables; Non-current trade payables]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"http://awilcodrilling.com/role/GroupStatementOfCashFlows","ParentId":"","Name":"1005 - Statement - Group statement of cash flows","Weight":"","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_IncreaseDecreaseInCashAndCashEquivalents","ParentId":"http://awilcodrilling.com/role/GroupStatementOfCashFlows","Name":"ifrs-full:IncreaseDecreaseInCashAndCashEquivalents","Weight":"","Order":"","Label":"Increase (decrease) in cash and cash equivalents","Documentation":"The increase (decrease) in cash and cash equivalents. [Refer: Cash and cash equivalents]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInInvestingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_IncreaseDecreaseInCashAndCashEquivalents","Name":"ifrs-full:CashFlowsFromUsedInInvestingActivities","Weight":"1","Order":"1","Label":"Cash flows from (used in) investing activities","Documentation":"The cash flows from (used in) investing activities, which are the acquisition and disposal of long-term assets and other investments not included in cash equivalents.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_PurchaseOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInInvestingActivities","Name":"ifrs-full:PurchaseOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","Weight":"-1","Order":"2","Label":"Purchase of property, plant and equipment, classified as investing activities","Documentation":"The cash outflow for the purchases of property, plant and equipment, classified as investing activities. [Refer: Property, plant and equipment]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_ProceedsFromSalesOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInInvestingActivities","Name":"ifrs-full:ProceedsFromSalesOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","Weight":"1","Order":"3","Label":"Proceeds from sales of property, plant and equipment, classified as investing activities","Documentation":"The cash inflow from sales of property, plant and equipment, classified as investing activities. [Refer: Property, plant and equipment]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_IncreaseDecreaseInCashAndCashEquivalents","Name":"ifrs-full:CashFlowsFromUsedInFinancingActivities","Weight":"1","Order":"4","Label":"Cash flows from (used in) financing activities","Documentation":"The cash flows from (used in) financing activities, which are activities that result in changes in the size and composition of the contributed equity and borrowings of the entity.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_PaymentsOfLeaseLiabilitiesClassifiedAsFinancingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivities","Name":"ifrs-full:PaymentsOfLeaseLiabilitiesClassifiedAsFinancingActivities","Weight":"-1","Order":"5","Label":"Payments of lease liabilities, classified as financing activities","Documentation":"The cash outflow for payment of lease liabilities, classified as financing activities. [Refer: Lease liabilities]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_IncreaseDecreaseInCashAndCashEquivalents","Name":"ifrs-full:CashFlowsFromUsedInOperatingActivities","Weight":"1","Order":"6","Label":"Cash flows from (used in) operating activities","Documentation":"The cash flows from (used in) operating activities, which are the principal revenue-producing activities of the entity and other activities that are not investing or financing activities. [Refer: Revenue]","PeriodType":"duration","Balance":"","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForDepreciationExpense","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForDepreciationExpense","Weight":"1","Order":"7","Label":"Adjustments for depreciation expense","Documentation":"Adjustments for depreciation expense to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","Weight":"1","Order":"8","Label":"Adjustments for impairment loss (reversal of impairment loss) recognised in profit or loss","Documentation":"Adjustments for impairment loss (reversal of impairment loss) recognised in profit or loss to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Impairment loss (reversal of impairment loss) recognised in profit or loss]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForFinanceIncomeCost","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForFinanceIncomeCost","Weight":"-1","Order":"9","Label":"Adjustments for finance income (cost)","Documentation":"Adjustments for net finance income or cost to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Finance income (cost); Profit (loss)]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForSharebasedPayments","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForSharebasedPayments","Weight":"1","Order":"10","Label":"Adjustments for share-based payments","Documentation":"Adjustments for share-based payments to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForDecreaseIncreaseInTradeAndOtherReceivables","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForDecreaseIncreaseInTradeAndOtherReceivables","Weight":"1","Order":"11","Label":"Adjustments for decrease (increase) in trade and other receivables","Documentation":"Adjustments for decrease (increase) in trade and other receivables to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Trade and other receivables; Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForDecreaseIncreaseInInventories","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForDecreaseIncreaseInInventories","Weight":"1","Order":"12","Label":"Adjustments for decrease (increase) in inventories","Documentation":"Adjustments for decrease (increase) in inventories to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Inventories; Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForDecreaseIncreaseInOtherOperatingReceivables","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForDecreaseIncreaseInOtherOperatingReceivables","Weight":"1","Order":"13","Label":"Adjustments for decrease (increase) in other operating receivables","Documentation":"Adjustments for decrease (increase) in other operating receivables to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForIncreaseDecreaseInTradeAccountPayable","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForIncreaseDecreaseInTradeAccountPayable","Weight":"1","Order":"14","Label":"Adjustments for increase (decrease) in trade accounts payable","Documentation":"Adjustments for increase (decrease) in trade accounts payable to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_InterestPaidClassifiedAsOperatingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:InterestPaidClassifiedAsOperatingActivities","Weight":"-1","Order":"15","Label":"Interest paid, classified as operating activities","Documentation":"The cash outflow for interest paid, classified as operating activities.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_InterestReceivedClassifiedAsOperatingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:InterestReceivedClassifiedAsOperatingActivities","Weight":"1","Order":"16","Label":"Interest received, classified as operating activities","Documentation":"The cash inflow from interest received, classified as operating activities.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_IncomeTaxesPaidClassifiedAsOperatingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:IncomeTaxesPaidClassifiedAsOperatingActivities","Weight":"-1","Order":"17","Label":"Income taxes paid, classified as operating activities","Documentation":"The cash outflow for income taxes paid, classified as operating activities.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_ProfitLossBeforeTax","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:ProfitLossBeforeTax","Weight":"1","Order":"18","Label":"Profit (loss) before tax","Documentation":"The profit (loss) before tax expense or income. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_AWLCF_AdjustmentsForInventoryWriteOff","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"awlcf:AdjustmentsForInventoryWriteOff","Weight":"1","Order":"19","Label":"Adjustments For Inventory Write Off","Documentation":"Adjustments For Inventory Write Off.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"false","Nillable":"true","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":1},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_EffectOfExchangeRateChangesOnCashAndCashEquivalents","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_IncreaseDecreaseInCashAndCashEquivalents","Name":"ifrs-full:EffectOfExchangeRateChangesOnCashAndCashEquivalents","Weight":"1","Order":"20","Label":"Effect of exchange rate changes on cash and cash equivalents","Documentation":"The effect of exchange rate changes on cash and cash equivalents held or due in a foreign currency. [Refer: Cash and cash equivalents]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0}];
  $scope.periodData = ["2021-01-01 - 2021-12-31","2020-01-01 - 2020-12-31","2021-12-31","2020-12-31","2019-12-31 (ifrs-full:IssuedCapitalMember)","2019-12-31 (ifrs-full:SharePremiumMember)","2019-12-31 (ifrs-full:RetainedEarningsMember)","2019-12-31","2020-12-31 (ifrs-full:IssuedCapitalMember)","2020-12-31 (ifrs-full:SharePremiumMember)","2020-12-31 (ifrs-full:RetainedEarningsMember)","2021-12-31 (ifrs-full:IssuedCapitalMember)","2021-12-31 (ifrs-full:SharePremiumMember)","2021-12-31 (ifrs-full:RetainedEarningsMember)"];
  $scope.periodValueData = [["-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[-72229000,-72229000,0,-167857000,-167857000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[-62963000,-62963000,0,-167696000,-167696000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[-61264000,-61264000,0,-167916000,-167916000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[-49029000,-49029000,0,-153029000,-153029000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,33077000,33077000,0,25602000,25602000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,33986000,33986000,0,33460000,33460000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,48120000,48120000,0,145171000,145171000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,12235000,12235000,0,14887000,14887000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-",0,386000,386000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,1441000,1441000,0,35000,35000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,4000,4000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,-254000,-254000,0,-131000,-131000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,9266000,9266000,0,161000,161000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",10899000,10899000,0,83128000,83128000,0,0,525000,525000,0,218381000,218381000,0,32079000,32079000,0,250985000,250985000,0,525000,525000,0,218381000,218381000,0,-135778000,-135778000,0,525000,525000,0,218381000,218381000,0,-208007000,-208007000],["-","-","-","-","-","-",0,525000,525000,0,525000,525000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,218381000,218381000,0,218381000,218381000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,-208007000,-208007000,0,-135778000,-135778000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",10899000,10899000,0,83128000,83128000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",26226000,26226000,0,92087000,92087000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",15764000,15764000,0,67912000,67912000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,15764000,15764000,0,66800000,66800000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-","-","-","-",0,1096000,1096000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-","-","-","-",0,16000,16000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",10462000,10462000,0,24175000,24175000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,115000,115000,0,3026000,3026000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,662000,662000,0,6411000,6411000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,9685000,9685000,0,14738000,14738000,"-","-","-","-","-","-","-","-","-",0,41249000,41249000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",15327000,15327000,0,8959000,8959000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",14901000,14901000,0,7933000,7933000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,4550000,4550000,0,6294000,6294000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,1100000,1100000,0,1573000,1573000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,9251000,9251000,0,66000,66000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",426000,426000,0,1026000,1026000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,426000,426000,0,1026000,1026000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[-5053000,-5053000,0,-26642000,-26380000,262000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[-2229000,-2229000,0,-19287000,-19287000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,2229000,2229000,0,19316000,19316000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-",0,29000,29000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[-472000,-472000,0,-520000,-520000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,472000,472000,0,520000,520000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[-2352000,-2352000,0,-6704000,-6704000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,6241000,6241000,0,10302000,10302000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,48120000,48120000,0,145171000,145171000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,-1441000,-1441000,0,351000,351000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,-114000,-114000,0,-532000,-532000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,3486000,3486000,0,5385000,5385000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,-115000,-115000,0,300000,300000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,2249000,2249000,0,-2058000,-2058000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,-3605000,-3605000,0,878000,878000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,53000,53000,0,35000,35000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-",0,386000,386000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,65000,65000,0,74000,74000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[-62963000,-62963000,0,-167696000,-167696000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,3026000,3026000,0,1620000,1620000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-",0,-131000,-131000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"]];
  $scope.definitionData = [{"Id":"http://awilcodrilling.com/role/Anchoring","ParentId":"","Name":"Anchoring","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"Anchoring_CashFlowsFromUsedInOperatingActivities","ParentId":"http://awilcodrilling.com/role/Anchoring","Name":"ifrs-full:CashFlowsFromUsedInOperatingActivities","Order":"","Label":"Cash flows from (used in) operating activities","Documentation":"The cash flows from (used in) operating activities, which are the principal revenue-producing activities of the entity and other activities that are not investing or financing activities. [Refer: Revenue]","PeriodType":"duration","Balance":"","Type":"xbrli:monetaryItemType","AbstractText":"","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"Anchoring_AdjustmentsForInventoryWriteOff","ParentId":"Anchoring_CashFlowsFromUsedInOperatingActivities","Name":"awlcf:AdjustmentsForInventoryWriteOff","Order":"1.0","Label":"Adjustments For Inventory Write Off","Documentation":"Adjustments For Inventory Write Off.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"false","Nillable":"true","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0}];
  // $scope.pageData = <!PAGE DATA!>;
  $scope.referenceData = [{"ElementName":"DividendsProposedOrDeclaredBeforeFinancialStatementsAuthorisedForIssueButNotRecognisedAsDistributionToOwners","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"137","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_137_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DeferredTaxLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_o&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DeferredTaxLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"56","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_56&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DeferredTaxAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_o&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DeferredTaxAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"56","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_56&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxExpenseContinuingOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyPlantAndEquipment","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReversalOfImpairmentLossRecognisedInProfitOrLossPropertyPlantAndEquipment","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ImpairmentLossRecognisedInProfitOrLossPropertyPlantAndEquipment","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"MaturityAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"61","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_61&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AggregatedTimeBandsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"61","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_61&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NotLaterThanOneYearMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"61","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_61_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Revenue","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Revenue","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"103","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_103&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Revenue","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"102","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_102&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProvisionsForEmployeeBenefits","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"EmployeeBenefitsExpense","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"102","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_102&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"EmployeeBenefitsExpense","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"99","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_99&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"EmployeeBenefitsExpense","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"104","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_104&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IntangibleAssetsOtherThanGoodwill","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Goodwill","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BiologicalAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_f&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DepreciationAndAmortisationExpense","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"102","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_102&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DepreciationAndAmortisationExpense","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"99","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_99&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DepreciationAndAmortisationExpense","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"104","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_104&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"66","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_66&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Assets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLossBeforeTax","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"103","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_103&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLossBeforeTax","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"102","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_102&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnCashFlowHedgesNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnCashFlowHedgesBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfShareCapitalReservesAndOtherEquityInterestExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfNotesAndOtherExplanatoryInformationExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReservesAndOtherEquityInterestExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"EquityAndLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfGeneralInformationAboutFinancialStatementsExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"51","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_51&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Equity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Equity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DistributionCosts","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"103","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_103&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DistributionCosts","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"99","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_99&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GrossProfit","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"103","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_103&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherExpenseByFunction","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"103","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_103&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherExpenseByFunction","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"99","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_99&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherIncome","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"103","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_103&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherIncome","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"102","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_102&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdministrativeExpense","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"103","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_103&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdministrativeExpense","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"99","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_99&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CostOfSales","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"99","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_99&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CostOfSales","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"103","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_103&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherExpenseByNature","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"102","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_102&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherExpenseByNature","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"99","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_99&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ChangesInInventoriesOfFinishedGoodsAndWorkInProgress","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"102","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_102&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ChangesInInventoriesOfFinishedGoodsAndWorkInProgress","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"99","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_99&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RawMaterialsAndConsumablesUsed","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"102","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_102&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RawMaterialsAndConsumablesUsed","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"99","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_99&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"99","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_99&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherShorttermProvisions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentProvisionsForEmployeeBenefits","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherProvisions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherLongtermProvisions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentProvisionsForEmployeeBenefits","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughTransfersAndOtherChangesEquity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ChangesInEquity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LegalFormOfEntity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"138","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_138_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CountryOfIncorporation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"138","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_138_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DomicileOfEntity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"138","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_138_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AddressOfRegisteredOfficeOfEntity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"138","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_138_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfPresentationCurrency","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"51","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_51_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NameOfUltimateParentOfGroup","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"138","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_138_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NameOfParentEntity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"138","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_138_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherReceivables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_h&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherReceivables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentReceivables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_h&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentReceivables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherCurrentReceivables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_h&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherCurrentReceivables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"ii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d_ii&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughOtherContributionsByOwners","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"iii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d_iii&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IssueOfEquity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"iii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d_iii&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughOtherDistributionsToOwners","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"iii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d_iii&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ComprehensiveIncomeAttributableToNoncontrollingInterests","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ComprehensiveIncomeAttributableToOwnersOfParent","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsPaid","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"107","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_107&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"StatementOfIFRSCompliance","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfMeasurementBasesUsedInPreparingFinancialStatements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfOtherAccountingPoliciesRelevantToUnderstandingOfFinancialStatements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfManagementJudgementsInApplyingEntitysAccountingPoliciesWithSignificantEffectOnRecognisedAmounts","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"122","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_122&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfAssumptionAboutFutureWithSignificantRiskOfResultingInMaterialAdjustments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"125","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_125&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfAssumptionAboutFutureWithSignificantRiskOfResultingInMaterialAdjustments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"14","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=14&code=ifrs-tx-2020-en-r&anchor=para_10&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureOfEntitysOperationsAndPrincipalActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"138","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_138_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfDepartureFromIFRS","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_20_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfDepartureFromIFRS","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_20_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ManagementConclusionOnFairPresentationAsConsequenceOfDeparture","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_20_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfUncertaintiesOfEntitysAbilityToContinueAsGoingConcern","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"25","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_25&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationWhyFinancialStatementsNotPreparedOnGoingConcernBasis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"25","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_25&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfReasonForUsingLongerOrShorterReportingPeriod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"36","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_36_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfReasonWhyFinancialStatementsAreNotEntirelyComparable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"36","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_36_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfReasonForReclassificationOrChangesInPresentation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"41","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_41_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureOfReclassificationOrChangesInPresentation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"41","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_41_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfReasonWhyReclassificationOfComparativeAmountsIsImpracticable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"42","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_42_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LevelOfRoundingUsedInFinancialStatements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"51","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_51_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NameOfReportingEntityOrOtherMeansOfIdentification","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"51","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_51_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfChangeInNameOfReportingEntityOrOtherMeansOfIdentificationFromEndOfPrecedingReportingPeriod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"51","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_51_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureOfFinancialStatements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"51","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_51_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncontrollingInterests","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_q&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"SharePremium","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"EquityAttributableToOwnersOfParent","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_r&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RetainedEarnings","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherReserves","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TreasuryShares","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TreasuryShares","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"32","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=32&code=ifrs-tx-2020-en-r&anchor=para_34&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherEquityInterest","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IssuedCapital","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Inventories","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_g&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Inventories","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"68","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_68&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherFinancialAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNoncurrentFinancialAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentFinancialAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentFinancialLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_m&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNoncurrentFinancialLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_m&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherFinancialLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_m&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentProperty","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashAndCashEquivalents","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPayables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_k&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherPayables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_k&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherCurrentPayables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_k&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentTaxLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_n&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentTaxAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_n&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"66","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_66&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"69","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_69&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"69","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_69&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfClassesOfShareCapitalExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureAndPurposeOfReservesWithinEquity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfOtherEquityInterest","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"80","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_80&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShareOfProfitLossOfAssociatesAndJointVenturesAccountedForUsingEquityMethod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PeriodCoveredByFinancialStatements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"51","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_51_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinanceCosts","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherGainsLosses","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"102","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_102&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherGainsLosses","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"103","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_103&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"SharesInEntityHeldByEntityOrByItsSubsidiariesOrAssociates","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"vi","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a_vi&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NumberOfSharesAuthorised","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NumberOfSharesIssuedButNotFullyPaid","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"ii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a_ii&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NumberOfSharesIssuedAndFullyPaid","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"ii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a_ii&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ParValuePerShare","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"iii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a_iii&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RightsPreferencesAndRestrictionsAttachingToClassOfShareCapital","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"v","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a_v&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"SharesReservedForIssueUnderOptionsAndContractsForSaleOfShares","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"vii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a_vii&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"StatementOfChangesInEquityTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ComponentsOfEquityAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"EquityAttributableToOwnersOfParentMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IssuedCapitalMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"SharePremiumMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TreasurySharesMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherEquityInterestMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RetainedEarningsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncontrollingInterestsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"EquityMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfClassesOfShareCapitalTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ClassesOfShareCapitalAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ClassesOfShareCapitalMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReservesWithinEquityTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReservesWithinEquityAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NumberOfSharesOutstanding","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"iv","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a_iv&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfFactThatSharesHaveNoParValue","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"iii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a_iii&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentProvisions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_l&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentProvisions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_l&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Provisions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_l&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughChangesInOwnershipInterestsInSubsidiariesThatDoNotResultInLossOfControl","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"iii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d_iii&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Accruals","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AccrualsClassifiedAsCurrent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AccrualsClassifiedAsNoncurrent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DeferredIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DeferredIncomeClassifiedAsCurrent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DeferredIncomeClassifiedAsNoncurrent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPayablesToRelatedParties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPayablesToTradeSuppliers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentReceivablesDueFromRelatedParties","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherCurrentPayablesToRelatedParties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherCurrentPayablesToTradeSuppliers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherCurrentPayablesToTradeSuppliers","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"70","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_70&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherCurrentReceivablesDueFromRelatedParties","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherPayablesToRelatedParties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherPayablesToTradeSuppliers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherReceivablesDueFromRelatedParties","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfNatureOfRequirementInIFRSAndConclusionWhyRequirementIsInConflictWithFairPresentation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"23","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_23_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfAdjustmentsThatWouldBeNecessaryToAchieveFairPresentation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"23","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_23_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PrincipalPlaceOfBusiness","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"138","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_138_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfFactAndBasisForPreparationOfFinancialStatementsWhenNotGoingConcernBasis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"25","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_25&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Liabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentTaxAssetsNoncurrent","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_n&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentTaxLiabilitiesNoncurrent","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_n&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughSharebasedPaymentTransactions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"iii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d_iii&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentTaxAssetsCurrent","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_n&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentTaxLiabilitiesCurrent","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_n&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherReservesMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherReservesMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReclassificationsOrChangesInPresentationExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"41","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_41&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReclassificationsOrChangesInPresentationTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"41","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_41&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassifiedItemsAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"41","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_41&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassifiedItemsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"41","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_41&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AmountOfReclassificationsOrChangesInPresentation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"41","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_41_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentAccountedForUsingEquityMethod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnExchangeDifferencesOnTranslationBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnExchangeDifferencesOnTranslationNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShorttermMiscellaneousOtherProvisions","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LongtermMiscellaneousOtherProvisions","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"MiscellaneousOtherProvisions","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LiabilitiesIncludedInDisposalGroupsClassifiedAsHeldForSale","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_p&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AssetsAndLiabilitiesAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"125","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_125&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AssetsAndLiabilitiesMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"125","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_125&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentInventories","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_g&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InventoriesTotal","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_g&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InventoryWritedown2011","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReversalOfInventoryWritedown","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAssetsAndLiabilitiesWithSignificantRiskOfMaterialAdjustmentExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"125","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_125&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureOfAssetsWithSignificantRiskOfMaterialAdjustmentsWithinNextFinancialYear","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"125","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_125_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureOfLiabilitiesWithSignificantRiskOfMaterialAdjustmentsWithinNextFinancialYear","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"125","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_125_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AssetsWithSignificantRiskOfMaterialAdjustmentsWithinNextFinancialYear","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"125","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_125_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LiabilitiesWithSignificantRiskOfMaterialAdjustmentsWithinNextFinancialYear","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"125","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_125_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RestatedMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_20_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RestatedMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanOneYearMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"61","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_61_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAssetsAndLiabilitiesWithSignificantRiskOfMaterialAdjustmentTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"125","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_125&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PreviouslyStatedMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RetrospectiveApplicationAndRetrospectiveRestatementAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseDueToChangesInAccountingPolicyAndCorrectionsOfPriorPeriodErrorsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseInNumberOfSharesOutstanding","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"iv","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a_iv&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LengthOfLifeOfLimitedLifeEntity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"138","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_138_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CumulativePreferenceDividendsNotRecognised","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"137","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_137_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfFinancialEffectOfDepartureFromIFRS","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_20_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureOfNecessaryAdjustmentToProvideComparativeInformation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"42","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_42_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentAssetsOrDisposalGroupsClassifiedAsHeldForSaleOrAsHeldForDistributionToOwners","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_j&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherReversalsOfProvisions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_g&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnLitigationSettlements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_f&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExpenseOfRestructuringActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnDisposalsOfInvestments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnDisposalsOfPropertyPlantAndEquipment","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfObjectivesPoliciesAndProcessesForManagingCapitalExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"134","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_134&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainLossArisingFromDifferenceBetweenCarryingAmountOfFinancialLiabilityExtinguishedAndConsiderationPaid","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"19","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"11","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=19&code=ifrs-tx-2020-en-r&anchor=para_11&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseInDividendsPayableThroughChangeInFairValueOfNoncashAssetsHeldForDistributionToOwners","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"17","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=17&code=ifrs-tx-2020-en-r&anchor=para_16_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncashAssetsDeclaredForDistributionToOwnersBeforeFinancialStatementsAuthorisedForIssue","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"17","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=17&code=ifrs-tx-2020-en-r&anchor=para_17_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsPayable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"17","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=17&code=ifrs-tx-2020-en-r&anchor=para_16_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureOfNoncashAssetsHeldForDistributionToOwnersDeclaredBeforeFinancialStatementsAuthorisedForIssue","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"17","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=17&code=ifrs-tx-2020-en-r&anchor=para_17_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncashAssetsDeclaredForDistributionToOwnersBeforeFinancialStatementsAuthorisedForIssueAtFairValue","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"17","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=17&code=ifrs-tx-2020-en-r&anchor=para_17_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"QualitativeInformationAboutEntitysObjectivesPoliciesAndProcessesForManagingCapital","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"135","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_135_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"SummaryOfQuantitativeDataAboutWhatEntityManagesAsCapital","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"135","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_135_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfChangesInEntitysObjectivesPoliciesAndProcessesForManagingCapitalAndWhatEntityManagesAsCapital","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"135","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_135_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InformationWhetherEntityCompliedWithAnyExternallyImposedCapitalRequirements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"135","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_135_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InformationAboutConsequencesOfNoncomplianceWithExternallyImposedCapitalRequirements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"135","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_135_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"SummaryQuantitativeDataAboutPuttableFinancialInstrumentsClassifiedAsEquityInstruments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"136A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_136A_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InformationAboutObjectivesPoliciesAndProcessesForManagingEntitysObligationToRepurchaseOrRedeemPuttableFinancialInstruments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"136A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_136A_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExpectedCashOutflowOnRedemptionOrRepurchaseOfPuttableFinancialInstruments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"136A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_136A_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InformationAboutHowExpectedCashOutflowOnRedemptionOrRepurchaseWasDetermined","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"136A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_136A_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfObjectivesPoliciesAndProcessesForManagingCapitalTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"136","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_136&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FairValueHedgesMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"86","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2020-en-r&anchor=para_86_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowHedgesMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"86","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2020-en-r&anchor=para_86_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"HedgesOfNetInvestmentInForeignOperationsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"86","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2020-en-r&anchor=para_86_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnDisposalsOfOtherNoncurrentAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"EquityReclassifiedIntoFinancialLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"80A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_80A&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnHedgesOfNetInvestmentsInForeignOperationsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnHedgesOfNetInvestmentsInForeignOperationsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"102","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2020-en-r&anchor=para_102&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxHedgesOfNetInvestmentsInForeignOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"102","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2020-en-r&anchor=para_102_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxHedgesOfNetInvestmentsInForeignOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"102","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2020-en-r&anchor=para_102_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnHedgesOfNetInvestmentsInForeignOperationsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnHedgesOfNetInvestmentsInForeignOperationsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"102","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2020-en-r&anchor=para_102&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAnalysisOfOtherComprehensiveIncomeByItemExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106A&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLossFromOperatingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"32","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"IE33","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=32&code=ifrs-tx-2020-en-r&anchor=para_IE33&doctype=Illustrative%20Examples","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsClassifiedAsExpense","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"32","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"40","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=32&code=ifrs-tx-2020-en-r&anchor=para_40&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DifferenceBetweenCarryingAmountOfDividendsPayableAndCarryingAmountOfNoncashAssetsDistributed","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"17","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"15","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=17&code=ifrs-tx-2020-en-r&anchor=para_15&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnHedgesOfNetInvestmentsInForeignOperationsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"102","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2020-en-r&anchor=para_102_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnHedgesOfNetInvestmentsInForeignOperationsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"102","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2020-en-r&anchor=para_102_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentTradeReceivables","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentTradeReceivables","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"68","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_68&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainLossArisingFromDerecognitionOfFinancialAssetsMeasuredAtAmortisedCost","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82_aa&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsProposedOrDeclaredBeforeFinancialStatementsAuthorisedForIssueButNotRecognisedAsDistributionToOwnersPerShare","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"137","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_137_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"WritedownsReversalsOfPropertyPlantAndEquipment","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"WritedownsReversalsOfInventories","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAmountsToBeRecoveredOrSettledAfterTwelveMonthsForClassesOfAssetsAndLiabilitiesThatContainAmountsToBeRecoveredOrSettledBothNoMoreAndMoreThanTwelveMonthsAfterReportingDateExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"61","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_61&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAmountsToBeRecoveredOrSettledAfterTwelveMonthsForClassesOfAssetsAndLiabilitiesThatContainAmountsToBeRecoveredOrSettledBothNoMoreAndMoreThanTwelveMonthsAfterReportingDateTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"61","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_61&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExpenseByNature","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"99","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_99&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentBiologicalAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_f&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentBiologicalAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_f&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentAssetsOtherThanAssetsOrDisposalGroupsClassifiedAsHeldForSaleOrAsHeldForDistributionToOwners","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"66","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_66&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsRecognisedAsDistributionsToOwnersPerShare","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"107","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_107&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentLiabilitiesOtherThanLiabilitiesIncludedInDisposalGroupsClassifiedAsHeldForSale","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"69","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_69&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfTermsOfSharesReservedForIssueUnderOptionsAndContractsForSaleOfShares","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"vii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a_vii&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DepartureFromRequirementOfIFRSAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_20_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseDueToDepartureFromRequirementOfIFRSMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_20_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsOnLitigationSettlements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_f&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LossesOnLitigationSettlements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_f&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReversalOfProvisionsForCostOfRestructuring","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsOnDisposalsOfInvestments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LossesOnDisposalsOfInvestments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsOnDisposalsOfPropertyPlantAndEquipment","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LossesOnDisposalsOfPropertyPlantAndEquipment","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CapitalRequirementsAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"136","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_136&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CapitalRequirementsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"136","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_136&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialLiabilitiesReclassifiedIntoEquity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"80A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_80A&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfTimingAndReasonOfReclassificationBetweenFinancialLiabilitiesAndEquity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"80A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_80A&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAnalysisOfOtherComprehensiveIncomeByItemTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106A&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentTradeReceivables","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPrepayments","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNoncurrentReceivables","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentPrepayments","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeReceivables","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentReceivables","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Prepayments","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherReceivables","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReportedIfInComplianceWithRequirementOfIFRSMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_20_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdditionalPaidinCapitalMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfGoodwillExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"StatutoryReserveMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CapitalReserveMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CapitalRedemptionReserveMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"MergerReserveMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"MiscellaneousOtherReservesMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfEquityComponentOfConvertibleInstrumentsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AccumulatedOtherComprehensiveIncomeMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfIntangibleAssetsAndGoodwillExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfProvisionsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfIssuedCapitalExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfBorrowingsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfCommitmentsAndContingentLiabilitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfCommitmentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDerivativeFinancialInstrumentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfBasisOfPreparationOfFinancialStatementsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDeferredTaxesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfExpensesByNatureExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfExpensesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherOperatingIncomeExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherOperatingIncomeExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherOperatingExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfGeneralAndAdministrativeExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfLeasePrepaymentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDividendsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinanceIncomeExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinanceIncomeExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinanceCostExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfCashAndCashEquivalentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInformationAboutEmployeesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherCurrentAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherNoncurrentAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherCurrentLiabilitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherNoncurrentLiabilitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherLiabilitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDiscontinuedOperationsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfNoncurrentAssetsOrDisposalGroupsClassifiedAsHeldForSaleExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInvestmentsAccountedForUsingEquityMethodExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfTradeAndOtherReceivablesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfTradeAndOtherPayablesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfResearchAndDevelopmentExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAuditorsRemunerationExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInformationAboutKeyManagementPersonnelExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfTaxReceivablesAndPayablesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAuthorisationOfFinancialStatementsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAvailableforsaleAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_10_e&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfTreasurySharesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDepreciationAndAmortisationExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInterestExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfPrepaymentsAndOtherAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAccruedExpensesAndOtherLiabilitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfGoingConcernExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAccountingJudgementsAndEstimatesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInvestmentsOtherThanInvestmentsAccountedForUsingEquityMethodExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDeferredIncomeExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfRestrictedCashAndCashEquivalentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfNoncontrollingInterestsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfProfitLossFromOperatingActivitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfCostOfSalesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfBasisOfConsolidationExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfChangesInAccountingPoliciesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInvestmentContractsLiabilitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDeferredAcquisitionCostsArisingFromInsuranceContractsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReinsuranceExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfClaimsAndBenefitsPaidExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfNetAssetValueAttributableToUnitholdersExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInsurancePremiumRevenueExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfSubordinatedLiabilitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinancialInstrumentsAtFairValueThroughProfitOrLossExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinancialInstrumentsDesignatedAtFairValueThroughProfitOrLossExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinancialRiskManagementExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfLoansAndAdvancesToCustomersExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfLoansAndAdvancesToBanksExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFairValueOfFinancialInstrumentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinancialAssetsHeldForTradingExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinancialLiabilitiesHeldForTradingExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinancialInstrumentsHeldForTradingExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFeeAndCommissionIncomeExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDepositsFromCustomersExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfTradingIncomeExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfCollateralExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfCashAndBankBalancesAtCentralBanksExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfCreditRiskExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfMarketRiskExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfLiquidityRiskExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDebtSecuritiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDepositsFromBanksExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInterestIncomeExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReclassificationOfFinancialInstrumentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInterestIncomeExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAllowanceForCreditLossesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfRepurchaseAndReverseRepurchaseAgreementsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughTreasuryShareTransactions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAdditionalInformationExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentReceivablesFromTaxesOtherThanIncomeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfMethodsUsedToMeasureFairValueOfNoncashAssetsDeclaredForDistributionToOwnersBeforeFinancialStatementsAuthorisedForIssue","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"17","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=17&code=ifrs-tx-2020-en-r&anchor=para_17_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentReceivablesFromTaxesOtherThanIncomeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReceivablesFromTaxesOtherThanIncomeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentValueAddedTaxReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentValueAddedTaxReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ValueAddedTaxReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentPayablesOnSocialSecurityAndTaxesOtherThanIncomeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPayablesOnSocialSecurityAndTaxesOtherThanIncomeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PayablesOnSocialSecurityAndTaxesOtherThanIncomeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentValueAddedTaxPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentValueAddedTaxPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ValueAddedTaxPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShorttermEmployeeBenefitsAccruals","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"81A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_81A_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ComprehensiveIncomeAttributableToNoncontrollingInterests","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"81B","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_81B_b_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ComprehensiveIncomeAttributableToOwnersOfParent","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"81B","SubParagraph":null,"Clause":"ii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_81B_b_ii&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"81A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_81A_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLossAttributableToNoncontrollingInterests","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"81B","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_81B_a_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLossAttributableToOwnersOfParent","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"81B","SubParagraph":null,"Clause":"ii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_81B_a_ii&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLossFromDiscontinuedOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82_ea&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfBreakdownOfAssetsAndLiabilitiesAggregatedIntoSingleLineInvestmentBalanceTransitionFromProportionateConsolidationToEquityMethodExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"11","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"C5","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=11&code=ifrs-tx-2020-en-r&anchor=para_C5&doctype=Appendix&subtype=C","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReconciliationBetweenInvestmentDerecognisedAndAssetsAndLiabilitiesRecognisedTransitionFromAccountingForInvestmentAtCostOrInAccordanceWithIFRS9ToAccountingForAssetsAndLiabilitiesExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"11","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"C12","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=11&code=ifrs-tx-2020-en-r&anchor=para_C12_b&doctype=Appendix&subtype=C","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReconciliationBetweenInvestmentDerecognisedAndAssetsAndLiabilitiesRecognisedTransitionFromEquityMethodToAccountingForAssetsAndLiabilitiesExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"11","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"C10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=11&code=ifrs-tx-2020-en-r&anchor=para_C10&doctype=Appendix&subtype=C","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncontrollingInterests","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"10","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"22","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=10&code=ifrs-tx-2020-en-r&anchor=para_22&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToRemeasurementsOfDefinedBenefitPlansOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToComponentsOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToCashFlowHedgesOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToExchangeDifferencesOnTranslationOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToChangesInRevaluationSurplusOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToHedgesOfNetInvestmentsInForeignOperationsOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToShareOfOtherComprehensiveIncomeOfAssociatesAndJointVenturesAccountedForUsingEquityMethod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfRemeasurementsOfDefinedBenefitPlansMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevaluationSurplusMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RetainedEarningsMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfExchangeDifferencesOnTranslationMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfCashFlowHedgesMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfSharebasedPaymentsMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentsInAssociatesAccountedForUsingEquityMethod","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentAssetsLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LiabilitiesDueToCentralBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RecognisedLiabilitiesDefinedBenefitPlan","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RecognisedAssetsDefinedBenefitPlan","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNonfinancialLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentNonfinancialLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNonfinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNoncurrentNonfinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentNonfinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNoncurrentNonfinancialLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentPortionOfLongtermBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Borrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LongtermBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShorttermBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IntangibleAssetsAndGoodwill","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentBorrowingsAndCurrentPortionOfNoncurrentBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentLeasePrepayments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentRecognisedAssetsDefinedBenefitPlan","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentRestrictedCashAndCashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentDerivativeFinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentInvestmentsOtherThanInvestmentsAccountedForUsingEquityMethod","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNoncurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentRestrictedCashAndCashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentDerivativeFinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentPrepaymentsAndOtherCurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentInvestments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentRecognisedAssetsDefinedBenefitPlan","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RestrictedCashAndCashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DerivativeFinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LoansAndAdvancesToBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LoansAndAdvancesToCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashAndBankBalancesAtCentralBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentsOtherThanInvestmentsAccountedForUsingEquityMethod","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReverseRepurchaseAgreementsAndCashCollateralOnSecuritiesBorrowed","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentsForRiskOfPolicyholders","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentDerivativeFinancialLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentRecognisedLiabilitiesDefinedBenefitPlan","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentGovernmentGrants","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNoncurrentLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNoncurrentPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentAdvances","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentDividendPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentDerivativeFinancialLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentRecognisedLiabilitiesDefinedBenefitPlan","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentAccruedExpensesAndOtherCurrentLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentAdvances","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentDividendPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentGovernmentGrants","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DerivativeFinancialLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DepositsFromBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DepositsFromCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"SubordinatedLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DebtSecurities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RepurchaseAgreementsAndCashCollateralOnSecuritiesLent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentContractsLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CapitalReserve","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfEquityComponentOfConvertibleInstruments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AccumulatedOtherComprehensiveIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CapitalRedemptionReserve","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"MergerReserve","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"StatutoryReserve","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdditionalPaidinCapital","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Advances","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ItemsInCourseOfCollectionFromOtherBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ItemsInCourseOfTransmissionToOtherBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentsInJointVenturesAccountedForUsingEquityMethod","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShorttermDepositsNotClassifiedAsCashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LongtermDeposits","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"EquityInstrumentsHeld","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DebtInstrumentsHeld","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxGainsLossesOnRemeasurementsOfDefinedBenefitPlans","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnCashFlowHedgesBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxCashFlowHedges","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxExchangeDifferencesOnTranslation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShareOfOtherComprehensiveIncomeOfAssociatesAndJointVenturesAccountedForUsingEquityMethodBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxGainsLossesOnRevaluation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxHedgesOfNetInvestmentsInForeignOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnHedgesOfNetInvestmentsInForeignOperationsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnExchangeDifferencesOnTranslationBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxGainsLossesOnRemeasurementsOfDefinedBenefitPlans","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnCashFlowHedgesNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxCashFlowHedges","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxExchangeDifferencesOnTranslation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShareOfOtherComprehensiveIncomeOfAssociatesAndJointVenturesAccountedForUsingEquityMethod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxGainsLossesOnRevaluation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxHedgesOfNetInvestmentsInForeignOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnHedgesOfNetInvestmentsInForeignOperationsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnExchangeDifferencesOnTranslationNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeThatWillBeReclassifiedToProfitOrLossNetOfTax","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"IG6","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_IG6&doctype=Implementation%20Guidance","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeThatWillNotBeReclassifiedToProfitOrLossNetOfTax","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"IG6","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_IG6&doctype=Implementation%20Guidance","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherWorkPerformedByEntityAndCapitalised","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"IG6","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_IG6&doctype=Implementation%20Guidance","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RetainedEarnings","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"IG6","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_IG6&doctype=Implementation%20Guidance","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxGainsLossesOnRemeasurementsOfDefinedBenefitPlans","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxGainsLossesOnRemeasurementsOfDefinedBenefitPlans","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxCashFlowHedges","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxExchangeDifferencesOnTranslation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxCashFlowHedges","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxExchangeDifferencesOnTranslation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxGainsLossesOnRevaluation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxGainsLossesOnRevaluation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfRemeasurementsOfDefinedBenefitPlans","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfCashFlowHedges","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfSharebasedPayments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsOnChangeInFairValueOfDerivatives","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LossesOnChangeInFairValueOfDerivatives","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RoyaltyExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ServicesExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RentalExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinanceIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherIncomeExpenseFromSubsidiariesJointlyControlledEntitiesAndAssociates","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinanceIncomeCost","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RepairsAndMaintenanceExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherOperatingIncomeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BasicAndDilutedEarningsLossPerShare","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BasicAndDilutedEarningsLossPerShareFromContinuingOperations","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BasicAndDilutedEarningsLossPerShareFromDiscontinuedOperations","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DistributionAndAdministrativeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueAndOperatingIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OperatingExpenseExcludingCostOfSales","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"SalesAndMarketingExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TaxExpenseOtherThanIncomeTaxExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnChangeInFairValueOfDerivatives","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherFinanceIncomeCost","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FeeAndCommissionIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FeeAndCommissionExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FeeAndCommissionIncomeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradingIncomeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NetEarnedPremium","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ClaimsAndBenefitsPaidNetOfReinsuranceRecoveries","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseInProvisionForUnearnedPremium","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PremiumsWrittenNetOfReinsurance","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseInInsuranceLiabilitiesNetOfReinsurance","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AcquisitionAndAdministrationExpenseRelatedToInsuranceContracts","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseInAccumulatedDeferredTaxRecognisedInOtherComprehensiveIncomeDueToChangeInTaxRate","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeAttributableToOwnersOfParent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeAttributableToNoncontrollingInterests","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherIndividuallyImmaterialComponentsOfOtherComprehensiveIncomeNetOfTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherIndividuallyImmaterialComponentsOfOtherComprehensiveIncomeBeforeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToOtherIndividuallyImmaterialComponentsOfOtherComprehensiveIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughExerciseOfWarrantsEquity","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsRecognisedAsDistributionsToNoncontrollingInterests","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughChangeInEquityOfSubsidiaries","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughAcquisitionOfSubsidiary","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughDisposalOfSubsidiary","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughTransferBetweenRevaluationReserveAndRetainedEarnings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughTransferToStatutoryReserve","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughAppropriationOfRetainedEarnings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughExerciseOfOptions","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughConversionOfConvertibleInstruments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IssueOfConvertibleInstruments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DecreaseIncreaseThroughTaxOnSharebasedPaymentTransactions","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughTransactionsWithOwners","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PurchaseOfTreasuryShares","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"SaleOrIssueOfTreasuryShares","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CancellationOfTreasuryShares","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReductionOfIssuedCapital","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShareIssueRelatedCost","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NumberOfSharesIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDecommissioningRestorationAndRehabilitationProvisionsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForMiningRightsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForMiningAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForStrippingCostsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForOilAndGasAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForAvailableforsaleFinancialAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_117_b&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForHeldtomaturityInvestmentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_117_b&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForLoansAndReceivablesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_117_b&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForEmployeeBenefitsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForSegmentReportingExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForForeignCurrencyTranslationExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForPropertyPlantAndEquipmentExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForIntangibleAssetsOtherThanGoodwillExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForIntangibleAssetsAndGoodwillExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForInvestmentPropertyExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForConstructionInProgressExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForBusinessCombinationsAndGoodwillExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForGoodwillExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForBusinessCombinationsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForEarningsPerShareExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForIncomeTaxExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForLeasesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForTradeAndOtherReceivablesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForTradeAndOtherPayablesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForSubsidiariesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForTransactionsWithRelatedPartiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForIssuedCapitalExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForTreasurySharesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDividendsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForProvisionsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForImpairmentOfAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForImpairmentOfFinancialAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForImpairmentOfNonfinancialAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForBorrowingsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForBorrowingCostsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForResearchAndDevelopmentExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFinancialAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFinancialLiabilitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFinancialInstrumentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDerivativeFinancialInstrumentsAndHedgingExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDerivativeFinancialInstrumentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForHedgingExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForNoncurrentAssetsOrDisposalGroupsClassifiedAsHeldForSaleExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDiscontinuedOperationsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForNoncurrentAssetsOrDisposalGroupsClassifiedAsHeldForSaleAndDiscontinuedOperationsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForInvestmentsOtherThanInvestmentsAccountedForUsingEquityMethodExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForInvestmentInAssociatesAndJointVenturesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForRestrictedCashAndCashEquivalentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForExpensesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFinanceIncomeAndCostsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFinanceCostsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForSharebasedPaymentTransactionsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFairValueMeasurementExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForCashFlowsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDepreciationExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFunctionalCurrencyExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForTransactionsWithNoncontrollingInterestsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForEnvironmentRelatedExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForBiologicalAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForReinsuranceExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDeferredAcquisitionCostsArisingFromInsuranceContractsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFinancialInstrumentsAtFairValueThroughProfitOrLossExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFinancialGuaranteesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForOffsettingOfFinancialInstrumentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDerecognitionOfFinancialInstrumentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFeeAndCommissionIncomeAndExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForRepurchaseAndReverseRepurchaseAgreementsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForCollateralExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForInterestIncomeAndExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForTradingIncomeAndExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForReclassificationOfFinancialInstrumentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForInvestmentInAssociates","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForInvestmentsInJointVentures","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForTerminationBenefits","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FuelAndEnergyExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TransportationExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InsuranceExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanFiveYearsAndNotLaterThanTenYearsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanTenYearsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DirectorsRemunerationExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfessionalFeesExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ContractualCapitalCommitments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AuthorisedCapitalCommitmentsButNotContractedFor","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CapitalCommitments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanOneYearAndNotLaterThanTwoYearsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanTwoYearsAndNotLaterThanThreeYearsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanThreeYearsAndNotLaterThanFourYearsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanFourYearsAndNotLaterThanFiveYearsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanTwoYearsAndNotLaterThanFiveYearsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPortionOfNoncurrentLoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentLoansReceivedAndCurrentPortionOfNoncurrentLoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPortionOfNoncurrentSecuredBankLoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentSecuredBankLoansReceivedAndCurrentPortionOfNoncurrentSecuredBankLoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"SecuredBankLoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPortionOfNoncurrentUnsecuredBankLoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentUnsecuredBankLoansReceivedAndCurrentPortionOfNoncurrentUnsecuredBankLoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"UnsecuredBankLoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPortionOfNoncurrentBondsIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentBondsIssuedAndCurrentPortionOfNoncurrentBondsIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BondsIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPortionOfOtherNoncurrentBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentBorrowingsAndCurrentPortionOfOtherNoncurrentBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPortionOfNoncurrentNotesAndDebenturesIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentNotesAndDebenturesIssuedAndCurrentPortionOfNoncurrentNotesAndDebenturesIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NotesAndDebenturesIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPortionOfNoncurrentCommercialPapersIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentCommercialPapersIssuedAndCurrentPortionOfNoncurrentCommercialPapersIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CommercialPapersIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentAdvancesToSuppliers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentPrepaidExpenses","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentInterestReceivable","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentInterestReceivable","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestReceivable","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentInterestPayable","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentInterestPayable","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestPayable","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AuditorsRemuneration","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AuditorsRemunerationForAuditServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AuditorsRemunerationForTaxServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AuditorsRemunerationForOtherServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnDisposalsOfNoncurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsOnDisposalsOfNoncurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LossesOnDisposalsOfNoncurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"MiscellaneousOtherOperatingIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"MiscellaneousOtherOperatingExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RentalIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeFromReimbursementsUnderInsurancePolicies","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherFinanceCost","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherFinanceIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnLoansAndReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_112_c&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnCashAndCashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnBankLoansAndOverdrafts","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnBonds","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExpenseDueToUnwindingOfDiscountOnProvisions","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseInNumberOfOrdinarySharesIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DepreciationExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AmortisationExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ClosingForeignExchangeRate","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AverageForeignExchangeRate","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NumberOfEmployees","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AverageNumberOfEmployees","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExpenseFromSharebasedPaymentTransactionsWithEmployees","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExpenseFromCashsettledSharebasedPaymentTransactionsInWhichGoodsOrServicesReceivedDidNotQualifyForRecognitionAsAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherDebtInstrumentsHeld","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GovernmentDebtInstrumentsHeld","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CorporateDebtInstrumentsHeld","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BankDebtInstrumentsHeld","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AssetbackedDebtInstrumentsHeld","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ConsumerLoans","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CorporateLoans","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BankBalancesAtCentralBanksOtherThanMandatoryReserveDeposits","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"MandatoryReserveDepositsAtCentralBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DatedSubordinatedLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"UndatedSubordinatedLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BalancesOnCurrentAccountsFromCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BalancesOnTermDepositsFromCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BalancesOnDemandDepositsFromCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BalancesOnOtherDepositsFromCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OptionContractMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FuturesContractMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"SwapContractMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ForwardContractMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnDepositsFromBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnDepositsFromCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnDebtInstrumentsIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnOtherFinancialLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnFinancialLiabilitiesHeldForTrading","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnFinancialLiabilitiesDesignatedAtFairValueThroughProfitOrLoss","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnRepurchaseAgreementsAndCashCollateralOnSecuritiesLent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnCashAndBankBalancesAtCentralBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnAvailableforsaleFinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_112_c&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnHeldtomaturityInvestments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_112_c&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnLoansAndAdvancesToBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnLoansAndAdvancesToCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnDebtInstrumentsHeld","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnOtherFinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnFinancialAssetsHeldForTrading","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnFinancialAssetsDesignatedAtFairValueThroughProfitOrLoss","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnReverseRepurchaseAgreementsAndCashCollateralOnSecuritiesBorrowed","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BrokerageFeeIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PortfolioAndOtherManagementFeeIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CreditrelatedFeeAndCommissionIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherFeeAndCommissionIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BrokerageFeeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherFeeAndCommissionExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradingIncomeExpenseOnForeignExchangeContracts","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradingIncomeExpenseOnDerivativeFinancialInstruments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradingIncomeExpenseOnEquityInstruments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradingIncomeExpenseOnDebtInstruments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherTradingIncomeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShorttermEmployeeBenefitsExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CorporateLoansMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanOneMonthAndNotLaterThanTwoMonthsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanTwoMonthsAndNotLaterThanThreeMonthsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanSixMonthsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NotionalAmount","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OnDemandMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToComponentsOfOtherComprehensiveIncomeThatWillNotBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToShareOfOtherComprehensiveIncomeOfAssociatesAndJointVenturesAccountedForUsingEquityMethodThatWillBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToShareOfOtherComprehensiveIncomeOfAssociatesAndJointVenturesAccountedForUsingEquityMethodThatWillNotBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToComponentsOfOtherComprehensiveIncomeThatWillBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeThatWillNotBeReclassifiedToProfitOrLossBeforeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"IG6","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_IG6&doctype=Implementation%20Guidance","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeThatWillBeReclassifiedToProfitOrLossBeforeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"IG6","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_IG6&doctype=Implementation%20Guidance","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLossFromContinuingOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"81A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_81A_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"81A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_81A_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfFactThatEntityDoesNotHaveLegalOrConstructiveObligationToNegativeNetAssetsTransitionFromProportionateConsolidationToEquityMethod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"11","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"C4","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=11&code=ifrs-tx-2020-en-r&anchor=para_C4&doctype=Appendix&subtype=C","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CumulativeUnrecognisedShareOfLossesOfJointVenturesTransitionFromProportionateConsolidationToEquityMethod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"11","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"C4","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=11&code=ifrs-tx-2020-en-r&anchor=para_C4&doctype=Appendix&subtype=C","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"StatementThatUnadjustedComparativeInformationHasBeenPreparedOnDifferentBasis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"10","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"C6B","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=10&code=ifrs-tx-2020-en-r&anchor=para_C6B&doctype=Appendix&subtype=C","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfBasisOfPreparationOfUnadjustedComparativeInformation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"10","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"C6B","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=10&code=ifrs-tx-2020-en-r&anchor=para_C6B&doctype=Appendix&subtype=C","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IdentificationOfUnadjustedComparativeInformation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"10","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"C6B","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=10&code=ifrs-tx-2020-en-r&anchor=para_C6B&doctype=Appendix&subtype=C","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OrdinarySharesMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PreferenceSharesMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"79","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_79_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RawMaterials","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Merchandise","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProductionSupplies","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"WorkInProgress","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinishedGoods","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsRecognisedAsDistributionsToOwnersOfParent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsRecognisedAsDistributionsToOwnersOfParentRelatingToPriorYears","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsRecognisedAsDistributionsToOwnersOfParentRelatingToCurrentYear","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"106","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_106_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnLiabilitiesDueToCentralBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GovernmentGrants","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DateOfEndOfReportingPeriod2013","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"51","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_51_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeFromFinesAndPenalties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForCustomerAcquisitionCostsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinanceLeaseReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentFinanceLeaseReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentFinanceLeaseReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DepreciationAmortisationAndImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsOnDisposalsOfInvestmentProperties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LossesOnDisposalsOfInvestmentProperties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnDisposalsOfInvestmentProperties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyServiceChargeIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyServiceChargeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyServiceChargeIncomeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyManagementExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyDevelopmentAndProjectManagementIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyDevelopmentAndProjectManagementExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RentalIncomeFromInvestmentPropertyNetOfDirectOperatingExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BankAndSimilarCharges","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyTaxExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ImpairmentLossRecognisedInProfitOrLossTradeReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReversalOfImpairmentLossRecognisedInProfitOrLossTradeReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLossTradeReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyIntendedForSaleInOrdinaryCourseOfBusiness","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentDepositsFromCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentDepositsFromCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RentDeferredIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RentDeferredIncomeClassifiedAsCurrent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RentDeferredIncomeClassifiedAsNoncurrent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RetentionPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentRetentionPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentRetentionPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReceivablesFromSaleOfProperties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReceivablesFromRentalOfProperties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentReceivablesFromSaleOfProperties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentReceivablesFromRentalOfProperties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentReceivablesFromSaleOfProperties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentReceivablesFromRentalOfProperties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BorrowingCostsIncurred","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BorrowingCostsRecognisedAsExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestCostsCapitalised","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestCostsIncurred","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanThreeMonthsAndNotLaterThanFourMonthsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanFourMonthsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeReceivablesMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentPropertyUnderConstructionOrDevelopment","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentPropertyCompleted","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TypesOfInvestmentPropertyAxis","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentPropertyUnderConstructionOrDevelopmentMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentPropertyCompletedMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AccrualsAndDeferredIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AccrualsAndDeferredIncomeClassifiedAsCurrent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AccrualsAndDeferredIncomeClassifiedAsNoncurrent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentPropertyMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForRecognitionOfRevenue","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfRevenueExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_10_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherRevenue","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromConstructionContracts","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromDividends","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromInterest","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfDataServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfInterconnectionServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfInternetAndDataServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfInternetServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfLandLineTelephoneServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfMobileTelephoneServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfOtherTelecommunicationServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfTelecommunicationServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfTelephoneServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRoyalties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromSaleOfCopper","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromSaleOfCrudeOil","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromSaleOfGold","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromSaleOfGoods","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromSaleOfNaturalGas","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromSaleOfOilAndGasProducts","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromSaleOfPetroleumAndPetrochemicalProducts","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromSaleOfSilver","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromSaleOfTelecommunicationEquipment","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LicenceFeeIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"SellingGeneralAndAdministrativeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForTaxesOtherThanIncomeTaxExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForWarrantsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfTransportServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfPassengerTransportServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfCargoAndMailTransportServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OperatingExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FuelExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"EnergyExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnDeposits","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForCustomerLoyaltyProgrammesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForRepairsAndMaintenanceExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDeferredIncomeTaxExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AccruedIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PrepaymentsAndAccruedIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentAccruedIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentPrepaymentsAndCurrentAccruedIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentAccruedIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPrepaymentsAndNoncurrentAccruedIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NotLaterThanThreeMonthsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShareOfOtherComprehensiveIncomeOfAssociatesAndJointVenturesAccountedForUsingEquityMethodThatWillBeReclassifiedToProfitOrLossNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82A&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShareOfOtherComprehensiveIncomeOfAssociatesAndJointVenturesAccountedForUsingEquityMethodThatWillBeReclassifiedToProfitOrLossBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82A&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShareOfOtherComprehensiveIncomeOfAssociatesAndJointVenturesAccountedForUsingEquityMethodThatWillNotBeReclassifiedToProfitOrLossBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82A&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShareOfOtherComprehensiveIncomeOfAssociatesAndJointVenturesAccountedForUsingEquityMethodThatWillNotBeReclassifiedToProfitOrLossNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82A&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfSummaryOfSignificantAccountingPoliciesExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForEmissionRightsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfInformationTechnologyServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfInformationTechnologyMaintenanceAndSupportServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfInformationTechnologyConsultingServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfAdvertisingServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfPrintingServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"MediaProductionExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProgrammingAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentProgrammingAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentProgrammingAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForProgrammingAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromSaleOfElectricity","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"EnergyTransmissionCharges","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PayablesForPurchaseOfEnergy","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentPayablesForPurchaseOfEnergy","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPayablesForPurchaseOfEnergy","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForRegulatoryDeferralAccountsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForServiceConcessionArrangementsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"TravelExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CommunicationExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DonationsAndSubsidiesExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CostOfMerchandiseSold","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CostOfPurchasedEnergySold","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PayablesForPurchaseOfNoncurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentPayablesForPurchaseOfNoncurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPayablesForPurchaseOfNoncurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForContingentLiabilitiesAndContingentAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrencySwapContractMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestRateSwapContractMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromSaleOfPublications","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CirculationRevenue","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"SubscriptionCirculationRevenue","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NonsubscriptionCirculationRevenue","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromSaleOfBooks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShareOfProfitLossOfAssociatesAccountedForUsingEquityMethod","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShareOfProfitLossOfJointVenturesAccountedForUsingEquityMethod","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AssetsLessCurrentLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromSaleOfAgriculturalProduce","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromSaleOfSugar","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromSaleOfAlcoholAndAlcoholicDrinks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromHotelOperations","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRoomOccupancyServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromSaleOfFoodAndBeverage","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromRenderingOfGamingServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CostOfSalesHotelOperations","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CostOfSalesRoomOccupancyServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CostOfSalesFoodAndBeverage","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FranchiseFeeIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFranchiseFeesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDiscountsAndRebatesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"UtilitiesExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"SellingExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GeneralAndAdministrativeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdvertisingExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReceivablesDueFromAssociates","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentReceivablesDueFromAssociates","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentReceivablesDueFromAssociates","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReceivablesDueFromJointVentures","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentReceivablesDueFromJointVentures","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentReceivablesDueFromJointVentures","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentExciseTaxPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExciseTaxPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentExciseTaxPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentDebtInstrumentsIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentDebtInstrumentsIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NetDebt","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForExceptionalItemsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ImpairmentLossRecognisedInProfitOrLossLoansAndAdvances","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReversalOfImpairmentLossRecognisedInProfitOrLossLoansAndAdvances","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLossLoansAndAdvances","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainOnRecoveryOfLoansAndAdvancesPreviouslyWrittenOff","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BankAcceptanceAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BankAcceptanceLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DerivativeFinancialAssetsHeldForTrading","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DerivativeFinancialAssetsHeldForHedging","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DerivativeFinancialLiabilitiesHeldForTrading","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DerivativeFinancialLiabilitiesHeldForHedging","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OccupancyExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LoansToGovernment","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LoansToGovernmentMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialAssetsAtFairValueThroughProfitOrLossClassifiedAsHeldForTrading","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentFinancialAssetsAtFairValueThroughProfitOrLossClassifiedAsHeldForTrading","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentFinancialAssetsAtFairValueThroughProfitOrLossClassifiedAsHeldForTrading","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_55&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NetAssetsLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"112","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_112_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLossFromOperatingActivities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherWorkPerformedByEntityAndCapitalised","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeThatWillBeReclassifiedToProfitOrLossNetOfTax","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82A&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeThatWillNotBeReclassifiedToProfitOrLossNetOfTax","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82A&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeThatWillBeReclassifiedToProfitOrLossBeforeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82A&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeThatWillNotBeReclassifiedToProfitOrLossBeforeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82A&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForInsuranceContracts","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"117","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_117_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestRevenueCalculatedUsingEffectiveInterestMethod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82_a_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveForCatastropheMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_108&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveForEqualisationMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_108&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveForCatastrophe","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-b&anchor=para_78_e&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveForEqualisation","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-b&anchor=para_78_e&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfDiscretionaryParticipationFeaturesMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_108&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfDiscretionaryParticipationFeatures","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-b&anchor=para_78_e&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AssetsUnderInsuranceContractsAndReinsuranceContractsIssued","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-b&anchor=para_55&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AssetsUnderReinsuranceCeded","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-b&anchor=para_55&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LiabilitiesArisingFromInsuranceContracts","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"55","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-b&anchor=para_55&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueFromInsuranceContractsIssuedWithoutReductionForReinsuranceHeld","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-b&anchor=para_85&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeFromContractsWithReinsurers","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-b&anchor=para_85&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExpenseForPolicyholderClaimsAndBenefitsWithoutReductionForReinsuranceHeld","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-b&anchor=para_85&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExpensesArisingFromReinsuranceHeld","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-b&anchor=para_85&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InsuranceContractsIssuedThatAreAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_da&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InsuranceContractsIssuedThatAreLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_ma&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReinsuranceContractsHeldThatAreAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_da&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReinsuranceContractsHeldThatAreLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"54","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_54_ma&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InsuranceRevenue","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82","SubParagraph":null,"Clause":"ii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82_a_ii&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InsuranceServiceExpensesFromInsuranceContractsIssued","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82_ab&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeExpensesFromReinsuranceContractsHeldOtherThanFinanceIncomeExpenses","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82_ac&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedRecognisedInProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82_bb&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinanceIncomeExpensesFromReinsuranceContractsHeldRecognisedInProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82_bc&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedExcludedFromProfitOrLossThatWillBeReclassifiedToProfitOrLossNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnInsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedExcludedFromProfitOrLossNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxInsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedExcludedFromProfitOrLossThatWillBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxInsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedExcludedFromProfitOrLossThatWillBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxInsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedExcludedFromProfitOrLossThatWillNotBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxInsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedExcludedFromProfitOrLossThatWillNotBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedExcludedFromProfitOrLossThatWillBeReclassifiedToProfitOrLossBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnInsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedExcludedFromProfitOrLossBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxInsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedExcludedFromProfitOrLossThatWillBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxInsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedExcludedFromProfitOrLossThatWillBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxInsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedExcludedFromProfitOrLossThatWillNotBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxInsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedExcludedFromProfitOrLossThatWillNotBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToInsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedOfOtherComprehensiveIncomeThatWillBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToInsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedOfOtherComprehensiveIncomeThatWillNotBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfInsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedExcludedFromProfitOrLossThatWillBeReclassifiedToProfitOrLoss","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfInsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedExcludedFromProfitOrLossThatWillBeReclassifiedToProfitOrLossMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfInsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedExcludedFromProfitOrLossThatWillNotBeReclassifiedToProfitOrLoss","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfInsuranceFinanceIncomeExpensesFromInsuranceContractsIssuedExcludedFromProfitOrLossThatWillNotBeReclassifiedToProfitOrLossMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinanceIncomeExpensesFromReinsuranceContractsHeldExcludedFromProfitOrLossNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnFinanceIncomeExpensesFromReinsuranceContractsHeldExcludedFromProfitOrLossNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxFinanceIncomeExpensesFromReinsuranceContractsHeldExcludedFromProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxFinanceIncomeExpensesFromReinsuranceContractsHeldExcludedFromProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinanceIncomeExpensesFromReinsuranceContractsHeldExcludedFromProfitOrLossBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnFinanceIncomeExpensesFromReinsuranceContractsHeldExcludedFromProfitOrLossBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxFinanceIncomeExpensesFromReinsuranceContractsHeldExcludedFromProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxFinanceIncomeExpensesFromReinsuranceContractsHeldExcludedFromProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToFinanceIncomeExpensesFromReinsuranceContractsHeldOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfFinanceIncomeExpensesFromReinsuranceContractsHeldExcludedFromProfitOrLoss","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfFinanceIncomeExpensesFromReinsuranceContractsHeldExcludedFromProfitOrLossMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IdentificationOfUnadjustedComparativeInformation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"11","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"C13B","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=11&code=ifrs-tx-2020-en-r&anchor=para_C13B&doctype=Appendix&subtype=C","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"StatementThatUnadjustedComparativeInformationHasBeenPreparedOnDifferentBasis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"11","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"C13B","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=11&code=ifrs-tx-2020-en-r&anchor=para_C13B&doctype=Appendix&subtype=C","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfBasisOfPreparationOfUnadjustedComparativeInformation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"11","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"C13B","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=11&code=ifrs-tx-2020-en-r&anchor=para_C13B&doctype=Appendix&subtype=C","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestRevenueExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"85","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_85&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLossFromDiscontinuedOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"98","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_98_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnFinancialAssetsMeasuredAtFairValueThroughOtherComprehensiveIncomeBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxFinancialAssetsMeasuredAtFairValueThroughOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxFinancialAssetsMeasuredAtFairValueThroughOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnHedgesOfNetInvestmentsInForeignOperationsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.13","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.13_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnChangeInValueOfTimeValueOfOptionsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AmountRemovedFromReserveOfChangeInValueOfForeignCurrencyBasisSpreadsAndIncludedInInitialCostOrOtherCarryingAmountOfNonfinancialAssetLiabilityOrFirmCommitmentForWhichFairValueHedgeAccountingIsApplied","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToChangeInValueOfForeignCurrencyBasisSpreadsOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxGainsLossesOnHedgingInstrumentsThatHedgeInvestmentsInEquityInstruments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxGainsLossesOnHedgingInstrumentsThatHedgeInvestmentsInEquityInstruments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfCashFlowHedgesMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.11","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.11&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxGainsLossesFromInvestmentsInEquityInstruments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxGainsLossesFromInvestmentsInEquityInstruments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToChangeInValueOfTimeValueOfOptionsOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnFinancialAssetsMeasuredAtFairValueThroughOtherComprehensiveIncomeBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnChangeInValueOfForwardElementsOfForwardContractsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AmountRemovedFromReserveOfChangeInValueOfForwardElementsOfForwardContractsAndIncludedInInitialCostOrOtherCarryingAmountOfNonfinancialAssetLiabilityOrFirmCommitmentForWhichFairValueHedgeAccountingIsApplied","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToChangesInFairValueOfFinancialLiabilityAttributableToChangeInCreditRiskOfLiabilityOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AmountsRemovedFromEquityAndAdjustedAgainstFairValueOfFinancialAssetsOnReclassificationOutOfFairValueThroughOtherComprehensiveIncomeMeasurementCategoryBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"5.6.5","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_5.6.5&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxChangeInFairValueOfFinancialLiabilityAttributableToChangeInCreditRiskOfLiability","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxChangeInFairValueOfFinancialLiabilityAttributableToChangeInCreditRiskOfLiability","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnFinancialAssetsMeasuredAtFairValueThroughOtherComprehensiveIncomeNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfChangeInFairValueOfFinancialLiabilityAttributableToChangeInCreditRiskOfLiability","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfChangeInValueOfTimeValueOfOptions","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfChangeInValueOfTimeValueOfOptions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.15","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.15&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnChangeInValueOfTimeValueOfOptionsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToFinancialAssetsMeasuredAtFairValueThroughOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxChangeInValueOfForwardElementsOfForwardContracts","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxChangeInValueOfForwardElementsOfForwardContracts","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxChangeInValueOfForeignCurrencyBasisSpreads","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxChangeInValueOfForeignCurrencyBasisSpreads","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfChangeInValueOfForwardElementsOfForwardContractsMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfChangeInValueOfForwardElementsOfForwardContractsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfChangeInValueOfForwardElementsOfForwardContracts","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfChangeInValueOfForwardElementsOfForwardContracts","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnChangeInValueOfForeignCurrencyBasisSpreadsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxChangeInValueOfTimeValueOfOptions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxChangeInValueOfTimeValueOfOptions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnChangeInValueOfForeignCurrencyBasisSpreadsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AmountsRemovedFromEquityAndAdjustedAgainstFairValueOfFinancialAssetsOnReclassificationOutOfFairValueThroughOtherComprehensiveIncomeMeasurementCategoryNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"5.6.5","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_5.6.5&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxChangeInValueOfForwardElementsOfForwardContracts","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxChangeInValueOfForwardElementsOfForwardContracts","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnChangeInValueOfForeignCurrencyBasisSpreadsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentNoncashAssetsPledgedAsCollateralForWhichTransfereeHasRightByContractOrCustomToSellOrRepledgeCollateral","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"3.2.23","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_3.2.23_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CumulativeGainLossPreviouslyRecognisedInOtherComprehensiveIncomeArisingFromReclassificationOfFinancialAssetsOutOfFairValueThroughOtherComprehensiveIncomeIntoFairValueThroughProfitOrLossMeasurementCategory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82_cb&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfGainsAndLossesFromInvestmentsInEquityInstrumentsMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxHedgesOfNetInvestmentsInForeignOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.13","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.13_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfGainsAndLossesOnFinancialAssetsMeasuredAtFairValueThroughOtherComprehensiveIncomeMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToChangeInValueOfForwardElementsOfForwardContractsOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfCashFlowHedges","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.11","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.11&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnHedgesOfNetInvestmentsInForeignOperationsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.14&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfGainsAndLossesFromInvestmentsInEquityInstruments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ImpairmentLossImpairmentGainAndReversalOfImpairmentLossDeterminedInAccordanceWithIFRS9","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82_ba&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncashAssetsPledgedAsCollateralForWhichTransfereeHasRightByContractOrCustomToSellOrRepledgeCollateral","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"3.2.23","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_3.2.23_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesArisingFromDifferenceBetweenPreviousCarryingAmountAndFairValueOfFinancialAssetsReclassifiedAsMeasuredAtFairValue","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82_ca&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"HedgingGainsLossesForHedgeOfGroupOfItemsWithOffsettingRiskPositions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.6.4","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.6.4&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnChangeInValueOfForwardElementsOfForwardContractsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnChangeInValueOfTimeValueOfOptionsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnChangeInValueOfForwardElementsOfForwardContractsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfChangeInValueOfForeignCurrencyBasisSpreadsMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfChangeInValueOfForeignCurrencyBasisSpreadsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxGainsLossesFromInvestmentsInEquityInstruments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxGainsLossesFromInvestmentsInEquityInstruments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfChangeInValueOfTimeValueOfOptionsMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfChangeInValueOfTimeValueOfOptionsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.15","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.15&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxChangeInValueOfTimeValueOfOptions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxChangeInValueOfTimeValueOfOptions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToHedgesOfInvestmentsInEquityInstrumentsOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxChangeInValueOfForeignCurrencyBasisSpreads","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxChangeInValueOfForeignCurrencyBasisSpreads","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxHedgesOfNetInvestmentsInForeignOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.13","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.13_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnHedgesOfNetInvestmentsInForeignOperationsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.13","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.13_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestRevenueCalculatedUsingEffectiveInterestMethod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"82","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_82_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnChangeInValueOfForeignCurrencyBasisSpreadsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_92&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfChangeInValueOfForeignCurrencyBasisSpreads","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfChangeInValueOfForeignCurrencyBasisSpreads","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnChangeInValueOfForwardElementsOfForwardContractsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AmountRemovedFromReserveOfCashFlowHedgesAndIncludedInInitialCostOrOtherCarryingAmountOfNonfinancialAssetLiabilityOrFirmCommitmentForWhichFairValueHedgeAccountingIsApplied","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.11","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.11_d_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxFinancialAssetsMeasuredAtFairValueThroughOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxFinancialAssetsMeasuredAtFairValueThroughOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnChangeInValueOfTimeValueOfOptionsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfGainsAndLossesOnHedgingInstrumentsThatHedgeInvestmentsInEquityInstruments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfChangeInFairValueOfFinancialLiabilityAttributableToChangeInCreditRiskOfLiabilityMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfGainsAndLossesOnHedgingInstrumentsThatHedgeInvestmentsInEquityInstrumentsMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_108&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnHedgesOfNetInvestmentsInForeignOperationsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.14&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentNoncashAssetsPledgedAsCollateralForWhichTransfereeHasRightByContractOrCustomToSellOrRepledgeCollateral","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"3.2.23","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_3.2.23_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxGainsLossesOnHedgingInstrumentsThatHedgeInvestmentsInEquityInstruments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxGainsLossesOnHedgingInstrumentsThatHedgeInvestmentsInEquityInstruments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToInvestmentsInEquityInstrumentsOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_90&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AmountRemovedFromReserveOfChangeInValueOfTimeValueOfOptionsAndIncludedInInitialCostOrOtherCarryingAmountOfNonfinancialAssetLiabilityOrFirmCommitmentForWhichFairValueHedgeAccountingIsApplied","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"6.5.15","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_6.5.15_b_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfGainsAndLossesOnFinancialAssetsMeasuredAtFairValueThroughOtherComprehensiveIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_78_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxChangeInFairValueOfFinancialLiabilityAttributableToChangeInCreditRiskOfLiability","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_7&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxChangeInFairValueOfFinancialLiabilityAttributableToChangeInCreditRiskOfLiability","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnFinancialAssetsMeasuredAtFairValueThroughOtherComprehensiveIncomeNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2020-en-r&anchor=para_91_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnRemeasuringAvailableforsaleFinancialAssetsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_91_b&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnAvailableforsaleFinancialAssetsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_92&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxAvailableforsaleFinancialAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_91_b&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxAvailableforsaleFinancialAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_7&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToAvailableforsaleFinancialAssetsOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"90","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_90&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnRemeasuringAvailableforsaleFinancialAssetsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_91_a&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnAvailableforsaleFinancialAssetsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"92","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_92&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxAvailableforsaleFinancialAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"91","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_91_a&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxAvailableforsaleFinancialAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_7&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfGainsAndLossesOnRemeasuringAvailableforsaleFinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"78","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_78_e&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfGainsAndLossesOnRemeasuringAvailableforsaleFinancialAssetsMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"108","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2017-en-b&anchor=para_108&doctype=Standard&forcepdf=true","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncashAssetsPledgedAsCollateralForWhichTransfereeHasRightByContractOrCustomToSellOrRepledgeCollateral","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2017-en-b&anchor=para_37_a&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentNoncashAssetsPledgedAsCollateralForWhichTransfereeHasRightByContractOrCustomToSellOrRepledgeCollateral","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2017-en-b&anchor=para_37_a&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentNoncashAssetsPledgedAsCollateralForWhichTransfereeHasRightByContractOrCustomToSellOrRepledgeCollateral","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2017-en-b&anchor=para_37_a&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ClassesOfFinancialAssetsAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ClassesOfFinancialLiabilitiesAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfReasonsForDesignationOrDedesignationOfFinancialAssetsAsMeasuredAtFairValueThroughProfitOrLossWhenApplyingAmendmentsToIFRS9ForPrepaymentFeaturesWithNegativeCompensation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfReasonsForDesignationOrDedesignationOfFinancialLiabilitiesAsMeasuredAtFairValueThroughProfitOrLossWhenApplyingAmendmentsToIFRS9ForPrepaymentFeaturesWithNegativeCompensation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinancialAssetsAffectedByAmendmentsToIFRS9ForPrepaymentFeaturesWithNegativeCompensationExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinancialAssetsAffectedByAmendmentsToIFRS9ForPrepaymentFeaturesWithNegativeCompensationTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinancialLiabilitiesAffectedByAmendmentsToIFRS9ForPrepaymentFeaturesWithNegativeCompensationExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinancialLiabilitiesAffectedByAmendmentsToIFRS9ForPrepaymentFeaturesWithNegativeCompensationTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialAssetsAffectedByAmendmentsToIFRS9ForPrepaymentFeaturesWithNegativeCompensationCarryingAmountAfterApplyingAmendments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialAssetsAffectedByAmendmentsToIFRS9ForPrepaymentFeaturesWithNegativeCompensationCarryingAmountImmediatelyBeforeApplyingAmendments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialAssetsAffectedByAmendmentsToIFRS9ForPrepaymentFeaturesWithNegativeCompensationMeasurementCategoryAfterApplyingAmendments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialAssetsAffectedByAmendmentsToIFRS9ForPrepaymentFeaturesWithNegativeCompensationMeasurementCategoryImmediatelyBeforeApplyingAmendments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialAssetsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialAssetsThatWereDesignatedAsMeasuredAtFairValueThroughProfitOrLossBeforeApplicationOfAmendmentsToIFRS9ForPrepaymentFeaturesWithNegativeCompensationThatAreNoLongerSoDesignated","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialLiabilitiesAffectedByAmendmentsToIFRS9ForPrepaymentFeaturesWithNegativeCompensationCarryingAmountAfterApplyingAmendments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialLiabilitiesAffectedByAmendmentsToIFRS9ForPrepaymentFeaturesWithNegativeCompensationCarryingAmountImmediatelyBeforeApplyingAmendments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialLiabilitiesAffectedByAmendmentsToIFRS9ForPrepaymentFeaturesWithNegativeCompensationMeasurementCategoryAfterApplyingAmendments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialLiabilitiesAffectedByAmendmentsToIFRS9ForPrepaymentFeaturesWithNegativeCompensationMeasurementCategoryImmediatelyBeforeApplyingAmendments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialLiabilitiesMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialLiabilitiesThatWereDesignatedAsMeasuredAtFairValueThroughProfitOrLossBeforeApplicationOfAmendmentsToIFRS9ForPrepaymentFeaturesWithNegativeCompensationThatAreNoLongerSoDesignated","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"9","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"7.2.34","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=9&code=ifrs-tx-2020-en-r&anchor=para_7.2.34_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Inventories","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"36","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_36_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InventoryWritedown2011","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"36","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_36_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReversalOfInventoryWritedown","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"36","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_36_f&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInventoriesExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"0","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&doctype=Standard&dita_xref=IAS02_g36-39_TI","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForMeasuringInventories","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"36","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_36_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InventoryCostFormulas","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"36","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_36_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CostOfInventoriesRecognisedAsExpenseDuringPeriod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"36","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_36_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InventoriesPledgedAsSecurityForLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"36","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_36_h&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CircumstancesLeadingToReversalsOfInventoryWritedown","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"36","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_36_g&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InventoriesAtFairValueLessCostsToSell","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"36","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_36_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentOreStockpiles","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentOreStockpiles","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentCrudeOil","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentPetroleumAndPetrochemicalProducts","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentNaturalGas","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RawMaterials","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherInventories","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Merchandise","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinishedGoods","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"WorkInProgress","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProductionSupplies","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"SpareParts","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentRawMaterialsAndCurrentProductionSupplies","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentMaterialsAndSuppliesToBeConsumedInProductionProcessOrRenderingServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentInventoriesHeldForSale","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentFuel","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InventoriesAtNetRealisableValue","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"36","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_36&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentAgriculturalProduce","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentFoodAndBeverage","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentPackagingAndStorageMaterials","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentInventoriesInTransit","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"2","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"37","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=2&code=ifrs-tx-2020-en-r&anchor=para_37&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashAndCashEquivalents","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"45","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_45&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"18","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_18_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnExchangeDifferencesOnTranslationRecognisedInProfitOrLoss","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"0","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&doctype=Illustrative%20Examples&dita_xref=IAS07_IE_A_TI","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShorttermDepositsClassifiedAsCashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"45","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_45&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseInCashAndCashEquivalentsBeforeEffectOfExchangeRateChanges","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"45","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_45&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShorttermInvestmentsClassifiedAsCashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"45","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_45&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCashAndCashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"45","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_45&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseInCashAndCashEquivalents","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"45","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_45&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BankOverdraftsClassifiedAsCashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"45","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_45&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BalancesWithBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"45","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_45&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"BankingArrangementsClassifiedAsCashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"45","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_45&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashOnHand","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"45","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_45&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfCashFlowStatementExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"0","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&doctype=Standard&dita_xref=IAS07_g10-17_TI","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsFromUsedInFinancingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_10&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsFromUsedInFinancingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"50","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_50_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsFromUsedInInvestingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_10&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsFromUsedInInvestingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"50","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_50_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsFromLosingControlOfSubsidiariesOrOtherBusinessesClassifiedAsInvestingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"39","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_39&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsUsedInObtainingControlOfSubsidiariesOrOtherBusinessesClassifiedAsInvestingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"39","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_39&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherInflowsOutflowsOfCashClassifiedAsOperatingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsFromUsedInOperatingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"10","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_10&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsFromUsedInOperatingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"50","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_50_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"EffectOfExchangeRateChangesOnCashAndCashEquivalents","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"25","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_25&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"EffectOfExchangeRateChangesOnCashAndCashEquivalents","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"28","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_28&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestReceivedClassifiedAsOperatingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"31","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_31&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsPaidClassifiedAsFinancingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"31","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_31&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsReceivedClassifiedAsOperatingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"31","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_31&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsReceivedClassifiedAsInvestingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"31","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_31&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestReceivedClassifiedAsInvestingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"31","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_31&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestPaidClassifiedAsOperatingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"31","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_31&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsPaidClassifiedAsOperatingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"31","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_31&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestPaidClassifiedAsFinancingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"31","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_31&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxesPaidRefundClassifiedAsInvestingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"35","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_35&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxesPaidRefundClassifiedAsInvestingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14_f&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxesPaidRefundClassifiedAsOperatingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"35","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_35&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxesPaidRefundClassifiedAsOperatingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14_f&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxesPaidRefundClassifiedAsFinancingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"35","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_35&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxesPaidRefundClassifiedAsFinancingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14_f&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashAndCashEquivalentsHeldByEntityUnavailableForUseByGroup","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"48","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_48&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForReconcileProfitLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForIncreaseDecreaseInTradeAccountPayable","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDecreaseIncreaseInOtherOperatingReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDecreaseIncreaseInInventories","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForIncreaseDecreaseInOtherOperatingPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDecreaseIncreaseInTradeAccountReceivable","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForProvisions","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForUnrealisedForeignExchangeLossesGains","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDepreciationAndAmortisationExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForUndistributedProfitsOfAssociates","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForIncomeTaxExpense","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"35","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_35&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherAdjustmentsForNoncashItems","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForSharebasedPayments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForFairValueGainsLosses","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PaymentsFromContractsHeldForDealingOrTradingPurpose","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14_g&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReceiptsFromContractsHeldForDealingOrTradingPurpose","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14_g&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCashReceiptsFromOperatingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCashPaymentsFromOperatingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherAdjustmentsForWhichCashEffectsAreInvestingOrFinancingCashFlow","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PaymentsOfOtherEquityInstruments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromIssuingOtherEquityInstruments","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromIssuingShares","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PaymentsToAcquireOrRedeemEntitysShares","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PaymentsToAndOnBehalfOfEmployees","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PaymentsToSuppliersForGoodsAndServices","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromOtherLongtermAssetsClassifiedAsInvestingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromSalesOfIntangibleAssetsClassifiedAsInvestingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromSalesOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromBorrowingsClassifiedAsFinancingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PurchaseOfOtherLongtermAssetsClassifiedAsInvestingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PurchaseOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PurchaseOfIntangibleAssetsClassifiedAsInvestingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReceiptsFromRoyaltiesFeesCommissionsAndOtherRevenue","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReceiptsFromSalesOfGoodsAndRenderingOfServices","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RepaymentsOfBorrowingsClassifiedAsFinancingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashAdvancesAndLoansMadeToOtherPartiesClassifiedAsInvestingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashPaymentsForFutureContractsForwardContractsOptionContractsAndSwapContractsClassifiedAsInvestingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16_g&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashReceiptsFromFutureContractsForwardContractsOptionContractsAndSwapContractsClassifiedAsInvestingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16_h&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashReceiptsFromRepaymentOfAdvancesAndLoansMadeToOtherPartiesClassifiedAsInvestingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16_f&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCashPaymentsToAcquireInterestsInJointVenturesClassifiedAsInvestingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCashPaymentsToAcquireEquityOrDebtInstrumentsOfOtherEntitiesClassifiedAsInvestingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCashReceiptsFromSalesOfEquityOrDebtInstrumentsOfOtherEntitiesClassifiedAsInvestingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCashReceiptsFromSalesOfInterestsInJointVenturesClassifiedAsInvestingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherInflowsOutflowsOfCashClassifiedAsFinancingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"21","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_21&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherInflowsOutflowsOfCashClassifiedAsInvestingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"21","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_21&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForFinanceCosts","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherAdjustmentsToReconcileProfitLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestPaidClassifiedAsInvestingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"31","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_31&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"Cash","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"45","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_45&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"45","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_45&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfInvestingAndFinancingTransactionsNotRequireUseOfCashOrCashEquivalents","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"43","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_43&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxesPaidRefund","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"35","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_35&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherDifferencesToCashAndCashEquivalentsInStatementOfCashFlows","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"45","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_45&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashAndCashEquivalentsIfDifferentFromStatementOfFinancialPosition","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"45","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_45&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAdditionalInformationAboutUnderstandingFinancialPositionsAndLiquidityOfEntityExplanatory","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"50","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_50&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyToDetermineComponentsOfCashAndCashEquivalents","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"46","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_46&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ConsiderationPaidReceived","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"40","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_40_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"UndrawnBorrowingFacilities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"50","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_50_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsFromUsedInIncreasesInOperatingCapacity","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"50","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_50_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromChangesInOwnershipInterestsInSubsidiaries","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"42A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_42A&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromChangesInOwnershipInterestsInSubsidiaries","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"42B","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_42B&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PaymentsFromChangesInOwnershipInterestsInSubsidiaries","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"42A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_42A&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PaymentsFromChangesInOwnershipInterestsInSubsidiaries","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"42B","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_42B&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PortionOfConsiderationPaidReceivedConsistingOfCashAndCashEquivalents","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"40","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_40_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CommentaryByManagementOnSignificantCashAndCashEquivalentBalancesHeldByEntityThatAreNotAvailableForUseByGroup","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"48","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_48&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsFromUsedInOperations","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"0","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&doctype=Illustrative%20Examples&dita_xref=IAS07_IE_A_TI","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReceiptsFromRentsAndSubsequentSalesOfSuchAssets","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PaymentsToManufactureOrAcquireAssetsHeldForRentalToOthersAndSubsequentlyHeldForSale","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsFromUsedInMaintainingOperatingCapacity","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"50","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_50_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashAndCashEquivalentsClassifiedAsPartOfDisposalGroupHeldForSale","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"45","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_45&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxesPaidClassifiedAsOperatingActivities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"35","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_35&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinanceCostsPaidClassifiedAsOperatingActivities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"31","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_31&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsFromUsedInOperationsBeforeChangesInWorkingCapital","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"0","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&doctype=Illustrative%20Examples&dita_xref=IAS07_IE_A_TI","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxesRefundClassifiedAsOperatingActivities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"35","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_35&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinanceIncomeReceivedClassifiedAsOperatingActivities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"31","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_31&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsPaidToEquityHoldersOfParentClassifiedAsFinancingActivities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsPaidToNoncontrollingInterestsClassifiedAsFinancingActivities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromSaleOrIssueOfTreasuryShares","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromExerciseOfOptions","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromIssueOfPreferenceShares","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromNoncurrentBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RepaymentsOfNoncurrentBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromCurrentBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RepaymentsOfCurrentBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsFromUsedInIncreaseDecreaseInCurrentBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromIssueOfBondsNotesAndDebentures","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RepaymentsOfBondsNotesAndDebentures","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PaymentsForShareIssueCosts","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PaymentsForDebtIssueCosts","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromContributionsOfNoncontrollingInterests","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromIssueOfSubordinatedLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RepaymentsOfSubordinatedLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PaymentsForExplorationAndEvaluationExpenses","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForLossesGainsOnDisposalOfNoncurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PaymentsToSuppliersForGoodsAndServicesAndToAndOnBehalfOfEmployees","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_14&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDecreaseIncreaseInLoansAndAdvancesToCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDecreaseIncreaseInLoansAndAdvancesToBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForIncreaseDecreaseInDepositsFromCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForIncreaseDecreaseInDepositsFromBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForIncreaseDecreaseInInsuranceReinsuranceAndInvestmentContractLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForInterestExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForInterestIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDividendIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForFinanceIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForFinanceIncomeCost","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDeferredTaxExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsToReconcileProfitLossOtherThanChangesInWorkingCapital","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsFromUsedInOperationsBeforeChangesInWorkingCapital","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseInWorkingCapital","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDecreaseIncreaseInTradeAndOtherReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForIncreaseDecreaseInTradeAndOtherPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDecreaseIncreaseInOtherAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForIncreaseDecreaseInOtherLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDecreaseIncreaseInOtherCurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForIncreaseDecreaseInOtherCurrentLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForIncreaseDecreaseInEmployeeBenefitLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDepreciationAndAmortisationExpenseAndImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForAmortisationExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDepreciationExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForImpairmentLossRecognisedInProfitOrLossGoodwill","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLossTradeAndOtherReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLossInventories","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForGainsLossesOnFairValueAdjustmentInvestmentProperty","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForGainLossOnDisposalsPropertyPlantAndEquipment","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForGainLossOnDisposalOfInvestmentsInSubsidiariesJointVenturesAndAssociates","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForUndistributedProfitsOfInvestmentsAccountedForUsingEquityMethod","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForIncreaseDecreaseInDeferredIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromDisposalOfExplorationAndEvaluationAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PurchaseOfExplorationAndEvaluationAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromDisposalOfMiningAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PurchaseOfMiningAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsFromUsedInDecreaseIncreaseInRestrictedCashAndCashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsReceivedFromInvestmentsAccountedForUsingEquityMethodClassifiedAsInvestingActivities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsReceivedFromAssociatesClassifiedAsInvestingActivities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsReceivedFromJointVenturesClassifiedAsInvestingActivities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PurchaseOfInterestsInAssociates","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromSalesOfInterestsInAssociates","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PurchaseOfInterestsInInvestmentsAccountedForUsingEquityMethod","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromSalesOfInvestmentsAccountedForUsingEquityMethod","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashAdvancesAndLoansMadeToRelatedParties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashReceiptsFromRepaymentOfAdvancesAndLoansMadeToRelatedParties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PurchaseOfInvestmentProperty","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromSalesOfInvestmentProperty","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PurchaseOfBiologicalAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromSalesOfBiologicalAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromDisposalOfNoncurrentAssetsOrDisposalGroupsClassifiedAsHeldForSaleAndDiscontinuedOperations","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PurchaseOfPropertyPlantAndEquipmentIntangibleAssetsOtherThanGoodwillInvestmentPropertyAndOtherNoncurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromDisposalsOfPropertyPlantAndEquipmentIntangibleAssetsOtherThanGoodwillInvestmentPropertyAndOtherNoncurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsUsedInExplorationAndDevelopmentActivities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PurchaseOfInvestmentsOtherThanInvestmentsAccountedForUsingEquityMethod","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromSalesOfInvestmentsOtherThanInvestmentsAccountedForUsingEquityMethod","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PurchaseOfFinancialInstrumentsClassifiedAsInvestingActivities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromSalesOrMaturityOfFinancialInstrumentsClassifiedAsInvestingActivities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PurchaseOfAvailableforsaleFinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2017-en-b&anchor=para_16&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromDisposalOrMaturityOfAvailableforsaleFinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2017-en-b&anchor=para_16&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsFromUsedInDecreaseIncreaseInShorttermDepositsAndInvestments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"InflowsOfCashFromInvestingActivities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"OutflowsOfCashFromInvestingActivities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PurchaseOfOilAndGasAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromDisposalOfOilAndGasAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashAndCashEquivalentsInSubsidiaryOrBusinessesAcquiredOrDisposed2013","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"40","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_40_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AssetsOtherThanCashOrCashEquivalentsInSubsidiaryOrBusinessesAcquiredOrDisposed2013","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"40","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_40_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LiabilitiesInSubsidiaryOrBusinessesAcquiredOrDisposed2013","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"40","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_40_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForGainsLossesOnChangeInFairValueOfDerivatives","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForIncreaseInOtherProvisionsArisingFromPassageOfTime","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLossExplorationAndEvaluationAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProceedsFromIssueOfOrdinaryShares","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PaymentsForDevelopmentProjectExpenditure","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"16","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_16&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLossPropertyPlantAndEquipment","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAcquisitionOfEntityByMeansOfEquityIssue","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfConversionOfDebtToEquity","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForGainsLossesOnChangeInFairValueLessCostsToSellBiologicalAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDecreaseIncreaseInBiologicalAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashAdvancesAndLoansFromRelatedParties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashRepaymentsOfAdvancesAndLoansFromRelatedParties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLossLoansAndAdvances","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForIncreaseDecreaseInRepurchaseAgreementsAndCashCollateralOnSecuritiesLent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDecreaseIncreaseInReverseRepurchaseAgreementsAndCashCollateralOnSecuritiesBorrowed","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDecreaseIncreaseInFinancialAssetsHeldForTrading","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForIncreaseDecreaseInFinancialLiabilitiesHeldForTrading","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForDecreaseIncreaseInDerivativeFinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdjustmentsForIncreaseDecreaseInDerivativeFinancialLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShorttermBorrowingsMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"0","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&doctype=Illustrative%20Examples&dita_xref=IAS07_IE_C_TI","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LiabilitiesArisingFromFinancingActivitiesAxis","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44D","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44D&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LiabilitiesArisingFromFinancingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44D","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44D&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReconciliationOfLiabilitiesArisingFromFinancingActivitiesExplanatory","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44D","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44D&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughFinancingCashFlowsLiabilitiesArisingFromFinancingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44B","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44B_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughEffectOfChangesInForeignExchangeRatesLiabilitiesArisingFromFinancingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44B","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44B_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInformationThatEnablesUsersOfFinancialStatementsToEvaluateChangesInLiabilitiesArisingFromFinancingActivitiesExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44A","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44A&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LiabilitiesArisingFromFinancingActivitiesMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44D","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44D&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LeaseLiabilitiesMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"0","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&doctype=Illustrative%20Examples&dita_xref=IAS07_IE_C_TI","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseThroughNewLeasesLiabilitiesArisingFromFinancingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"0","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&doctype=Illustrative%20Examples&dita_xref=IAS07_IE_A_TI","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LongtermBorrowingsMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"0","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&doctype=Illustrative%20Examples&dita_xref=IAS07_IE_C_TI","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughObtainingOrLosingControlOfSubsidiariesOrOtherBusinessesLiabilitiesArisingFromFinancingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44B","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44B_b&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughOtherChangesLiabilitiesArisingFromFinancingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44B","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44B_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughChangesInFairValuesLiabilitiesArisingFromFinancingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44B","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44B_d&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AssetsHeldToHedgeLiabilitiesArisingFromFinancingActivitiesMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"0","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&doctype=Illustrative%20Examples&dita_xref=IAS07_IE_C_TI","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReconciliationOfLiabilitiesArisingFromFinancingActivitiesTable","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44D","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44D&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseInLiabilitiesArisingFromFinancingActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44B","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44B&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LeaseLiabilitiesMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44C","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44C&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"LongtermBorrowingsMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44C","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44C&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"AssetsHeldToHedgeLiabilitiesArisingFromFinancingActivitiesMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44C","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44C&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShorttermBorrowingsMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44C","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44C&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseThroughNewLeasesLiabilitiesArisingFromFinancingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44B","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44B&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowsFromUsedInOperations","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"20","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_20&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReceiptsFromPremiumsAndClaimsAnnuitiesAndOtherPolicyBenefits","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-b&anchor=para_14_e&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PaymentsForPremiumsAndClaimsAnnuitiesAndOtherPolicyBenefits","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"14","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-b&anchor=para_14_e&doctype=Standard&book=b","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAcquisitionOfAssetsByAssumingDirectlyRelatedLiabilitiesOrByMeansOfLease","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"44","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_44_a&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PaymentsOfLeaseLiabilitiesClassifiedAsFinancingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"7","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"17","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=7&code=ifrs-tx-2020-en-r&anchor=para_17_e&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RestatedMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"28","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_28_f_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RestatedMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"29","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_29_c_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RestatedMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"49","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_49_b_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PreviouslyStatedMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"28","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_28_f_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PreviouslyStatedMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"29","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_29_c_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"PreviouslyStatedMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"49","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_49_b_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RetrospectiveApplicationAndRetrospectiveRestatementAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"28","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_28_f_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RetrospectiveApplicationAndRetrospectiveRestatementAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"29","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_29_c_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"RetrospectiveApplicationAndRetrospectiveRestatementAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"49","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_49_b_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseDueToChangesInAccountingPolicyAndCorrectionsOfPriorPeriodErrorsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"28","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_28_f_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseDueToChangesInAccountingPolicyAndCorrectionsOfPriorPeriodErrorsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"29","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_29_c_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseDueToChangesInAccountingPolicyAndCorrectionsOfPriorPeriodErrorsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"49","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_49_b_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialEffectOfChangesInAccountingPolicyMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"28","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_28_f_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialEffectOfChangesInAccountingPolicyMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"29","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_29_c_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfChangesInAccountingPoliciesAccountingEstimatesAndErrorsExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"0","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&doctype=Standard&dita_xref=IAS08_g7-31_TI","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialEffectOfCorrectionsOfAccountingErrorsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"49","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_49_b_i&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialEffectOfCorrectionsOfAccountingErrorsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"49","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_49_c&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfInitialApplicationOfStandardsOrInterpretations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"28","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_28&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfVoluntaryChangeInAccountingPolicy","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"29","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_29&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureAndAmountOfChangeInAccountingEstimate","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"8","Section":null,"Footnote":null,"Subsection":null,"IssueDate":"1/1/2020","Paragraph":"39","SubParagraph":null,"Clause":"0","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=8&code=ifrs-tx-2020-en-r&anchor=para_39&doctype=Standard","URIDate":"1/1/2020","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfFactThatAmountOfChangeInAccountingEstimateI