'use strict';

var ngApp = angular.module('myNgApp', ['ngSanitize']);

ngApp.controller('AppCtrl', ['$scope', '$http', '$timeout', '$sce', function($scope, $http, $timeout, $sce)
{
  $scope.showPageNoDiv = true;
  $scope.documents = [];
  $scope.document = {};
  $scope.pageQueue = [];
  $scope.noOfPageToLoad = 2;
  $scope.references = [];
  $scope.statusFilters = [{id: 0, name: 'All Status'}, {id: 1, name: 'Mandatory'}, {id: 2, name: 'Voluntary'}];
  $scope.tagStatusFilters = [{id: 0, name: 'All Tags'}, {id: 1, name: 'Used Tags'}, {id: 2, name: 'Unused Tags'}];
  $scope.filter = {};
  $scope.filter.status = 0;
  $scope.filter.tagStatus = 0;
  $scope.filter.exactMatch = false;
  $scope.filter.textBlock = false;
  $scope.filter.showSecondaryLabel = false;
  $scope.filter.highlightTextBlock = true;
  $scope.filterData = [];
  $scope.triggerFocused = false;
  $scope.triggerFocusedElement = "";

  $scope.viewerData = [{"EntityName":"Awilco Drilling PLC","DocumentName":"Annual Report_12/31/2022","FileName":"213800GETNUFDN7CEI51-2022-12-31.zip","Version":4,"RoundVersion":1,"HasSecoundaryLang":false,"IsPortalEnabled":"true","IsBrandingEnabled":"false","IsBrandingEnabledInViewer":"false","LogoName":"","EntityGeography":5}];
  $scope.factData = [{"Id":4114864,"FileId":8839,"Sequence":1,"PageIdentifier":"6435e991-e5d2-4e50-a260-75d123eab459","ElementIdentifier":"ec6319a5-886f-4b3e-8c62-f60d5db70533","ElementType":2,"TagName":"ifrs-full:AddressOfRegisteredOfficeOfEntity","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Suite 1 7 \r\nth \r\nFloor \r\n50 Broadway \r\nLondon \r\nSW1H 0BL","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Address of entity's registered office","Documentation":"The address at which the entity's office is registered.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114863,"FileId":8839,"Sequence":2,"PageIdentifier":"c7d815cd-9e7a-44cb-9696-55c76dba6f34","ElementIdentifier":"9a56be58-23d1-4325-a294-a3a4ca30c173","ElementType":2,"TagName":"ifrs-full:DescriptionOfNatureOfEntitysOperationsAndPrincipalActivities","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Following the contractual arrangements as above to sell both rigs during Q2 2022, the principal activity of the Group during the year was to continue the arbitration processes with Keppel FELS shipyard.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of nature of entity's operations and principal activities","Documentation":"The description of the nature of the entity's operations and principal activities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114862,"FileId":8839,"Sequence":3,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"f63316e7-64a3-4ee0-aa8f-66a0c0ed833d","ElementType":1,"TagName":"ifrs-full:Revenue","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Revenue","Documentation":"The income arising in the course of an entity's ordinary activities. Income is increases in assets, or decreases in liabilities, that result in increases in equity, other than those relating to contributions from holders of equity claims.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114861,"FileId":8839,"Sequence":4,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"6020b9ca-b76b-4ab4-8b1a-90022d7fca17","ElementType":1,"TagName":"ifrs-full:Revenue","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"33,077","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Revenue","Documentation":"The income arising in the course of an entity's ordinary activities. Income is increases in assets, or decreases in liabilities, that result in increases in equity, other than those relating to contributions from holders of equity claims.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114860,"FileId":8839,"Sequence":5,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"b5b9aa52-3959-41a3-aaaa-720a546f11e5","ElementType":1,"TagName":"ifrs-full:CostOfSales","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"5,363","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cost of sales","Documentation":"The amount of all expenses directly or indirectly attributed to the goods or services sold. Attributed expenses include, but are not limited to, costs previously included in the measurement of inventory that has now been sold, such as depreciation and maintenance of factory buildings and equipment used in the production process, unallocated production overheads, and abnormal amounts of production costs of inventories.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114859,"FileId":8839,"Sequence":6,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"b7eb178a-1e6b-4b9c-85c7-d40c908f6f25","ElementType":1,"TagName":"ifrs-full:CostOfSales","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"33,986","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cost of sales","Documentation":"The amount of all expenses directly or indirectly attributed to the goods or services sold. Attributed expenses include, but are not limited to, costs previously included in the measurement of inventory that has now been sold, such as depreciation and maintenance of factory buildings and equipment used in the production process, unallocated production overheads, and abnormal amounts of production costs of inventories.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114858,"FileId":8839,"Sequence":7,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"3823c1de-932c-414f-96e3-475e6b2b7e1d","ElementType":1,"TagName":"ifrs-full:ImpairmentLoss","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"205","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Impairment loss","Documentation":"The amount recognised as a reduction of the carrying amount of an asset or cash-generating unit to its recoverable amount. [Refer: Carrying amount [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114857,"FileId":8839,"Sequence":8,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"8b593cff-0043-4320-a9d5-0a68fd354471","ElementType":1,"TagName":"ifrs-full:ImpairmentLoss","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"48,120","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Impairment loss","Documentation":"The amount recognised as a reduction of the carrying amount of an asset or cash-generating unit to its recoverable amount. [Refer: Carrying amount [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114856,"FileId":8839,"Sequence":9,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"f0be7fb2-feca-418f-8c28-5c6c1c1d3cf8","ElementType":1,"TagName":"ifrs-full:GainsOnDisposalsOfPropertyPlantAndEquipment","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"3,188","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Gains on disposals of property, plant and equipment","Documentation":"The gain on the disposal of property, plant and equipment. [Refer: Property, plant and equipment]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114855,"FileId":8839,"Sequence":10,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"497e0512-36c3-402e-8fae-94bcdfcccf9f","ElementType":1,"TagName":"ifrs-full:GainsOnDisposalsOfPropertyPlantAndEquipment","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Gains on disposals of property, plant and equipment","Documentation":"The gain on the disposal of property, plant and equipment. [Refer: Property, plant and equipment]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114854,"FileId":8839,"Sequence":11,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"5d078323-adf8-4495-a237-ee2fda581cf8","ElementType":1,"TagName":"ifrs-full:GrossProfit","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"2,380","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Gross profit","Documentation":"The amount of revenue less cost of sales. [Refer: Cost of sales; Revenue]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114822,"FileId":8839,"Sequence":12,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"ea7288d9-f470-4c00-9d96-73403c522b0e","ElementType":1,"TagName":"ifrs-full:GrossProfit","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"49,029","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Gross profit","Documentation":"The amount of revenue less cost of sales. [Refer: Cost of sales; Revenue]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114821,"FileId":8839,"Sequence":13,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"6da123b6-e7e4-4051-8408-1ecb4e45805c","ElementType":1,"TagName":"ifrs-full:GeneralAndAdministrativeExpense","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"20,153","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"General and administrative expense","Documentation":"The amount of expense relating to general and administrative activities of the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114820,"FileId":8839,"Sequence":14,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"18f6b280-738d-4074-ab7a-421d59950cc1","ElementType":1,"TagName":"ifrs-full:GeneralAndAdministrativeExpense","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"12,235","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"General and administrative expense","Documentation":"The amount of expense relating to general and administrative activities of the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114819,"FileId":8839,"Sequence":15,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"cf992d42-cf1b-444e-80ea-48156b194fe7","ElementType":1,"TagName":"ifrs-full:OtherExpenseByFunction","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"122,568","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Other expense, by function","Documentation":"The amount of expenses that the entity does not separately disclose in the same statement or note when the entity uses the 'function of expense' form for its analysis of expenses.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114787,"FileId":8839,"Sequence":16,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"6a5e923c-45e4-422a-a2cd-280a759accbf","ElementType":1,"TagName":"ifrs-full:OtherExpenseByFunction","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"4","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Other expense, by function","Documentation":"The amount of expenses that the entity does not separately disclose in the same statement or note when the entity uses the 'function of expense' form for its analysis of expenses.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114786,"FileId":8839,"Sequence":17,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"0c554ed7-0ced-43cd-89bc-63619109ccf2","ElementType":1,"TagName":"ifrs-full:ProfitLossFromOperatingActivities","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"145,101","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Profit (loss) from operating activities","Documentation":"The profit (loss) from operating activities of the entity. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114785,"FileId":8839,"Sequence":18,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"4b52bf66-1f4a-4ee8-ab11-e5510c157c32","ElementType":1,"TagName":"ifrs-full:ProfitLossFromOperatingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"61,268","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Profit (loss) from operating activities","Documentation":"The profit (loss) from operating activities of the entity. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114784,"FileId":8839,"Sequence":19,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"045fb8b1-a639-4675-b60e-c8143d235e9a","ElementType":1,"TagName":"ifrs-full:FinanceIncome","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"53","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Finance income","Documentation":"The amount of income associated with interest and other financing activities of the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114783,"FileId":8839,"Sequence":20,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"b0e9394d-af0c-45fa-bc86-bf29b28a7b48","ElementType":1,"TagName":"ifrs-full:FinanceIncome","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Finance income","Documentation":"The amount of income associated with interest and other financing activities of the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114782,"FileId":8839,"Sequence":21,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"853a53c7-54e9-4d1e-85bf-e4755ff83c82","ElementType":1,"TagName":"ifrs-full:FinanceCosts","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"168","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Finance costs","Documentation":"The amount of costs associated with financing activities of the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114781,"FileId":8839,"Sequence":22,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"061ac041-307a-47e4-ac0c-cff22e033607","ElementType":1,"TagName":"ifrs-full:FinanceCosts","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"1,441","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Finance costs","Documentation":"The amount of costs associated with financing activities of the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114780,"FileId":8839,"Sequence":23,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"95c3efca-7f51-45e7-99d2-560ca263f239","ElementType":1,"TagName":"ifrs-full:GainsLossesOnExchangeDifferencesOnTranslationRecognisedInProfitOrLoss","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"119","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Foreign exchange gain (loss)","Documentation":"The amount of exchange differences recognised in profit or loss that arise from foreign currency transactions, excluding those arising on financial instruments measured at fair value through profit or loss in accordance with IFRS 9. [Refer: At fair value [member]; Financial instruments, class [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114779,"FileId":8839,"Sequence":24,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"6e2a43f8-986c-4797-a77e-dddb2116f8d0","ElementType":1,"TagName":"ifrs-full:GainsLossesOnExchangeDifferencesOnTranslationRecognisedInProfitOrLoss","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"254","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Foreign exchange gain (loss)","Documentation":"The amount of exchange differences recognised in profit or loss that arise from foreign currency transactions, excluding those arising on financial instruments measured at fair value through profit or loss in accordance with IFRS 9. [Refer: At fair value [member]; Financial instruments, class [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114778,"FileId":8839,"Sequence":25,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"89baf549-e4cd-4d77-875f-80db168669ef","ElementType":1,"TagName":"ifrs-full:ProfitLossBeforeTax","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"145,335","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Profit (loss) before tax","Documentation":"The profit (loss) before tax expense or income. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114777,"FileId":8839,"Sequence":26,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"3bada69c-903e-4164-bc7d-c9509ededafa","ElementType":1,"TagName":"ifrs-full:ProfitLossBeforeTax","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"62,963","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Profit (loss) before tax","Documentation":"The profit (loss) before tax expense or income. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114776,"FileId":8839,"Sequence":27,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"a45af2c5-9574-4e25-8f95-a4b970e42ff6","ElementType":1,"TagName":"ifrs-full:IncomeTaxExpenseContinuingOperations","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"21","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Tax expense (income)","Documentation":"The aggregate amount included in the determination of profit (loss) for the period in respect of current tax and deferred tax. [Refer: Current tax expense (income); Deferred tax expense (income)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114788,"FileId":8839,"Sequence":28,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"8bc25965-c6f9-4e07-991c-94f8c73544c2","ElementType":1,"TagName":"ifrs-full:IncomeTaxExpenseContinuingOperations","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"9,266","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Tax expense (income)","Documentation":"The aggregate amount included in the determination of profit (loss) for the period in respect of current tax and deferred tax. [Refer: Current tax expense (income); Deferred tax expense (income)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114775,"FileId":8839,"Sequence":29,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"f31ce0bc-1dbf-41c1-9018-65da17b1e374","ElementType":1,"TagName":"ifrs-full:ProfitLoss","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"145,356","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Profit (loss)","Documentation":"The total of income less expenses from continuing and discontinued operations, excluding the components of other comprehensive income. [Refer: Other comprehensive income]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114773,"FileId":8839,"Sequence":30,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"2dec2512-dd24-406d-b3bb-5586c71eac47","ElementType":1,"TagName":"ifrs-full:ProfitLoss","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"72,229","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Profit (loss)","Documentation":"The total of income less expenses from continuing and discontinued operations, excluding the components of other comprehensive income. [Refer: Other comprehensive income]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114772,"FileId":8839,"Sequence":31,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"39ce6bc9-6d20-4c77-ae36-1f2dc07cdee1","ElementType":1,"TagName":"ifrs-full:DilutedEarningsLossPerShare","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD_per_Share","CurrencyName":"Ugandan Shilling","Decimal":"1","Scale":"Actuals","Value":"228.2","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"shares","Sign":"-","IsHiddenElement":false,"Label":"Diluted earnings (loss) per share","Documentation":"The amount of profit (loss) attributable to ordinary equity holders of the parent entity (the numerator), divided by the weighted average number of ordinary shares outstanding during the period (the denominator), both adjusted for the effects of all dilutive potential ordinary shares. [Refer: Ordinary shares [member]; Weighted average [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"num:perShareItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114771,"FileId":8839,"Sequence":32,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"5a5cf782-3af5-4523-8ea4-d706ed89aae0","ElementType":1,"TagName":"ifrs-full:BasicEarningsLossPerShare","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD_per_Share","CurrencyName":"Ugandan Shilling","Decimal":"1","Scale":"Actuals","Value":"228.2","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"shares","Sign":"-","IsHiddenElement":false,"Label":"Basic earnings (loss) per share","Documentation":"The amount of profit (loss) attributable to ordinary equity holders of the parent entity (the numerator) divided by the weighted average number of ordinary shares outstanding during the period (the denominator).","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"num:perShareItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114770,"FileId":8839,"Sequence":33,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"8de3e0cd-3b13-4852-820e-aaa91d3fbf04","ElementType":1,"TagName":"ifrs-full:DilutedEarningsLossPerShare","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD_per_Share","CurrencyName":"Ugandan Shilling","Decimal":"1","Scale":"Actuals","Value":"132.3","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"shares","Sign":"-","IsHiddenElement":false,"Label":"Diluted earnings (loss) per share","Documentation":"The amount of profit (loss) attributable to ordinary equity holders of the parent entity (the numerator), divided by the weighted average number of ordinary shares outstanding during the period (the denominator), both adjusted for the effects of all dilutive potential ordinary shares. [Refer: Ordinary shares [member]; Weighted average [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"num:perShareItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114769,"FileId":8839,"Sequence":34,"PageIdentifier":"6392f216-4026-4c57-a2bb-6fadf7887c5a","ElementIdentifier":"b7f91cc0-8b3a-45b3-86fd-1e1f3bf6bd4e","ElementType":1,"TagName":"ifrs-full:BasicEarningsLossPerShare","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD_per_Share","CurrencyName":"Ugandan Shilling","Decimal":"1","Scale":"Actuals","Value":"132.3","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"shares","Sign":"-","IsHiddenElement":false,"Label":"Basic earnings (loss) per share","Documentation":"The amount of profit (loss) attributable to ordinary equity holders of the parent entity (the numerator) divided by the weighted average number of ordinary shares outstanding during the period (the denominator).","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"num:perShareItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114768,"FileId":8839,"Sequence":35,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"458357e0-8769-4e54-83f4-3f5f6eb01d80","ElementType":1,"TagName":"ifrs-full:PropertyPlantAndEquipment","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Property, plant and equipment","Documentation":"The amount of tangible assets that: (a) are held for use in the production or supply of goods or services, for rental to others, or for administrative purposes; and (b) are expected to be used during more than one period.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114767,"FileId":8839,"Sequence":36,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"da1ad143-89f6-49b9-b815-ff5bb856f9d1","ElementType":1,"TagName":"ifrs-full:PropertyPlantAndEquipment","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"15,764","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Property, plant and equipment","Documentation":"The amount of tangible assets that: (a) are held for use in the production or supply of goods or services, for rental to others, or for administrative purposes; and (b) are expected to be used during more than one period.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114766,"FileId":8839,"Sequence":37,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"bb20ce5f-559e-4708-a2d8-c39c2eb6c952","ElementType":1,"TagName":"ifrs-full:RightofuseAssets","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Right-of-use assets","Documentation":"The amount of assets that represent a lessee's right to use an underlying asset for the lease term. Underlying asset is an asset that is the subject of a lease, for which the right to use that asset has been provided by a lessor to a lessee.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114765,"FileId":8839,"Sequence":38,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"2acc4961-29ca-4a8a-8065-848c7a698f90","ElementType":1,"TagName":"ifrs-full:RightofuseAssets","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Right-of-use assets","Documentation":"The amount of assets that represent a lessee's right to use an underlying asset for the lease term. Underlying asset is an asset that is the subject of a lease, for which the right to use that asset has been provided by a lessor to a lessee.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114764,"FileId":8839,"Sequence":39,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"daa74971-a31f-49b9-8589-edfbb21b2149","ElementType":1,"TagName":"ifrs-full:NoncurrentAssets","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Non-current assets","Documentation":"The amount of assets that do not meet the definition of current assets. [Refer: Current assets]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114763,"FileId":8839,"Sequence":40,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"eb0fe62e-efe0-46f8-9e38-abaa085d7498","ElementType":1,"TagName":"ifrs-full:NoncurrentAssets","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"15,764","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Non-current assets","Documentation":"The amount of assets that do not meet the definition of current assets. [Refer: Current assets]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114762,"FileId":8839,"Sequence":41,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"57a1ff44-3a90-499c-b331-fbdc5c5b1d0f","ElementType":1,"TagName":"ifrs-full:Inventories","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current inventories","Documentation":"The amount of current inventories. [Refer: Inventories]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114774,"FileId":8839,"Sequence":42,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"ef62f0ed-f85b-4e7d-8f02-e54e46e17767","ElementType":1,"TagName":"ifrs-full:Inventories","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"115","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current inventories","Documentation":"The amount of current inventories. [Refer: Inventories]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114789,"FileId":8839,"Sequence":43,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"e359765a-046e-4b81-ace8-d4cae5d0bd7c","ElementType":1,"TagName":"ifrs-full:TradeAndOtherCurrentReceivables","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"2,635","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Trade and other current receivables","Documentation":"The amount of current trade receivables and current other receivables. [Refer: Current trade receivables; Other current receivables]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114790,"FileId":8839,"Sequence":44,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"31b71ae2-1f96-45ed-98ad-dc0e5f0a4347","ElementType":1,"TagName":"ifrs-full:TradeAndOtherCurrentReceivables","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"662","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Trade and other current receivables","Documentation":"The amount of current trade receivables and current other receivables. [Refer: Current trade receivables; Other current receivables]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114791,"FileId":8839,"Sequence":45,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"cb73345e-f34d-4657-97c0-c98683be891e","ElementType":1,"TagName":"ifrs-full:CashAndCashEquivalents","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"8,880","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cash and cash equivalents","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114818,"FileId":8839,"Sequence":46,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"1b35e726-21f9-4c6a-a374-98d579089fe5","ElementType":1,"TagName":"ifrs-full:CashAndCashEquivalents","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"9,685","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cash and cash equivalents","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114817,"FileId":8839,"Sequence":47,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"d0993036-a370-4bc1-b80a-7374d41cff7c","ElementType":1,"TagName":"ifrs-full:CurrentAssets","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"11,515","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current assets","Documentation":"The amount of assets that the entity (a) expects to realise or intends to sell or consume in its normal operating cycle; (b) holds primarily for the purpose of trading; (c) expects to realise within twelve months after the reporting period; or (d) classifies as cash or cash equivalents (as defined in IAS 7) unless the asset is restricted from being exchanged or used to settle a liability for at least twelve months after the reporting period. [Refer: Assets]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114816,"FileId":8839,"Sequence":48,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"7ab8a501-76eb-4b4b-a3bf-bb979d6b778e","ElementType":1,"TagName":"ifrs-full:CurrentAssets","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"10,462","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current assets","Documentation":"The amount of assets that the entity (a) expects to realise or intends to sell or consume in its normal operating cycle; (b) holds primarily for the purpose of trading; (c) expects to realise within twelve months after the reporting period; or (d) classifies as cash or cash equivalents (as defined in IAS 7) unless the asset is restricted from being exchanged or used to settle a liability for at least twelve months after the reporting period. [Refer: Assets]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114815,"FileId":8839,"Sequence":49,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"526cce48-d68a-4b3b-b42f-946291002fad","ElementType":1,"TagName":"ifrs-full:Assets","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"11,515","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Assets","Documentation":"The amount of a present economic resource controlled by the entity as a result of past events. Economic resource is a right that has the potential to produce economic benefits.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114814,"FileId":8839,"Sequence":50,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"e429b81a-552d-4f2a-99c1-0c9b8b62495a","ElementType":1,"TagName":"ifrs-full:Assets","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"26,226","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Assets","Documentation":"The amount of a present economic resource controlled by the entity as a result of past events. Economic resource is a right that has the potential to produce economic benefits.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114813,"FileId":8839,"Sequence":51,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"2d30a1f4-59fd-486a-bfb6-2a6cb7511c66","ElementType":1,"TagName":"ifrs-full:TradeAndOtherCurrentPayables","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"118,372","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Trade and other current payables","Documentation":"The amount of current trade payables and current other payables. [Refer: Current trade payables; Other current payables]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114812,"FileId":8839,"Sequence":52,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"40cfac76-314d-44f4-8109-33d9e0bf46d3","ElementType":1,"TagName":"ifrs-full:TradeAndOtherCurrentPayables","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"4,550","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Trade and other current payables","Documentation":"The amount of current trade payables and current other payables. [Refer: Current trade payables; Other current payables]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114811,"FileId":8839,"Sequence":53,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"83f8f20a-fa52-4aff-8657-a532a2b09956","ElementType":1,"TagName":"ifrs-full:CurrentProvisions","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"9,278","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current provisions","Documentation":"The amount of current provisions, including provisions for employee benefits. [Refer: Provisions]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114810,"FileId":8839,"Sequence":54,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"e866e341-e00a-4d2d-a5fa-ac6c2cf4c845","ElementType":1,"TagName":"ifrs-full:CurrentProvisions","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"1,100","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current provisions","Documentation":"The amount of current provisions, including provisions for employee benefits. [Refer: Provisions]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114809,"FileId":8839,"Sequence":55,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"13589496-a6b4-4ff1-bc52-5e65f8a39d26","ElementType":1,"TagName":"ifrs-full:ShorttermBorrowings","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"1,500","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current borrowings","Documentation":"The amount of current borrowings. [Refer: Borrowings]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114808,"FileId":8839,"Sequence":56,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"65fa89bd-f67d-4ec0-9413-f24bd77d8211","ElementType":1,"TagName":"ifrs-full:ShorttermBorrowings","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current borrowings","Documentation":"The amount of current borrowings. [Refer: Borrowings]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114807,"FileId":8839,"Sequence":57,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"4e018e95-08dc-4749-ae32-faa5f38f4936","ElementType":1,"TagName":"ifrs-full:CurrentTaxLiabilitiesCurrent","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"9,174","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current tax liabilities, current","Documentation":"The current amount of current tax liabilities. [Refer: Current tax liabilities]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114806,"FileId":8839,"Sequence":58,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"6d65da72-446a-4fae-9487-7a380b23bf6a","ElementType":1,"TagName":"ifrs-full:CurrentTaxLiabilitiesCurrent","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"9,251","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current tax liabilities, current","Documentation":"The current amount of current tax liabilities. [Refer: Current tax liabilities]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114805,"FileId":8839,"Sequence":59,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"9501e99a-414f-42c8-8e22-bbd32afe8f4f","ElementType":1,"TagName":"ifrs-full:CurrentLiabilities","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"138,324","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current liabilities","Documentation":"Expiry date 2023-01-01: The amount of liabilities that: (a) the entity expects to settle in its normal operating cycle; (b) the entity holds primarily for the purpose of trading; (c) are due to be settled within twelve months after the reporting period; or (d) the entity does not have an unconditional right to defer settlement for at least twelve months after the reporting period.\r\nEffective 2023-01-01: The amount of liabilities that: (a) the entity expects to settle in its normal operating cycle; (b) the entity holds primarily for the purpose of trading; (c) are due to be settled within twelve months after the reporting period; or (d) the entity does not have the right at the end of the reporting period to defer settlement for at least twelve months after the reporting period.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114804,"FileId":8839,"Sequence":60,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"6efc1d22-ac63-4677-9140-9783118dc4a9","ElementType":1,"TagName":"ifrs-full:CurrentLiabilities","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"14,901","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Current liabilities","Documentation":"Expiry date 2023-01-01: The amount of liabilities that: (a) the entity expects to settle in its normal operating cycle; (b) the entity holds primarily for the purpose of trading; (c) are due to be settled within twelve months after the reporting period; or (d) the entity does not have an unconditional right to defer settlement for at least twelve months after the reporting period.\r\nEffective 2023-01-01: The amount of liabilities that: (a) the entity expects to settle in its normal operating cycle; (b) the entity holds primarily for the purpose of trading; (c) are due to be settled within twelve months after the reporting period; or (d) the entity does not have the right at the end of the reporting period to defer settlement for at least twelve months after the reporting period.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114803,"FileId":8839,"Sequence":61,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"6f030337-9105-44de-989c-8d8f464b65b2","ElementType":1,"TagName":"ifrs-full:NoncurrentPayables","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"146","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Trade and other non-current payables","Documentation":"The amount of non-current trade payables and non-current other payables. [Refer: Other non-current payables; Non-current trade payables]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114802,"FileId":8839,"Sequence":62,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"bc414e77-90dd-48ed-8e12-e483174596c9","ElementType":1,"TagName":"ifrs-full:NoncurrentPayables","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"426","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Trade and other non-current payables","Documentation":"The amount of non-current trade payables and non-current other payables. [Refer: Other non-current payables; Non-current trade payables]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114801,"FileId":8839,"Sequence":63,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"cf4c53ae-18c5-49cf-bf4f-7a0182c3396c","ElementType":1,"TagName":"ifrs-full:NoncurrentLiabilities","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"146","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Non-current liabilities","Documentation":"The amount of liabilities that do not meet the definition of current liabilities. [Refer: Current liabilities]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114800,"FileId":8839,"Sequence":64,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"310aece0-7ed9-4677-8da6-826963d97d97","ElementType":1,"TagName":"ifrs-full:NoncurrentLiabilities","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"426","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Non-current liabilities","Documentation":"The amount of liabilities that do not meet the definition of current liabilities. [Refer: Current liabilities]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114799,"FileId":8839,"Sequence":65,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"3a7acf14-af47-4280-82ee-fcd0d62bdf76","ElementType":1,"TagName":"ifrs-full:Liabilities","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"138,470","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Liabilities","Documentation":"The amount of a present obligation of the entity to transfer an economic resource as a result of past events. Economic resource is a right that has the potential to produce economic benefits.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114798,"FileId":8839,"Sequence":66,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"afef7b4c-c780-4a02-97a7-e5d0ffcbc549","ElementType":1,"TagName":"ifrs-full:Liabilities","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"15,327","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Liabilities","Documentation":"The amount of a present obligation of the entity to transfer an economic resource as a result of past events. Economic resource is a right that has the potential to produce economic benefits.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114797,"FileId":8839,"Sequence":67,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"31f10a02-4d2d-41d5-a0c6-b09c6b3b6510","ElementType":1,"TagName":"ifrs-full:NetAssetsLiabilities","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"126,955","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Assets (liabilities)","Documentation":"The amount of assets less the amount of liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114796,"FileId":8839,"Sequence":68,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"ed6ea701-8f41-41d5-8ff0-736910963ebd","ElementType":1,"TagName":"ifrs-full:NetAssetsLiabilities","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"10,899","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Assets (liabilities)","Documentation":"The amount of assets less the amount of liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114795,"FileId":8839,"Sequence":69,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"8aeb3fff-f776-459a-8723-4502c6611905","ElementType":1,"TagName":"ifrs-full:IssuedCapital","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"3,581","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Issued capital","Documentation":"The nominal value of capital issued.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114794,"FileId":8839,"Sequence":70,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"c40cd8ac-b13b-441a-90c5-00fb4238229d","ElementType":1,"TagName":"ifrs-full:IssuedCapital","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"525","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Issued capital","Documentation":"The nominal value of capital issued.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114793,"FileId":8839,"Sequence":71,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"1bba74d3-5b96-46db-b838-37e18e860e69","ElementType":1,"TagName":"ifrs-full:SharePremium","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"222,827","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Share premium","Documentation":"The amount received or receivable from the issuance of the entity's shares in excess of nominal value.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114792,"FileId":8839,"Sequence":72,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"2aed215c-614e-4258-ad7f-079f7542dddf","ElementType":1,"TagName":"ifrs-full:SharePremium","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"218,381","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Share premium","Documentation":"The amount received or receivable from the issuance of the entity's shares in excess of nominal value.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114638,"FileId":8839,"Sequence":73,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"fad22f48-5272-4aa6-aaa6-0f8208a88d5c","ElementType":1,"TagName":"ifrs-full:RetainedEarnings","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"353,363","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Retained earnings","Documentation":"A component of equity representing the entity's cumulative undistributed earnings or deficit.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114865,"FileId":8839,"Sequence":74,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"ebafe98e-d0bc-4908-bd24-eb1c3b9e9776","ElementType":1,"TagName":"ifrs-full:RetainedEarnings","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"208,007","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Retained earnings","Documentation":"A component of equity representing the entity's cumulative undistributed earnings or deficit.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114866,"FileId":8839,"Sequence":75,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"6df28209-719f-408b-b248-850666934966","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"126,955","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114867,"FileId":8839,"Sequence":76,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"44aeadf9-0547-462f-89ba-7fc46ee3e140","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"10,899","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114868,"FileId":8839,"Sequence":77,"PageIdentifier":"5af5fefe-bf3b-4f19-9c6b-ba66b9e7619a","ElementIdentifier":"fa19c62b-a62e-4744-8c92-69ac34b6a441","ElementType":2,"TagName":"ifrs-full:DisclosureOfAuthorisationOfFinancialStatementsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Signed on behalf of the Board of Directors Sigurd Thorvildsen \r\nDirector \r\n26 May 2023","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of authorisation of financial statements [text block]","Documentation":"The disclosure of the authorisation of financial statements for issue.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114869,"FileId":8839,"Sequence":78,"PageIdentifier":"1edb7592-e6a5-403f-9e6c-2265293aef98","ElementIdentifier":"4060e1ee-14f1-4031-9d7d-6a63523385e6","ElementType":2,"TagName":"ifrs-full:DisclosureOfConsolidatedAndSeparateFinancialStatementsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Company statement of financial position \r\nas at 31 December 2022 \r\n2022 2021 \r\nNotes US$000 US$000 \r\nNon-current assets \r\nProperty, plant and equipment 16 - 419 \r\nRight of use assets 23 - - \r\nInvestment in subsidiaries 18 - 75 \r\nAmount due from subsidiary undertakings 26 - 15,245 \r\n- 15,739 \r\nCurrent assets \r\nTrade and other receivables 19 2,635 2,305 \r\nCash and cash equivalents 20 \r\n8,539 9,346 \r\n11,174 11,651 \r\nTotal assets 11,174 27,390 \r\nCurrent liabilities \r\nTrade and other payables 21 1,380 2,435 \r\nLoans 1,500 - \r\n2,880 2,435 \r\nNon-current liabilities \r\nTrade and other payables 21 146 426 \r\nTotal liabilities \r\n3,026 2,861 \r\nNet assets 8,148 24,529 \r\nShareholders&#8217; Equity \r\nCalled up share capital 25 3,581 525 \r\nShare premium account 25 222,827 218,381 \r\nRetained deficit (218,260) (194,377) \r\nTotal Shareholders&#8217; equity 8,148 24,529 \r\nThe loss recorded by the Company for the year was US$ 23.9 million (2021: US$ 83.7 million loss). \r\nSigned on behalf of the Board of Directors \r\nSigurd Thorvildsen \r\nDirector \r\n26 May 2023 Company statement of changes in equity \r\nfor the year ended 31 December 2022 \r\nCalled Up \r\nShare \r\ncapital \r\nShare \r\nPremium \r\naccount \r\nRetained \r\nEarnings/(deficit) \r\nTotal \r\nshareholders \r\nequity \r\nUS$000 US$000 US$000 US$000 \r\nAt 1 January 2021 525 218,381 (110,669) 108,237 \r\nTotal comprehensive loss for the year - - (83,708) (83,708) \r\nAt 31 December 2021 525 218,381 (194,377) 24,529 \r\nEquity issue as at 22 December 2022 3,056 4,796 - 7,852 \r\nEquity issue costs as at 22 December 2022 - (350) - (350) \r\nTotal comprehensive loss for the year - - (23,883) (23,883) \r\nAt 31 December 2022 3,581 222,827 (218,260) 8,148 Company statement of cash flows \r\nfor the year ended 31 December 2022 \r\n2022 2021 \r\nNotes US$000 US$000 \r\nOperating activities \r\nLoss before taxation (23,884) (83,692) \r\nAdjustments to reconcile loss before tax to net cash flows: \r\nDepreciation of fixed assets and right of use assets 16, 23 419 390 \r\nImpairment of fixed assets and investments 18, 23 75 979 \r\nNet finance income (6,686) (1,907) \r\nShare based payment - (114) \r\nWorking capital adjustments: \r\nDecrease / (Increase) in prepayments 6,440 (25) \r\nDecrease in trade and subsidiary receivables 26 15,278 80,968 \r\n(Decrease) in trade and other payables (1,089) (833) \r\nInterest paid (168) (41) \r\nInterest received 50 - \r\nNet cash flows used in operating activities (9,565) (4,275) \r\nFinancing activities \r\nProceeds from issue of share capital 7,852 - \r\nEquity issue costs (350) - \r\nIssue of loans 1,500 - \r\nPayment of principal portion of lease liabilities 23 (244) (340) \r\nNet cash flows generated from/(used in) financing activities 8,758 (340) \r\nNet decrease in cash and cash equivalents (807) (4,615) \r\nCash and cash equivalents at beginning of year 9,346 13,961 \r\nCash and cash equivalents at end of year 20 8,539 9,346 ","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of separate financial statements [text block]","Documentation":"The entire disclosure for separate financial statements.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114870,"FileId":8839,"Sequence":79,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"338d978d-2c11-4756-a085-434f3339da3c","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2020_IssuedCapitalMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"525","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:IssuedCapitalMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114871,"FileId":8839,"Sequence":80,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"bc2875cc-4862-4b9f-ad08-ba9c1bca42e8","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2020_SharePremiumMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"218,381","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:SharePremiumMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114872,"FileId":8839,"Sequence":81,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"611ce147-1548-4f4e-b97a-d2a731c36d2f","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2020_RetainedEarningsMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"135,778","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:RetainedEarningsMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114873,"FileId":8839,"Sequence":82,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"18ee93a6-3845-4cee-8eb3-f1337503a0ca","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"83,128","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114874,"FileId":8839,"Sequence":83,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"e63255f7-1920-4360-8b09-7153fa0450e8","ElementType":1,"TagName":"ifrs-full:ComprehensiveIncome","ContextRef":"P01_01_2021To12_31_2021_IssuedCapitalMemberifrsfullComponentsOfEquityAxis","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:IssuedCapitalMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Comprehensive income","Documentation":"The amount of change in equity resulting from transactions and other events, other than those changes resulting from transactions with owners in their capacity as owners.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114875,"FileId":8839,"Sequence":84,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"2806b223-6f81-4838-9873-dc128129f525","ElementType":1,"TagName":"ifrs-full:ComprehensiveIncome","ContextRef":"P01_01_2021To12_31_2021_SharePremiumMemberifrsfullComponentsOfEquityAxis","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:SharePremiumMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Comprehensive income","Documentation":"The amount of change in equity resulting from transactions and other events, other than those changes resulting from transactions with owners in their capacity as owners.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114876,"FileId":8839,"Sequence":85,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"1b73fb61-2657-4312-8592-882e8527d74a","ElementType":1,"TagName":"ifrs-full:ComprehensiveIncome","ContextRef":"P01_01_2021To12_31_2021_RetainedEarningsMemberifrsfullComponentsOfEquityAxis","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"72,229","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:RetainedEarningsMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Comprehensive income","Documentation":"The amount of change in equity resulting from transactions and other events, other than those changes resulting from transactions with owners in their capacity as owners.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114877,"FileId":8839,"Sequence":86,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"5588aac2-2d6d-418f-a631-7b8101e8288d","ElementType":1,"TagName":"ifrs-full:ComprehensiveIncome","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"72,229","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Comprehensive income","Documentation":"The amount of change in equity resulting from transactions and other events, other than those changes resulting from transactions with owners in their capacity as owners.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114878,"FileId":8839,"Sequence":87,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"fc0e6ccd-c157-494b-99c7-d36abff36a87","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2021_IssuedCapitalMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"525","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:IssuedCapitalMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114879,"FileId":8839,"Sequence":88,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"05ab4653-e918-47cd-a2c7-8972c92f12c7","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2021_SharePremiumMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"218,381","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:SharePremiumMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114880,"FileId":8839,"Sequence":89,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"7df4dad2-ddfd-4c7c-b11d-16414ae3a9a9","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2021_RetainedEarningsMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"208,007","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:RetainedEarningsMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114853,"FileId":8839,"Sequence":90,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"addf5b42-0eb0-47a3-b3a8-f59ae7ad6701","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"10,899","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114881,"FileId":8839,"Sequence":91,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"bcaef614-d82c-4900-b633-dea13e66b87a","ElementType":1,"TagName":"ifrs-full:IssueOfEquity","ContextRef":"P01_01_2022To12_31_2022_IssuedCapitalMemberifrsfullComponentsOfEquityAxis","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"3,056","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:IssuedCapitalMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Issue of equity","Documentation":"The increase in equity through the issue of equity instruments.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114852,"FileId":8839,"Sequence":92,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"57d7eb44-dfbd-46bc-bac2-f94fd51ff72f","ElementType":1,"TagName":"ifrs-full:IssueOfEquity","ContextRef":"P01_01_2022To12_31_2022_SharePremiumMemberifrsfullComponentsOfEquityAxis","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"4,796","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:SharePremiumMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Issue of equity","Documentation":"The increase in equity through the issue of equity instruments.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114850,"FileId":8839,"Sequence":93,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"7f54aaf9-7dfb-4f80-9d81-7dbf345c1291","ElementType":1,"TagName":"ifrs-full:IssueOfEquity","ContextRef":"P01_01_2022To12_31_2022_RetainedEarningsMemberifrsfullComponentsOfEquityAxis","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:RetainedEarningsMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Issue of equity","Documentation":"The increase in equity through the issue of equity instruments.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114823,"FileId":8839,"Sequence":94,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"d468e03c-1669-4ba1-9263-4f43b0ec5377","ElementType":1,"TagName":"ifrs-full:IssueOfEquity","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"7,852","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Issue of equity","Documentation":"The increase in equity through the issue of equity instruments.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114824,"FileId":8839,"Sequence":95,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"7c8b409e-fd24-41dd-b3cb-7a6c61cf907d","ElementType":1,"TagName":"ifrs-full:ShareIssueRelatedCost","ContextRef":"P01_01_2022To12_31_2022_IssuedCapitalMemberifrsfullComponentsOfEquityAxis","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:IssuedCapitalMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Share issue related cost","Documentation":"The amount of cost related to the issuance of shares.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114825,"FileId":8839,"Sequence":96,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"dfec1fd1-3113-41fc-89ca-c3b368e02221","ElementType":1,"TagName":"ifrs-full:ShareIssueRelatedCost","ContextRef":"P01_01_2022To12_31_2022_SharePremiumMemberifrsfullComponentsOfEquityAxis","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"350","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:SharePremiumMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Share issue related cost","Documentation":"The amount of cost related to the issuance of shares.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114826,"FileId":8839,"Sequence":97,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"f062a834-818d-4bc5-bba7-d29615c1e550","ElementType":1,"TagName":"ifrs-full:ShareIssueRelatedCost","ContextRef":"P01_01_2022To12_31_2022_RetainedEarningsMemberifrsfullComponentsOfEquityAxis","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:RetainedEarningsMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Share issue related cost","Documentation":"The amount of cost related to the issuance of shares.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114827,"FileId":8839,"Sequence":98,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"e236c7ab-8f8c-4cd9-a6cb-f8f22636a423","ElementType":1,"TagName":"ifrs-full:ShareIssueRelatedCost","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"350","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Share issue related cost","Documentation":"The amount of cost related to the issuance of shares.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114828,"FileId":8839,"Sequence":99,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"d3cb6615-709a-4c6a-b9c2-0787739dff9d","ElementType":1,"TagName":"ifrs-full:ComprehensiveIncome","ContextRef":"P01_01_2022To12_31_2022_IssuedCapitalMemberifrsfullComponentsOfEquityAxis","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:IssuedCapitalMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Comprehensive income","Documentation":"The amount of change in equity resulting from transactions and other events, other than those changes resulting from transactions with owners in their capacity as owners.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114829,"FileId":8839,"Sequence":100,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"226332f1-a3f6-4106-9a06-2d78b0b324c8","ElementType":1,"TagName":"ifrs-full:ComprehensiveIncome","ContextRef":"P01_01_2022To12_31_2022_SharePremiumMemberifrsfullComponentsOfEquityAxis","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:SharePremiumMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Comprehensive income","Documentation":"The amount of change in equity resulting from transactions and other events, other than those changes resulting from transactions with owners in their capacity as owners.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114830,"FileId":8839,"Sequence":101,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"37d57a17-c542-4b99-aaa1-78041aee96ea","ElementType":1,"TagName":"ifrs-full:ComprehensiveIncome","ContextRef":"P01_01_2022To12_31_2022_RetainedEarningsMemberifrsfullComponentsOfEquityAxis","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"145,356","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:RetainedEarningsMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Comprehensive income","Documentation":"The amount of change in equity resulting from transactions and other events, other than those changes resulting from transactions with owners in their capacity as owners.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114831,"FileId":8839,"Sequence":102,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"d4c4f458-b4bb-4591-96c5-4901c103438c","ElementType":1,"TagName":"ifrs-full:ComprehensiveIncome","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"145,356","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Comprehensive income","Documentation":"The amount of change in equity resulting from transactions and other events, other than those changes resulting from transactions with owners in their capacity as owners.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114832,"FileId":8839,"Sequence":103,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"0419cbb0-2cdd-4d98-b684-953556bcc1fc","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2022_IssuedCapitalMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"3,581","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:IssuedCapitalMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114833,"FileId":8839,"Sequence":104,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"745aa5b6-16db-4b86-b8c9-1d3e27cfab51","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2022_SharePremiumMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"222,827","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:SharePremiumMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114834,"FileId":8839,"Sequence":105,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"62ae3460-5b87-49c6-ae75-3cf2182f060e","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2022_RetainedEarningsMemberifrsfullComponentsOfEquityAxis","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"353,363","Dimension":"ifrs-full:ComponentsOfEquityAxis","Member":"ifrs-full:RetainedEarningsMember","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114835,"FileId":8839,"Sequence":106,"PageIdentifier":"cb93031f-ed03-4fe1-8c82-3053df3df7ea","ElementIdentifier":"1ba0d266-73d6-45d7-9ba2-9723a8e1bb6a","ElementType":1,"TagName":"ifrs-full:Equity","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"126,955","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114836,"FileId":8839,"Sequence":107,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"80c1fa8c-7604-4fbd-a9c0-2789ddadfef8","ElementType":1,"TagName":"ifrs-full:ProfitLossBeforeTax","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"145,336","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Profit (loss) before tax","Documentation":"The profit (loss) before tax expense or income. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114837,"FileId":8839,"Sequence":108,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"8b3f7da6-7e89-4996-b841-4642db8c9d0d","ElementType":1,"TagName":"ifrs-full:ProfitLossBeforeTax","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"62,963","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Profit (loss) before tax","Documentation":"The profit (loss) before tax expense or income. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114838,"FileId":8839,"Sequence":109,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"daa81912-7646-48f5-8f3f-4a9ba9c3f848","ElementType":1,"TagName":"ifrs-full:AdjustmentsForDepreciationExpense","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"419","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for depreciation expense","Documentation":"Adjustments for depreciation expense to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114839,"FileId":8839,"Sequence":110,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"8570fc2d-fd66-4305-8671-749af8a91067","ElementType":1,"TagName":"ifrs-full:AdjustmentsForDepreciationExpense","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"6,241","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for depreciation expense","Documentation":"Adjustments for depreciation expense to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114840,"FileId":8839,"Sequence":111,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"644e3520-1c95-47d8-8efa-fc42b90d6fe0","ElementType":1,"TagName":"ifrs-full:AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"205","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for impairment loss (reversal of impairment loss) recognised in profit or loss","Documentation":"Adjustments for impairment loss (reversal of impairment loss) recognised in profit or loss to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Impairment loss (reversal of impairment loss) recognised in profit or loss]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114841,"FileId":8839,"Sequence":112,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"9bf9fa19-37e4-4d14-998f-17f8fb889f9d","ElementType":1,"TagName":"ifrs-full:AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"48,120","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for impairment loss (reversal of impairment loss) recognised in profit or loss","Documentation":"Adjustments for impairment loss (reversal of impairment loss) recognised in profit or loss to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Impairment loss (reversal of impairment loss) recognised in profit or loss]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114842,"FileId":8839,"Sequence":113,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"4d72450f-7094-4b0d-bf4a-67a508983c63","ElementType":1,"TagName":"awlcf:AdjustmentsForInventoryWriteOff","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments For Inventory Write Off","Documentation":"Adjustments For Inventory Write Off.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"false","Nillable":"true","SubstitutionGroup":"xbrli:item","IsReferenceExist":false,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":1,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114843,"FileId":8839,"Sequence":114,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"ba124a74-5f1e-4ff5-8fa7-f17607e8ce6f","ElementType":1,"TagName":"awlcf:AdjustmentsForInventoryWriteOff","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"3,026","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments For Inventory Write Off","Documentation":"Adjustments For Inventory Write Off.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"false","Nillable":"true","SubstitutionGroup":"xbrli:item","IsReferenceExist":false,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":1,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114844,"FileId":8839,"Sequence":115,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"68e6720b-5aa1-4f92-b9f4-47bd6db74dea","ElementType":1,"TagName":"ifrs-full:AdjustmentsForFinanceIncomeCost","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"115","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Adjustments for finance income (cost)","Documentation":"Adjustments for net finance income or cost to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Finance income (cost); Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114845,"FileId":8839,"Sequence":116,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"6303bfd3-fdb8-49fa-8a7e-7aba54cd5c95","ElementType":1,"TagName":"ifrs-full:AdjustmentsForFinanceIncomeCost","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"1,441","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Adjustments for finance income (cost)","Documentation":"Adjustments for net finance income or cost to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Finance income (cost); Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114846,"FileId":8839,"Sequence":117,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"39553496-be94-499c-b019-4930d763fc11","ElementType":1,"TagName":"ifrs-full:AdjustmentsForSharebasedPayments","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for share-based payments","Documentation":"Adjustments for share-based payments to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114847,"FileId":8839,"Sequence":118,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"ea0c68a4-7019-439b-9e0b-5d1e019ece48","ElementType":1,"TagName":"ifrs-full:AdjustmentsForSharebasedPayments","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"114","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Adjustments for share-based payments","Documentation":"Adjustments for share-based payments to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114848,"FileId":8839,"Sequence":119,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"0c6356bc-1ffb-44c9-bd28-4365ce1d77d1","ElementType":1,"TagName":"ifrs-full:AdjustmentsForGainLossOnDisposalsPropertyPlantAndEquipment","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"3,188","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for gain (loss) on disposals, property, plant and equipment","Documentation":"Adjustments for gain (loss) on disposals of property, plant and equipment to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss); Property, plant and equipment; Disposals, property, plant and equipment]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114849,"FileId":8839,"Sequence":120,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"d620787c-9fda-47bb-9e19-4a11b0b85491","ElementType":1,"TagName":"ifrs-full:AdjustmentsForGainLossOnDisposalsPropertyPlantAndEquipment","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for gain (loss) on disposals, property, plant and equipment","Documentation":"Adjustments for gain (loss) on disposals of property, plant and equipment to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss); Property, plant and equipment; Disposals, property, plant and equipment]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114761,"FileId":8839,"Sequence":121,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"ed286cf0-7417-49da-ab9d-8dff38b36573","ElementType":1,"TagName":"ifrs-full:AdjustmentsForDecreaseIncreaseInTradeAndOtherReceivables","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"34","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for decrease (increase) in trade and other receivables","Documentation":"Adjustments for decrease (increase) in trade and other receivables to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Trade and other receivables; Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114851,"FileId":8839,"Sequence":122,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"a8e7fa5d-0fd8-465e-a7e4-9b7913bdb6cc","ElementType":1,"TagName":"ifrs-full:AdjustmentsForDecreaseIncreaseInTradeAndOtherReceivables","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"3,486","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for decrease (increase) in trade and other receivables","Documentation":"Adjustments for decrease (increase) in trade and other receivables to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Trade and other receivables; Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114760,"FileId":8839,"Sequence":123,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"f05c4125-90a8-4bfa-8fb3-da0e25493ad6","ElementType":1,"TagName":"ifrs-full:AdjustmentsForDecreaseIncreaseInInventories","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"115","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for decrease (increase) in inventories","Documentation":"Adjustments for decrease (increase) in inventories to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Inventories; Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114728,"FileId":8839,"Sequence":124,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"7c72ef3d-3520-40c6-9f5e-a08038fd10c8","ElementType":1,"TagName":"ifrs-full:AdjustmentsForDecreaseIncreaseInInventories","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"115","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Adjustments for decrease (increase) in inventories","Documentation":"Adjustments for decrease (increase) in inventories to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Inventories; Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114669,"FileId":8839,"Sequence":125,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"288ca3ce-4e5b-4d6a-a7a4-76731306a893","ElementType":1,"TagName":"ifrs-full:AdjustmentsForDecreaseIncreaseInOtherOperatingReceivables","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"2,006","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Adjustments for decrease (increase) in other operating receivables","Documentation":"Adjustments for decrease (increase) in other operating receivables to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114670,"FileId":8839,"Sequence":126,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"7f03cbfb-4ce1-4755-8a83-5a7baff0ed6c","ElementType":1,"TagName":"ifrs-full:AdjustmentsForDecreaseIncreaseInOtherOperatingReceivables","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"2,249","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for decrease (increase) in other operating receivables","Documentation":"Adjustments for decrease (increase) in other operating receivables to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114671,"FileId":8839,"Sequence":127,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"ab44ab27-b265-4084-9f51-b291cdcfce5c","ElementType":1,"TagName":"ifrs-full:AdjustmentsForIncreaseDecreaseInTradeAccountPayable","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"122,098","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Adjustments for increase (decrease) in trade accounts payable","Documentation":"Adjustments for increase (decrease) in trade accounts payable to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114672,"FileId":8839,"Sequence":128,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"f66bb4d9-73ae-4b0e-9285-43a9ecf921b7","ElementType":1,"TagName":"ifrs-full:AdjustmentsForIncreaseDecreaseInTradeAccountPayable","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"3,605","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Adjustments for increase (decrease) in trade accounts payable","Documentation":"Adjustments for increase (decrease) in trade accounts payable to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114673,"FileId":8839,"Sequence":129,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"f5d25421-25ec-4820-891a-260d3d9539a2","ElementType":1,"TagName":"ifrs-full:InterestPaidClassifiedAsOperatingActivities","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"168","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Interest paid, classified as operating activities","Documentation":"The cash outflow for interest paid, classified as operating activities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114674,"FileId":8839,"Sequence":130,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"30752ae7-adf0-4df6-a2a3-de8d8f658eae","ElementType":1,"TagName":"ifrs-full:InterestPaidClassifiedAsOperatingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"53","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Interest paid, classified as operating activities","Documentation":"The cash outflow for interest paid, classified as operating activities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114675,"FileId":8839,"Sequence":131,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"d58795be-40cc-40f8-8e46-e07858952252","ElementType":1,"TagName":"ifrs-full:InterestReceivedClassifiedAsOperatingActivities","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"53","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Interest received, classified as operating activities","Documentation":"The cash inflow from interest received, classified as operating activities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114676,"FileId":8839,"Sequence":132,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"5c87ecb9-405a-4580-9eb0-a778d72724bb","ElementType":1,"TagName":"ifrs-full:InterestReceivedClassifiedAsOperatingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Interest received, classified as operating activities","Documentation":"The cash inflow from interest received, classified as operating activities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114677,"FileId":8839,"Sequence":133,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"275d913a-313f-4e61-bf95-4882f4c80420","ElementType":1,"TagName":"ifrs-full:IncomeTaxesPaidClassifiedAsOperatingActivities","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"98","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Income taxes paid, classified as operating activities","Documentation":"The cash outflow for income taxes paid, classified as operating activities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114678,"FileId":8839,"Sequence":134,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"89720fd3-dcc9-441a-b86b-2810afecb0d9","ElementType":1,"TagName":"ifrs-full:IncomeTaxesPaidClassifiedAsOperatingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"65","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Income taxes paid, classified as operating activities","Documentation":"The cash outflow for income taxes paid, classified as operating activities.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114679,"FileId":8839,"Sequence":135,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"81fb3e7e-fd07-4b6f-98a8-431d5285a1bd","ElementType":1,"TagName":"ifrs-full:CashFlowsFromUsedInOperatingActivities","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"27,757","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Cash flows from (used in) operating activities","Documentation":"The cash flows from (used in) operating activities, which are the principal revenue-producing activities of the entity and other activities that are not investing or financing activities. [Refer: Revenue]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114680,"FileId":8839,"Sequence":136,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"5d1bc8bb-954d-4963-adf9-0632e47be41a","ElementType":1,"TagName":"ifrs-full:CashFlowsFromUsedInOperatingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"2,352","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Cash flows from (used in) operating activities","Documentation":"The cash flows from (used in) operating activities, which are the principal revenue-producing activities of the entity and other activities that are not investing or financing activities. [Refer: Revenue]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114681,"FileId":8839,"Sequence":137,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"6703f006-c6ee-46ea-b60f-dfce5f0604e8","ElementType":1,"TagName":"ifrs-full:PurchaseOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"205","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Purchase of property, plant and equipment, classified as investing activities","Documentation":"The cash outflow for the purchases of property, plant and equipment, classified as investing activities. [Refer: Property, plant and equipment]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114682,"FileId":8839,"Sequence":138,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"f16531ab-09c1-4156-8154-255477cfbc55","ElementType":1,"TagName":"ifrs-full:PurchaseOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"2,229","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Purchase of property, plant and equipment, classified as investing activities","Documentation":"The cash outflow for the purchases of property, plant and equipment, classified as investing activities. [Refer: Property, plant and equipment]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114683,"FileId":8839,"Sequence":139,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"df03e59a-cf72-48a7-a4e3-9f82dc1d5e03","ElementType":1,"TagName":"ifrs-full:ProceedsFromSalesOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"18,533","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Proceeds from sales of property, plant and equipment, classified as investing activities","Documentation":"The cash inflow from sales of property, plant and equipment, classified as investing activities. [Refer: Property, plant and equipment]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114684,"FileId":8839,"Sequence":140,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"163750fa-7449-4458-a577-3c7d4aa4606e","ElementType":1,"TagName":"ifrs-full:ProceedsFromSalesOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Proceeds from sales of property, plant and equipment, classified as investing activities","Documentation":"The cash inflow from sales of property, plant and equipment, classified as investing activities. [Refer: Property, plant and equipment]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114685,"FileId":8839,"Sequence":141,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"e505f55f-5ddf-4da9-908f-11447f2db56d","ElementType":1,"TagName":"ifrs-full:CashFlowsFromUsedInInvestingActivities","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"18,328","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cash flows from (used in) investing activities","Documentation":"The cash flows from (used in) investing activities, which are the acquisition and disposal of long-term assets and other investments not included in cash equivalents.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114686,"FileId":8839,"Sequence":142,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"70c001fb-aff6-4e48-8d2e-096ab348615f","ElementType":1,"TagName":"ifrs-full:CashFlowsFromUsedInInvestingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"2,229","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Cash flows from (used in) investing activities","Documentation":"The cash flows from (used in) investing activities, which are the acquisition and disposal of long-term assets and other investments not included in cash equivalents.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114687,"FileId":8839,"Sequence":143,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"c08d8bef-8e0a-4eea-8a5a-6033ab41b07a","ElementType":1,"TagName":"ifrs-full:ProceedsFromIssuingShares","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"7,852","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Proceeds from issuing shares","Documentation":"The cash inflow from issuing shares.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114688,"FileId":8839,"Sequence":144,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"92d967d2-fe7d-4637-ae30-b9225dfe9c28","ElementType":1,"TagName":"ifrs-full:ProceedsFromIssuingShares","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Proceeds from issuing shares","Documentation":"The cash inflow from issuing shares.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114689,"FileId":8839,"Sequence":145,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"ac4895b6-1aba-479b-82b1-6fd3c26f4476","ElementType":1,"TagName":"ifrs-full:PaymentsForShareIssueCosts","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"350","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Payments for share issue costs","Documentation":"The cash outflow for share issue costs.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114690,"FileId":8839,"Sequence":146,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"10c61ff2-780b-47a9-8dfc-812308f85574","ElementType":1,"TagName":"ifrs-full:PaymentsForShareIssueCosts","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Payments for share issue costs","Documentation":"The cash outflow for share issue costs.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114691,"FileId":8839,"Sequence":147,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"6299134a-40c9-4fb8-86b1-2b368b8c3e37","ElementType":1,"TagName":"ifrs-full:ProceedsFromBorrowingsClassifiedAsFinancingActivities","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"1,500","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Proceeds from borrowings, classified as financing activities","Documentation":"The cash inflow from borrowings obtained. [Refer: Borrowings]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114692,"FileId":8839,"Sequence":148,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"62d263c4-0d06-43a4-8fef-d62ab7262d66","ElementType":1,"TagName":"ifrs-full:ProceedsFromBorrowingsClassifiedAsFinancingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Proceeds from borrowings, classified as financing activities","Documentation":"The cash inflow from borrowings obtained. [Refer: Borrowings]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114693,"FileId":8839,"Sequence":149,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"4f84d17d-50a7-4a10-a1f8-9e8f2909d7c4","ElementType":1,"TagName":"ifrs-full:PaymentsOfLeaseLiabilitiesClassifiedAsFinancingActivities","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"244","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Payments of lease liabilities, classified as financing activities","Documentation":"The cash outflow for payment of lease liabilities, classified as financing activities. [Refer: Lease liabilities]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114694,"FileId":8839,"Sequence":150,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"3e95c91d-a224-4908-b327-9a63fcb705da","ElementType":1,"TagName":"ifrs-full:PaymentsOfLeaseLiabilitiesClassifiedAsFinancingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"472","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Payments of lease liabilities, classified as financing activities","Documentation":"The cash outflow for payment of lease liabilities, classified as financing activities. [Refer: Lease liabilities]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114695,"FileId":8839,"Sequence":151,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"85bb7a43-3aca-4526-a1e7-16f8b47ba114","ElementType":1,"TagName":"ifrs-full:CashFlowsFromUsedInFinancingActivities","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"8,758","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cash flows from (used in) financing activities","Documentation":"The cash flows from (used in) financing activities, which are activities that result in changes in the size and composition of the contributed equity and borrowings of the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114668,"FileId":8839,"Sequence":152,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"7be66bcc-6c42-42a4-be4a-d639bc8ce198","ElementType":1,"TagName":"ifrs-full:CashFlowsFromUsedInFinancingActivities","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"472","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Cash flows from (used in) financing activities","Documentation":"The cash flows from (used in) financing activities, which are activities that result in changes in the size and composition of the contributed equity and borrowings of the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114667,"FileId":8839,"Sequence":153,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"f7143b0e-881d-4ce5-b6fc-5b57846930fe","ElementType":1,"TagName":"ifrs-full:IncreaseDecreaseInCashAndCashEquivalents","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"671","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Increase (decrease) in cash and cash equivalents after effect of exchange rate changes","Documentation":"The increase (decrease) in cash and cash equivalents after the effect of exchange rate changes on cash and cash equivalents held in foreign currencies. [Refer: Cash and cash equivalents; Effect of exchange rate changes on cash and cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114666,"FileId":8839,"Sequence":154,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"c93611f3-2050-457e-9235-2c8bdc63788b","ElementType":1,"TagName":"ifrs-full:IncreaseDecreaseInCashAndCashEquivalents","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"5,053","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Increase (decrease) in cash and cash equivalents after effect of exchange rate changes","Documentation":"The increase (decrease) in cash and cash equivalents after the effect of exchange rate changes on cash and cash equivalents held in foreign currencies. [Refer: Cash and cash equivalents; Effect of exchange rate changes on cash and cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114651,"FileId":8839,"Sequence":155,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"a107dbc4-5efa-406b-8ecf-1602273b86bf","ElementType":1,"TagName":"ifrs-full:EffectOfExchangeRateChangesOnCashAndCashEquivalents","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"134","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"-","IsHiddenElement":false,"Label":"Effect of exchange rate changes on cash and cash equivalents","Documentation":"The effect of exchange rate changes on cash and cash equivalents held or due in a foreign currency. [Refer: Cash and cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114639,"FileId":8839,"Sequence":156,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"9c0d0872-22ce-4757-a590-08c5a0850654","ElementType":1,"TagName":"ifrs-full:EffectOfExchangeRateChangesOnCashAndCashEquivalents","ContextRef":"P01_01_2021To12_31_2021","Period":"01-Jan-2021 - 31-Dec-2021","Unit":"Unit_USD","CurrencyName":"","Decimal":"-3","Scale":"Thousands","Value":"-","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Effect of exchange rate changes on cash and cash equivalents","Documentation":"The effect of exchange rate changes on cash and cash equivalents held or due in a foreign currency. [Refer: Cash and cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:fixed-zero","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114640,"FileId":8839,"Sequence":157,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"91edfac9-d91c-42ae-a1d3-578aea087c31","ElementType":1,"TagName":"ifrs-full:CashAndCashEquivalents","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"9,685","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cash and cash equivalents","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114641,"FileId":8839,"Sequence":158,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"19efb2ca-b5de-47fd-9728-7b8d0835121c","ElementType":1,"TagName":"ifrs-full:CashAndCashEquivalents","ContextRef":"PAsOn12_31_2020","Period":"31-Dec-2020","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"14,738","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cash and cash equivalents","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114642,"FileId":8839,"Sequence":159,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"3c2e7539-e130-481e-8313-b8bffb46b64e","ElementType":1,"TagName":"ifrs-full:CashAndCashEquivalents","ContextRef":"PAsOn12_31_2022","Period":"31-Dec-2022","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"8,880","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cash and cash equivalents","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114643,"FileId":8839,"Sequence":160,"PageIdentifier":"8ba183b3-caa6-4d3f-a209-12136349667e","ElementIdentifier":"cf39c24c-371a-4546-aec6-5e8d8d549779","ElementType":1,"TagName":"ifrs-full:CashAndCashEquivalents","ContextRef":"PAsOn12_31_2021","Period":"31-Dec-2021","Unit":"Unit_USD","CurrencyName":"Ugandan Shilling","Decimal":"-3","Scale":"Thousands","Value":"9,685","Dimension":"","Member":"","CurrencyCode":"USD","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Cash and cash equivalents","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"ixt:num-dot-decimal","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":false,"IsMandatoryTag":false},{"Id":4114644,"FileId":8839,"Sequence":161,"PageIdentifier":"04cbfd3a-20e6-4bb2-8c41-6bd411241ae9","ElementIdentifier":"8fcdf65f-6f79-4976-98d1-c172702f3c9a","ElementType":2,"TagName":"ifrs-full:DisclosureOfNotesAndOtherExplanatoryInformationExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"1.General information \r\nThe Group and Company financial statements of Awilco Drilling PLC for the year ended \r\n31 December 2022 were authorised for issue by the Board of Directors on 26 May 2023.  The Company is \r\na public company limited by shares, incorporated in the United Kingdom (England and Wales) under the \r\nCompanies Act 2006 and listed on the Euronext Growth Oslo stock exchange. The Company&#8217;s registered \r\nnumber is 7114196 and the address of the registered office is given on page 1. The principal place of the \r\nbusiness is 2 Kingshill Park, Westhill, Aberdeenshire, AB32 6FL. The nature of the Group&#8217;s operations and \r\nits principal activities are set out in the Strategic report. \r\n 2.Basis of preparation \r\nStatement of compliance \r\nThe Group and Company financial statements are prepared in accordance with UK-adopted International \r\nAccounting Standards (UK-adopted IAS) as applied in accordance with section 408 of the Companies Act \r\n2006. No IFRS reconciliation table has been provided, as would typically be required under the Euronext \r\nGrowth Markets rule book as there are no reconciling items between IFRS and UK Adopted IAS for the \r\n Group.\r\nBasis other than going concern \r\nIt is the responsibility of the directors to prepare the financial statements on a going concern basis unless it \r\nis inappropriate to presume the Group will continue in business. The Group is no longer performing \r\noperational activities relating to rigs. Accordingly, they adopt the basis other than going concern in \r\npreparing these financial statements. There have been no departures from IFRS, and no adjustments to \r\ncarrying values as a result of the basis of preparation have been made.  The Group is raising the necessary \r\nfunds from shareholders to fund the ongoing arbitration process. During May 2023, the Group successfully \r\nsigned a further short-term shareholder loan with Awilhelmsen Offshore AS. The loan is for a total of USD \r\nfour million, structured as a draw-down facility. \r\nManagement intend to raise further funding by way of a private placement expected to be carried out during \r\nQ2 2023, followed up with the subsequent repair offerings. The funds will be used to support the ongoing \r\narbitration process. \r\nBasis of consolidation \r\nThe Group financial statements incorporate the financial statements of the Company and entities controlled \r\nby the Company. Under IFRS 10, control exists where the investor has: (a) power over the investee; (b) \r\nexposure, or rights, to variable returns from its involvement with the investee; and (c) the ability to use its \r\npower over the investee to affect the amount of the investor&#8217;s returns. \r\nThe financial statements of the subsidiaries are prepared for the same reporting period as the Company, \r\nusing consistent accounting policies and prepared on a historical cost basis. The Group has elected to take \r\nthe exemption under section 408 of the Companies Act 2006 not to present the Company income statement. \r\nThe loss recorded by the Company for the year was US$ 23.9 million (2021: US$ 83.7 million loss). \r\nMeasurement and disclosure of climate-related matters \r\nIn preparing the financial statements, management have considered the impact of the physical and transition \r\nrisks of climate change as set out on page 10, but have concluded that it does not have a material impact on \r\nthe recognition and measurement of the assets and liabilities in these financial statements as at 31 December \r\n 2022.\r\n 3.Significant accounting judgements, estimates and assumptions \r\nKey sources of estimation uncertainty \r\nThe key assumptions concerning the future, and other key sources of estimation uncertainty at the balance \r\nsheet date, that have a significant risk of causing a material adjustment to the carrying amounts of the assets \r\nand liabilities within the next financial year, are discussed below.  \r\n \r\n \r\n \r\n  \r\nLegal Proceedings \r\nThe subsidiary companies are involved in legal arbitration proceedings. The subsidiary company has \r\nrecognised a provision for cost reimbursement due to a legal obligation as a result of a past event that exists \r\nat the balance sheet date, it is probable that an outflow of economic resources will be required to settle the \r\nobligation, and a reasonable estimate can be made of the amount of the obligation, even although the timing \r\nor amount of the liability is uncertain. \r\nThe final amount of any cost reimbursement may be materially different to management&#8217;s estimate . \r\nSimilarly, the subsidiary company would recognise an asset for any settlement or cost reimbursement in \r\nrelation to legal proceedings due to them if it is virtually certain that the income will be received. \r\nFollowing the arbitration tribunal&#8217;s ruling which awarded in favour of Keppel FELS, a provision has been \r\nmade in the subsidiary company based on an estimate of the expected legal costs. This is considered as a \r\nliability of the subsidiary and not the parent company. \r\nWhere an outflow of economic resources is not probable or an inflow of economic resources is not virtually \r\ncertain, the subsidiary company will disclose a contingent liability or continent asset, respectively. \r\nContingent Liabilities \r\nAs detailed in Note 24, there is one item that is considered as a contingent liability. This is in connection \r\nwith a claim that has been submitted by Keppel FELS shipyard in respect of amounts it considers recoverable \r\ndue to termination provisions in the contract for Nordic Spring. The Group has applied judgement in \r\nevaluating it as contingent liability only and no provision has been made. \r\n 4.Accounting policies \r\nNew standards and interpretations \r\nThere were various standards effective for annual periods beginning on or after 1 January 2022 \r\n&#8226; Reference to the Conceptual Framework &#8211; Amendments to IFRS 3 \r\n&#8226; Property, Plant and Equipment: Proceeds before Intended Use &#8211; Amendments to IAS 16 \r\n&#8226; Onerous Contracts &#8211; Costs of Fulfilling a Contract &#8211; Amendments to IAS 37 \r\n&#8226; IFRS 1 First-time Adoption of International Financial Reporting Standards &#8211; Subsidiary as a first- \r\ntime adopter \r\n&#8226; IFRS 9 Financial Instruments &#8211; Fees in the &#8217;10 per cent&#8217; test for derecognition of financial \r\nliabilities \r\n&#8226; IAS 41 Agriculture &#8211; Taxation in fair value measurements \r\nHowever, none had any impact on these financial statements. The Group has not early adopted any other \r\nstandard, interpretation or amendment that has been issued but is not yet effective. \r\nNew standards and interpretations - not yet adopted \r\nThe following standards and amendments and interpretations to existing standards have been published and \r\nare mandatory for the Group&#8217;s accounting period beginning on or after 1 January 20 23 or later periods, but \r\nthe Group has not early adopted them: \r\n&#8226; IFRS 17 Insurance contracts \r\n&#8226; Classification of Liabilities as Current or Non-current &#8211; Amendments to IAS 1 \r\n&#8226; Definition of accounting estimates - Amendments to IAS 8 \r\n&#8226; Disclosure of Accounting Policies - Amendments to IAS 1 and IFRS Practice Statement 2 \r\n&#8226; Deferred Tax related to Assets and Liabilities arising from a Single Transaction &#8211; Amendments to \r\nIAS 12 \r\n&#8226; Lease Liability in a Sale and Leaseback &#8211; Amendments to IFRS 16 \r\nIt is not anticipated that the application of these standards and amendments will have any material impact \r\non the Group&#8217;s financial statements . \r\n \r\n \r\n \r\n  \r\nCash and cash equivalents \r\nCash and cash equivalents in the statement of financial position comprise cash at bank. \r\nProperty, plant and equipment \r\nRigs and equipment are stated at cost less depreciation and impairment losses. The cost of an asset comprises \r\nits purchase price and directly attributable cost of bringing the asset to its working condition. When it can \r\nbe clearly demonstrated that subsequent expenditures have resulted in an increase in future economic \r\nbenefits expected to be obtained from the use of the assets beyond their originally assessed standard of \r\nperformance, the expenditure is capitalised as an additional cost of the asset. \r\nA component of an asset with a cost that is significant in relation to the total cost of the asset is depreciated \r\nseparately. Components with a similar depreciation method and useful life are grouped together. \r\nDepreciation is calculated using the straight-line method for each asset, after taking into account the \r\nestimated residual value, over its expected useful lives as follows: \r\nSemi-submersible drilling rigs &#8211; 20 years \r\nSpecial purpose surveys &#8211; 5 years \r\nOther fixtures and equipment &#8211;  3-5 years\r\nUseful lives and residual values are reviewed annually and where adjustments are required, these are made \r\nprospectively. An item of property, plant and equipment is derecognised upon disposal or when no future \r\neconomic benefits are expected to arise from the continued use of the asset. Any gain or loss arising on the \r\nderecognition of the asset is included in the statement of comprehensive income in the period of \r\n derecognition.\r\n Inventories\r\nInventories of drilling equipment and spares for future integrated drilling service wells are stated at the lower \r\nof cost incurred and net realisable value. These inventory items include spare parts and supplies relating to \r\nthe operation of the semi-submersible drilling rigs. \r\nRevenue recognition \r\nRevenue derived from charter-hire contracts or other service contracts is recognised in the period that \r\nservices are rendered at rates established in the relevant contracts. Certain contracts include mobilisation \r\nfees payable at the start of the contract. In cases where the fee covers a general upgrade of a rig or equipment \r\nwhich increases the value of the rig or equipment beyond the contract period, the fee is recognised as revenue \r\nover the firm contract period whereas the investment is depreciated over the remaining lifetime of the asset. \r\nIn cases where the fee covers specific upgrades or equipment specific to the contract, the mobilisation fees \r\nare recognised as revenue over the firm contract period. \r\nCost of sales \r\nCost of sales includes rig operating costs and the depreciation cost for the two rigs. \r\n Taxation\r\nCurrent income tax \r\nCurrent tax assets and liabilities are measured at the amount expected to be recovered from or paid to the \r\ntaxation authorities, based on tax rates and laws that are enacted or substantively enacted by the balance \r\nsheet date. \r\nIncome tax is charged or credited directly to equity if it relates to items that are credited or charged to equity. \r\nOtherwise income tax is recognised in the statement of comprehensive income. \r\n Deferred income tax\r\nDeferred tax is provided using the liability method on temporary differences between the tax bases of \r\nassets and liabilities and their carrying amounts for financial reporting purposes at the reporting date.  \r\n \r\n \r\n \r\n  \r\n \r\nDeferred tax liabilities are recognised for all taxable temporary differences, except: \r\n&#8226; When the deferred tax liability arises from the initial recognition of goodwill or an asset or \r\nliability in a transaction that is not a business combination and, at the time of the transaction, \r\naffects neither the accounting profit nor taxable profit or loss \r\n&#8226; In respect of taxable temporary differences associated with investments in subsidiaries, associates \r\nand interests in joint arrangements, when the timing of the reversal of the temporary differences \r\ncan be controlled and it is probable that the temporary differences will not reverse in the \r\nforeseeable future. \r\nDeferred tax assets are recognised for all deductible temporary differences, the carry forward of unused tax \r\ncredits and any unused tax losses. \r\nDeferred tax assets are recognised to the extent that it is probable that taxable profit will be available against \r\nwhich the deductible temporary differences, and the carry forward of unused tax credits and unused tax \r\nlosses can be utilised, except: \r\n&#8226; When the deferred tax asset relating to the deductible temporary differences arises from the initial \r\nrecognition of an asset or liability in a transaction that is not a business combination and, at the \r\ntime of the transaction, affects neither the accounting profit nor taxable profit or loss \r\n&#8226; In respect of deductible temporary differences associated with investments in subsidiaries, \r\nassociates and interests in joint arrangements, deferred tax assets are recognised only to the extent \r\nthat it is probable that the temporary differences will reverse in the foreseeable future and taxable \r\nprofit will be available against which the temporary differences can be utilised \r\nThe carrying amount of deferred tax assets is reviewed at each reporting date and reduced to the extent that \r\nit is no longer probable that sufficient taxable profit will be available to allow all or part of the deferred tax \r\nasset to be utilised. Unrecognised deferred tax assets are re-assessed at each reporting date and are \r\nrecognised to the extent that it has become probable that future taxable profits will allow the deferred tax \r\nasset to be recovered. \r\nDeferred tax assets and liabilities are measured at the tax rates that are expected to apply in the year when \r\nthe asset is realised or the liability is settled, based on tax rates (and tax laws) that have been enacted or \r\nsubstantively enacted at the reporting date. \r\nForeign currency translation \r\nFunctional and presentation currency \r\nItems included in the financial statements of each of the Group&#8217;s entities are measured using United States \r\nDollars (US$) &#8220;the functional currency&#8221;. The Group financial statements are presented in US$, which is the \r\nCompany&#8217;s functional currency and presentation currency and all values are rounded to the nearest thousand \r\ndollars (US$000) except when otherwise indicated. \r\nTransactions and balances \r\nForeign currency transactions are translated into the functional currency using the exchange rates prevailing \r\nat the date of the transactions. Foreign exchange gains and losses resulting from the settlement of such \r\ntransactions and from the translation at period end exchange rates of monetary assets and liabilities \r\ndenominated in foreign currency are recognised in the statement of comprehensive income. The principal \r\nforeign currencies used by the Group are Pounds Sterling (&#163; or GBP), Euro (&#8364;) and Norwegian Kroner \r\n (NOK).\r\nEarnings/(loss) per share \r\nBasic earnings/(loss) per share amounts are calculated by dividing net profit for the period attributable to \r\nordinary equity holders of the Company by the weighted average number of ordinary shares outstanding \r\nduring the year.  \r\n \r\n \r\n \r\n  \r\n \r\nDiluted earnings/(loss) per share amounts are calculated by dividing the net profit by the weighted average \r\nnumber of ordinary shares outstanding during the period plus the weighted average number of ordinary \r\nshares that would be issued on conversion of all the dilutive potential ordinary shares into ordinary shares. \r\n Leases\r\nThe Group applies a single recognition and measurement approach for all leases, except for short-term leases \r\nand leases of low-value assets. The Group has taken the recognition exemption in respect of short-term \r\nleases and leases of low value assets, and instead recognises the expense associated with such leases in the \r\nincome statement on a straight-line basis. \r\nFor all other leases, the Group recognises lease liabilities representing lease payments and right-of-use assets \r\nrepresenting the right to use the underlying assets. \r\nRight-of-use assets \r\nThe Group recognises right-of-use assets at the commencement date of the lease and are measured at cost, \r\nless any accumulated depreciation and impairment losses, adjusted for any re-measurement of lease \r\nliabilities. The cost of right-of-use assets includes the amount of lease liabilities recognised, initial direct \r\ncost incurred, and lease payments made at or before the commencement date less any incentives received. \r\nRight of use assets are depreciated on a straight-line basis over the remaining lease term. \r\nLease liabilities \r\nAt the commencement date of the lease, the Group recognises lease liabilities at the present value of lease \r\npayments to be made over the lease term, using the interest rate implicit to the lease, and if not readily \r\ndeterminable, at the incremental borrowing rate. \r\nThe lease liabilities are included in trade and other payables in Note 21. \r\nFinancial assets \r\nFinancial assets are recognised when the Group becomes party to the contracts that give rise to them and \r\nare classified as financial assets at fair value through profit or loss, amortised cost, or fair value through \r\nother comprehensive income as appropriate. When financial assets are recognised initially, they are \r\nmeasured at fair value, being the transaction price plus, in the case of financial asset not at fair value through \r\nprofit or loss, directly attributable transaction costs. \r\nImpairment of financial assets \r\nFurther disclosures relating to impairment of financial assets are also provided in Note 19. \r\nThe Group recognises an allowance for expected credit loss (ECL) for all debt instruments not held at fair \r\nvalue through profit or loss. ECLs are based on the difference between the contractual cash flows due in \r\naccordance with the contract and all the cash flows that the Group expects to receive, discounted at an \r\napproximation of the original effective interest rate. The expected cash flows will include cash flows from \r\nthe sale of collateral held or other credit enhancements that are integral to the contractual terms. \r\nFor financial assets other than trade receivables and contract assets, ECLs are recognised in two stages. For \r\ncredit exposures for which there has not been a significant increase in credit risk since initial recognition, \r\nECLs are provided for credit losses that result from default events that are possible within the next 12- \r\nmonths (a 12-month ECL). For those credit exposures for which there has been a significant increase in \r\ncredit risk since initial recognition, a loss allowance is required for credit losses expected over the remaining \r\nlife of the exposure, irrespective of the timing of the default (a lifetime ECL).&#8221;  \r\nTrade and other receivables \r\nTrade receivables and amounts due from subsidiary undertakings, which generally have 60-day terms, are \r\nrecognised and subsequently carried at the original invoiced value net of expected credit loss. Where the \r\ntime value of money is material, receivables are carried at amortised cost. During the current and prior \r\nyears, these balances have been immaterial.  \r\n \r\n \r\n \r\n  \r\nTrade and other payables \r\nTrade payables are recognised initially at fair value and subsequently measured at amortised cost using the \r\neffective interest method. \r\nDerecognition of financial liabilities \r\nA financial liability is derecognised when the obligation under the liability is discharged or cancelled or \r\nexpires. Where an existing financial liability is replaced by another from the same lender on substantially \r\ndifferent terms, or the terms of an existing liability are substantially modified, such an exchange or \r\nmodification is treated as a derecognition of the original liability and the recognition of a new liability, and \r\nthe difference in the respective carrying amounts is recognised in the statement of comprehensive income. \r\nShare-based payment \r\nThe cost of cash-settled transactions is measured initially at fair value at the grant date using a Black-Scholes \r\nmodel, further details are given in Note 26. This fair value is expensed over the period until the vesting date \r\nwith recognition of a corresponding liability. The liability is remeasured to fair value at each reporting date \r\nup to and including the settlement date, with changes in fair value recognised in statement of comprehensive \r\nincome for the period. \r\n Pension\r\nThe pension plan in place is a defined contribution plan. Pension contributions are charged to the statement \r\nof comprehensive income as an expense in the period to which the contributions relate. Once the \r\ncontributions have been paid, there are no further payment obligations. \r\nGovernment grants \r\nGovernment grants are recognised where there is reasonable assurance that the grant will be received, and \r\nall attached conditions will be complied with. When the grant relates to an expense item, it is recognised as \r\na deduction in reporting of the related expense, on a systematic basis over the periods that the related costs \r\nfor which it is intended to compensate are expensed. \r\n5. Revenue \r\nRevenue represents the invoiced amount of services provided after the deduction of rebates and retrospective \r\ndiscounts. All items are stated net of value added tax. \r\nThe Group only had one segment &#8211; providing drilling services in the UK. As a result, no further segmental \r\ninformation has been provided. \r\nInformation about major customers \r\nThere was no revenue arising during the year from the provision of drilling services (2021: US$ 25 million \r\nand US$ 8 million from two major customers). \r\n6. Operating loss \r\nThis is stated after charging \r\n2022 2021 \r\nUS$000 US$000 \r\nDepreciation (Note 16, 23) 419 6,241 \r\nLegal and other arbitration costs &#8211; included in G&amp;A expense 15,069 5,544 \r\nInventory recognised as an expense during the year \r\n- 255 \r\nWrite off of inventory -  3,026 \r\n \r\n \r\n \r\n7. Other expense \r\nAs noted in the Strategic report, during April 2023, Awilco Rig 1 Pte Ltd received the arbitration tribunal&#8217;s \r\nruling was awarded in favour of Keppel FELS. This is considered an adjusting post balance sheet event \r\ntherefore the below costs have been recognised. The arbitration panel is still to determine the final amounts \r\nfor the interest and legal fees. \r\n2022 2021 \r\nUS$000 US$000 \r\nTribunal award 98,522 - \r\nInterest on award 14,768 - \r\nProvision for legal fees (Note 22) 9,278 - \r\n122,568  -\r\n 8.Auditors&#8217; remuneration \r\nThe Group paid the following amounts to its auditors in respect of the audit of the financial statements and \r\nfor other services provided to the Group. \r\n2022 2021 \r\nUS$000 US$000 \r\nAudit of the financial statements 246 246 \r\nLocal statutory audits of subsidiaries 19 23 \r\nTax services - compliance 34 27 \r\n299  296\r\n 9.Staff costs \r\n2022 2022 2021 2021 \r\nGroup \r\nUS$000 \r\nCompany \r\nUS$000 \r\nGroup \r\nUS$000 \r\nCompany \r\nUS$000 \r\nWages and salaries 5,001 2,314 14,608 2,555 \r\nDirectors Fees 216 216 277 277 \r\nPension costs 181 86 649 120 \r\nSocial security costs 640 346 1,877 457 \r\nLong term incentive plan - - (19) (19) \r\n6,038 2,962 17,393 3,391 \r\nThe Company makes contributions to a defined contribution scheme for all eligible employees up to a \r\nmaximum of 9% of salary. Contributions are charged to the income statement as incurred. \r\nThe average monthly number of employees during the year was made up as follows: \r\n2022 2021 \r\nNo. No. \r\nOnshore, including management (Company) 14 22 \r\nOffshore 24 96 \r\n38  118 \r\n \r\n \r\n \r\n10. Finance income \r\n 20222021 \r\nUS$000 US$000 \r\nBank interest 53  -\r\n11. Finance expense \r\n 20222021 \r\nUS$000 US$000 \r\nInterest on lease liabilities 124 53 \r\nInterest on loans 44 - \r\nInterest on taxation - 1,388 \r\n168  1,441\r\n12. Net (loss)/gain on foreign exchange transactions \r\n2022 2021 \r\nUS$000 US$000 \r\nGain on foreign exchange transactions 21 14 \r\n(Loss) on foreign exchange transactions (140) (268) \r\nNet (loss) on foreign exchange transactions (119)  (254)\r\n 13.Income tax \r\nIncome tax on profit on ordinary activities \r\n 20222021 \r\nUS$000 US$000 \r\nForeign tax on the loss for the year 21 98 \r\nTotal current income tax 21 98 \r\nAmounts under provided in previous years - 9,152 \r\nTax credit available to the UK - - \r\nTotal current income tax 21 9,250 \r\nDeferred income tax: \r\nOrigination and reversal of temporary differences - 16 \r\nImpact of changes in tax rates - - \r\nTotal deferred income tax - 16 \r\nIncome tax charge in the Group statement of comprehensive income 21 9,266  \r\n \r\n \r\n \r\n  \r\nReconciliation of the total income tax charge \r\n2022 2021 \r\nUS$000 US$000 \r\nLoss from continuing operations (145,336) (62,963) \r\nTax calculated at UK standard rate of corporation tax of 19% (2021:19%) (27,614) (11,963) \r\nExpenses not deductible/(income not taxable) for tax purposes (27) 112 \r\nEffect of (lower)/higher taxes on overseas earnings 21 98 \r\nUnrecognised deferred tax asset 28,247 11,867 \r\nTax (over)/under provided in previous years - 9,152 \r\nDisposal of assets (606) - \r\nIncome tax charge in the Group statement of comprehensive income 21 9,266 \r\nThe income tax expense above is computed at loss before taxation multiplied by the effective rate of \r\ncorporation tax in the UK of 19% (2021: 19%). \r\nThe corporate tax measures announced in the March 2021 Budget set out that corporation tax will increase \r\nfrom 19% to 25% from April 2023. \r\nDeferred income tax \r\nThe deferred income tax included in the statement of financial position is as follows: \r\n2022 2021 \r\nUS$000 US$000 \r\nDeferred tax asset \r\nAs at 1 January - 16 \r\nShare-based payment \r\n- (16) \r\nAs at 31 December - - \r\nUnrecognised deductible temporary differences \r\nThe Group has total tax losses of US$ 241.1 million which arose in the UK (2021: US$ 82.1 million) that \r\nare available for offset against future deductible profits that are not part of the bareboat charter ring-fence \r\narrangements. Following the disposal of the rigs during the year, there are no longer deductible temporary \r\ndifferences relating to fixed assets (2021: US$ 59.4 million) or unutilised capital allowances. (2021: US$ \r\n40.6 million). Deferred tax assets have not been recognised in respect of these losses due to the uncertainty \r\nof future profits being at this level.  \r\n \r\n \r\n \r\n14. Loss per share \r\nThe following reflects the income and share data used in the basic and diluted loss per share computations: \r\n2022 2021 \r\nUS$000 US$000 \r\nLoss for the year attributable to equity share holders (145,356) (72,229) \r\nRestated \r\n2022 2021 \r\nNo.000 No.000 \r\nWeighted average number of ordinary shares for basic and diluted earnings \r\nper share 637 546 \r\nTotal earnings and weighted average number of shares outstanding during the year are the same as for diluted \r\nearnings per share. On 20 December 2022, a 100 : 1 reverse share split was performed (see also Note 24) \r\nwhich resulted in the prior year weighted average number of ordinary shares being retrospectively restated. \r\n15. Government grants \r\n2022 2021 \r\nUS$000 US$000 \r\nAt 1 January \r\n- - \r\nReceived during the year - 14 \r\nReleased to the statement of profit or loss \r\n- (14) \r\nAt 31 December - - \r\nThe above Government grants received were in respect of the UK Coronavirus Job Retention Scheme.  \r\n \r\n \r\n \r\n16. Property, plant and equipment \r\nGroup \r\nSemi- \r\nsubmersible \r\ndrilling rigs \r\nAssets under \r\nconstruction \r\nSpecial \r\npurpose \r\nsurveys \r\nOther \r\nfixtures and \r\nequipment Total \r\nUS$000 US$000 US$000 US$000 US$000 \r\nCost: \r\nAt 1 January 2021 337,652 111,280 16,159 2,017 467,108 \r\nAdjustment 247 - (247) - - \r\nAdditions 722 - 1,507 - 2,229 \r\nAt 31 December 2021 338,621 111,280 17,419 2,017 469,337 \r\nAdditions - - 205 - 205 \r\nDisposals (338,621) - (17,419) - (356,040) \r\nAt 31 December 2022 - 111,280 205 2,017 113,502 \r\nDepreciation and impairment: \r\nAt 1 January 2021 (272,897) (111,280) (14,603) (1,528) (400,308) \r\nAdjustment (578) 578 - \r\nProvided (4,295) - (1,555) (70) (5,920) \r\nImpairment (45,507) - (1,839) - (47,346) \r\nAt 31 December 2021 (323,277) (111,280) (17,419) (1,598) (453,574) \r\nProvided - - - (419) (419) \r\nImpairment - - (205) - (205) \r\nDisposals 323,277 - 17,419 - 340,696 \r\nAt 31 December 2022 - (111,280) (205) (2,017) (113,502) \r\nNet book value: \r\nAt 31 December 2022 - - - - - \r\nAt 31 December 2021 15,345 - - 419 15,764  \r\n \r\n \r\n \r\n  \r\nCompany \r\nOther \r\nfixtures and \r\nequipment \r\nUS$000 \r\nCost: \r\nAt 1 January 2021 2,017 \r\nAdditions - \r\nDisposals - \r\nAt 31 December 2021 2,017 \r\nAdditions - \r\nDisposals - \r\nAt 31 December 2022 2,017 \r\nDepreciation: \r\nAt 1 January 2021 (1528) \r\nProvided (70) \r\nAt 31 December 2021 (1,598) \r\nProvided (419) \r\nAt 31 December 2022 (2,017) \r\nNet book value: \r\nAt 31 December 2022 - \r\nAt 31 December 2021  419\r\n17. Impairment \r\nThe Group considered annually whether there were indicators of impairment of its property, plant and \r\nequipment, and at the prior year-end identified that there were indicators the WilPhoenix rig was impaired. \r\nIn particular it was noted that there was no secured work for the rig, additional costs were expected to be \r\nneeded to maintain the rig and the Group was contemplating disposing of the asset. As such, it was necessary \r\nto estimate the recoverable amount. Recoverable amount was assessed based on the rig&#8217;s fair value less cost \r\nof disposal. \r\nPost year end, a sale of the rig was agreed, and therefore the agreed sale price was used as the basis for \r\ndetermining the fair value less cost of disposal of the rig. As a result, the Group recognised US$ 47.3 million \r\nas an impairment loss relating to the WilPhoenix rig in the prior year. \r\nDuring the current year, an impairment of US$ 0.2 million was recognised.  \r\n \r\n \r\n \r\n18. Investments \r\nCompany Company \r\n2022 2021 \r\nUS$000 US$000 \r\nCompany shares in subsidiary undertakings \r\nAt 1 January 75 279 \r\nImpairment of investment in WilHunter (UK) Limited - (100) \r\nImpairment of investment in Awilco Drilling Offshore (UK) Limited - (100) \r\nImpairment of investment in Awilco Drilling Norge AS - (4) \r\nImpairment of investment in Awilco Drilling Pte Ltd (75) - \r\nAt 31 December - 75 \r\nDetails of the holdings are as follows, all 100% shareholdings: \r\nCountry of \r\nIncorporation Registered Address Name \r\nAwilco Drilling Offshore (UK) Limited United Kingdom \r\nSuite 1, 7 \r\nth \r\nFloor, 50 \r\nBroadway, London \r\nWilHunter (UK) Limited &#8211; in liquidation United Kingdom \r\nSuite 1, 7 \r\nth \r\nFloor, 50 \r\nBroadway, London \r\nAwilco Drilling Pte. Ltd. Singapore 8 Wilkie Road, Singapore \r\nAwilco Rig 1 Pte. Ltd. Singapore 8 Wilkie Road, Singapore \r\nAwilco Rig 2 Pte. Ltd. Singapore 8 Wilkie Road, Singapore  \r\n \r\n \r\n \r\n19. Trade and other receivables \r\n GroupCompany Group Company \r\n2022 2022 2021 2021 \r\nUS$000 US$000 US$000 US$000 \r\nTrade receivables 3 3 37 37 \r\nPrepayments and other receivables (1) 2,598 2,598 542 236 \r\nAccrued interest - - - 1,949 \r\nVAT receivable 34 34 83 83 \r\n2,635 2,635 662  2,305\r\n(1) Included in the balance sheet at 31 December 2022 is a guarantee of GBP 2 million provided to SEPA in \r\nconnection with the WilHunter rig recycling process. This was subsequently settled post year end. \r\nAs at 31 December 2022 and 2021, all trade receivables in the Group and Company are neither past due nor \r\n impaired.\r\n20. Cash and cash equivalents \r\n GroupCompany Group Company \r\n2022 2022 2021 2021 \r\nUS$000 US$000 US$000 US$000 \r\nCash at bank 8,880 8,539 9,685 9,346 \r\nCash at bank earns interest at floating rates based on daily bank deposit rates. The Company has no restricted \r\ncash. (2021: nil) \r\n21. Trade and other payables \r\n GroupCompany Group Company \r\n2022 2022 2021 2021 \r\nUS$000 US$000 US$000 US$000 \r\nTrade and other payables: \r\nLease Liabilities 495 495 315 315 \r\nTrade payables 1,156 391 885 763 \r\nAccruals and other liabilities (1) 115,305 640 3,350 1,357 \r\n116,956 1,526 4,550 2,435 \r\nNon-current: \r\nLease Liabilities 146 146 424 424 \r\nOther liabilities - - 2 2 \r\nTotal 146 146 426  426\r\n(1) Includes US$ 113.3 million in connection with the arbitration tribunal ruling in favour of Keppel FELS \r\n(see Note 7)  \r\n \r\n \r\n \r\n22. Provisions \r\nRedundancy \r\nTribunal \r\nAward \r\nTotal \r\nUS$000 US$000 US$000 \r\nAt 1 January 2022 1,100 - 1,100 \r\nUtilised (1,100) 9,278 8,178 \r\nAt 31 December 2022 - 9,278 9,278 \r\nThe redundancy provision was in relation to Offshore personnel, which was subsequently settled during the \r\nyear. The tribunal award is in relation to the expected costs award in connection with the tribunal ruling in \r\nfavour of Keppel FELS (Note 7). The final decision on the amount of the award for legal costs is still to be \r\nreceived from the arbitration panel. \r\n23. Leases \r\nThe Group has a lease contract in place for the office building at 2 Kingshill Park, Westhill, Aberdeenshire, \r\nAB32 6FL. In the prior year, the remaining right of use asset for the office building in Westhill was fully \r\nimpaired. Set out below is the carrying amount of the right-of-use assets recognised and the movements \r\nduring the period: \r\nOffice Building Office Building \r\nGroup Company Group Company \r\n2022 2022 2021 2021 \r\nUS$000 US$000 US$000 US$000 \r\nAs at 1 January - - 1,096 1,096 \r\nDepreciation Expense - - (321) (321) \r\nImpairment - - (775) (775) \r\nAs at 31 December - - - - \r\nSet out below are the carrying amounts of lease liabilities (included under trade and other payables) and \r\nthe movements during the period: \r\n2022 2022 2021 2021 \r\nGroup Company Group Company \r\nUS$000 US$000 US$000 US$000 \r\nAs at 1 January 739 739 1,633 1,066 \r\nAccretion of interest 124 124 53 41 \r\nPayments (368) (368) (505) (368) \r\nRemeasurement - - (442) - \r\nAs at 31 December \r\n495 495 739 739 \r\nCurrent \r\n349 349 315 315 \r\nNon-current 146 146 424 424 \r\nThe maturity analysis of lease liabilities is disclosed in Note 26.  \r\n \r\n \r\n \r\n  \r\nThe following are the amounts recognised in profit or loss: \r\n2022 2022 2021 2021 \r\nGroup Company Group Company \r\nUS$000 US$000 US$000 US$000 \r\nDepreciation expense of right-of-use assets - - 321 321 \r\nInterest expense on lease liabilities 124 124 53 41 \r\nExpense relating to leases of low-value assets (included in \r\nadministrative expenses) 5 5 3 3 \r\nTotal amount recognised in profit or loss 129 129 377 365 \r\nThe Group has total cash outflows for leases of US$ 0.1 million (2021: US$ 0.5 million). \r\n24. Commitments and contingencies \r\nCapital commitments \r\nThere were nil capital commitments at 31 December 2022 (2021: US$ 0.9 million). \r\n2022 2021 \r\nUS$000 US$000 \r\nAmounts due within one year -  873\r\nContingent Liabilities \r\nIn December 2020, Awilco Rig 2 Pte Ltd received notice from the shipyard purporting to terminate the \r\ncontract for Nordic Spring. A notice of arbitration was also received. The Company notified the shipyard \r\nthat it exercised its contractual right of termination as a result of breaches under the contract. It also \r\nexercised its contractual right and issued the shipyard a notice of termination as a result of Force Majeure. \r\nIt is recognised that Keppel FELS has submitted a claim in respect of amounts it considers recoverable due \r\nto termination provisions in the contract for Nordic Spring. Statement of claims have been received from \r\nKeppel FELS in the amount of Singapore Dollars 356.18 million (US$ 268.9 million) for Awilco Rig 2 Pte. \r\nLtd. but this claim is strongly denied. Due to the non-recourse nature of the contract, this is considered as \r\na contingent liability only of the subsidiary and not the parent company. No provision has been made. It is \r\nexpected that the final arbitration outcome for Awilco Rig 2 Pte Ltd, including any appeal process, will be \r\nno earlier than Q3 2023. \r\nContingent Asset \r\nFollowing the termination of Nordic Spring, the subsidiary company, Awilco Rig 2 Pte. Ltd. has entered \r\narbitration with Keppel FELS in respect of deposit and variation order payments. A total amount of USD \r\n43.0 million plus interest is considered to be recoverable and is therefore disclosed as a contingent asset.  \r\n \r\n \r\n \r\n25. Share capital \r\nGroup and Company \r\n2022 2021 \r\nAuthorised No.000 No.000 \r\nOrdinary shares of &#163;0.65 each (2021 : \r\n&#163;0.0065) \r\n4,469 54,582 \r\nOn 20 December 2022, a 100 : 1 reverse share split was performed \r\nGroup and Company \r\nAllotted called up and fully paid \r\n2022 \r\nNo.000 \r\n2022 \r\nUS$000 \r\n2021 \r\nNo.000 \r\n2021 \r\nUS$000 \r\nAt 1 January 54,582 525 54,582 525 \r\nShare consolidation (54,036) - - - \r\nEquity issue 3,923 3,056 - - \r\nAt 31 December \r\n4,469 3,581 54,582 525 \r\nGroup and Company \r\n2022 \r\nShare \r\npremium \r\naccount \r\n2021 \r\nShare \r\npremium \r\naccount \r\nUS$000 US$000 \r\nAt 1 January 218,381 218,381 \r\nEquity issue 4,446 - \r\nAt 31 December 222,827  218,381\r\n26. Related party transactions \r\nDuring the year the Group entered into transactions, in the ordinary course of business, with Awilhelmsen \r\nOffshore AS, which is a major shareholder through its subsidiaries. \r\nTransactions entered into and trading balances outstanding at 31 December 2022 with Awilhelmsen AS \r\nand its subsidiaries are as follows: \r\n2022 2021 \r\nUS$000 US$000 \r\nPurchase of management services 914 918 \r\nInterest \r\n72 - \r\nAmounts owed to Awilhelmsen AS and its subsidiaries (261) (264) \r\nThe Group and Company entered into a loan arrangement of US$ 1.5 million with major shareholders in \r\nconnection with which commitment fees and interest amounting to US$96,000 (including US$24,000 to \r\nQVT) were incurred and paid during 2022 (2021: nil). \r\nSales and purchases between related parties are made at normal market prices. Outstanding balances are \r\nunsecured, interest-free and cash settlement terms vary between 30 and 90 days. The Company has not \r\nprovided or benefitted from any guarantees for any related party receivables or payables.  Included in the \r\npurchase of management services are the amounts in respect of the interim CEO.  \r\n \r\n \r\n \r\n  \r\nDirectors and other key management personnel \r\nThe remuneration of directors and other key management personnel of the Group is as follows \r\n2022 2021 \r\nUS$000 US$000 \r\nShort-term employee benefits \r\n1,336 1,437 \r\nShare-based payments - (112) \r\nTermination benefits 298 529 \r\nOther long-term benefits \r\n60 82 \r\nIncluded in the short-term employee benefits are director&#8217;s emoluments of GBP 195,000 (2021: GBP \r\n195,000).  Five directors received remuneration in respect of their services to the Company during the year \r\n(2021: five).  The highest paid director was Sigurd Thorvildsen - please refer to the Directors&#8217; remuneration \r\nreport on page 29 for further details. \r\n Company\r\nThe Company entered into the following transactions and had the following balances with its wholly \r\nowned subsidiaries \r\n2022 2021 \r\nUS$000 US$000 \r\nTransactions: \r\nAmounts invoiced to Awilco Drilling Offshore (UK) Limited in respect of \r\nservices provided to the company 11,782 32,804 \r\nAmounts invoiced on behalf of Awilco Drilling Offshore (UK) Limited (20,025) (36,384) \r\nInvoiced to Awilco Drilling Pte. Ltd. 541 127 \r\nTransfer of funds to Awilco Drilling Pte. Ltd. 604 299 \r\nAmounts invoiced to Awilco Rig 1 Pte. Ltd. in respect of services provided \r\nto the company 21,138 - \r\nAmounts invoiced to Awilco Rig 2 Pte. Ltd. in respect of services provided \r\nto the company 5,391 - \r\nAmounts invoiced to Awilco Drilling Norge AS in respect of services \r\nprovided to the company 18 3,431 \r\nSettlement of balance due from Awilco Drilling Norge AS (13,412) - \r\nTaxation paid on behalf of subsidiaries 98 68 \r\nTransfer of share capital funds due to WilHunter (UK) Limited 100  \r\n \r\n \r\n \r\n  \r\n 20222021 \r\nBalances: US$000 US$000 \r\nAmounts receivable from Awilco Drilling Offshore (UK) Limited 78,431 86,674 \r\nAmounts payable to WilHunter (UK) Limited - (100) \r\nAmounts receivable from Awilco Drilling Pte. Ltd. 7,716 6,473 \r\nAmounts receivable from Awilco Rig 1 Pte. Ltd. 78,481 57,343 \r\nAmounts receivable from Awilco Rig 2 Pte. Ltd. 49,689 44,298 \r\nAmounts receivable from Awilco Drilling Norge AS - 13,394 \r\n214,317 208,082 \r\nAllowance for expected credit loss \r\n(214,317) (192,837) \r\n- 15,245 \r\nThe balances receivable from the subsidiary companies are considered long term. There are long term loan \r\nagreements in place with Awilco Drilling Pte. Ltd, Awilco Rig 1 Pte. Ltd. and Awilco Rig 2 Pte. Ltd. \r\nSet out below is the movement in the allowance for expected credit losses of intercompany receivables: \r\n2022 2021 \r\nUS$000 US$000 \r\nAs at 1 January (192,837) (115,010) \r\nProvision for expected credit loss (21,480) (71,199) \r\nAs at 31 December (214,317) (192,837) \r\nExpected credit loss is due to making a full provision for amounts due from Awilco Drilling Offshore (UK) \r\nLimited, Awilco Drilling Pte. Ltd, Awilco Rig 1 Pte. Ltd. and Awilco Rig 2 Pte. Ltd. \r\nEntity with significant influence over the Group \r\nAwilhelmsen Offshore AS, owns 50.5% of the ordinary shares in Awilco Drilling PLC. \r\n27. Capital management, financial risk management objectives and policies \r\nThe Group&#8217;s and the Company&#8217;s principal financial liabilities comprise trade and other payables. The main \r\npurpose of these financial liabilities is to finance the Group&#8217;s operations. The Group has trade and other \r\nreceivables, and cash and cash equivalents that are derived directly from its operations. Management has \r\nassessed the fair values of the financial instruments are approximates to their carrying values. \r\nThe Group and the Company are exposed to market risk, credit risk and liquidity risk. \r\nMarket risk \r\nMarket risk is the risk that the fair value or future cash flows of a financial instrument will fluctuate because \r\nof changes in market prices. Market risk comprises foreign currency risk. Financial instruments affected by \r\nmarket risk are trade and other payables. \r\nForeign currency risk \r\nForeign currency risk is the risk that the fair value or future cash flows of a financial instrument will fluctuate \r\nbecause of changes in foreign exchange rates. The Group&#8217;s and Company&#8217;s exposure to the risk of changes \r\nin foreign exchange rates relates primarily to the Group&#8217;s and Company&#8217;s activities (when expenses are \r\ndenominated in a different currency from the Company&#8217;s functional currency).  \r\n \r\n \r\n \r\n  \r\n \r\nForeign currency risk (continued) \r\nAt the balance sheet date, the Group held GBP 0.7 million in trade and other payables (2021: GBP 0.9 \r\nmillion). A 5% strengthening or weakening of US$ to GBP would have an effect of US$ 0.1 million on the \r\nGroup 2021 result (2021: US$0.1 million). The Group has no other material currency exposures. \r\nCredit risk \r\nCredit risk is the risk that a counterparty will not meet its obligations under a financial instrument or \r\ncustomer contract, leading to a financial loss. During its operational phase, the Group was exposed to credit \r\nrisk from its operating activities (primarily for trade receivables). The Company has credit risk due to its \r\ntrade and other receivables from subsidiary undertakings and from external clients. \r\nManagement would assess the credit rating of new and existing clients and determine if any action was \r\nrequired to secure the financial security in respect of work performed. \r\nLiquidity risk \r\nThe Group&#8217;s objective is to maintain sufficient liquidity in order to support the needs of the business and \r\nmeet the repayments of the debt and commitments as they fall due. In order to achieve this, the Group also \r\nhas the prospect of issuing new equity or entering into new borrowing arrangements. \r\nThe table below summarises the maturity profile of the Group&#8217;s financial liabilities based on contractual \r\nundiscounted payments. \r\nGroup Less than \r\n3 months \r\n3 to 12 \r\nmonths \r\n1-5 \r\nyears Total \r\nTrade and other payables 6,231 113,291 2 119,524 \r\nLease liabilities - 368 153 521 \r\n31 December 2022 6,231 113,659 155 120,045 \r\nTrade and other payables 5,335 - 2 5,337 \r\nLease liabilities - 368 522 890 \r\n31 December 2021 5,335 368 524 6,227 \r\nThe table below summarises the maturity profile of the Company&#8217;s financial liabilities based on contractual \r\nundiscounted payments. \r\nCompany \r\nLess than \r\n3 months \r\n3 to 12 \r\nmonths \r\n1-5 \r\nyears Total \r\nTrade and other payables 2,530 - 2 2,532 \r\nLease liabilities - 368 153 521 \r\n31 December 2022 2,530 368 155 3,053 \r\nTrade and other payables 2,120 - 2 2,122 \r\nLease liabilities - 368 522 890 \r\n31 December 2021 2,120 368 524  3,012 \r\n \r\n \r\n \r\n  \r\n \r\nCapital management \r\nCapital includes called up share capital, share premium and retained earnings / (deficit). \r\nAs the Company is currently no longer performing operational activities relating to rigs, there will be no \r\ndividends distributed arising from operational activity. \r\nThe Company&#8217;s capital is monitored at a Group level. The Group monitors capital using a gearing ratio, \r\nwhich is net debt divided by total shareholders&#8217; funds plus net debt. The Group includes within net debt, \r\nbonds and loans less cash and cash equivalents. \r\nGroup Group \r\n2022 2021 \r\nUS$000 US$000 \r\nCash and cash equivalents (note 19) 8,880 9,685 \r\nNet debt / (funds) 7,380 9,685 \r\nCapital (126,955) 10,899 \r\nCapital less net debt (134,335) (1,214) \r\nGearing ratio n/a  n/a\r\n28. Share-based payments \r\nLong Term Incentive Plan \r\nA long term incentive plan for key management personnel, with a total limit of up to 4,000,000 shares was \r\napproved at the general meeting on 11 November 2019. \r\nThe 2020 plan &#8220;vests&#8221; in 25% tranches. The vesting dates for the plan are linked to the contract that was \r\nsigned with Keppel FELS shipyard in Singapore to build up to four semi-submersible drilling rigs with each \r\ncontract option being independent of each other. Each 25% tranche &#8220;vests&#8221; on the date each of the four rig \r\noption contract commence, and day rate revenue is earned. In the event that the rig building contract is \r\nterminated, as is the case for Rig 1 and Rig 2, the shares will lapse. In the event that the build option is not \r\nexercised, as is the case for Rig 3 and Rig 4 specific vesting dates in 2023 and 2024 are stipulated. \r\nThe awards are options and, following the share consolidation during December 2022, they have a revised \r\nstrike price of NOK 3,000 (2021 : NOK 30). \r\nAs the shares were consolidated on a basis of 1:100, this resulted in an adjustment to the strike price in \r\naccordance with the plan documentation. As a result of this increase, there has been no movement in the \r\nprovision during the year, based on the current trading price of the shares. \r\nAll share options and share awards are synthetic based and are cash settled. \r\nThe estimated fair value of the granted share options and awards are reached on the basis of the &#8220;Black - \r\nScholes option pricing model&#8221;. The model is applied utilising a risk-free discount rate and also taking into \r\naccount the terms and conditions upon which the options and awards are granted as well as the performance \r\nconditions that are required to be satisfied before vesting. The weighted average remaining contractual life \r\nat 31 December 2022 is 1.24 years. There was no movement in the Group total share option and award \r\nduring the year (2021: US$ 0.1 million credit). The carrying amount of the liability relating to the cash- \r\nsettled options at 31 December 2022 is unchanged at US$ 2k (2021: US$2k ).  \r\n \r\n \r\n \r\n  \r\nThe following table list the inputs to the model used for the annual revaluation of the 2020 Plan (share \r\nprices are in NOK). \r\nGroup and Company 2022 2021 \r\n2020 Plan 2020 Plan \r\nExercise price 3,000.0 30.0 \r\nYear-end Share price 1.16 3.20 \r\nExpected life 1.24 years 0.56 years \r\nVolatility 0.00 0.18 \r\nRisk free interest rate 3.13% 0.34% \r\nModel used Black Scholes \r\nThe following table illustrates the number and weighted average exercise prices (WAEP) of, and \r\nmovements in, share options and awards during the year. \r\nGroup and Company 2022 2022 2021 2021 \r\nNo. WAEP (NOK) No. WAEP (NOK) \r\nOutstanding as at 1 January 475,000 30.0 1,247,284 25.86 \r\nGranted during the year - - - - \r\nExercised during the year - - (172,284) - \r\nForfeited during the year (100,00) 30.0 (600,000) 30.0 \r\nAdjusted during the year - - - - \r\nOutstanding at 31 December 375,000 3,000.0 475,000 30.0 \r\nExercisable at 31 December - - - - \r\nThe table below summaries the carrying amount of the liability at 31 December 2021 and 2022 \r\nGroup and Company \r\nLess than 3 \r\nmonths 3 to 12 months 1 &#8211; 5 years Total \r\nUS$000 US$000 US$000 US$000 \r\nShare options / awards - - 2  2 \r\n \r\n \r\n \r\n29. Subsequent events \r\nDuring January, following successful recycling of the WilHunter rig in Turkey, the counter security of GBP \r\n2 million that was held in escrow in connection with the SEPA guarantee was returned in full. \r\nAlso, during January, the short-term shareholder loan and associated interest was repaid in full. \r\nDuring February, a sublet opportunity was identified for the top floor of the Westhill office. The Company \r\nsigned a revised lease with the landlord for the remaining bottom floor area of the office. \r\nDuring April, the subsidiary company, Awilco Rig 1 Pte Ltd received the arbitration tribunal&#8217;s ruling which \r\nawarded in favour of Keppel FELS. This is considered as an adjusting post balance sheet event and the \r\nfinancial statements have been amended accordingly. \r\nDuring May, the Company signed a further short-term shareholder loan with Awilhelmsen Offshore AS. \r\nThe loan is for a total of up to USD four million, structured as a draw-down facility, with interest rate of 10 \r\npercent per annum on the aggregated outstanding principal amount. In addition, there is an arrangement fee \r\nof 2 percent on the total amount. Maturity date for the loan is 30 June 2023. The loan shall be used to support \r\nthe ongoing arbitration process.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of notes and other explanatory information [text block]","Documentation":"The disclosure of notes and other explanatory information as part of a complete set of financial statements.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114645,"FileId":8839,"Sequence":162,"PageIdentifier":"04cbfd3a-20e6-4bb2-8c41-6bd411241ae9","ElementIdentifier":"e23678ee-bae3-4312-b4e6-5b1699f390f4","ElementType":2,"TagName":"ifrs-full:DisclosureOfGeneralInformationAboutFinancialStatementsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"1.General information \r\nThe Group and Company financial statements of Awilco Drilling PLC for the year ended \r\n31 December 2022 were authorised for issue by the Board of Directors on 26 May 2023.  The Company is \r\na public company limited by shares, incorporated in the United Kingdom (England and Wales) under the \r\nCompanies Act 2006 and listed on the Euronext Growth Oslo stock exchange. The Company&#8217;s registered \r\nnumber is 7114196 and the address of the registered office is given on page 1. The principal place of the \r\nbusiness is 2 Kingshill Park, Westhill, Aberdeenshire, AB32 6FL. The nature of the Group&#8217;s operations and \r\nits principal activities are set out in the Strategic report.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of general information about financial statements [text block]","Documentation":"The entire disclosure for general information about financial statements.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114646,"FileId":8839,"Sequence":163,"PageIdentifier":"04cbfd3a-20e6-4bb2-8c41-6bd411241ae9","ElementIdentifier":"b9936419-88f3-420a-beff-51371a416307","ElementType":2,"TagName":"ifrs-full:NameOfReportingEntityOrOtherMeansOfIdentification","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Awilco Drilling PLC","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Name of reporting entity or other means of identification","Documentation":"The name of the reporting entity or other means of identification.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114647,"FileId":8839,"Sequence":164,"PageIdentifier":"04cbfd3a-20e6-4bb2-8c41-6bd411241ae9","ElementIdentifier":"883e0f43-0a93-4934-98fa-c51e50f44940","ElementType":2,"TagName":"ifrs-full:NameOfParentEntity","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Awilco Drilling PLC","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Name of parent entity","Documentation":"The name of the entity's parent. [Refer: Parent [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114648,"FileId":8839,"Sequence":165,"PageIdentifier":"04cbfd3a-20e6-4bb2-8c41-6bd411241ae9","ElementIdentifier":"4fd34bc0-a4b7-4715-8d28-7ad9e265e0a4","ElementType":2,"TagName":"ifrs-full:LegalFormOfEntity","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"PLC","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Legal form of entity","Documentation":"Information about the legal structure under which the entity operates.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114649,"FileId":8839,"Sequence":166,"PageIdentifier":"04cbfd3a-20e6-4bb2-8c41-6bd411241ae9","ElementIdentifier":"e4919b5a-7e13-45e5-afb6-310207732d61","ElementType":2,"TagName":"ifrs-full:DateOfEndOfReportingPeriod2013","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"31 December 2022","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Date of end of reporting period","Documentation":"The date of the end of the reporting period.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:dateItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":false},{"Id":4114650,"FileId":8839,"Sequence":167,"PageIdentifier":"04cbfd3a-20e6-4bb2-8c41-6bd411241ae9","ElementIdentifier":"975405a1-fd61-40d8-b723-62780be46fce","ElementType":2,"TagName":"ifrs-full:CountryOfIncorporation","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"United Kingdom","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Country of incorporation","Documentation":"The country in which the entity is incorporated.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114652,"FileId":8839,"Sequence":168,"PageIdentifier":"04cbfd3a-20e6-4bb2-8c41-6bd411241ae9","ElementIdentifier":"cb7a067a-85d4-4d9c-b515-b08b60196058","ElementType":2,"TagName":"ifrs-full:DomicileOfEntity","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"United Kingdom","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Domicile of entity","Documentation":"The country of domicile of the entity. [Refer: Country of domicile [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114665,"FileId":8839,"Sequence":169,"PageIdentifier":"04cbfd3a-20e6-4bb2-8c41-6bd411241ae9","ElementIdentifier":"d7a445b4-2231-40b4-9e2b-71d4c7633e4f","ElementType":2,"TagName":"ifrs-full:PrincipalPlaceOfBusiness","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"2 Kingshill Park, Westhill, Aberdeenshire, AB32 6FL.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Principal place of business","Documentation":"The place where an entity principally conducts operations.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114653,"FileId":8839,"Sequence":170,"PageIdentifier":"04cbfd3a-20e6-4bb2-8c41-6bd411241ae9","ElementIdentifier":"da428958-4399-4dbb-8b6c-3f1a170fab55","ElementType":2,"TagName":"ifrs-full:DisclosureOfBasisOfPreparationOfFinancialStatementsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"2.Basis of preparation \r\nStatement of compliance \r\nThe Group and Company financial statements are prepared in accordance with UK-adopted International \r\nAccounting Standards (UK-adopted IAS) as applied in accordance with section 408 of the Companies Act \r\n2006. No IFRS reconciliation table has been provided, as would typically be required under the Euronext \r\nGrowth Markets rule book as there are no reconciling items between IFRS and UK Adopted IAS for the \r\n Group.\r\nBasis other than going concern \r\nIt is the responsibility of the directors to prepare the financial statements on a going concern basis unless it \r\nis inappropriate to presume the Group will continue in business. The Group is no longer performing \r\noperational activities relating to rigs. Accordingly, they adopt the basis other than going concern in \r\npreparing these financial statements. There have been no departures from IFRS, and no adjustments to \r\ncarrying values as a result of the basis of preparation have been made.  The Group is raising the necessary \r\nfunds from shareholders to fund the ongoing arbitration process. During May 2023, the Group successfully \r\nsigned a further short-term shareholder loan with Awilhelmsen Offshore AS. The loan is for a total of USD \r\nfour million, structured as a draw-down facility. \r\nManagement intend to raise further funding by way of a private placement expected to be carried out during \r\nQ2 2023, followed up with the subsequent repair offerings. The funds will be used to support the ongoing \r\narbitration process. \r\nBasis of consolidation \r\nThe Group financial statements incorporate the financial statements of the Company and entities controlled \r\nby the Company. Under IFRS 10, control exists where the investor has: (a) power over the investee; (b) \r\nexposure, or rights, to variable returns from its involvement with the investee; and (c) the ability to use its \r\npower over the investee to affect the amount of the investor&#8217;s returns. \r\nThe financial statements of the subsidiaries are prepared for the same reporting period as the Company, \r\nusing consistent accounting policies and prepared on a historical cost basis. The Group has elected to take \r\nthe exemption under section 408 of the Companies Act 2006 not to present the Company income statement. \r\nThe loss recorded by the Company for the year was US$ 23.9 million (2021: US$ 83.7 million loss). \r\nMeasurement and disclosure of climate-related matters \r\nIn preparing the financial statements, management have considered the impact of the physical and transition \r\nrisks of climate change as set out on page 10, but have concluded that it does not have a material impact on \r\nthe recognition and measurement of the assets and liabilities in these financial statements as at 31 December \r\n 2022.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of basis of preparation of financial statements [text block]","Documentation":"The disclosure of the basis used for the preparation of the financial statements.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114654,"FileId":8839,"Sequence":171,"PageIdentifier":"04cbfd3a-20e6-4bb2-8c41-6bd411241ae9","ElementIdentifier":"48f80963-18a9-434f-9326-2e45375dd71c","ElementType":2,"TagName":"ifrs-full:StatementOfIFRSCompliance","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Statement of compliance The Group and Company financial statements are prepared in accordance with UK-adopted International \r\nAccounting Standards (UK-adopted IAS) as applied in accordance with section 408 of the Companies Act \r\n2006. No IFRS reconciliation table has been provided, as would typically be required under the Euronext \r\nGrowth Markets rule book as there are no reconciling items between IFRS and UK Adopted IAS for the \r\n Group.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Statement of IFRS compliance [text block]","Documentation":"An explicit and unreserved statement of compliance with all the requirements of IFRSs.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114655,"FileId":8839,"Sequence":172,"PageIdentifier":"04cbfd3a-20e6-4bb2-8c41-6bd411241ae9","ElementIdentifier":"154c348c-1b5f-4faa-ae44-c85c65d75f7e","ElementType":2,"TagName":"ifrs-full:DisclosureOfGoingConcernExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Basis other than going concern It is the responsibility of the directors to prepare the financial statements on a going concern basis unless it \r\nis inappropriate to presume the Group will continue in business. The Group is no longer performing \r\noperational activities relating to rigs. Accordingly, they adopt the basis other than going concern in \r\npreparing these financial statements. There have been no departures from IFRS, and no adjustments to \r\ncarrying values as a result of the basis of preparation have been made.  The Group is raising the necessary \r\nfunds from shareholders to fund the ongoing arbitration process. During May 2023, the Group successfully \r\nsigned a further short-term shareholder loan with Awilhelmsen Offshore AS. The loan is for a total of USD \r\nfour million, structured as a draw-down facility. \r\nManagement intend to raise further funding by way of a private placement expected to be carried out during \r\nQ2 2023, followed up with the subsequent repair offerings. The funds will be used to support the ongoing \r\narbitration process.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of going concern [text block]","Documentation":"The disclosure of the entity's ability to continue as a going concern.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114656,"FileId":8839,"Sequence":173,"PageIdentifier":"04cbfd3a-20e6-4bb2-8c41-6bd411241ae9","ElementIdentifier":"3e734f32-8920-44be-ab90-f61045a4dab0","ElementType":2,"TagName":"ifrs-full:DisclosureOfBasisOfConsolidationExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Basis of consolidation The Group financial statements incorporate the financial statements of the Company and entities controlled \r\nby the Company. Under IFRS 10, control exists where the investor has: (a) power over the investee; (b) \r\nexposure, or rights, to variable returns from its involvement with the investee; and (c) the ability to use its \r\npower over the investee to affect the amount of the investor&#8217;s returns. \r\nThe financial statements of the subsidiaries are prepared for the same reporting period as the Company, \r\nusing consistent accounting policies and prepared on a historical cost basis. The Group has elected to take \r\nthe exemption under section 408 of the Companies Act 2006 not to present the Company income statement. \r\nThe loss recorded by the Company for the year was US$ 23.9 million (2021: US$ 83.7 million loss).","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of basis of consolidation [text block]","Documentation":"The disclosure of the basis used for consolidation.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114657,"FileId":8839,"Sequence":174,"PageIdentifier":"04cbfd3a-20e6-4bb2-8c41-6bd411241ae9","ElementIdentifier":"5786f649-dd18-4f35-a251-30d475a790ef","ElementType":2,"TagName":"ifrs-full:DisclosureOfAccountingJudgementsAndEstimatesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"3.Significant accounting judgements, estimates and assumptions \r\nKey sources of estimation uncertainty \r\nThe key assumptions concerning the future, and other key sources of estimation uncertainty at the balance \r\nsheet date, that have a significant risk of causing a material adjustment to the carrying amounts of the assets \r\nand liabilities within the next financial year, are discussed below.  \r\n \r\n \r\n \r\n  \r\nLegal Proceedings \r\nThe subsidiary companies are involved in legal arbitration proceedings. The subsidiary company has \r\nrecognised a provision for cost reimbursement due to a legal obligation as a result of a past event that exists \r\nat the balance sheet date, it is probable that an outflow of economic resources will be required to settle the \r\nobligation, and a reasonable estimate can be made of the amount of the obligation, even although the timing \r\nor amount of the liability is uncertain. \r\nThe final amount of any cost reimbursement may be materially different to management&#8217;s estimate . \r\nSimilarly, the subsidiary company would recognise an asset for any settlement or cost reimbursement in \r\nrelation to legal proceedings due to them if it is virtually certain that the income will be received. \r\nFollowing the arbitration tribunal&#8217;s ruling which awarded in favour of Keppel FELS, a provision has been \r\nmade in the subsidiary company based on an estimate of the expected legal costs. This is considered as a \r\nliability of the subsidiary and not the parent company. \r\nWhere an outflow of economic resources is not probable or an inflow of economic resources is not virtually \r\ncertain, the subsidiary company will disclose a contingent liability or continent asset, respectively. \r\nContingent Liabilities \r\nAs detailed in Note 24, there is one item that is considered as a contingent liability. This is in connection \r\nwith a claim that has been submitted by Keppel FELS shipyard in respect of amounts it considers recoverable \r\ndue to termination provisions in the contract for Nordic Spring. The Group has applied judgement in \r\nevaluating it as contingent liability only and no provision has been made.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of accounting judgements and estimates [text block]","Documentation":"The disclosure of judgements that management has made in the process of applying the entity's accounting policies that have the most significant effect on amounts recognised in the financial statements along with information about the assumptions that the entity makes about the future, and other major sources of estimation uncertainty at the end of the reporting period, that have a significant risk of resulting in a material adjustment to the carrying amounts of assets and liabilities within the next year. [Refer: Carrying amount [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114658,"FileId":8839,"Sequence":175,"PageIdentifier":"828551b4-4312-481f-a1ca-e9dc9d1942e1","ElementIdentifier":"314dc4da-85d6-4774-9810-5b7364c11ad6","ElementType":2,"TagName":"ifrs-full:DisclosureOfSummaryOfSignificantAccountingPoliciesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"4.Accounting policies \r\nNew standards and interpretations \r\nThere were various standards effective for annual periods beginning on or after 1 January 2022 \r\n&#8226; Reference to the Conceptual Framework &#8211; Amendments to IFRS 3 \r\n&#8226; Property, Plant and Equipment: Proceeds before Intended Use &#8211; Amendments to IAS 16 \r\n&#8226; Onerous Contracts &#8211; Costs of Fulfilling a Contract &#8211; Amendments to IAS 37 \r\n&#8226; IFRS 1 First-time Adoption of International Financial Reporting Standards &#8211; Subsidiary as a first- \r\ntime adopter \r\n&#8226; IFRS 9 Financial Instruments &#8211; Fees in the &#8217;10 per cent&#8217; test for derecognition of financial \r\nliabilities \r\n&#8226; IAS 41 Agriculture &#8211; Taxation in fair value measurements \r\nHowever, none had any impact on these financial statements. The Group has not early adopted any other \r\nstandard, interpretation or amendment that has been issued but is not yet effective. \r\nNew standards and interpretations - not yet adopted \r\nThe following standards and amendments and interpretations to existing standards have been published and \r\nare mandatory for the Group&#8217;s accounting period beginning on or after 1 January 20 23 or later periods, but \r\nthe Group has not early adopted them: \r\n&#8226; IFRS 17 Insurance contracts \r\n&#8226; Classification of Liabilities as Current or Non-current &#8211; Amendments to IAS 1 \r\n&#8226; Definition of accounting estimates - Amendments to IAS 8 \r\n&#8226; Disclosure of Accounting Policies - Amendments to IAS 1 and IFRS Practice Statement 2 \r\n&#8226; Deferred Tax related to Assets and Liabilities arising from a Single Transaction &#8211; Amendments to \r\nIAS 12 \r\n&#8226; Lease Liability in a Sale and Leaseback &#8211; Amendments to IFRS 16 \r\nIt is not anticipated that the application of these standards and amendments will have any material impact \r\non the Group&#8217;s financial statements . \r\n \r\n \r\n \r\n  \r\nCash and cash equivalents \r\nCash and cash equivalents in the statement of financial position comprise cash at bank. \r\nProperty, plant and equipment \r\nRigs and equipment are stated at cost less depreciation and impairment losses. The cost of an asset comprises \r\nits purchase price and directly attributable cost of bringing the asset to its working condition. When it can \r\nbe clearly demonstrated that subsequent expenditures have resulted in an increase in future economic \r\nbenefits expected to be obtained from the use of the assets beyond their originally assessed standard of \r\nperformance, the expenditure is capitalised as an additional cost of the asset. \r\nA component of an asset with a cost that is significant in relation to the total cost of the asset is depreciated \r\nseparately. Components with a similar depreciation method and useful life are grouped together. \r\nDepreciation is calculated using the straight-line method for each asset, after taking into account the \r\nestimated residual value, over its expected useful lives as follows: \r\nSemi-submersible drilling rigs &#8211; 20 years \r\nSpecial purpose surveys &#8211; 5 years \r\nOther fixtures and equipment &#8211;  3-5 years\r\nUseful lives and residual values are reviewed annually and where adjustments are required, these are made \r\nprospectively. An item of property, plant and equipment is derecognised upon disposal or when no future \r\neconomic benefits are expected to arise from the continued use of the asset. Any gain or loss arising on the \r\nderecognition of the asset is included in the statement of comprehensive income in the period of \r\n derecognition.\r\n Inventories\r\nInventories of drilling equipment and spares for future integrated drilling service wells are stated at the lower \r\nof cost incurred and net realisable value. These inventory items include spare parts and supplies relating to \r\nthe operation of the semi-submersible drilling rigs. \r\nRevenue recognition \r\nRevenue derived from charter-hire contracts or other service contracts is recognised in the period that \r\nservices are rendered at rates established in the relevant contracts. Certain contracts include mobilisation \r\nfees payable at the start of the contract. In cases where the fee covers a general upgrade of a rig or equipment \r\nwhich increases the value of the rig or equipment beyond the contract period, the fee is recognised as revenue \r\nover the firm contract period whereas the investment is depreciated over the remaining lifetime of the asset. \r\nIn cases where the fee covers specific upgrades or equipment specific to the contract, the mobilisation fees \r\nare recognised as revenue over the firm contract period. \r\nCost of sales \r\nCost of sales includes rig operating costs and the depreciation cost for the two rigs. \r\n Taxation\r\nCurrent income tax \r\nCurrent tax assets and liabilities are measured at the amount expected to be recovered from or paid to the \r\ntaxation authorities, based on tax rates and laws that are enacted or substantively enacted by the balance \r\nsheet date. \r\nIncome tax is charged or credited directly to equity if it relates to items that are credited or charged to equity. \r\nOtherwise income tax is recognised in the statement of comprehensive income. \r\n Deferred income tax\r\nDeferred tax is provided using the liability method on temporary differences between the tax bases of \r\nassets and liabilities and their carrying amounts for financial reporting purposes at the reporting date.  \r\n \r\n \r\n \r\n  \r\n \r\nDeferred tax liabilities are recognised for all taxable temporary differences, except: \r\n&#8226; When the deferred tax liability arises from the initial recognition of goodwill or an asset or \r\nliability in a transaction that is not a business combination and, at the time of the transaction, \r\naffects neither the accounting profit nor taxable profit or loss \r\n&#8226; In respect of taxable temporary differences associated with investments in subsidiaries, associates \r\nand interests in joint arrangements, when the timing of the reversal of the temporary differences \r\ncan be controlled and it is probable that the temporary differences will not reverse in the \r\nforeseeable future. \r\nDeferred tax assets are recognised for all deductible temporary differences, the carry forward of unused tax \r\ncredits and any unused tax losses. \r\nDeferred tax assets are recognised to the extent that it is probable that taxable profit will be available against \r\nwhich the deductible temporary differences, and the carry forward of unused tax credits and unused tax \r\nlosses can be utilised, except: \r\n&#8226; When the deferred tax asset relating to the deductible temporary differences arises from the initial \r\nrecognition of an asset or liability in a transaction that is not a business combination and, at the \r\ntime of the transaction, affects neither the accounting profit nor taxable profit or loss \r\n&#8226; In respect of deductible temporary differences associated with investments in subsidiaries, \r\nassociates and interests in joint arrangements, deferred tax assets are recognised only to the extent \r\nthat it is probable that the temporary differences will reverse in the foreseeable future and taxable \r\nprofit will be available against which the temporary differences can be utilised \r\nThe carrying amount of deferred tax assets is reviewed at each reporting date and reduced to the extent that \r\nit is no longer probable that sufficient taxable profit will be available to allow all or part of the deferred tax \r\nasset to be utilised. Unrecognised deferred tax assets are re-assessed at each reporting date and are \r\nrecognised to the extent that it has become probable that future taxable profits will allow the deferred tax \r\nasset to be recovered. \r\nDeferred tax assets and liabilities are measured at the tax rates that are expected to apply in the year when \r\nthe asset is realised or the liability is settled, based on tax rates (and tax laws) that have been enacted or \r\nsubstantively enacted at the reporting date. \r\nForeign currency translation \r\nFunctional and presentation currency \r\nItems included in the financial statements of each of the Group&#8217;s entities are measured using United States \r\nDollars (US$) &#8220;the functional currency&#8221;. The Group financial statements are presented in US$, which is the \r\nCompany&#8217;s functional currency and presentation currency and all values are rounded to the nearest thousand \r\ndollars (US$000) except when otherwise indicated. \r\nTransactions and balances \r\nForeign currency transactions are translated into the functional currency using the exchange rates prevailing \r\nat the date of the transactions. Foreign exchange gains and losses resulting from the settlement of such \r\ntransactions and from the translation at period end exchange rates of monetary assets and liabilities \r\ndenominated in foreign currency are recognised in the statement of comprehensive income. The principal \r\nforeign currencies used by the Group are Pounds Sterling (&#163; or GBP), Euro (&#8364;) and Norwegian Kroner \r\n (NOK).\r\nEarnings/(loss) per share \r\nBasic earnings/(loss) per share amounts are calculated by dividing net profit for the period attributable to \r\nordinary equity holders of the Company by the weighted average number of ordinary shares outstanding \r\nduring the year.  \r\n \r\n \r\n \r\n  \r\n \r\nDiluted earnings/(loss) per share amounts are calculated by dividing the net profit by the weighted average \r\nnumber of ordinary shares outstanding during the period plus the weighted average number of ordinary \r\nshares that would be issued on conversion of all the dilutive potential ordinary shares into ordinary shares. \r\n Leases\r\nThe Group applies a single recognition and measurement approach for all leases, except for short-term leases \r\nand leases of low-value assets. The Group has taken the recognition exemption in respect of short-term \r\nleases and leases of low value assets, and instead recognises the expense associated with such leases in the \r\nincome statement on a straight-line basis. \r\nFor all other leases, the Group recognises lease liabilities representing lease payments and right-of-use assets \r\nrepresenting the right to use the underlying assets. \r\nRight-of-use assets \r\nThe Group recognises right-of-use assets at the commencement date of the lease and are measured at cost, \r\nless any accumulated depreciation and impairment losses, adjusted for any re-measurement of lease \r\nliabilities. The cost of right-of-use assets includes the amount of lease liabilities recognised, initial direct \r\ncost incurred, and lease payments made at or before the commencement date less any incentives received. \r\nRight of use assets are depreciated on a straight-line basis over the remaining lease term. \r\nLease liabilities \r\nAt the commencement date of the lease, the Group recognises lease liabilities at the present value of lease \r\npayments to be made over the lease term, using the interest rate implicit to the lease, and if not readily \r\ndeterminable, at the incremental borrowing rate. \r\nThe lease liabilities are included in trade and other payables in Note 21. \r\nFinancial assets \r\nFinancial assets are recognised when the Group becomes party to the contracts that give rise to them and \r\nare classified as financial assets at fair value through profit or loss, amortised cost, or fair value through \r\nother comprehensive income as appropriate. When financial assets are recognised initially, they are \r\nmeasured at fair value, being the transaction price plus, in the case of financial asset not at fair value through \r\nprofit or loss, directly attributable transaction costs. \r\nImpairment of financial assets \r\nFurther disclosures relating to impairment of financial assets are also provided in Note 19. \r\nThe Group recognises an allowance for expected credit loss (ECL) for all debt instruments not held at fair \r\nvalue through profit or loss. ECLs are based on the difference between the contractual cash flows due in \r\naccordance with the contract and all the cash flows that the Group expects to receive, discounted at an \r\napproximation of the original effective interest rate. The expected cash flows will include cash flows from \r\nthe sale of collateral held or other credit enhancements that are integral to the contractual terms. \r\nFor financial assets other than trade receivables and contract assets, ECLs are recognised in two stages. For \r\ncredit exposures for which there has not been a significant increase in credit risk since initial recognition, \r\nECLs are provided for credit losses that result from default events that are possible within the next 12- \r\nmonths (a 12-month ECL). For those credit exposures for which there has been a significant increase in \r\ncredit risk since initial recognition, a loss allowance is required for credit losses expected over the remaining \r\nlife of the exposure, irrespective of the timing of the default (a lifetime ECL).&#8221;  \r\nTrade and other receivables \r\nTrade receivables and amounts due from subsidiary undertakings, which generally have 60-day terms, are \r\nrecognised and subsequently carried at the original invoiced value net of expected credit loss. Where the \r\ntime value of money is material, receivables are carried at amortised cost. During the current and prior \r\nyears, these balances have been immaterial.  \r\n \r\n \r\n \r\n  \r\nTrade and other payables \r\nTrade payables are recognised initially at fair value and subsequently measured at amortised cost using the \r\neffective interest method. \r\nDerecognition of financial liabilities \r\nA financial liability is derecognised when the obligation under the liability is discharged or cancelled or \r\nexpires. Where an existing financial liability is replaced by another from the same lender on substantially \r\ndifferent terms, or the terms of an existing liability are substantially modified, such an exchange or \r\nmodification is treated as a derecognition of the original liability and the recognition of a new liability, and \r\nthe difference in the respective carrying amounts is recognised in the statement of comprehensive income. \r\nShare-based payment \r\nThe cost of cash-settled transactions is measured initially at fair value at the grant date using a Black-Scholes \r\nmodel, further details are given in Note 26. This fair value is expensed over the period until the vesting date \r\nwith recognition of a corresponding liability. The liability is remeasured to fair value at each reporting date \r\nup to and including the settlement date, with changes in fair value recognised in statement of comprehensive \r\nincome for the period. \r\n Pension\r\nThe pension plan in place is a defined contribution plan. Pension contributions are charged to the statement \r\nof comprehensive income as an expense in the period to which the contributions relate. Once the \r\ncontributions have been paid, there are no further payment obligations. \r\nGovernment grants \r\nGovernment grants are recognised where there is reasonable assurance that the grant will be received, and \r\nall attached conditions will be complied with. When the grant relates to an expense item, it is recognised as \r\na deduction in reporting of the related expense, on a systematic basis over the periods that the related costs \r\nfor which it is intended to compensate are expensed.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of significant accounting policies [text block]","Documentation":"The entire disclosure for significant accounting policies applied by the entity.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114659,"FileId":8839,"Sequence":176,"PageIdentifier":"73966ffd-d675-4cde-ac15-3e8a9436c4f7","ElementIdentifier":"03fca60d-5085-4904-8749-87d9e71b7420","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyToDetermineComponentsOfCashAndCashEquivalents","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Cash and cash equivalents Cash and cash equivalents in the statement of financial position comprise cash at bank.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for determining components of cash and cash equivalents [text block]","Documentation":"The description of the entity's accounting policy used to determine the components of cash and cash equivalents. [Refer: Cash and cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114660,"FileId":8839,"Sequence":177,"PageIdentifier":"73966ffd-d675-4cde-ac15-3e8a9436c4f7","ElementIdentifier":"68f2cb80-1fd6-4243-934d-02b75fcc03c6","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForPropertyPlantAndEquipmentExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Property, plant and equipment Rigs and equipment are stated at cost less depreciation and impairment losses. The cost of an asset comprises \r\nits purchase price and directly attributable cost of bringing the asset to its working condition. When it can \r\nbe clearly demonstrated that subsequent expenditures have resulted in an increase in future economic \r\nbenefits expected to be obtained from the use of the assets beyond their originally assessed standard of \r\nperformance, the expenditure is capitalised as an additional cost of the asset. \r\nA component of an asset with a cost that is significant in relation to the total cost of the asset is depreciated \r\nseparately. Components with a similar depreciation method and useful life are grouped together. \r\nDepreciation is calculated using the straight-line method for each asset, after taking into account the \r\nestimated residual value, over its expected useful lives as follows: \r\nSemi-submersible drilling rigs &#8211; 20 years \r\nSpecial purpose surveys &#8211; 5 years \r\nOther fixtures and equipment &#8211;  3-5 years\r\nUseful lives and residual values are reviewed annually and where adjustments are required, these are made \r\nprospectively. An item of property, plant and equipment is derecognised upon disposal or when no future \r\neconomic benefits are expected to arise from the continued use of the asset. Any gain or loss arising on the \r\nderecognition of the asset is included in the statement of comprehensive income in the period of \r\n derecognition.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for property, plant and equipment [text block]","Documentation":"The description of the entity's accounting policy for property, plant and equipment. [Refer: Property, plant and equipment]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114661,"FileId":8839,"Sequence":178,"PageIdentifier":"73966ffd-d675-4cde-ac15-3e8a9436c4f7","ElementIdentifier":"c0924746-f1ae-4aed-a4cf-792dd441aa94","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForDepreciationExpenseExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Depreciation is calculated using the straight-line method for each asset, after taking into account the estimated residual value, over its expected useful lives as follows: \r\nSemi-submersible drilling rigs &#8211; 20 years \r\nSpecial purpose surveys &#8211; 5 years \r\nOther fixtures and equipment &#8211;  3-5 years","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for depreciation expense [text block]","Documentation":"The description of the entity's accounting policy for depreciation expense. [Refer: Depreciation and amortisation expense]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114662,"FileId":8839,"Sequence":179,"PageIdentifier":"73966ffd-d675-4cde-ac15-3e8a9436c4f7","ElementIdentifier":"77bdf8d3-42fc-425a-974d-50aa669f9e5d","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForMeasuringInventories","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"InventoriesInventories of drilling equipment and spares for future integrated drilling service wells are stated at the lower \r\nof cost incurred and net realisable value. These inventory items include spare parts and supplies relating to \r\nthe operation of the semi-submersible drilling rigs.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for measuring inventories [text block]","Documentation":"The description of the entity's accounting policy for measuring inventories. [Refer: Inventories]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114663,"FileId":8839,"Sequence":180,"PageIdentifier":"73966ffd-d675-4cde-ac15-3e8a9436c4f7","ElementIdentifier":"f3765cb7-5a7c-460d-8a97-74f6e48579d5","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForRecognitionOfRevenue","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Revenue recognition Revenue derived from charter-hire contracts or other service contracts is recognised in the period that \r\nservices are rendered at rates established in the relevant contracts. Certain contracts include mobilisation \r\nfees payable at the start of the contract. In cases where the fee covers a general upgrade of a rig or equipment \r\nwhich increases the value of the rig or equipment beyond the contract period, the fee is recognised as revenue \r\nover the firm contract period whereas the investment is depreciated over the remaining lifetime of the asset. \r\nIn cases where the fee covers specific upgrades or equipment specific to the contract, the mobilisation fees \r\nare recognised as revenue over the firm contract period.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for recognition of revenue [text block]","Documentation":"The description of the entity's accounting policy for recognising revenue. [Refer: Revenue]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114664,"FileId":8839,"Sequence":181,"PageIdentifier":"73966ffd-d675-4cde-ac15-3e8a9436c4f7","ElementIdentifier":"9a664338-0122-4f60-9531-be0b7d9b14b9","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForFeeAndCommissionIncomeAndExpenseExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Revenue derived from charter-hire contracts or other service contracts is recognised in the period that services are rendered at rates established in the relevant contracts. Certain contracts include mobilisation \r\nfees payable at the start of the contract. In cases where the fee covers a general upgrade of a rig or equipment \r\nwhich increases the value of the rig or equipment beyond the contract period, the fee is recognised as revenue \r\nover the firm contract period whereas the investment is depreciated over the remaining lifetime of the asset. \r\nIn cases where the fee covers specific upgrades or equipment specific to the contract, the mobilisation fees are recognised as revenue over the firm contract period.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for fee and commission income and expense [text block]","Documentation":"The description of the entity's accounting policy for fee and commission income and expense. [Refer: Fee and commission income (expense)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114696,"FileId":8839,"Sequence":182,"PageIdentifier":"73966ffd-d675-4cde-ac15-3e8a9436c4f7","ElementIdentifier":"e7bab360-b871-49a1-98b8-02dde74a78f0","ElementType":2,"TagName":"ifrs-full:DisclosureOfCostOfSalesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Cost of sales Cost of sales includes rig operating costs and the depreciation cost for the two rigs.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of cost of sales [text block]","Documentation":"The disclosure of the cost of sales. [Refer: Cost of sales]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114697,"FileId":8839,"Sequence":183,"PageIdentifier":"73966ffd-d675-4cde-ac15-3e8a9436c4f7","ElementIdentifier":"759bb046-b45a-4fb0-b444-de91ee8cc1dc","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForIncomeTaxExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"TaxationCurrent income tax \r\nCurrent tax assets and liabilities are measured at the amount expected to be recovered from or paid to the \r\ntaxation authorities, based on tax rates and laws that are enacted or substantively enacted by the balance \r\nsheet date. \r\nIncome tax is charged or credited directly to equity if it relates to items that are credited or charged to equity. \r\nOtherwise income tax is recognised in the statement of comprehensive income. \r\n Deferred income tax\r\nDeferred tax is provided using the liability method on temporary differences between the tax bases of \r\nassets and liabilities and their carrying amounts for financial reporting purposes at the reporting date.  \r\n \r\n \r\n \r\n  \r\n \r\nDeferred tax liabilities are recognised for all taxable temporary differences, except: \r\n&#8226; When the deferred tax liability arises from the initial recognition of goodwill or an asset or \r\nliability in a transaction that is not a business combination and, at the time of the transaction, \r\naffects neither the accounting profit nor taxable profit or loss \r\n&#8226; In respect of taxable temporary differences associated with investments in subsidiaries, associates \r\nand interests in joint arrangements, when the timing of the reversal of the temporary differences \r\ncan be controlled and it is probable that the temporary differences will not reverse in the \r\nforeseeable future. \r\nDeferred tax assets are recognised for all deductible temporary differences, the carry forward of unused tax \r\ncredits and any unused tax losses. \r\nDeferred tax assets are recognised to the extent that it is probable that taxable profit will be available against \r\nwhich the deductible temporary differences, and the carry forward of unused tax credits and unused tax \r\nlosses can be utilised, except: \r\n&#8226; When the deferred tax asset relating to the deductible temporary differences arises from the initial \r\nrecognition of an asset or liability in a transaction that is not a business combination and, at the \r\ntime of the transaction, affects neither the accounting profit nor taxable profit or loss \r\n&#8226; In respect of deductible temporary differences associated with investments in subsidiaries, \r\nassociates and interests in joint arrangements, deferred tax assets are recognised only to the extent \r\nthat it is probable that the temporary differences will reverse in the foreseeable future and taxable \r\nprofit will be available against which the temporary differences can be utilised \r\nThe carrying amount of deferred tax assets is reviewed at each reporting date and reduced to the extent that \r\nit is no longer probable that sufficient taxable profit will be available to allow all or part of the deferred tax \r\nasset to be utilised. Unrecognised deferred tax assets are re-assessed at each reporting date and are \r\nrecognised to the extent that it has become probable that future taxable profits will allow the deferred tax \r\nasset to be recovered. \r\nDeferred tax assets and liabilities are measured at the tax rates that are expected to apply in the year when \r\nthe asset is realised or the liability is settled, based on tax rates (and tax laws) that have been enacted or \r\nsubstantively enacted at the reporting date.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for income tax [text block]","Documentation":"The description of the entity's accounting policy for income tax.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114698,"FileId":8839,"Sequence":184,"PageIdentifier":"73966ffd-d675-4cde-ac15-3e8a9436c4f7","ElementIdentifier":"c6414895-c031-484d-8f8f-11b67f114692","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForDeferredIncomeTaxExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Deferred income taxDeferred tax is provided using the liability method on temporary differences between the tax bases of \r\nassets and liabilities and their carrying amounts for financial reporting purposes at the reporting date.  \r\n \r\n \r\n \r\n  \r\n \r\nDeferred tax liabilities are recognised for all taxable temporary differences, except: \r\n&#8226; When the deferred tax liability arises from the initial recognition of goodwill or an asset or \r\nliability in a transaction that is not a business combination and, at the time of the transaction, \r\naffects neither the accounting profit nor taxable profit or loss \r\n&#8226; In respect of taxable temporary differences associated with investments in subsidiaries, associates \r\nand interests in joint arrangements, when the timing of the reversal of the temporary differences \r\ncan be controlled and it is probable that the temporary differences will not reverse in the \r\nforeseeable future. \r\nDeferred tax assets are recognised for all deductible temporary differences, the carry forward of unused tax \r\ncredits and any unused tax losses. \r\nDeferred tax assets are recognised to the extent that it is probable that taxable profit will be available against \r\nwhich the deductible temporary differences, and the carry forward of unused tax credits and unused tax \r\nlosses can be utilised, except: \r\n&#8226; When the deferred tax asset relating to the deductible temporary differences arises from the initial \r\nrecognition of an asset or liability in a transaction that is not a business combination and, at the \r\ntime of the transaction, affects neither the accounting profit nor taxable profit or loss \r\n&#8226; In respect of deductible temporary differences associated with investments in subsidiaries, \r\nassociates and interests in joint arrangements, deferred tax assets are recognised only to the extent \r\nthat it is probable that the temporary differences will reverse in the foreseeable future and taxable \r\nprofit will be available against which the temporary differences can be utilised \r\nThe carrying amount of deferred tax assets is reviewed at each reporting date and reduced to the extent that \r\nit is no longer probable that sufficient taxable profit will be available to allow all or part of the deferred tax \r\nasset to be utilised. Unrecognised deferred tax assets are re-assessed at each reporting date and are \r\nrecognised to the extent that it has become probable that future taxable profits will allow the deferred tax \r\nasset to be recovered. \r\nDeferred tax assets and liabilities are measured at the tax rates that are expected to apply in the year when \r\nthe asset is realised or the liability is settled, based on tax rates (and tax laws) that have been enacted or \r\nsubstantively enacted at the reporting date.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for deferred income tax [text block]","Documentation":"The description of the entity's accounting policy for deferred income tax. [Refer: Deferred tax expense (income)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114699,"FileId":8839,"Sequence":185,"PageIdentifier":"5bf4e927-f7b9-4273-9df0-525e2ebad9b9","ElementIdentifier":"fdb2df62-f2a4-4068-b04b-bb36a9e08eb1","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForForeignCurrencyTranslationExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Foreign currency translation Functional and presentation currency \r\nItems included in the financial statements of each of the Group&#8217;s entities are measured using United States \r\nDollars (US$) &#8220;the functional currency&#8221;. The Group financial statements are presented in US$, which is the \r\nCompany&#8217;s functional currency and presentation currency and all values are rounded to the nearest thousand \r\ndollars (US$000) except when otherwise indicated. \r\nTransactions and balances \r\nForeign currency transactions are translated into the functional currency using the exchange rates prevailing \r\nat the date of the transactions. Foreign exchange gains and losses resulting from the settlement of such \r\ntransactions and from the translation at period end exchange rates of monetary assets and liabilities \r\ndenominated in foreign currency are recognised in the statement of comprehensive income. The principal \r\nforeign currencies used by the Group are Pounds Sterling (&#163; or GBP), Euro (&#8364;) and Norwegian Kroner \r\n (NOK).","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for foreign currency translation [text block]","Documentation":"The description of the entity's accounting policy for foreign currency translation.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114731,"FileId":8839,"Sequence":186,"PageIdentifier":"5bf4e927-f7b9-4273-9df0-525e2ebad9b9","ElementIdentifier":"1d087236-df48-4d82-b18c-f4de732e4b18","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForFunctionalCurrencyExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Functional and presentation currency Items included in the financial statements of each of the Group&#8217;s entities are measured using United States \r\nDollars (US$) &#8220;the functional currency&#8221;. The Group financial statements are presented in US$, which is the \r\nCompany&#8217;s functional currency and presentation currency and all values are rounded to the nearest thousand \r\ndollars (US$000) except when otherwise indicated.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for functional currency [text block]","Documentation":"The description of the entity's accounting policy for the currency of the primary economic environment in which the entity operates.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114732,"FileId":8839,"Sequence":187,"PageIdentifier":"5bf4e927-f7b9-4273-9df0-525e2ebad9b9","ElementIdentifier":"11080bc4-bc1c-427a-a964-bfa8a3ebbeb2","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForEarningsPerShareExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Earnings/(loss) per share Basic earnings/(loss) per share amounts are calculated by dividing net profit for the period attributable to \r\nordinary equity holders of the Company by the weighted average number of ordinary shares outstanding \r\nduring the year.  \r\n \r\n \r\n \r\n  \r\n \r\nDiluted earnings/(loss) per share amounts are calculated by dividing the net profit by the weighted average \r\nnumber of ordinary shares outstanding during the period plus the weighted average number of ordinary \r\nshares that would be issued on conversion of all the dilutive potential ordinary shares into ordinary shares.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for earnings per share [text block]","Documentation":"The description of the entity's accounting policy for earnings per share.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114733,"FileId":8839,"Sequence":188,"PageIdentifier":"566702fa-8eda-4b6e-a2b7-b4b88b69c92a","ElementIdentifier":"543f1891-8f91-4bf9-81d6-e6ede14f9ea2","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForLeasesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"LeasesThe Group applies a single recognition and measurement approach for all leases, except for short-term leases \r\nand leases of low-value assets. The Group has taken the recognition exemption in respect of short-term \r\nleases and leases of low value assets, and instead recognises the expense associated with such leases in the \r\nincome statement on a straight-line basis. \r\nFor all other leases, the Group recognises lease liabilities representing lease payments and right-of-use assets \r\nrepresenting the right to use the underlying assets. \r\nRight-of-use assets \r\nThe Group recognises right-of-use assets at the commencement date of the lease and are measured at cost, \r\nless any accumulated depreciation and impairment losses, adjusted for any re-measurement of lease \r\nliabilities. The cost of right-of-use assets includes the amount of lease liabilities recognised, initial direct \r\ncost incurred, and lease payments made at or before the commencement date less any incentives received. \r\nRight of use assets are depreciated on a straight-line basis over the remaining lease term. \r\nLease liabilities \r\nAt the commencement date of the lease, the Group recognises lease liabilities at the present value of lease \r\npayments to be made over the lease term, using the interest rate implicit to the lease, and if not readily \r\ndeterminable, at the incremental borrowing rate. \r\nThe lease liabilities are included in trade and other payables in Note 21.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for leases [text block]","Documentation":"The description of the entity's accounting policy for leases. A lease is an agreement whereby the lessor conveys to the lessee in return for a payment or series of payments the right to use an asset for an agreed period of time.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114734,"FileId":8839,"Sequence":189,"PageIdentifier":"566702fa-8eda-4b6e-a2b7-b4b88b69c92a","ElementIdentifier":"cb47971b-94df-45e3-b080-8371292c9a2c","ElementType":2,"TagName":"ifrs-full:DisclosureOfQuantitativeInformationAboutRightofuseAssetsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Right-of-use assets The Group recognises right-of-use assets at the commencement date of the lease and are measured at cost, \r\nless any accumulated depreciation and impairment losses, adjusted for any re-measurement of lease \r\nliabilities. The cost of right-of-use assets includes the amount of lease liabilities recognised, initial direct \r\ncost incurred, and lease payments made at or before the commencement date less any incentives received. \r\nRight of use assets are depreciated on a straight-line basis over the remaining lease term.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of quantitative information about right-of-use assets [text block]","Documentation":"The disclosure of quantitative information about right-of-use assets. [Refer: Right-of-use assets]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":false},{"Id":4114735,"FileId":8839,"Sequence":190,"PageIdentifier":"566702fa-8eda-4b6e-a2b7-b4b88b69c92a","ElementIdentifier":"f3e1fa4d-42b1-4070-bf94-511da712ef3b","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForFinancialAssetsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Financial assets Financial assets are recognised when the Group becomes party to the contracts that give rise to them and \r\nare classified as financial assets at fair value through profit or loss, amortised cost, or fair value through \r\nother comprehensive income as appropriate. When financial assets are recognised initially, they are \r\nmeasured at fair value, being the transaction price plus, in the case of financial asset not at fair value through \r\nprofit or loss, directly attributable transaction costs.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for financial assets [text block]","Documentation":"The description of the entity's accounting policy for financial assets. [Refer: Financial assets]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114736,"FileId":8839,"Sequence":191,"PageIdentifier":"566702fa-8eda-4b6e-a2b7-b4b88b69c92a","ElementIdentifier":"359df154-d5c2-4b6b-9e49-40bd840d866a","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForImpairmentOfFinancialAssetsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Impairment of financial assets Further disclosures relating to impairment of financial assets are also provided in Note 19. \r\nThe Group recognises an allowance for expected credit loss (ECL) for all debt instruments not held at fair \r\nvalue through profit or loss. ECLs are based on the difference between the contractual cash flows due in \r\naccordance with the contract and all the cash flows that the Group expects to receive, discounted at an \r\napproximation of the original effective interest rate. The expected cash flows will include cash flows from \r\nthe sale of collateral held or other credit enhancements that are integral to the contractual terms. \r\nFor financial assets other than trade receivables and contract assets, ECLs are recognised in two stages. For \r\ncredit exposures for which there has not been a significant increase in credit risk since initial recognition, \r\nECLs are provided for credit losses that result from default events that are possible within the next 12- \r\nmonths (a 12-month ECL). For those credit exposures for which there has been a significant increase in \r\ncredit risk since initial recognition, a loss allowance is required for credit losses expected over the remaining \r\nlife of the exposure, irrespective of the timing of the default (a lifetime ECL).&#8221;","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for impairment of financial assets [text block]","Documentation":"The description of the entity's accounting policy for the impairment of financial assets. [Refer: Financial assets]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114737,"FileId":8839,"Sequence":192,"PageIdentifier":"566702fa-8eda-4b6e-a2b7-b4b88b69c92a","ElementIdentifier":"8836f44d-14db-4c4b-acb6-3288ddef5bf0","ElementType":2,"TagName":"ifrs-full:DisclosureOfAllowanceForCreditLossesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"The Group recognises an allowance for expected credit loss (ECL) for all debt instruments not held at fair \r\nvalue through profit or loss. ECLs are based on the difference between the contractual cash flows due in \r\naccordance with the contract and all the cash flows that the Group expects to receive, discounted at an \r\napproximation of the original effective interest rate. The expected cash flows will include cash flows from \r\nthe sale of collateral held or other credit enhancements that are integral to the contractual terms. \r\nFor financial assets other than trade receivables and contract assets, ECLs are recognised in two stages. For \r\ncredit exposures for which there has not been a significant increase in credit risk since initial recognition, \r\nECLs are provided for credit losses that result from default events that are possible within the next 12- \r\nmonths (a 12-month ECL). For those credit exposures for which there has been a significant increase in \r\ncredit risk since initial recognition, a loss allowance is required for credit losses expected over the remaining \r\nlife of the exposure, irrespective of the timing of the default (a lifetime ECL).&#8221; 20222021 \r\nBalances: US$000 US$000 \r\nAmounts receivable from Awilco Drilling Offshore (UK) Limited 78,431 86,674 \r\nAmounts payable to WilHunter (UK) Limited - (100) \r\nAmounts receivable from Awilco Drilling Pte. Ltd. 7,716 6,473 \r\nAmounts receivable from Awilco Rig 1 Pte. Ltd. 78,481 57,343 \r\nAmounts receivable from Awilco Rig 2 Pte. Ltd. 49,689 44,298 \r\nAmounts receivable from Awilco Drilling Norge AS - 13,394 \r\n214,317 208,082 \r\nAllowance for expected credit loss \r\n(214,317) (192,837) \r\n- 15,245 \r\nThe balances receivable from the subsidiary companies are considered long term. There are long term loan \r\nagreements in place with Awilco Drilling Pte. Ltd, Awilco Rig 1 Pte. Ltd. and Awilco Rig 2 Pte. Ltd. \r\nSet out below is the movement in the allowance for expected credit losses of intercompany receivables: \r\n2022 2021 \r\nUS$000 US$000 \r\nAs at 1 January (192,837) (115,010) \r\nProvision for expected credit loss (21,480) (71,199) \r\nAs at 31 December (214,317) (192,837) \r\nExpected credit loss is due to making a full provision for amounts due from Awilco Drilling Offshore (UK) \r\nLimited, Awilco Drilling Pte. Ltd, Awilco Rig 1 Pte. Ltd. and Awilco Rig 2 Pte. Ltd. ","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of allowance for credit losses [text block]","Documentation":"The disclosure of the allowance relating to impairments of financial assets due to credit losses. [Refer: Financial assets]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114738,"FileId":8839,"Sequence":193,"PageIdentifier":"566702fa-8eda-4b6e-a2b7-b4b88b69c92a","ElementIdentifier":"8ef78bdc-a70b-496a-b7fc-ed6a5767772b","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForTradeAndOtherReceivablesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Trade and other receivables Trade receivables and amounts due from subsidiary undertakings, which generally have 60-day terms, are \r\nrecognised and subsequently carried at the original invoiced value net of expected credit loss. Where the \r\ntime value of money is material, receivables are carried at amortised cost. During the current and prior \r\nyears, these balances have been immaterial.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for trade and other receivables [text block]","Documentation":"The description of the entity's accounting policy for trade and other receivables. [Refer: Trade and other receivables]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114739,"FileId":8839,"Sequence":194,"PageIdentifier":"3e36bd6e-4e57-4160-b1b5-42a951a11169","ElementIdentifier":"062f6114-5b8f-4492-97d1-ddd5755cefab","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForTradeAndOtherPayablesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Trade and other payables Trade payables are recognised initially at fair value and subsequently measured at amortised cost using the \r\neffective interest method.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for trade and other payables [text block]","Documentation":"The description of the entity's accounting policy for trade and other payables. [Refer: Trade and other payables]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114740,"FileId":8839,"Sequence":195,"PageIdentifier":"3e36bd6e-4e57-4160-b1b5-42a951a11169","ElementIdentifier":"bf198d7c-7f91-4140-a0cd-52ec2008f5d8","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForDerecognitionOfFinancialInstrumentsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Derecognition of financial liabilities A financial liability is derecognised when the obligation under the liability is discharged or cancelled or \r\nexpires. Where an existing financial liability is replaced by another from the same lender on substantially \r\ndifferent terms, or the terms of an existing liability are substantially modified, such an exchange or \r\nmodification is treated as a derecognition of the original liability and the recognition of a new liability, and \r\nthe difference in the respective carrying amounts is recognised in the statement of comprehensive income.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for derecognition of financial instruments [text block]","Documentation":"The description of the entity's accounting policy for the derecognition of financial instruments. [Refer: Financial instruments, class [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114741,"FileId":8839,"Sequence":196,"PageIdentifier":"3e36bd6e-4e57-4160-b1b5-42a951a11169","ElementIdentifier":"0996fb82-7e32-424b-9405-65cb23ece140","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForSharebasedPaymentTransactionsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Share-based payment The cost of cash-settled transactions is measured initially at fair value at the grant date using a Black-Scholes \r\nmodel, further details are given in Note 26. This fair value is expensed over the period until the vesting date \r\nwith recognition of a corresponding liability. The liability is remeasured to fair value at each reporting date \r\nup to and including the settlement date, with changes in fair value recognised in statement of comprehensive \r\nincome for the period.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for share-based payment transactions [text block]","Documentation":"The description of the entity's accounting policy for transactions in which the entity: (a) receives goods or services from the supplier of those goods or services (including an employee) in a share-based payment arrangement; or (b) incurs an obligation to settle the transaction with the supplier in a share-based payment arrangement when another group entity receives those goods or services. [Refer: Share-based payment arrangements [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114742,"FileId":8839,"Sequence":197,"PageIdentifier":"3e36bd6e-4e57-4160-b1b5-42a951a11169","ElementIdentifier":"814ac1a8-29c2-422a-952b-8c42e0326db9","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForEmployeeBenefitsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"PensionThe pension plan in place is a defined contribution plan. Pension contributions are charged to the statement \r\nof comprehensive income as an expense in the period to which the contributions relate. Once the \r\ncontributions have been paid, there are no further payment obligations.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for employee benefits [text block]","Documentation":"The description of the entity's accounting policy for employee benefits. Employee benefits are all forms of consideration given by an entity in exchange for services rendered by employees or for the termination of employment.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114743,"FileId":8839,"Sequence":198,"PageIdentifier":"3e36bd6e-4e57-4160-b1b5-42a951a11169","ElementIdentifier":"aefce503-c244-49d5-b29e-d6c76a853e71","ElementType":2,"TagName":"ifrs-full:DescriptionOfAccountingPolicyForGovernmentGrants","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Government grants Government grants are recognised where there is reasonable assurance that the grant will be received, and \r\nall attached conditions will be complied with. When the grant relates to an expense item, it is recognised as \r\na deduction in reporting of the related expense, on a systematic basis over the periods that the related costs for which it is intended to compensate are expensed.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Description of accounting policy for government grants [text block]","Documentation":"The description of the entity's accounting policy for government grants, including the methods of presentation adopted in the financial statements. [Refer: Government [member]; Government grants]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114744,"FileId":8839,"Sequence":199,"PageIdentifier":"3e36bd6e-4e57-4160-b1b5-42a951a11169","ElementIdentifier":"04017373-6fb4-434b-9e4c-411e76ad1e32","ElementType":2,"TagName":"ifrs-full:DisclosureOfRevenueExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"5. Revenue Revenue represents the invoiced amount of services provided after the deduction of rebates and retrospective \r\ndiscounts. All items are stated net of value added tax. \r\nThe Group only had one segment &#8211; providing drilling services in the UK. As a result, no further segmental \r\ninformation has been provided. \r\nInformation about major customers \r\nThere was no revenue arising during the year from the provision of drilling services (2021: US$ 25 million \r\nand US$ 8 million from two major customers).","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of revenue [text block]","Documentation":"The entire disclosure for revenue.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114745,"FileId":8839,"Sequence":200,"PageIdentifier":"3e36bd6e-4e57-4160-b1b5-42a951a11169","ElementIdentifier":"9ff0d7ad-7246-480b-bb76-107c10649698","ElementType":2,"TagName":"ifrs-full:DisclosureOfRevenueFromContractsWithCustomersExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Information about major customers There was no revenue arising during the year from the provision of drilling services (2021: US$ 25 million and US$ 8 million from two major customers).","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of revenue from contracts with customers [text block]","Documentation":"The entire disclosure for revenue from contracts with customers.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114746,"FileId":8839,"Sequence":201,"PageIdentifier":"3e36bd6e-4e57-4160-b1b5-42a951a11169","ElementIdentifier":"f165b510-8996-4baa-8369-3174bc243475","ElementType":2,"TagName":"ifrs-full:DisclosureOfProfitLossFromOperatingActivitiesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"6. Operating loss This is stated after charging \r\n2022 2021 \r\nUS$000 US$000 \r\nDepreciation (Note 16, 23) 419 6,241 \r\nLegal and other arbitration costs &#8211; included in G&amp;A expense 15,069 5,544 \r\nInventory recognised as an expense during the year \r\n- 255 \r\nWrite off of inventory -  3,026","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of profit (loss) from operating activities [text block]","Documentation":"The disclosure of profit (loss) from operating activities. [Refer: Profit (loss) from operating activities]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114747,"FileId":8839,"Sequence":202,"PageIdentifier":"339c3d5f-11e1-4e29-acf5-4d6f4dc7582b","ElementIdentifier":"8feabd33-7ae4-4e28-b9c5-e5c164573365","ElementType":2,"TagName":"ifrs-full:DisclosureOfOtherOperatingExpenseExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"7. Other expense As noted in the Strategic report, during April 2023, Awilco Rig 1 Pte Ltd received the arbitration tribunal&#8217;s \r\nruling was awarded in favour of Keppel FELS. This is considered an adjusting post balance sheet event \r\ntherefore the below costs have been recognised. The arbitration panel is still to determine the final amounts \r\nfor the interest and legal fees. \r\n2022 2021 \r\nUS$000 US$000 \r\nTribunal award 98,522 - \r\nInterest on award 14,768 - \r\nProvision for legal fees (Note 22) 9,278 - \r\n122,568  -","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of other operating expense [text block]","Documentation":"The disclosure of other operating expense. [Refer: Other operating income (expense)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114748,"FileId":8839,"Sequence":203,"PageIdentifier":"339c3d5f-11e1-4e29-acf5-4d6f4dc7582b","ElementIdentifier":"b7955d4c-917a-4553-a3d7-c1ae30dedd81","ElementType":2,"TagName":"ifrs-full:DisclosureOfAuditorsRemunerationExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"8.Auditors&#8217; remuneration \r\nThe Group paid the following amounts to its auditors in respect of the audit of the financial statements and \r\nfor other services provided to the Group. \r\n2022 2021 \r\nUS$000 US$000 \r\nAudit of the financial statements 246 246 \r\nLocal statutory audits of subsidiaries 19 23 \r\nTax services - compliance 34 27 \r\n299  296","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of auditors' remuneration [text block]","Documentation":"The disclosure of compensation to the entity's auditors.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114749,"FileId":8839,"Sequence":204,"PageIdentifier":"339c3d5f-11e1-4e29-acf5-4d6f4dc7582b","ElementIdentifier":"1882e86c-999a-4549-b019-bf8c1057e40c","ElementType":2,"TagName":"ifrs-full:DisclosureOfEmployeeBenefitsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"9.Staff costs \r\n2022 2022 2021 2021 \r\nGroup \r\nUS$000 \r\nCompany \r\nUS$000 \r\nGroup \r\nUS$000 \r\nCompany \r\nUS$000 \r\nWages and salaries 5,001 2,314 14,608 2,555 \r\nDirectors Fees 216 216 277 277 \r\nPension costs 181 86 649 120 \r\nSocial security costs 640 346 1,877 457 \r\nLong term incentive plan - - (19) (19) \r\n6,038 2,962 17,393 3,391 \r\nThe Company makes contributions to a defined contribution scheme for all eligible employees up to a \r\nmaximum of 9% of salary. Contributions are charged to the income statement as incurred. \r\nThe average monthly number of employees during the year was made up as follows: \r\n2022 2021 \r\nNo. No. \r\nOnshore, including management (Company) 14 22 \r\nOffshore 24 96 \r\n38  118","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of employee benefits [text block]","Documentation":"The entire disclosure for employee benefits.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114750,"FileId":8839,"Sequence":205,"PageIdentifier":"339c3d5f-11e1-4e29-acf5-4d6f4dc7582b","ElementIdentifier":"a9554dca-223e-478e-b149-9fecc3e8c2b8","ElementType":2,"TagName":"ifrs-full:DisclosureOfInformationAboutEmployeesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"The average monthly number of employees during the year was made up as follows: 2022 2021 \r\nNo. No. \r\nOnshore, including management (Company) 14 22 \r\nOffshore 24 96 \r\n38  118","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of information about employees [text block]","Documentation":"The disclosure of information about employees.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114751,"FileId":8839,"Sequence":206,"PageIdentifier":"10cbcadc-2185-4832-80ea-dda3f0e9e509","ElementIdentifier":"eec5ac7e-819d-4bd2-bd42-8a6d38a5eb57","ElementType":2,"TagName":"ifrs-full:DisclosureOfFinanceIncomeExpenseExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"10. Finance income  20222021 \r\nUS$000 US$000 \r\nBank interest 53  -\r\n11. Finance expense \r\n 20222021 \r\nUS$000 US$000 \r\nInterest on lease liabilities 124 53 \r\nInterest on loans 44 - \r\nInterest on taxation - 1,388 \r\n168  1,441","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of finance income (cost) [text block]","Documentation":"The disclosure of finance income (cost). [Refer: Finance income (cost)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114752,"FileId":8839,"Sequence":207,"PageIdentifier":"10cbcadc-2185-4832-80ea-dda3f0e9e509","ElementIdentifier":"42bf46c1-e9b7-41b5-b8be-ddfb705bc810","ElementType":2,"TagName":"ifrs-full:DisclosureOfFinanceIncomeExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"10. Finance income  20222021 \r\nUS$000 US$000 \r\nBank interest 53  -","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of finance income [text block]","Documentation":"The disclosure of finance income. [Refer: Finance income]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114753,"FileId":8839,"Sequence":208,"PageIdentifier":"10cbcadc-2185-4832-80ea-dda3f0e9e509","ElementIdentifier":"d7d2d366-a5f1-4168-b948-d1e2b17160ee","ElementType":2,"TagName":"ifrs-full:DisclosureOfInterestIncomeExpenseExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":" 20222021 \r\nUS$000 US$000 \r\nBank interest 53  - 20222021 \r\nUS$000 US$000 \r\nInterest on lease liabilities 124 53 \r\nInterest on loans 44 - \r\nInterest on taxation - 1,388 \r\n168  1,441","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of interest income (expense) [text block]","Documentation":"The disclosure of interest income and expense. [Refer: Interest income (expense)]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114754,"FileId":8839,"Sequence":209,"PageIdentifier":"10cbcadc-2185-4832-80ea-dda3f0e9e509","ElementIdentifier":"a8fba89d-92c3-4c4d-9db6-d3241eb3487b","ElementType":2,"TagName":"ifrs-full:DisclosureOfInterestIncomeExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"20222021 \r\nUS$000 US$000 \r\nBank interest 53  -","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of interest income [text block]","Documentation":"The disclosure of interest income. [Refer: Interest income]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114755,"FileId":8839,"Sequence":210,"PageIdentifier":"10cbcadc-2185-4832-80ea-dda3f0e9e509","ElementIdentifier":"53120574-99d1-4073-8e63-56a175dcfc90","ElementType":2,"TagName":"ifrs-full:DisclosureOfFinanceCostExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"11. Finance expense  20222021 \r\nUS$000 US$000 \r\nInterest on lease liabilities 124 53 \r\nInterest on loans 44 - \r\nInterest on taxation - 1,388 \r\n168  1,441","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of finance cost [text block]","Documentation":"The disclosure of finance cost. [Refer: Finance costs]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114756,"FileId":8839,"Sequence":211,"PageIdentifier":"10cbcadc-2185-4832-80ea-dda3f0e9e509","ElementIdentifier":"51f8f78a-2164-4c51-af33-fb01429e2626","ElementType":2,"TagName":"ifrs-full:DisclosureOfInterestExpenseExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"20222021 \r\nUS$000 US$000 \r\nInterest on lease liabilities 124 53 \r\nInterest on loans 44 - \r\nInterest on taxation - 1,388 \r\n168  1,441","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of interest expense [text block]","Documentation":"The disclosure of interest expense. [Refer: Interest expense]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114757,"FileId":8839,"Sequence":212,"PageIdentifier":"10cbcadc-2185-4832-80ea-dda3f0e9e509","ElementIdentifier":"62284f97-b793-4755-9925-a50d7d4f4f61","ElementType":2,"TagName":"ifrs-full:DisclosureOfEffectOfChangesInForeignExchangeRatesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"12. Net (loss)/gain on foreign exchange transactions 2022 2021 \r\nUS$000 US$000 \r\nGain on foreign exchange transactions 21 14 \r\n(Loss) on foreign exchange transactions (140) (268) \r\nNet (loss) on foreign exchange transactions (119)  (254)","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of effect of changes in foreign exchange rates [text block]","Documentation":"The entire disclosure for the effect of changes in foreign exchange rates.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114730,"FileId":8839,"Sequence":213,"PageIdentifier":"10cbcadc-2185-4832-80ea-dda3f0e9e509","ElementIdentifier":"d5127aab-09f0-428d-b15d-52b1bbe493de","ElementType":2,"TagName":"ifrs-full:DisclosureOfIncomeTaxExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"13.Income tax \r\nIncome tax on profit on ordinary activities \r\n 20222021 \r\nUS$000 US$000 \r\nForeign tax on the loss for the year 21 98 \r\nTotal current income tax 21 98 \r\nAmounts under provided in previous years - 9,152 \r\nTax credit available to the UK - - \r\nTotal current income tax 21 9,250 \r\nDeferred income tax: \r\nOrigination and reversal of temporary differences - 16 \r\nImpact of changes in tax rates - - \r\nTotal deferred income tax - 16 \r\nIncome tax charge in the Group statement of comprehensive income 21 9,266  \r\n \r\n \r\n \r\n  \r\nReconciliation of the total income tax charge \r\n2022 2021 \r\nUS$000 US$000 \r\nLoss from continuing operations (145,336) (62,963) \r\nTax calculated at UK standard rate of corporation tax of 19% (2021:19%) (27,614) (11,963) \r\nExpenses not deductible/(income not taxable) for tax purposes (27) 112 \r\nEffect of (lower)/higher taxes on overseas earnings 21 98 \r\nUnrecognised deferred tax asset 28,247 11,867 \r\nTax (over)/under provided in previous years - 9,152 \r\nDisposal of assets (606) - \r\nIncome tax charge in the Group statement of comprehensive income 21 9,266 \r\nThe income tax expense above is computed at loss before taxation multiplied by the effective rate of \r\ncorporation tax in the UK of 19% (2021: 19%). \r\nThe corporate tax measures announced in the March 2021 Budget set out that corporation tax will increase \r\nfrom 19% to 25% from April 2023. \r\nDeferred income tax \r\nThe deferred income tax included in the statement of financial position is as follows: \r\n2022 2021 \r\nUS$000 US$000 \r\nDeferred tax asset \r\nAs at 1 January - 16 \r\nShare-based payment \r\n- (16) \r\nAs at 31 December - - \r\nUnrecognised deductible temporary differences \r\nThe Group has total tax losses of US$ 241.1 million which arose in the UK (2021: US$ 82.1 million) that \r\nare available for offset against future deductible profits that are not part of the bareboat charter ring-fence \r\narrangements. Following the disposal of the rigs during the year, there are no longer deductible temporary \r\ndifferences relating to fixed assets (2021: US$ 59.4 million) or unutilised capital allowances. (2021: US$ \r\n40.6 million). Deferred tax assets have not been recognised in respect of these losses due to the uncertainty \r\nof future profits being at this level.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of income tax [text block]","Documentation":"The entire disclosure for income taxes.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114758,"FileId":8839,"Sequence":214,"PageIdentifier":"10cbcadc-2185-4832-80ea-dda3f0e9e509","ElementIdentifier":"b4f474af-5a26-4917-b34d-1f6c65b0586a","ElementType":2,"TagName":"ifrs-full:DisclosureOfDeferredTaxesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"20222021 \r\nUS$000 US$000 \r\nForeign tax on the loss for the year 21 98 \r\nTotal current income tax 21 98 \r\nAmounts under provided in previous years - 9,152 \r\nTax credit available to the UK - - \r\nTotal current income tax 21 9,250 \r\nDeferred income tax: \r\nOrigination and reversal of temporary differences - 16 \r\nImpact of changes in tax rates - - \r\nTotal deferred income tax - 16 \r\nIncome tax charge in the Group statement of comprehensive income 21 9,266  \r\n \r\n \r\n \r\n  \r\nReconciliation of the total income tax charge \r\n2022 2021 \r\nUS$000 US$000 \r\nLoss from continuing operations (145,336) (62,963) \r\nTax calculated at UK standard rate of corporation tax of 19% (2021:19%) (27,614) (11,963) \r\nExpenses not deductible/(income not taxable) for tax purposes (27) 112 \r\nEffect of (lower)/higher taxes on overseas earnings 21 98 \r\nUnrecognised deferred tax asset 28,247 11,867 \r\nTax (over)/under provided in previous years - 9,152 \r\nDisposal of assets (606) - \r\nIncome tax charge in the Group statement of comprehensive income 21 9,266 \r\nThe income tax expense above is computed at loss before taxation multiplied by the effective rate of \r\ncorporation tax in the UK of 19% (2021: 19%). \r\nThe corporate tax measures announced in the March 2021 Budget set out that corporation tax will increase \r\nfrom 19% to 25% from April 2023. \r\nDeferred income tax \r\nThe deferred income tax included in the statement of financial position is as follows: \r\n2022 2021 \r\nUS$000 US$000 \r\nDeferred tax asset \r\nAs at 1 January - 16 \r\nShare-based payment \r\n- (16) \r\nAs at 31 December - - \r\nUnrecognised deductible temporary differences \r\nThe Group has total tax losses of US$ 241.1 million which arose in the UK (2021: US$ 82.1 million) that \r\nare available for offset against future deductible profits that are not part of the bareboat charter ring-fence \r\narrangements. Following the disposal of the rigs during the year, there are no longer deductible temporary \r\ndifferences relating to fixed assets (2021: US$ 59.4 million) or unutilised capital allowances. (2021: US$ \r\n40.6 million). Deferred tax assets have not been recognised in respect of these losses due to the uncertainty \r\nof future profits being at this level.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of deferred taxes [text block]","Documentation":"The disclosure of deferred taxes. [Refer: Deferred tax liabilities; Deferred tax assets]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114729,"FileId":8839,"Sequence":215,"PageIdentifier":"5d9aa78b-2ca7-4fc2-b69c-43dc78e717c9","ElementIdentifier":"f3a00c12-e086-4b6d-9a48-e6eda857d772","ElementType":2,"TagName":"ifrs-full:DisclosureOfEarningsPerShareExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"14. Loss per share The following reflects the income and share data used in the basic and diluted loss per share computations: \r\n2022 2021 \r\nUS$000 US$000 \r\nLoss for the year attributable to equity share holders (145,356) (72,229) \r\nRestated \r\n2022 2021 \r\nNo.000 No.000 \r\nWeighted average number of ordinary shares for basic and diluted earnings \r\nper share 637 546 \r\nTotal earnings and weighted average number of shares outstanding during the year are the same as for diluted \r\nearnings per share. On 20 December 2022, a 100 : 1 reverse share split was performed (see also Note 24) \r\nwhich resulted in the prior year weighted average number of ordinary shares being retrospectively restated.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of earnings per share [text block]","Documentation":"The entire disclosure for earnings per share.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114727,"FileId":8839,"Sequence":216,"PageIdentifier":"5d9aa78b-2ca7-4fc2-b69c-43dc78e717c9","ElementIdentifier":"6b0958f1-7dde-4b11-b029-f3e7b5347c4e","ElementType":2,"TagName":"ifrs-full:DisclosureOfGovernmentGrantsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"15. Government grants 2022 2021 \r\nUS$000 US$000 \r\nAt 1 January \r\n- - \r\nReceived during the year - 14 \r\nReleased to the statement of profit or loss \r\n- (14) \r\nAt 31 December - - \r\nThe above Government grants received were in respect of the UK Coronavirus Job Retention Scheme.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of government grants [text block]","Documentation":"The entire disclosure for government grants.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114700,"FileId":8839,"Sequence":217,"PageIdentifier":"c4388735-14b3-42fa-a9b4-a6ea4a2b5add","ElementIdentifier":"7f58ecb1-31a9-49f9-a61b-103de662c7f8","ElementType":2,"TagName":"ifrs-full:DisclosureOfPropertyPlantAndEquipmentExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"16. Property, plant and equipment Group \r\nSemi- \r\nsubmersible \r\ndrilling rigs \r\nAssets under \r\nconstruction \r\nSpecial \r\npurpose \r\nsurveys \r\nOther \r\nfixtures and \r\nequipment Total \r\nUS$000 US$000 US$000 US$000 US$000 \r\nCost: \r\nAt 1 January 2021 337,652 111,280 16,159 2,017 467,108 \r\nAdjustment 247 - (247) - - \r\nAdditions 722 - 1,507 - 2,229 \r\nAt 31 December 2021 338,621 111,280 17,419 2,017 469,337 \r\nAdditions - - 205 - 205 \r\nDisposals (338,621) - (17,419) - (356,040) \r\nAt 31 December 2022 - 111,280 205 2,017 113,502 \r\nDepreciation and impairment: \r\nAt 1 January 2021 (272,897) (111,280) (14,603) (1,528) (400,308) \r\nAdjustment (578) 578 - \r\nProvided (4,295) - (1,555) (70) (5,920) \r\nImpairment (45,507) - (1,839) - (47,346) \r\nAt 31 December 2021 (323,277) (111,280) (17,419) (1,598) (453,574) \r\nProvided - - - (419) (419) \r\nImpairment - - (205) - (205) \r\nDisposals 323,277 - 17,419 - 340,696 \r\nAt 31 December 2022 - (111,280) (205) (2,017) (113,502) \r\nNet book value: \r\nAt 31 December 2022 - - - - - \r\nAt 31 December 2021 15,345 - - 419 15,764  \r\n \r\n \r\n \r\n  \r\nCompany \r\nOther \r\nfixtures and \r\nequipment \r\nUS$000 \r\nCost: \r\nAt 1 January 2021 2,017 \r\nAdditions - \r\nDisposals - \r\nAt 31 December 2021 2,017 \r\nAdditions - \r\nDisposals - \r\nAt 31 December 2022 2,017 \r\nDepreciation: \r\nAt 1 January 2021 (1528) \r\nProvided (70) \r\nAt 31 December 2021 (1,598) \r\nProvided (419) \r\nAt 31 December 2022 (2,017) \r\nNet book value: \r\nAt 31 December 2022 - \r\nAt 31 December 2021  419","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of property, plant and equipment [text block]","Documentation":"The entire disclosure for property, plant and equipment.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114701,"FileId":8839,"Sequence":218,"PageIdentifier":"c4388735-14b3-42fa-a9b4-a6ea4a2b5add","ElementIdentifier":"7c56b33b-033b-4878-8355-594bbe40b784","ElementType":2,"TagName":"ifrs-full:DisclosureOfDepreciationAndAmortisationExpenseExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Group \r\nSemi- \r\nsubmersible \r\ndrilling rigs \r\nAssets under \r\nconstruction \r\nSpecial \r\npurpose \r\nsurveys \r\nOther \r\nfixtures and \r\nequipment Total \r\nUS$000 US$000 US$000 US$000 US$000 \r\nCost: \r\nAt 1 January 2021 337,652 111,280 16,159 2,017 467,108 \r\nAdjustment 247 - (247) - - \r\nAdditions 722 - 1,507 - 2,229 \r\nAt 31 December 2021 338,621 111,280 17,419 2,017 469,337 \r\nAdditions - - 205 - 205 \r\nDisposals (338,621) - (17,419) - (356,040) \r\nAt 31 December 2022 - 111,280 205 2,017 113,502 \r\nDepreciation and impairment: \r\nAt 1 January 2021 (272,897) (111,280) (14,603) (1,528) (400,308) \r\nAdjustment (578) 578 - \r\nProvided (4,295) - (1,555) (70) (5,920) \r\nImpairment (45,507) - (1,839) - (47,346) \r\nAt 31 December 2021 (323,277) (111,280) (17,419) (1,598) (453,574) \r\nProvided - - - (419) (419) \r\nImpairment - - (205) - (205) \r\nDisposals 323,277 - 17,419 - 340,696 \r\nAt 31 December 2022 - (111,280) (205) (2,017) (113,502) \r\nNet book value: \r\nAt 31 December 2022 - - - - - \r\nAt 31 December 2021 15,345 - - 419 15,764 Company \r\nOther \r\nfixtures and \r\nequipment \r\nUS$000 \r\nCost: \r\nAt 1 January 2021 2,017 \r\nAdditions - \r\nDisposals - \r\nAt 31 December 2021 2,017 \r\nAdditions - \r\nDisposals - \r\nAt 31 December 2022 2,017 \r\nDepreciation: \r\nAt 1 January 2021 (1528) \r\nProvided (70) \r\nAt 31 December 2021 (1,598) \r\nProvided (419) \r\nAt 31 December 2022 (2,017) \r\nNet book value: \r\nAt 31 December 2022 - \r\nAt 31 December 2021  419Office Building Office Building \r\nGroup Company Group Company \r\n2022 2022 2021 2021 \r\nUS$000 US$000 US$000 US$000 \r\nAs at 1 January - - 1,096 1,096 \r\nDepreciation Expense - - (321) (321) \r\nImpairment - - (775) (775) \r\nAs at 31 December - - - - 2022 2022 2021 2021 \r\nGroup Company Group Company \r\nUS$000 US$000 US$000 US$000 \r\nDepreciation expense of right-of-use assets - - 321 321 \r\nInterest expense on lease liabilities 124 124 53 41 \r\nExpense relating to leases of low-value assets (included in \r\nadministrative expenses) 5 5 3 3 \r\nTotal amount recognised in profit or loss 129 129 377 365 ","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of depreciation and amortisation expense [text block]","Documentation":"The disclosure of depreciation and amortisation expense. [Refer: Depreciation and amortisation expense]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114702,"FileId":8839,"Sequence":219,"PageIdentifier":"8ed72ea9-8635-4d7e-8af7-95449c1e5280","ElementIdentifier":"cb40c3b2-c858-47a1-903d-91780204945b","ElementType":2,"TagName":"ifrs-full:DisclosureOfImpairmentOfAssetsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"17. Impairment The Group considered annually whether there were indicators of impairment of its property, plant and \r\nequipment, and at the prior year-end identified that there were indicators the WilPhoenix rig was impaired. \r\nIn particular it was noted that there was no secured work for the rig, additional costs were expected to be \r\nneeded to maintain the rig and the Group was contemplating disposing of the asset. As such, it was necessary \r\nto estimate the recoverable amount. Recoverable amount was assessed based on the rig&#8217;s fair value less cost \r\nof disposal. \r\nPost year end, a sale of the rig was agreed, and therefore the agreed sale price was used as the basis for \r\ndetermining the fair value less cost of disposal of the rig. As a result, the Group recognised US$ 47.3 million \r\nas an impairment loss relating to the WilPhoenix rig in the prior year. \r\nDuring the current year, an impairment of US$ 0.2 million was recognised.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of impairment of assets [text block]","Documentation":"The entire disclosure for the impairment of assets.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114703,"FileId":8839,"Sequence":220,"PageIdentifier":"08656a83-edf7-4ce3-aa09-229e31365ffa","ElementIdentifier":"edd20fb1-de2c-475e-8b4d-28f847a7f750","ElementType":2,"TagName":"ifrs-full:DisclosureOfInvestmentsAccountedForUsingEquityMethodExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"18. Investments Company Company \r\n2022 2021 \r\nUS$000 US$000 \r\nCompany shares in subsidiary undertakings \r\nAt 1 January 75 279 \r\nImpairment of investment in WilHunter (UK) Limited - (100) \r\nImpairment of investment in Awilco Drilling Offshore (UK) Limited - (100) \r\nImpairment of investment in Awilco Drilling Norge AS - (4) \r\nImpairment of investment in Awilco Drilling Pte Ltd (75) - \r\nAt 31 December - 75 \r\nDetails of the holdings are as follows, all 100% shareholdings: \r\nCountry of \r\nIncorporation Registered Address Name \r\nAwilco Drilling Offshore (UK) Limited United Kingdom \r\nSuite 1, 7 \r\nth \r\nFloor, 50 \r\nBroadway, London \r\nWilHunter (UK) Limited &#8211; in liquidation United Kingdom \r\nSuite 1, 7 \r\nth \r\nFloor, 50 \r\nBroadway, London \r\nAwilco Drilling Pte. Ltd. Singapore 8 Wilkie Road, Singapore \r\nAwilco Rig 1 Pte. Ltd. Singapore 8 Wilkie Road, Singapore \r\nAwilco Rig 2 Pte. Ltd. Singapore 8 Wilkie Road, Singapore","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of investments accounted for using equity method [text block]","Documentation":"The disclosure of investments accounted for using the equity method. [Refer: Investments accounted for using equity method]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114704,"FileId":8839,"Sequence":221,"PageIdentifier":"08656a83-edf7-4ce3-aa09-229e31365ffa","ElementIdentifier":"8aa8522b-64f6-4efb-90db-9520aec56674","ElementType":2,"TagName":"ifrs-full:DisclosureOfSignificantInvestmentsInSubsidiariesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Company Company \r\n2022 2021 \r\nUS$000 US$000 \r\nCompany shares in subsidiary undertakings \r\nAt 1 January 75 279 \r\nImpairment of investment in WilHunter (UK) Limited - (100) \r\nImpairment of investment in Awilco Drilling Offshore (UK) Limited - (100) \r\nImpairment of investment in Awilco Drilling Norge AS - (4) \r\nImpairment of investment in Awilco Drilling Pte Ltd (75) - \r\nAt 31 December - 75 \r\nDetails of the holdings are as follows, all 100% shareholdings: \r\nCountry of \r\nIncorporation Registered Address Name \r\nAwilco Drilling Offshore (UK) Limited United Kingdom \r\nSuite 1, 7 \r\nth \r\nFloor, 50 \r\nBroadway, London \r\nWilHunter (UK) Limited &#8211; in liquidation United Kingdom \r\nSuite 1, 7 \r\nth \r\nFloor, 50 \r\nBroadway, London \r\nAwilco Drilling Pte. Ltd. Singapore 8 Wilkie Road, Singapore \r\nAwilco Rig 1 Pte. Ltd. Singapore 8 Wilkie Road, Singapore \r\nAwilco Rig 2 Pte. Ltd. Singapore 8 Wilkie Road, Singapore The Company entered into the following transactions and had the following balances with its wholly \r\nowned subsidiaries \r\n2022 2021 \r\nUS$000 US$000 \r\nTransactions: \r\nAmounts invoiced to Awilco Drilling Offshore (UK) Limited in respect of \r\nservices provided to the company 11,782 32,804 \r\nAmounts invoiced on behalf of Awilco Drilling Offshore (UK) Limited (20,025) (36,384) \r\nInvoiced to Awilco Drilling Pte. Ltd. 541 127 \r\nTransfer of funds to Awilco Drilling Pte. Ltd. 604 299 \r\nAmounts invoiced to Awilco Rig 1 Pte. Ltd. in respect of services provided \r\nto the company 21,138 - \r\nAmounts invoiced to Awilco Rig 2 Pte. Ltd. in respect of services provided \r\nto the company 5,391 - \r\nAmounts invoiced to Awilco Drilling Norge AS in respect of services \r\nprovided to the company 18 3,431 \r\nSettlement of balance due from Awilco Drilling Norge AS (13,412) - \r\nTaxation paid on behalf of subsidiaries 98 68 \r\nTransfer of share capital funds due to WilHunter (UK) Limited 100 20222021 \r\nBalances: US$000 US$000 \r\nAmounts receivable from Awilco Drilling Offshore (UK) Limited 78,431 86,674 \r\nAmounts payable to WilHunter (UK) Limited - (100) \r\nAmounts receivable from Awilco Drilling Pte. Ltd. 7,716 6,473 \r\nAmounts receivable from Awilco Rig 1 Pte. Ltd. 78,481 57,343 \r\nAmounts receivable from Awilco Rig 2 Pte. Ltd. 49,689 44,298 \r\nAmounts receivable from Awilco Drilling Norge AS - 13,394 \r\n214,317 208,082 \r\nAllowance for expected credit loss \r\n(214,317) (192,837) \r\n- 15,245 \r\nThe balances receivable from the subsidiary companies are considered long term. There are long term loan \r\nagreements in place with Awilco Drilling Pte. Ltd, Awilco Rig 1 Pte. Ltd. and Awilco Rig 2 Pte. Ltd. \r\nSet out below is the movement in the allowance for expected credit losses of intercompany receivables: \r\n2022 2021 \r\nUS$000 US$000 \r\nAs at 1 January (192,837) (115,010) \r\nProvision for expected credit loss (21,480) (71,199) \r\nAs at 31 December (214,317) (192,837) \r\nExpected credit loss is due to making a full provision for amounts due from Awilco Drilling Offshore (UK) \r\nLimited, Awilco Drilling Pte. Ltd, Awilco Rig 1 Pte. Ltd. and Awilco Rig 2 Pte. Ltd. \r\nEntity with significant influence over the Group \r\nAwilhelmsen Offshore AS, owns 50.5% of the ordinary shares in Awilco Drilling PLC. ","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of subsidiaries [text block]","Documentation":"The disclosure of subsidiaries. [Refer: Subsidiaries [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114705,"FileId":8839,"Sequence":222,"PageIdentifier":"e070e7a0-1aaf-4b98-aebc-e07497f0fd06","ElementIdentifier":"da204823-d7be-473e-b81a-08b3c9507cc6","ElementType":2,"TagName":"ifrs-full:DisclosureOfTradeAndOtherReceivablesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"19. Trade and other receivables  GroupCompany Group Company \r\n2022 2022 2021 2021 \r\nUS$000 US$000 US$000 US$000 \r\nTrade receivables 3 3 37 37 \r\nPrepayments and other receivables (1) 2,598 2,598 542 236 \r\nAccrued interest - - - 1,949 \r\nVAT receivable 34 34 83 83 \r\n2,635 2,635 662  2,305\r\n(1) Included in the balance sheet at 31 December 2022 is a guarantee of GBP 2 million provided to SEPA in \r\nconnection with the WilHunter rig recycling process. This was subsequently settled post year end. \r\nAs at 31 December 2022 and 2021, all trade receivables in the Group and Company are neither past due nor \r\n impaired.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of trade and other receivables [text block]","Documentation":"The disclosure of trade and other receivables. [Refer: Trade and other receivables]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114706,"FileId":8839,"Sequence":223,"PageIdentifier":"e070e7a0-1aaf-4b98-aebc-e07497f0fd06","ElementIdentifier":"d4d727f6-236b-4157-b62d-52bf68ac4b06","ElementType":2,"TagName":"ifrs-full:DisclosureOfPrepaymentsAndOtherAssetsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"GroupCompany Group Company \r\n2022 2022 2021 2021 \r\nUS$000 US$000 US$000 US$000 \r\nTrade receivables 3 3 37 37 \r\nPrepayments and other receivables (1) 2,598 2,598 542 236 \r\nAccrued interest - - - 1,949 \r\nVAT receivable 34 34 83 83 \r\n2,635 2,635 662  2,305","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of prepayments and other assets [text block]","Documentation":"The disclosure of prepayments and other assets. [Refer: Other assets; Prepayments]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114707,"FileId":8839,"Sequence":224,"PageIdentifier":"e070e7a0-1aaf-4b98-aebc-e07497f0fd06","ElementIdentifier":"8e36528d-61ca-4c9f-8974-828fee560cc2","ElementType":2,"TagName":"ifrs-full:DisclosureOfCashAndCashEquivalentsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"20. Cash and cash equivalents  GroupCompany Group Company \r\n2022 2022 2021 2021 \r\nUS$000 US$000 US$000 US$000 \r\nCash at bank 8,880 8,539 9,685 9,346 \r\nCash at bank earns interest at floating rates based on daily bank deposit rates. The Company has no restricted \r\ncash. (2021: nil)","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of cash and cash equivalents [text block]","Documentation":"The disclosure of cash and cash equivalents. [Refer: Cash and cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114708,"FileId":8839,"Sequence":225,"PageIdentifier":"e070e7a0-1aaf-4b98-aebc-e07497f0fd06","ElementIdentifier":"4bd3727f-9702-49d2-8c84-9b35fec7c536","ElementType":2,"TagName":"ifrs-full:DisclosureOfDepositsFromBanksExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"GroupCompany Group Company \r\n2022 2022 2021 2021 \r\nUS$000 US$000 US$000 US$000 \r\nCash at bank 8,880 8,539 9,685 9,346 \r\nCash at bank earns interest at floating rates based on daily bank deposit rates. The Company has no restricted \r\ncash. (2021: nil)","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of deposits from banks [text block]","Documentation":"The disclosure of deposits from banks. [Refer: Deposits from banks]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114709,"FileId":8839,"Sequence":226,"PageIdentifier":"e070e7a0-1aaf-4b98-aebc-e07497f0fd06","ElementIdentifier":"c32ea79a-a1e5-4c36-8bf9-d124dfd0b961","ElementType":2,"TagName":"ifrs-full:DisclosureOfRestrictedCashAndCashEquivalentsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"The Company has no restricted cash. (2021: nil)","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of restricted cash and cash equivalents [text block]","Documentation":"The disclosure of restricted cash and cash equivalents. [Refer: Restricted cash and cash equivalents]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114710,"FileId":8839,"Sequence":227,"PageIdentifier":"e070e7a0-1aaf-4b98-aebc-e07497f0fd06","ElementIdentifier":"899f1808-160b-423a-9226-91a9051ed340","ElementType":2,"TagName":"ifrs-full:DisclosureOfTradeAndOtherPayablesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"21. Trade and other payables  GroupCompany Group Company \r\n2022 2022 2021 2021 \r\nUS$000 US$000 US$000 US$000 \r\nTrade and other payables: \r\nLease Liabilities 495 495 315 315 \r\nTrade payables 1,156 391 885 763 \r\nAccruals and other liabilities (1) 115,305 640 3,350 1,357 \r\n116,956 1,526 4,550 2,435 \r\nNon-current: \r\nLease Liabilities 146 146 424 424 \r\nOther liabilities - - 2 2 \r\nTotal 146 146 426  426\r\n(1) Includes US$ 113.3 million in connection with the arbitration tribunal ruling in favour of Keppel FELS \r\n(see Note 7)","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of trade and other payables [text block]","Documentation":"The disclosure of trade and other payables. [Refer: Trade and other payables]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114711,"FileId":8839,"Sequence":228,"PageIdentifier":"e070e7a0-1aaf-4b98-aebc-e07497f0fd06","ElementIdentifier":"b5be1057-b8bd-41c9-bb99-b9c8cfb178dd","ElementType":2,"TagName":"ifrs-full:DisclosureOfAccruedExpensesAndOtherLiabilitiesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"GroupCompany Group Company \r\n2022 2022 2021 2021 \r\nUS$000 US$000 US$000 US$000 \r\nTrade and other payables: \r\nLease Liabilities 495 495 315 315 \r\nTrade payables 1,156 391 885 763 \r\nAccruals and other liabilities (1) 115,305 640 3,350 1,357 \r\n116,956 1,526 4,550 2,435 \r\nNon-current: \r\nLease Liabilities 146 146 424 424 \r\nOther liabilities - - 2 2 \r\nTotal 146 146 426  426","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of accrued expenses and other liabilities [text block]","Documentation":"The disclosure of accrued expenses and other liabilities. [Refer: Accruals; Other liabilities]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114712,"FileId":8839,"Sequence":229,"PageIdentifier":"587d84d0-f275-4349-8a2f-db349d6c1a21","ElementIdentifier":"63897c83-bc23-4822-8451-560ee7939484","ElementType":2,"TagName":"ifrs-full:DisclosureOfProvisionsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"22. Provisions Redundancy \r\nTribunal \r\nAward \r\nTotal \r\nUS$000 US$000 US$000 \r\nAt 1 January 2022 1,100 - 1,100 \r\nUtilised (1,100) 9,278 8,178 \r\nAt 31 December 2022 - 9,278 9,278 \r\nThe redundancy provision was in relation to Offshore personnel, which was subsequently settled during the \r\nyear. The tribunal award is in relation to the expected costs award in connection with the tribunal ruling in \r\nfavour of Keppel FELS (Note 7). The final decision on the amount of the award for legal costs is still to be \r\nreceived from the arbitration panel.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of provisions [text block]","Documentation":"The disclosure of provisions. [Refer: Provisions]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114713,"FileId":8839,"Sequence":230,"PageIdentifier":"587d84d0-f275-4349-8a2f-db349d6c1a21","ElementIdentifier":"7bec8dc6-53f9-441b-bd64-ae61bcaebce7","ElementType":2,"TagName":"ifrs-full:DisclosureOfLeasesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"23. Leases The Group has a lease contract in place for the office building at 2 Kingshill Park, Westhill, Aberdeenshire, \r\nAB32 6FL. In the prior year, the remaining right of use asset for the office building in Westhill was fully \r\nimpaired. Set out below is the carrying amount of the right-of-use assets recognised and the movements \r\nduring the period: \r\nOffice Building Office Building \r\nGroup Company Group Company \r\n2022 2022 2021 2021 \r\nUS$000 US$000 US$000 US$000 \r\nAs at 1 January - - 1,096 1,096 \r\nDepreciation Expense - - (321) (321) \r\nImpairment - - (775) (775) \r\nAs at 31 December - - - - \r\nSet out below are the carrying amounts of lease liabilities (included under trade and other payables) and \r\nthe movements during the period: \r\n2022 2022 2021 2021 \r\nGroup Company Group Company \r\nUS$000 US$000 US$000 US$000 \r\nAs at 1 January 739 739 1,633 1,066 \r\nAccretion of interest 124 124 53 41 \r\nPayments (368) (368) (505) (368) \r\nRemeasurement - - (442) - \r\nAs at 31 December \r\n495 495 739 739 \r\nCurrent \r\n349 349 315 315 \r\nNon-current 146 146 424 424 \r\nThe maturity analysis of lease liabilities is disclosed in Note 26.  \r\n \r\n \r\n \r\n  \r\nThe following are the amounts recognised in profit or loss: \r\n2022 2022 2021 2021 \r\nGroup Company Group Company \r\nUS$000 US$000 US$000 US$000 \r\nDepreciation expense of right-of-use assets - - 321 321 \r\nInterest expense on lease liabilities 124 124 53 41 \r\nExpense relating to leases of low-value assets (included in \r\nadministrative expenses) 5 5 3 3 \r\nTotal amount recognised in profit or loss 129 129 377 365 \r\nThe Group has total cash outflows for leases of US$ 0.1 million (2021: US$ 0.5 million).","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of leases [text block]","Documentation":"The entire disclosure for leases.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114714,"FileId":8839,"Sequence":231,"PageIdentifier":"b5625901-2de6-48f8-b215-c95bf6b59f96","ElementIdentifier":"46c180b7-a32c-41bc-beb1-0d6f2e0bfefb","ElementType":2,"TagName":"ifrs-full:DisclosureOfCommitmentsAndContingentLiabilitiesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"24. Commitments and contingencies Capital commitments \r\nThere were nil capital commitments at 31 December 2022 (2021: US$ 0.9 million). \r\n2022 2021 \r\nUS$000 US$000 \r\nAmounts due within one year -  873\r\nContingent Liabilities \r\nIn December 2020, Awilco Rig 2 Pte Ltd received notice from the shipyard purporting to terminate the \r\ncontract for Nordic Spring. A notice of arbitration was also received. The Company notified the shipyard \r\nthat it exercised its contractual right of termination as a result of breaches under the contract. It also \r\nexercised its contractual right and issued the shipyard a notice of termination as a result of Force Majeure. \r\nIt is recognised that Keppel FELS has submitted a claim in respect of amounts it considers recoverable due \r\nto termination provisions in the contract for Nordic Spring. Statement of claims have been received from \r\nKeppel FELS in the amount of Singapore Dollars 356.18 million (US$ 268.9 million) for Awilco Rig 2 Pte. \r\nLtd. but this claim is strongly denied. Due to the non-recourse nature of the contract, this is considered as \r\na contingent liability only of the subsidiary and not the parent company. No provision has been made. It is \r\nexpected that the final arbitration outcome for Awilco Rig 2 Pte Ltd, including any appeal process, will be \r\nno earlier than Q3 2023. \r\nContingent Asset \r\nFollowing the termination of Nordic Spring, the subsidiary company, Awilco Rig 2 Pte. Ltd. has entered \r\narbitration with Keppel FELS in respect of deposit and variation order payments. A total amount of USD \r\n43.0 million plus interest is considered to be recoverable and is therefore disclosed as a contingent asset.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of commitments and contingent liabilities [text block]","Documentation":"The disclosure of commitments and contingent liabilities. [Refer: Contingent liabilities [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114715,"FileId":8839,"Sequence":232,"PageIdentifier":"b5625901-2de6-48f8-b215-c95bf6b59f96","ElementIdentifier":"c497f279-c03a-44df-bd52-aa9b72a841bf","ElementType":2,"TagName":"ifrs-full:DisclosureOfCommitmentsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Capital commitments There were nil capital commitments at 31 December 2022 (2021: US$ 0.9 million). \r\n2022 2021 \r\nUS$000 US$000 \r\nAmounts due within one year -  873","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of commitments [text block]","Documentation":"The disclosure of commitments.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114716,"FileId":8839,"Sequence":233,"PageIdentifier":"b5625901-2de6-48f8-b215-c95bf6b59f96","ElementIdentifier":"217ddbef-69c3-4562-9b92-e54990960b33","ElementType":2,"TagName":"ifrs-full:DisclosureOfContingentLiabilitiesExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Contingent Liabilities In December 2020, Awilco Rig 2 Pte Ltd received notice from the shipyard purporting to terminate the \r\ncontract for Nordic Spring. A notice of arbitration was also received. The Company notified the shipyard \r\nthat it exercised its contractual right of termination as a result of breaches under the contract. It also \r\nexercised its contractual right and issued the shipyard a notice of termination as a result of Force Majeure. \r\nIt is recognised that Keppel FELS has submitted a claim in respect of amounts it considers recoverable due \r\nto termination provisions in the contract for Nordic Spring. Statement of claims have been received from \r\nKeppel FELS in the amount of Singapore Dollars 356.18 million (US$ 268.9 million) for Awilco Rig 2 Pte. \r\nLtd. but this claim is strongly denied. Due to the non-recourse nature of the contract, this is considered as \r\na contingent liability only of the subsidiary and not the parent company. No provision has been made. It is \r\nexpected that the final arbitration outcome for Awilco Rig 2 Pte Ltd, including any appeal process, will be \r\nno earlier than Q3 2023.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of contingent liabilities [text block]","Documentation":"The disclosure of contingent liabilities. [Refer: Contingent liabilities [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114717,"FileId":8839,"Sequence":234,"PageIdentifier":"b5625901-2de6-48f8-b215-c95bf6b59f96","ElementIdentifier":"76c84ba9-5688-491f-9a49-1abc32ce96dd","ElementType":2,"TagName":"ifrs-full:DisclosureOfOtherProvisionsContingentLiabilitiesAndContingentAssetsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Contingent Liabilities In December 2020, Awilco Rig 2 Pte Ltd received notice from the shipyard purporting to terminate the \r\ncontract for Nordic Spring. A notice of arbitration was also received. The Company notified the shipyard \r\nthat it exercised its contractual right of termination as a result of breaches under the contract. It also \r\nexercised its contractual right and issued the shipyard a notice of termination as a result of Force Majeure. \r\nIt is recognised that Keppel FELS has submitted a claim in respect of amounts it considers recoverable due \r\nto termination provisions in the contract for Nordic Spring. Statement of claims have been received from \r\nKeppel FELS in the amount of Singapore Dollars 356.18 million (US$ 268.9 million) for Awilco Rig 2 Pte. \r\nLtd. but this claim is strongly denied. Due to the non-recourse nature of the contract, this is considered as \r\na contingent liability only of the subsidiary and not the parent company. No provision has been made. It is \r\nexpected that the final arbitration outcome for Awilco Rig 2 Pte Ltd, including any appeal process, will be \r\nno earlier than Q3 2023. \r\nContingent Asset \r\nFollowing the termination of Nordic Spring, the subsidiary company, Awilco Rig 2 Pte. Ltd. has entered \r\narbitration with Keppel FELS in respect of deposit and variation order payments. A total amount of USD 43.0 million plus interest is considered to be recoverable and is therefore disclosed as a contingent asset.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of other provisions, contingent liabilities and contingent assets [text block]","Documentation":"The entire disclosure for other provisions, contingent liabilities and contingent assets.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114718,"FileId":8839,"Sequence":235,"PageIdentifier":"00be8301-693c-4fa0-8914-9740b1bf2c9e","ElementIdentifier":"a2974ab5-c34c-46af-9af2-445850aeca96","ElementType":2,"TagName":"ifrs-full:DisclosureOfShareCapitalReservesAndOtherEquityInterestExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"25. Share capital Group and Company \r\n2022 2021 \r\nAuthorised No.000 No.000 \r\nOrdinary shares of &#163;0.65 each (2021 : \r\n&#163;0.0065) \r\n4,469 54,582 \r\nOn 20 December 2022, a 100 : 1 reverse share split was performed \r\nGroup and Company \r\nAllotted called up and fully paid \r\n2022 \r\nNo.000 \r\n2022 \r\nUS$000 \r\n2021 \r\nNo.000 \r\n2021 \r\nUS$000 \r\nAt 1 January 54,582 525 54,582 525 \r\nShare consolidation (54,036) - - - \r\nEquity issue 3,923 3,056 - - \r\nAt 31 December \r\n4,469 3,581 54,582 525 \r\nGroup and Company \r\n2022 \r\nShare \r\npremium \r\naccount \r\n2021 \r\nShare \r\npremium \r\naccount \r\nUS$000 US$000 \r\nAt 1 January 218,381 218,381 \r\nEquity issue 4,446 - \r\nAt 31 December 222,827  218,381","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of share capital, reserves and other equity interest [text block]","Documentation":"The entire disclosure for share capital, reserves and other equity interest.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114719,"FileId":8839,"Sequence":236,"PageIdentifier":"00be8301-693c-4fa0-8914-9740b1bf2c9e","ElementIdentifier":"fa8f65f3-053c-4570-8a75-03a7067c13d8","ElementType":2,"TagName":"ifrs-full:DisclosureOfIssuedCapitalExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"25. Share capital Group and Company \r\n2022 2021 \r\nAuthorised No.000 No.000 \r\nOrdinary shares of &#163;0.65 each (2021 : \r\n&#163;0.0065) \r\n4,469 54,582 \r\nOn 20 December 2022, a 100 : 1 reverse share split was performed \r\nGroup and Company \r\nAllotted called up and fully paid \r\n2022 \r\nNo.000 \r\n2022 \r\nUS$000 \r\n2021 \r\nNo.000 \r\n2021 \r\nUS$000 \r\nAt 1 January 54,582 525 54,582 525 \r\nShare consolidation (54,036) - - - \r\nEquity issue 3,923 3,056 - - \r\nAt 31 December \r\n4,469 3,581 54,582 525 \r\nGroup and Company \r\n2022 \r\nShare \r\npremium \r\naccount \r\n2021 \r\nShare \r\npremium \r\naccount \r\nUS$000 US$000 \r\nAt 1 January 218,381 218,381 \r\nEquity issue 4,446 - \r\nAt 31 December 222,827  218,381","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of issued capital [text block]","Documentation":"The disclosure of issued capital. [Refer: Issued capital]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114720,"FileId":8839,"Sequence":237,"PageIdentifier":"00be8301-693c-4fa0-8914-9740b1bf2c9e","ElementIdentifier":"33d03be8-6f6d-4f05-a657-6b7e631f2d2c","ElementType":2,"TagName":"ifrs-full:DisclosureOfRelatedPartyExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"26. Related party transactions During the year the Group entered into transactions, in the ordinary course of business, with Awilhelmsen \r\nOffshore AS, which is a major shareholder through its subsidiaries. \r\nTransactions entered into and trading balances outstanding at 31 December 2022 with Awilhelmsen AS \r\nand its subsidiaries are as follows: \r\n2022 2021 \r\nUS$000 US$000 \r\nPurchase of management services 914 918 \r\nInterest \r\n72 - \r\nAmounts owed to Awilhelmsen AS and its subsidiaries (261) (264) \r\nThe Group and Company entered into a loan arrangement of US$ 1.5 million with major shareholders in \r\nconnection with which commitment fees and interest amounting to US$96,000 (including US$24,000 to \r\nQVT) were incurred and paid during 2022 (2021: nil). \r\nSales and purchases between related parties are made at normal market prices. Outstanding balances are \r\nunsecured, interest-free and cash settlement terms vary between 30 and 90 days. The Company has not \r\nprovided or benefitted from any guarantees for any related party receivables or payables.  Included in the \r\npurchase of management services are the amounts in respect of the interim CEO.  \r\n \r\n \r\n \r\n  \r\nDirectors and other key management personnel \r\nThe remuneration of directors and other key management personnel of the Group is as follows \r\n2022 2021 \r\nUS$000 US$000 \r\nShort-term employee benefits \r\n1,336 1,437 \r\nShare-based payments - (112) \r\nTermination benefits 298 529 \r\nOther long-term benefits \r\n60 82 \r\nIncluded in the short-term employee benefits are director&#8217;s emoluments of GBP 195,000 (2021: GBP \r\n195,000).  Five directors received remuneration in respect of their services to the Company during the year \r\n(2021: five).  The highest paid director was Sigurd Thorvildsen - please refer to the Directors&#8217; remuneration \r\nreport on page 29 for further details. \r\n Company\r\nThe Company entered into the following transactions and had the following balances with its wholly \r\nowned subsidiaries \r\n2022 2021 \r\nUS$000 US$000 \r\nTransactions: \r\nAmounts invoiced to Awilco Drilling Offshore (UK) Limited in respect of \r\nservices provided to the company 11,782 32,804 \r\nAmounts invoiced on behalf of Awilco Drilling Offshore (UK) Limited (20,025) (36,384) \r\nInvoiced to Awilco Drilling Pte. Ltd. 541 127 \r\nTransfer of funds to Awilco Drilling Pte. Ltd. 604 299 \r\nAmounts invoiced to Awilco Rig 1 Pte. Ltd. in respect of services provided \r\nto the company 21,138 - \r\nAmounts invoiced to Awilco Rig 2 Pte. Ltd. in respect of services provided \r\nto the company 5,391 - \r\nAmounts invoiced to Awilco Drilling Norge AS in respect of services \r\nprovided to the company 18 3,431 \r\nSettlement of balance due from Awilco Drilling Norge AS (13,412) - \r\nTaxation paid on behalf of subsidiaries 98 68 \r\nTransfer of share capital funds due to WilHunter (UK) Limited 100  \r\n \r\n \r\n \r\n  \r\n 20222021 \r\nBalances: US$000 US$000 \r\nAmounts receivable from Awilco Drilling Offshore (UK) Limited 78,431 86,674 \r\nAmounts payable to WilHunter (UK) Limited - (100) \r\nAmounts receivable from Awilco Drilling Pte. Ltd. 7,716 6,473 \r\nAmounts receivable from Awilco Rig 1 Pte. Ltd. 78,481 57,343 \r\nAmounts receivable from Awilco Rig 2 Pte. Ltd. 49,689 44,298 \r\nAmounts receivable from Awilco Drilling Norge AS - 13,394 \r\n214,317 208,082 \r\nAllowance for expected credit loss \r\n(214,317) (192,837) \r\n- 15,245 \r\nThe balances receivable from the subsidiary companies are considered long term. There are long term loan \r\nagreements in place with Awilco Drilling Pte. Ltd, Awilco Rig 1 Pte. Ltd. and Awilco Rig 2 Pte. Ltd. \r\nSet out below is the movement in the allowance for expected credit losses of intercompany receivables: \r\n2022 2021 \r\nUS$000 US$000 \r\nAs at 1 January (192,837) (115,010) \r\nProvision for expected credit loss (21,480) (71,199) \r\nAs at 31 December (214,317) (192,837) \r\nExpected credit loss is due to making a full provision for amounts due from Awilco Drilling Offshore (UK) \r\nLimited, Awilco Drilling Pte. Ltd, Awilco Rig 1 Pte. Ltd. and Awilco Rig 2 Pte. Ltd. \r\nEntity with significant influence over the Group \r\nAwilhelmsen Offshore AS, owns 50.5% of the ordinary shares in Awilco Drilling PLC.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of related party [text block]","Documentation":"The entire disclosure for related parties.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114721,"FileId":8839,"Sequence":238,"PageIdentifier":"3311f051-b787-478b-96ab-9fc803b43863","ElementIdentifier":"05d42d77-c4d4-448a-98ac-6a2621644ada","ElementType":2,"TagName":"ifrs-full:DisclosureOfInformationAboutKeyManagementPersonnelExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Directors and other key management personnel The remuneration of directors and other key management personnel of the Group is as follows \r\n2022 2021 \r\nUS$000 US$000 \r\nShort-term employee benefits \r\n1,336 1,437 \r\nShare-based payments - (112) \r\nTermination benefits 298 529 \r\nOther long-term benefits \r\n60 82 \r\nIncluded in the short-term employee benefits are director&#8217;s emoluments of GBP 195,000 (2021: GBP \r\n195,000).  Five directors received remuneration in respect of their services to the Company during the year \r\n(2021: five).  The highest paid director was Sigurd Thorvildsen - please refer to the Directors&#8217; remuneration \r\nreport on page 29 for further details.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of information about key management personnel [text block]","Documentation":"The disclosure of information about key management personnel. [Refer: Key management personnel of entity or parent [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114722,"FileId":8839,"Sequence":239,"PageIdentifier":"eeaa5725-0495-4245-8c47-9bdcbb31357e","ElementIdentifier":"230f7359-9501-49a0-a559-829f4f09a52d","ElementType":2,"TagName":"ifrs-full:DisclosureOfFinancialRiskManagementExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"27. Capital management, financial risk management objectives and policies The Group&#8217;s and the Company&#8217;s principal financial liabilities comprise trade and other payables. The main \r\npurpose of these financial liabilities is to finance the Group&#8217;s operations. The Group has trade and other \r\nreceivables, and cash and cash equivalents that are derived directly from its operations. Management has \r\nassessed the fair values of the financial instruments are approximates to their carrying values. \r\nThe Group and the Company are exposed to market risk, credit risk and liquidity risk. \r\nMarket risk \r\nMarket risk is the risk that the fair value or future cash flows of a financial instrument will fluctuate because \r\nof changes in market prices. Market risk comprises foreign currency risk. Financial instruments affected by \r\nmarket risk are trade and other payables. \r\nForeign currency risk \r\nForeign currency risk is the risk that the fair value or future cash flows of a financial instrument will fluctuate \r\nbecause of changes in foreign exchange rates. The Group&#8217;s and Company&#8217;s exposure to the risk of changes \r\nin foreign exchange rates relates primarily to the Group&#8217;s and Company&#8217;s activities (when expenses are \r\ndenominated in a different currency from the Company&#8217;s functional currency).  \r\n \r\n \r\n \r\n  \r\n \r\nForeign currency risk (continued) \r\nAt the balance sheet date, the Group held GBP 0.7 million in trade and other payables (2021: GBP 0.9 \r\nmillion). A 5% strengthening or weakening of US$ to GBP would have an effect of US$ 0.1 million on the \r\nGroup 2021 result (2021: US$0.1 million). The Group has no other material currency exposures. \r\nCredit risk \r\nCredit risk is the risk that a counterparty will not meet its obligations under a financial instrument or \r\ncustomer contract, leading to a financial loss. During its operational phase, the Group was exposed to credit \r\nrisk from its operating activities (primarily for trade receivables). The Company has credit risk due to its \r\ntrade and other receivables from subsidiary undertakings and from external clients. \r\nManagement would assess the credit rating of new and existing clients and determine if any action was \r\nrequired to secure the financial security in respect of work performed. \r\nLiquidity risk \r\nThe Group&#8217;s objective is to maintain sufficient liquidity in order to support the needs of the business and \r\nmeet the repayments of the debt and commitments as they fall due. In order to achieve this, the Group also \r\nhas the prospect of issuing new equity or entering into new borrowing arrangements. \r\nThe table below summarises the maturity profile of the Group&#8217;s financial liabilities based on contractual \r\nundiscounted payments. \r\nGroup Less than \r\n3 months \r\n3 to 12 \r\nmonths \r\n1-5 \r\nyears Total \r\nTrade and other payables 6,231 113,291 2 119,524 \r\nLease liabilities - 368 153 521 \r\n31 December 2022 6,231 113,659 155 120,045 \r\nTrade and other payables 5,335 - 2 5,337 \r\nLease liabilities - 368 522 890 \r\n31 December 2021 5,335 368 524 6,227 \r\nThe table below summarises the maturity profile of the Company&#8217;s financial liabilities based on contractual \r\nundiscounted payments. \r\nCompany \r\nLess than \r\n3 months \r\n3 to 12 \r\nmonths \r\n1-5 \r\nyears Total \r\nTrade and other payables 2,530 - 2 2,532 \r\nLease liabilities - 368 153 521 \r\n31 December 2022 2,530 368 155 3,053 \r\nTrade and other payables 2,120 - 2 2,122 \r\nLease liabilities - 368 522 890 \r\n31 December 2021 2,120 368 524  3,012 \r\n \r\n \r\n \r\n  \r\n \r\nCapital management \r\nCapital includes called up share capital, share premium and retained earnings / (deficit). \r\nAs the Company is currently no longer performing operational activities relating to rigs, there will be no \r\ndividends distributed arising from operational activity. \r\nThe Company&#8217;s capital is monitored at a Group level. The Group monitors capital using a gearing ratio, \r\nwhich is net debt divided by total shareholders&#8217; funds plus net debt. The Group includes within net debt, \r\nbonds and loans less cash and cash equivalents. \r\nGroup Group \r\n2022 2021 \r\nUS$000 US$000 \r\nCash and cash equivalents (note 19) 8,880 9,685 \r\nNet debt / (funds) 7,380 9,685 \r\nCapital (126,955) 10,899 \r\nCapital less net debt (134,335) (1,214) \r\nGearing ratio n/a  n/a","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of financial risk management [text block]","Documentation":"The disclosure of the entity's financial risk management practices and policies.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114723,"FileId":8839,"Sequence":240,"PageIdentifier":"eeaa5725-0495-4245-8c47-9bdcbb31357e","ElementIdentifier":"c373321a-31ed-427d-9445-50347b413894","ElementType":2,"TagName":"ifrs-full:DisclosureOfObjectivesPoliciesAndProcessesForManagingCapitalExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"27. Capital management, financial risk management objectives and policies The Group&#8217;s and the Company&#8217;s principal financial liabilities comprise trade and other payables. The main \r\npurpose of these financial liabilities is to finance the Group&#8217;s operations. The Group has trade and other \r\nreceivables, and cash and cash equivalents that are derived directly from its operations. Management has \r\nassessed the fair values of the financial instruments are approximates to their carrying values. \r\nThe Group and the Company are exposed to market risk, credit risk and liquidity risk. \r\nMarket risk \r\nMarket risk is the risk that the fair value or future cash flows of a financial instrument will fluctuate because \r\nof changes in market prices. Market risk comprises foreign currency risk. Financial instruments affected by \r\nmarket risk are trade and other payables. \r\nForeign currency risk \r\nForeign currency risk is the risk that the fair value or future cash flows of a financial instrument will fluctuate \r\nbecause of changes in foreign exchange rates. The Group&#8217;s and Company&#8217;s exposure to the risk of changes \r\nin foreign exchange rates relates primarily to the Group&#8217;s and Company&#8217;s activities (when expenses are \r\ndenominated in a different currency from the Company&#8217;s functional currency).  \r\n \r\n \r\n \r\n  \r\n \r\nForeign currency risk (continued) \r\nAt the balance sheet date, the Group held GBP 0.7 million in trade and other payables (2021: GBP 0.9 \r\nmillion). A 5% strengthening or weakening of US$ to GBP would have an effect of US$ 0.1 million on the \r\nGroup 2021 result (2021: US$0.1 million). The Group has no other material currency exposures. \r\nCredit risk \r\nCredit risk is the risk that a counterparty will not meet its obligations under a financial instrument or \r\ncustomer contract, leading to a financial loss. During its operational phase, the Group was exposed to credit \r\nrisk from its operating activities (primarily for trade receivables). The Company has credit risk due to its \r\ntrade and other receivables from subsidiary undertakings and from external clients. \r\nManagement would assess the credit rating of new and existing clients and determine if any action was \r\nrequired to secure the financial security in respect of work performed. \r\nLiquidity risk \r\nThe Group&#8217;s objective is to maintain sufficient liquidity in order to support the needs of the business and \r\nmeet the repayments of the debt and commitments as they fall due. In order to achieve this, the Group also \r\nhas the prospect of issuing new equity or entering into new borrowing arrangements. \r\nThe table below summarises the maturity profile of the Group&#8217;s financial liabilities based on contractual \r\nundiscounted payments. \r\nGroup Less than \r\n3 months \r\n3 to 12 \r\nmonths \r\n1-5 \r\nyears Total \r\nTrade and other payables 6,231 113,291 2 119,524 \r\nLease liabilities - 368 153 521 \r\n31 December 2022 6,231 113,659 155 120,045 \r\nTrade and other payables 5,335 - 2 5,337 \r\nLease liabilities - 368 522 890 \r\n31 December 2021 5,335 368 524 6,227 \r\nThe table below summarises the maturity profile of the Company&#8217;s financial liabilities based on contractual \r\nundiscounted payments. \r\nCompany \r\nLess than \r\n3 months \r\n3 to 12 \r\nmonths \r\n1-5 \r\nyears Total \r\nTrade and other payables 2,530 - 2 2,532 \r\nLease liabilities - 368 153 521 \r\n31 December 2022 2,530 368 155 3,053 \r\nTrade and other payables 2,120 - 2 2,122 \r\nLease liabilities - 368 522 890 \r\n31 December 2021 2,120 368 524  3,012 \r\n \r\n \r\n \r\n  \r\n \r\nCapital management \r\nCapital includes called up share capital, share premium and retained earnings / (deficit). \r\nAs the Company is currently no longer performing operational activities relating to rigs, there will be no \r\ndividends distributed arising from operational activity. \r\nThe Company&#8217;s capital is monitored at a Group level. The Group monitors capital using a gearing ratio, \r\nwhich is net debt divided by total shareholders&#8217; funds plus net debt. The Group includes within net debt, \r\nbonds and loans less cash and cash equivalents. \r\nGroup Group \r\n2022 2021 \r\nUS$000 US$000 \r\nCash and cash equivalents (note 19) 8,880 9,685 \r\nNet debt / (funds) 7,380 9,685 \r\nCapital (126,955) 10,899 \r\nCapital less net debt (134,335) (1,214) \r\nGearing ratio n/a  n/a","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of objectives, policies and processes for managing capital [text block]","Documentation":"The disclosure of information that enables users of financial statements to evaluate the entity's objectives, policies and processes for managing capital.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114724,"FileId":8839,"Sequence":241,"PageIdentifier":"eeaa5725-0495-4245-8c47-9bdcbb31357e","ElementIdentifier":"39aac2f2-5bae-4f38-8c30-1d04c0035858","ElementType":2,"TagName":"ifrs-full:DisclosureOfMarketRiskExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Market risk Market risk is the risk that the fair value or future cash flows of a financial instrument will fluctuate because \r\nof changes in market prices. Market risk comprises foreign currency risk. Financial instruments affected by \r\nmarket risk are trade and other payables. \r\nForeign currency risk \r\nForeign currency risk is the risk that the fair value or future cash flows of a financial instrument will fluctuate \r\nbecause of changes in foreign exchange rates. The Group&#8217;s and Company&#8217;s exposure to the risk of changes \r\nin foreign exchange rates relates primarily to the Group&#8217;s and Company&#8217;s activities (when expenses are \r\ndenominated in a different currency from the Company&#8217;s functional currency).  \r\n \r\n \r\n \r\n  \r\n \r\nForeign currency risk (continued) \r\nAt the balance sheet date, the Group held GBP 0.7 million in trade and other payables (2021: GBP 0.9 \r\nmillion). A 5% strengthening or weakening of US$ to GBP would have an effect of US$ 0.1 million on the \r\nGroup 2021 result (2021: US$0.1 million). The Group has no other material currency exposures.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of market risk [text block]","Documentation":"The disclosure of market risk. [Refer: Market risk [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114725,"FileId":8839,"Sequence":242,"PageIdentifier":"1b4e4028-6028-40f0-8fec-1fc51a5750ce","ElementIdentifier":"9df7ad3a-5375-4ee8-941c-ec32f00f14d2","ElementType":2,"TagName":"ifrs-full:DisclosureOfCreditRiskExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Credit risk Credit risk is the risk that a counterparty will not meet its obligations under a financial instrument or \r\ncustomer contract, leading to a financial loss. During its operational phase, the Group was exposed to credit \r\nrisk from its operating activities (primarily for trade receivables). The Company has credit risk due to its \r\ntrade and other receivables from subsidiary undertakings and from external clients. \r\nManagement would assess the credit rating of new and existing clients and determine if any action was \r\nrequired to secure the financial security in respect of work performed.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of credit risk [text block]","Documentation":"The disclosure of credit risk. [Refer: Credit risk [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114726,"FileId":8839,"Sequence":243,"PageIdentifier":"1b4e4028-6028-40f0-8fec-1fc51a5750ce","ElementIdentifier":"58611ae4-b89c-4d19-91f0-2519e8d312da","ElementType":2,"TagName":"ifrs-full:DisclosureOfLiquidityRiskExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"Liquidity risk The Group&#8217;s objective is to maintain sufficient liquidity in order to support the needs of the business and \r\nmeet the repayments of the debt and commitments as they fall due. In order to achieve this, the Group also \r\nhas the prospect of issuing new equity or entering into new borrowing arrangements. \r\nThe table below summarises the maturity profile of the Group&#8217;s financial liabilities based on contractual \r\nundiscounted payments. \r\nGroup Less than \r\n3 months \r\n3 to 12 \r\nmonths \r\n1-5 \r\nyears Total \r\nTrade and other payables 6,231 113,291 2 119,524 \r\nLease liabilities - 368 153 521 \r\n31 December 2022 6,231 113,659 155 120,045 \r\nTrade and other payables 5,335 - 2 5,337 \r\nLease liabilities - 368 522 890 \r\n31 December 2021 5,335 368 524 6,227 \r\nThe table below summarises the maturity profile of the Company&#8217;s financial liabilities based on contractual \r\nundiscounted payments. \r\nCompany \r\nLess than \r\n3 months \r\n3 to 12 \r\nmonths \r\n1-5 \r\nyears Total \r\nTrade and other payables 2,530 - 2 2,532 \r\nLease liabilities - 368 153 521 \r\n31 December 2022 2,530 368 155 3,053 \r\nTrade and other payables 2,120 - 2 2,122 \r\nLease liabilities - 368 522 890 \r\n31 December 2021 2,120 368 524  3,012","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of liquidity risk [text block]","Documentation":"The disclosure of liquidity risk. [Refer: Liquidity risk [member]]","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114759,"FileId":8839,"Sequence":244,"PageIdentifier":"03105861-82ea-4eca-a89c-cccc7abbe0fc","ElementIdentifier":"44d41d5c-f7df-4662-8b17-71f90c8c4d5f","ElementType":2,"TagName":"ifrs-full:DisclosureOfSharebasedPaymentArrangementsExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"28. Share-based payments Long Term Incentive Plan \r\nA long term incentive plan for key management personnel, with a total limit of up to 4,000,000 shares was \r\napproved at the general meeting on 11 November 2019. \r\nThe 2020 plan &#8220;vests&#8221; in 25% tranches. The vesting dates for the plan are linked to the contract that was \r\nsigned with Keppel FELS shipyard in Singapore to build up to four semi-submersible drilling rigs with each \r\ncontract option being independent of each other. Each 25% tranche &#8220;vests&#8221; on the date each of the four rig \r\noption contract commence, and day rate revenue is earned. In the event that the rig building contract is \r\nterminated, as is the case for Rig 1 and Rig 2, the shares will lapse. In the event that the build option is not \r\nexercised, as is the case for Rig 3 and Rig 4 specific vesting dates in 2023 and 2024 are stipulated. \r\nThe awards are options and, following the share consolidation during December 2022, they have a revised \r\nstrike price of NOK 3,000 (2021 : NOK 30). \r\nAs the shares were consolidated on a basis of 1:100, this resulted in an adjustment to the strike price in \r\naccordance with the plan documentation. As a result of this increase, there has been no movement in the \r\nprovision during the year, based on the current trading price of the shares. \r\nAll share options and share awards are synthetic based and are cash settled. \r\nThe estimated fair value of the granted share options and awards are reached on the basis of the &#8220;Black - \r\nScholes option pricing model&#8221;. The model is applied utilising a risk-free discount rate and also taking into \r\naccount the terms and conditions upon which the options and awards are granted as well as the performance \r\nconditions that are required to be satisfied before vesting. The weighted average remaining contractual life \r\nat 31 December 2022 is 1.24 years. There was no movement in the Group total share option and award \r\nduring the year (2021: US$ 0.1 million credit). The carrying amount of the liability relating to the cash- \r\nsettled options at 31 December 2022 is unchanged at US$ 2k (2021: US$2k ).  \r\n \r\n \r\n \r\n  \r\nThe following table list the inputs to the model used for the annual revaluation of the 2020 Plan (share \r\nprices are in NOK). \r\nGroup and Company 2022 2021 \r\n2020 Plan 2020 Plan \r\nExercise price 3,000.0 30.0 \r\nYear-end Share price 1.16 3.20 \r\nExpected life 1.24 years 0.56 years \r\nVolatility 0.00 0.18 \r\nRisk free interest rate 3.13% 0.34% \r\nModel used Black Scholes \r\nThe following table illustrates the number and weighted average exercise prices (WAEP) of, and \r\nmovements in, share options and awards during the year. \r\nGroup and Company 2022 2022 2021 2021 \r\nNo. WAEP (NOK) No. WAEP (NOK) \r\nOutstanding as at 1 January 475,000 30.0 1,247,284 25.86 \r\nGranted during the year - - - - \r\nExercised during the year - - (172,284) - \r\nForfeited during the year (100,00) 30.0 (600,000) 30.0 \r\nAdjusted during the year - - - - \r\nOutstanding at 31 December 375,000 3,000.0 475,000 30.0 \r\nExercisable at 31 December - - - - \r\nThe table below summaries the carrying amount of the liability at 31 December 2021 and 2022 \r\nGroup and Company \r\nLess than 3 \r\nmonths 3 to 12 months 1 &#8211; 5 years Total \r\nUS$000 US$000 US$000 US$000 \r\nShare options / awards - - 2  2","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of share-based payment arrangements [text block]","Documentation":"The entire disclosure for share-based payment arrangements.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true},{"Id":4114882,"FileId":8839,"Sequence":245,"PageIdentifier":"6b80d339-b0c6-4da0-add2-24b5e4891303","ElementIdentifier":"ecd56df6-31c9-4e77-9c71-52f691a06fc5","ElementType":2,"TagName":"ifrs-full:DisclosureOfEventsAfterReportingPeriodExplanatory","ContextRef":"P01_01_2022To12_31_2022","Period":"01-Jan-2022 - 31-Dec-2022","Unit":"","CurrencyName":"","Decimal":"0","Scale":"Actuals","Value":"29. Subsequent events During January, following successful recycling of the WilHunter rig in Turkey, the counter security of GBP \r\n2 million that was held in escrow in connection with the SEPA guarantee was returned in full. \r\nAlso, during January, the short-term shareholder loan and associated interest was repaid in full. \r\nDuring February, a sublet opportunity was identified for the top floor of the Westhill office. The Company \r\nsigned a revised lease with the landlord for the remaining bottom floor area of the office. \r\nDuring April, the subsidiary company, Awilco Rig 1 Pte Ltd received the arbitration tribunal&#8217;s ruling which \r\nawarded in favour of Keppel FELS. This is considered as an adjusting post balance sheet event and the \r\nfinancial statements have been amended accordingly. \r\nDuring May, the Company signed a further short-term shareholder loan with Awilhelmsen Offshore AS. \r\nThe loan is for a total of up to USD four million, structured as a draw-down facility, with interest rate of 10 \r\npercent per annum on the aggregated outstanding principal amount. In addition, there is an arrangement fee \r\nof 2 percent on the total amount. Maturity date for the loan is 30 June 2023. The loan shall be used to support the ongoing arbitration process.","Dimension":"","Member":"","CurrencyCode":"","UnitDenominator":"","Sign":"","IsHiddenElement":false,"Label":"Disclosure of events after reporting period [text block]","Documentation":"The entire disclosure for events after the reporting period.","SecondaryLabel":"","SecondaryDocumentation":"","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":true,"Format":"","FootNote":"","status":0,"IsExtendedElement":0,"IsTextBlock":true,"IsMandatoryTag":true}];
  $scope.presentationData = [{"Id":"http://awilcodrilling.com/role/GroupStatementOfComprehensiveIncome","ParentId":"","Name":"1001 - Statement - Group statement of comprehensive income","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","ParentId":"http://awilcodrilling.com/role/GroupStatementOfComprehensiveIncome","Name":"ifrs-full:IncomeStatementAbstract","Order":"","Label":"Profit or loss placeholder - this item MUST be used as a starting point for the statement of profit or loss if the statement of profit or loss is disclosed separately","Documentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_Revenue","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","Name":"ifrs-full:Revenue","Order":"1","Label":"Revenue","Documentation":"The income arising in the course of an entity's ordinary activities. Income is increases in assets, or decreases in liabilities, that result in increases in equity, other than those relating to contributions from holders of equity claims.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_CostOfSales","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","Name":"ifrs-full:CostOfSales","Order":"2","Label":"Cost of sales","Documentation":"The amount of all expenses directly or indirectly attributed to the goods or services sold. Attributed expenses include, but are not limited to, costs previously included in the measurement of inventory that has now been sold, such as depreciation and maintenance of factory buildings and equipment used in the production process, unallocated production overheads, and abnormal amounts of production costs of inventories.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ImpairmentLoss","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","Name":"ifrs-full:ImpairmentLoss","Order":"3","Label":"Impairment loss","Documentation":"The amount recognised as a reduction of the carrying amount of an asset or cash-generating unit to its recoverable amount. [Refer: Carrying amount [member]]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GainsOnDisposalsOfPropertyPlantAndEquipment","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","Name":"ifrs-full:GainsOnDisposalsOfPropertyPlantAndEquipment","Order":"4","Label":"Gains on disposals of property, plant and equipment","Documentation":"The gain on the disposal of property, plant and equipment. [Refer: Property, plant and equipment]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GrossProfit","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","Name":"ifrs-full:GrossProfit","Order":"5","Label":"Gross profit","Documentation":"The amount of revenue less cost of sales. [Refer: Cost of sales; Revenue]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GeneralAndAdministrativeExpense","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","Name":"ifrs-full:GeneralAndAdministrativeExpense","Order":"6","Label":"General and administrative expense","Documentation":"The amount of expense relating to general and administrative activities of the entity.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_OtherExpenseByFunction","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","Name":"ifrs-full:OtherExpenseByFunction","Order":"7","Label":"Other expense, by function","Documentation":"The amount of expenses that the entity does not separately disclose in the same statement or note when the entity uses the 'function of expense' form for its analysis of expenses.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossFromOperatingActivities","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","Name":"ifrs-full:ProfitLossFromOperatingActivities","Order":"8","Label":"Profit (loss) from operating activities","Documentation":"The profit (loss) from operating activities of the entity. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_FinanceIncome","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","Name":"ifrs-full:FinanceIncome","Order":"9","Label":"Finance income","Documentation":"The amount of income associated with interest and other financing activities of the entity.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_FinanceCosts","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","Name":"ifrs-full:FinanceCosts","Order":"10","Label":"Finance costs","Documentation":"The amount of costs associated with financing activities of the entity.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GainsLossesOnExchangeDifferencesOnTranslationRecognisedInProfitOrLoss","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","Name":"ifrs-full:GainsLossesOnExchangeDifferencesOnTranslationRecognisedInProfitOrLoss","Order":"11","Label":"Foreign exchange gain (loss)","Documentation":"The amount of exchange differences recognised in profit or loss that arise from foreign currency transactions, excluding those arising on financial instruments measured at fair value through profit or loss in accordance with IFRS 9. [Refer: At fair value [member]; Financial instruments, class [member]]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossBeforeTax","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","Name":"ifrs-full:ProfitLossBeforeTax","Order":"12","Label":"Profit (loss) before tax","Documentation":"The profit (loss) before tax expense or income. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeTaxExpenseContinuingOperations","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","Name":"ifrs-full:IncomeTaxExpenseContinuingOperations","Order":"13","Label":"Tax expense (income)","Documentation":"The aggregate amount included in the determination of profit (loss) for the period in respect of current tax and deferred tax. [Refer: Current tax expense (income); Deferred tax expense (income)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLoss","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","Name":"ifrs-full:ProfitLoss","Order":"14","Label":"Profit (loss)","Documentation":"The total of income less expenses from continuing and discontinued operations, excluding the components of other comprehensive income. [Refer: Other comprehensive income]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_BasicEarningsLossPerShare","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","Name":"ifrs-full:BasicEarningsLossPerShare","Order":"15","Label":"Basic earnings (loss) per share","Documentation":"The amount of profit (loss) attributable to ordinary equity holders of the parent entity (the numerator) divided by the weighted average number of ordinary shares outstanding during the period (the denominator).","PeriodType":"duration","Balance":"0","Type":"num:perShareItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_DilutedEarningsLossPerShare","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeStatementAbstract","Name":"ifrs-full:DilutedEarningsLossPerShare","Order":"16","Label":"Diluted earnings (loss) per share","Documentation":"The amount of profit (loss) attributable to ordinary equity holders of the parent entity (the numerator), divided by the weighted average number of ordinary shares outstanding during the period (the denominator), both adjusted for the effects of all dilutive potential ordinary shares. [Refer: Ordinary shares [member]; Weighted average [member]]","PeriodType":"duration","Balance":"0","Type":"num:perShareItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"http://awilcodrilling.com/role/GroupStatementOfFinancialPosition","ParentId":"","Name":"1002 - Statement - Group statement of financial position","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_StatementOfFinancialPositionAbstract","ParentId":"http://awilcodrilling.com/role/GroupStatementOfFinancialPosition","Name":"ifrs-full:StatementOfFinancialPositionAbstract","Order":"","Label":"Statement of financial position placeholder - this item MUST be used as a starting point for the statement of financial position","Documentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_AssetsAbstract","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_StatementOfFinancialPositionAbstract","Name":"ifrs-full:AssetsAbstract","Order":"1","Label":"Assets [abstract]","Documentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssetsAbstract","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_AssetsAbstract","Name":"ifrs-full:NoncurrentAssetsAbstract","Order":"2","Label":"Non-current assets [abstract]","Documentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_PropertyPlantAndEquipment","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssetsAbstract","Name":"ifrs-full:PropertyPlantAndEquipment","Order":"3","Label":"Property, plant and equipment","Documentation":"The amount of tangible assets that: (a) are held for use in the production or supply of goods or services, for rental to others, or for administrative purposes; and (b) are expected to be used during more than one period.","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_RightofuseAssets","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssetsAbstract","Name":"ifrs-full:RightofuseAssets","Order":"4","Label":"Right-of-use assets","Documentation":"The amount of assets that represent a lessee's right to use an underlying asset for the lease term. Underlying asset is an asset that is the subject of a lease, for which the right to use that asset has been provided by a lessor to a lessee.","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssets","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssetsAbstract","Name":"ifrs-full:NoncurrentAssets","Order":"5","Label":"Total non-current assets","Documentation":"The amount of assets that do not meet the definition of current assets. [Refer: Current assets]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssetsAbstract","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_AssetsAbstract","Name":"ifrs-full:CurrentAssetsAbstract","Order":"6","Label":"Current assets [abstract]","Documentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_Inventories","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssetsAbstract","Name":"ifrs-full:Inventories","Order":"7","Label":"Current inventories","Documentation":"The amount of current inventories. [Refer: Inventories]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_TradeAndOtherCurrentReceivables","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssetsAbstract","Name":"ifrs-full:TradeAndOtherCurrentReceivables","Order":"8","Label":"Trade and other current receivables","Documentation":"The amount of current trade receivables and current other receivables. [Refer: Current trade receivables; Other current receivables]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CashAndCashEquivalents","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssetsAbstract","Name":"ifrs-full:CashAndCashEquivalents","Order":"9","Label":"Cash and cash equivalents","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssets","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssetsAbstract","Name":"ifrs-full:CurrentAssets","Order":"10","Label":"Total current assets","Documentation":"The amount of assets that the entity (a) expects to realise or intends to sell or consume in its normal operating cycle; (b) holds primarily for the purpose of trading; (c) expects to realise within twelve months after the reporting period; or (d) classifies as cash or cash equivalents (as defined in IAS 7) unless the asset is restricted from being exchanged or used to settle a liability for at least twelve months after the reporting period. [Refer: Assets]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_Assets","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_AssetsAbstract","Name":"ifrs-full:Assets","Order":"11","Label":"Total assets","Documentation":"The amount of a present economic resource controlled by the entity as a result of past events. Economic resource is a right that has the potential to produce economic benefits.","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_LiabilitiesAbstract","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_StatementOfFinancialPositionAbstract","Name":"ifrs-full:LiabilitiesAbstract","Order":"12","Label":"Liabilities [abstract]","Documentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilitiesAbstract","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_LiabilitiesAbstract","Name":"ifrs-full:CurrentLiabilitiesAbstract","Order":"13","Label":"Current liabilities [abstract]","Documentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_TradeAndOtherCurrentPayables","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilitiesAbstract","Name":"ifrs-full:TradeAndOtherCurrentPayables","Order":"14","Label":"Trade and other current payables","Documentation":"The amount of current trade payables and current other payables. [Refer: Current trade payables; Other current payables]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentProvisions","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilitiesAbstract","Name":"ifrs-full:CurrentProvisions","Order":"15","Label":"Current provisions","Documentation":"The amount of current provisions, including provisions for employee benefits. [Refer: Provisions]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_ShorttermBorrowings","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilitiesAbstract","Name":"ifrs-full:ShorttermBorrowings","Order":"16","Label":"Current borrowings","Documentation":"The amount of current borrowings. [Refer: Borrowings]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentTaxLiabilitiesCurrent","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilitiesAbstract","Name":"ifrs-full:CurrentTaxLiabilitiesCurrent","Order":"17","Label":"Current tax liabilities, current","Documentation":"The current amount of current tax liabilities. [Refer: Current tax liabilities]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilities","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilitiesAbstract","Name":"ifrs-full:CurrentLiabilities","Order":"18","Label":"Total current liabilities","Documentation":"Expiry date 2023-01-01: The amount of liabilities that: (a) the entity expects to settle in its normal operating cycle; (b) the entity holds primarily for the purpose of trading; (c) are due to be settled within twelve months after the reporting period; or (d) the entity does not have an unconditional right to defer settlement for at least twelve months after the reporting period.\r\nEffective 2023-01-01: The amount of liabilities that: (a) the entity expects to settle in its normal operating cycle; (b) the entity holds primarily for the purpose of trading; (c) are due to be settled within twelve months after the reporting period; or (d) the entity does not have the right at the end of the reporting period to defer settlement for at least twelve months after the reporting period.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentLiabilitiesAbstract","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_LiabilitiesAbstract","Name":"ifrs-full:NoncurrentLiabilitiesAbstract","Order":"19","Label":"Non-current liabilities [abstract]","Documentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentPayables","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentLiabilitiesAbstract","Name":"ifrs-full:NoncurrentPayables","Order":"20","Label":"Trade and other non-current payables","Documentation":"The amount of non-current trade payables and non-current other payables. [Refer: Other non-current payables; Non-current trade payables]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentLiabilities","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentLiabilitiesAbstract","Name":"ifrs-full:NoncurrentLiabilities","Order":"21","Label":"Total non-current liabilities","Documentation":"The amount of liabilities that do not meet the definition of current liabilities. [Refer: Current liabilities]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_Liabilities","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_LiabilitiesAbstract","Name":"ifrs-full:Liabilities","Order":"22","Label":"Total liabilities","Documentation":"The amount of a present obligation of the entity to transfer an economic resource as a result of past events. Economic resource is a right that has the potential to produce economic benefits.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NetAssetsLiabilities","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_StatementOfFinancialPositionAbstract","Name":"ifrs-full:NetAssetsLiabilities","Order":"23","Label":"Assets (liabilities)","Documentation":"The amount of assets less the amount of liabilities.","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_EquityAbstract","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_StatementOfFinancialPositionAbstract","Name":"ifrs-full:EquityAbstract","Order":"24","Label":"Equity [abstract]","Documentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_IssuedCapital","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_EquityAbstract","Name":"ifrs-full:IssuedCapital","Order":"25","Label":"Issued capital","Documentation":"The nominal value of capital issued.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_SharePremium","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_EquityAbstract","Name":"ifrs-full:SharePremium","Order":"26","Label":"Share premium","Documentation":"The amount received or receivable from the issuance of the entity's shares in excess of nominal value.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_RetainedEarnings","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_EquityAbstract","Name":"ifrs-full:RetainedEarnings","Order":"27","Label":"Retained earnings","Documentation":"A component of equity representing the entity's cumulative undistributed earnings or deficit.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_Equity","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_EquityAbstract","Name":"ifrs-full:Equity","Order":"28","Label":"Total equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"http://awilcodrilling.com/role/GroupStatementOfChangesInEquity","ParentId":"","Name":"1003 - Statement - Group statement of changes in equity","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityAbstract","ParentId":"http://awilcodrilling.com/role/GroupStatementOfChangesInEquity","Name":"ifrs-full:StatementOfChangesInEquityAbstract","Order":"","Label":"Statement of changes in equity placeholder - this item MUST be used as a starting point for the statement of changes in equity","Documentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityTable","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityAbstract","Name":"ifrs-full:StatementOfChangesInEquityTable","Order":"1","Label":"Statement of changes in equity [table]","Documentation":"Schedule disclosing information related to changes in equity.","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrldt:hypercubeItem","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_ComponentsOfEquityAxis","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityTable","Name":"ifrs-full:ComponentsOfEquityAxis","Order":"2","Label":"Components of equity [axis]","Documentation":"The axis of a table defines the relationship between the members in the table and the line items or concepts that complete the table.","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrldt:dimensionItem","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_EquityMember","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_ComponentsOfEquityAxis","Name":"ifrs-full:EquityMember","Order":"3","Label":"Equity [member]","Documentation":"This member stands for the residual interest in the assets of the entity after deducting all its liabilities. It also represents the standard value for the 'Components of equity' axis if no other member is used.","PeriodType":"duration","Balance":"0","Type":"nonnum:domainItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_IssuedCapitalMember","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_EquityMember","Name":"ifrs-full:IssuedCapitalMember","Order":"4","Label":"Issued capital [member]","Documentation":"This member stands for a component of equity representing issued capital.","PeriodType":"duration","Balance":"0","Type":"nonnum:domainItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_SharePremiumMember","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_EquityMember","Name":"ifrs-full:SharePremiumMember","Order":"5","Label":"Share premium [member]","Documentation":"This member stands for the amount received or receivable from issuance of the entity's shares in excess of nominal value.","PeriodType":"duration","Balance":"0","Type":"nonnum:domainItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_RetainedEarningsMember","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_EquityMember","Name":"ifrs-full:RetainedEarningsMember","Order":"6","Label":"Retained earnings [member]","Documentation":"This member stands for a component of equity representing an entity's cumulative undistributed earnings or deficit.","PeriodType":"duration","Balance":"0","Type":"nonnum:domainItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityLineItems","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityTable","Name":"ifrs-full:StatementOfChangesInEquityLineItems","Order":"7","Label":"Statement of changes in equity [line items]","Documentation":"Line items represent concepts included in a table. These concepts are used to disclose reportable information associated with members defined in one or many axes of the table.","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_Equity","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityLineItems","Name":"ifrs-full:Equity","Order":"8","Label":"Equity at beginning of period","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"periodStartLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_IssueOfEquity","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityLineItems","Name":"ifrs-full:IssueOfEquity","Order":"9","Label":"Issue of equity","Documentation":"The increase in equity through the issue of equity instruments.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_ShareIssueRelatedCost","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityLineItems","Name":"ifrs-full:ShareIssueRelatedCost","Order":"10","Label":"Share issue related cost","Documentation":"The amount of cost related to the issuance of shares.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_ComprehensiveIncome","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityLineItems","Name":"ifrs-full:ComprehensiveIncome","Order":"11","Label":"Total comprehensive income","Documentation":"The amount of change in equity resulting from transactions and other events, other than those changes resulting from transactions with owners in their capacity as owners.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfChangesInEquity_loc_ifrs-full_Equity","ParentId":"GroupStatementOfChangesInEquity_loc_ifrs-full_StatementOfChangesInEquityLineItems","Name":"ifrs-full:Equity","Order":"12","Label":"Equity at end of period","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"periodEndLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"http://awilcodrilling.com/role/GroupStatementOfCashFlows","ParentId":"","Name":"1004 - Statement - Group statement of cash flows","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_StatementOfCashFlowsAbstract","ParentId":"http://awilcodrilling.com/role/GroupStatementOfCashFlows","Name":"ifrs-full:StatementOfCashFlowsAbstract","Order":"","Label":"Statement of cash flows placeholder - this item MUST be used as a starting point for the statement of cash flows","Documentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_StatementOfCashFlowsAbstract","Name":"ifrs-full:CashFlowsFromUsedInOperatingActivitiesAbstract","Order":"1","Label":"Cash flows from (used in) operating activities [abstract]","Documentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_ProfitLossBeforeTax","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract","Name":"ifrs-full:ProfitLossBeforeTax","Order":"2","Label":"Profit (loss) before tax","Documentation":"The profit (loss) before tax expense or income. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForReconcileProfitLossAbstract","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract","Name":"ifrs-full:AdjustmentsForReconcileProfitLossAbstract","Order":"3","Label":"Adjustments to reconcile profit (loss) [abstract]","Documentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForDepreciationExpense","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForReconcileProfitLossAbstract","Name":"ifrs-full:AdjustmentsForDepreciationExpense","Order":"4","Label":"Adjustments for depreciation expense","Documentation":"Adjustments for depreciation expense to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForReconcileProfitLossAbstract","Name":"ifrs-full:AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","Order":"5","Label":"Adjustments for impairment loss (reversal of impairment loss) recognised in profit or loss","Documentation":"Adjustments for impairment loss (reversal of impairment loss) recognised in profit or loss to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Impairment loss (reversal of impairment loss) recognised in profit or loss]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_awlcf_AdjustmentsForInventoryWriteOff","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForReconcileProfitLossAbstract","Name":"awlcf:AdjustmentsForInventoryWriteOff","Order":"6","Label":"Adjustments For Inventory Write Off","Documentation":"Adjustments For Inventory Write Off.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"false","Nillable":"true","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":1},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForFinanceIncomeCost","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForReconcileProfitLossAbstract","Name":"ifrs-full:AdjustmentsForFinanceIncomeCost","Order":"7","Label":"Adjustments for finance income (cost)","Documentation":"Adjustments for net finance income or cost to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Finance income (cost); Profit (loss)]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForSharebasedPayments","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForReconcileProfitLossAbstract","Name":"ifrs-full:AdjustmentsForSharebasedPayments","Order":"8","Label":"Adjustments for share-based payments","Documentation":"Adjustments for share-based payments to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForGainLossOnDisposalsPropertyPlantAndEquipment","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForReconcileProfitLossAbstract","Name":"ifrs-full:AdjustmentsForGainLossOnDisposalsPropertyPlantAndEquipment","Order":"9","Label":"Adjustments for gain (loss) on disposals, property, plant and equipment","Documentation":"Adjustments for gain (loss) on disposals of property, plant and equipment to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss); Property, plant and equipment; Disposals, property, plant and equipment]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForDecreaseIncreaseInTradeAndOtherReceivables","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract","Name":"ifrs-full:AdjustmentsForDecreaseIncreaseInTradeAndOtherReceivables","Order":"10","Label":"Adjustments for decrease (increase) in trade and other receivables","Documentation":"Adjustments for decrease (increase) in trade and other receivables to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Trade and other receivables; Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForDecreaseIncreaseInInventories","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract","Name":"ifrs-full:AdjustmentsForDecreaseIncreaseInInventories","Order":"11","Label":"Adjustments for decrease (increase) in inventories","Documentation":"Adjustments for decrease (increase) in inventories to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Inventories; Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForDecreaseIncreaseInOtherOperatingReceivables","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract","Name":"ifrs-full:AdjustmentsForDecreaseIncreaseInOtherOperatingReceivables","Order":"12","Label":"Adjustments for decrease (increase) in other operating receivables","Documentation":"Adjustments for decrease (increase) in other operating receivables to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForIncreaseDecreaseInTradeAccountPayable","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract","Name":"ifrs-full:AdjustmentsForIncreaseDecreaseInTradeAccountPayable","Order":"13","Label":"Adjustments for increase (decrease) in trade accounts payable","Documentation":"Adjustments for increase (decrease) in trade accounts payable to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_InterestPaidClassifiedAsOperatingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract","Name":"ifrs-full:InterestPaidClassifiedAsOperatingActivities","Order":"14","Label":"Interest paid, classified as operating activities","Documentation":"The cash outflow for interest paid, classified as operating activities.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_InterestReceivedClassifiedAsOperatingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract","Name":"ifrs-full:InterestReceivedClassifiedAsOperatingActivities","Order":"15","Label":"Interest received, classified as operating activities","Documentation":"The cash inflow from interest received, classified as operating activities.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_IncomeTaxesPaidClassifiedAsOperatingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract","Name":"ifrs-full:IncomeTaxesPaidClassifiedAsOperatingActivities","Order":"16","Label":"Income taxes paid, classified as operating activities","Documentation":"The cash outflow for income taxes paid, classified as operating activities.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivitiesAbstract","Name":"ifrs-full:CashFlowsFromUsedInOperatingActivities","Order":"17","Label":"Net cash flows from (used in) operating activities","Documentation":"The cash flows from (used in) operating activities, which are the principal revenue-producing activities of the entity and other activities that are not investing or financing activities. [Refer: Revenue]","PeriodType":"duration","Balance":"0","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInInvestingActivitiesAbstract","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_StatementOfCashFlowsAbstract","Name":"ifrs-full:CashFlowsFromUsedInInvestingActivitiesAbstract","Order":"18","Label":"Cash flows from (used in) investing activities [abstract]","Documentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_PurchaseOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInInvestingActivitiesAbstract","Name":"ifrs-full:PurchaseOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","Order":"19","Label":"Purchase of property, plant and equipment, classified as investing activities","Documentation":"The cash outflow for the purchases of property, plant and equipment, classified as investing activities. [Refer: Property, plant and equipment]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_ProceedsFromSalesOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInInvestingActivitiesAbstract","Name":"ifrs-full:ProceedsFromSalesOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","Order":"20","Label":"Proceeds from sales of property, plant and equipment, classified as investing activities","Documentation":"The cash inflow from sales of property, plant and equipment, classified as investing activities. [Refer: Property, plant and equipment]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInInvestingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInInvestingActivitiesAbstract","Name":"ifrs-full:CashFlowsFromUsedInInvestingActivities","Order":"21","Label":"Net cash flows from (used in) investing activities","Documentation":"The cash flows from (used in) investing activities, which are the acquisition and disposal of long-term assets and other investments not included in cash equivalents.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivitiesAbstract","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_StatementOfCashFlowsAbstract","Name":"ifrs-full:CashFlowsFromUsedInFinancingActivitiesAbstract","Order":"22","Label":"Cash flows from (used in) financing activities [abstract]","Documentation":"","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_ProceedsFromIssuingShares","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivitiesAbstract","Name":"ifrs-full:ProceedsFromIssuingShares","Order":"23","Label":"Proceeds from issuing shares","Documentation":"The cash inflow from issuing shares.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_PaymentsForShareIssueCosts","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivitiesAbstract","Name":"ifrs-full:PaymentsForShareIssueCosts","Order":"24","Label":"Payments for share issue costs","Documentation":"The cash outflow for share issue costs.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_ProceedsFromBorrowingsClassifiedAsFinancingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivitiesAbstract","Name":"ifrs-full:ProceedsFromBorrowingsClassifiedAsFinancingActivities","Order":"25","Label":"Proceeds from borrowings, classified as financing activities","Documentation":"The cash inflow from borrowings obtained. [Refer: Borrowings]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_PaymentsOfLeaseLiabilitiesClassifiedAsFinancingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivitiesAbstract","Name":"ifrs-full:PaymentsOfLeaseLiabilitiesClassifiedAsFinancingActivities","Order":"26","Label":"Payments of lease liabilities, classified as financing activities","Documentation":"The cash outflow for payment of lease liabilities, classified as financing activities. [Refer: Lease liabilities]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"negatedLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivitiesAbstract","Name":"ifrs-full:CashFlowsFromUsedInFinancingActivities","Order":"27","Label":"Net cash flows from (used in) financing activities","Documentation":"The cash flows from (used in) financing activities, which are activities that result in changes in the size and composition of the contributed equity and borrowings of the entity.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_IncreaseDecreaseInCashAndCashEquivalents","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_StatementOfCashFlowsAbstract","Name":"ifrs-full:IncreaseDecreaseInCashAndCashEquivalents","Order":"28","Label":"Net increase (decrease) in cash and cash equivalents","Documentation":"The increase (decrease) in cash and cash equivalents after the effect of exchange rate changes on cash and cash equivalents held in foreign currencies. [Refer: Cash and cash equivalents; Effect of exchange rate changes on cash and cash equivalents]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"totalLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_EffectOfExchangeRateChangesOnCashAndCashEquivalents","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_StatementOfCashFlowsAbstract","Name":"ifrs-full:EffectOfExchangeRateChangesOnCashAndCashEquivalents","Order":"29","Label":"Effect of exchange rate changes on cash and cash equivalents","Documentation":"The effect of exchange rate changes on cash and cash equivalents held or due in a foreign currency. [Refer: Cash and cash equivalents]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashAndCashEquivalents","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_StatementOfCashFlowsAbstract","Name":"ifrs-full:CashAndCashEquivalents","Order":"30","Label":"Cash and cash equivalents at beginning of period","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"periodStartLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashAndCashEquivalents","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_StatementOfCashFlowsAbstract","Name":"ifrs-full:CashAndCashEquivalents","Order":"31","Label":"Cash and cash equivalents at end of period","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"periodEndLabel","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"http://awilcodrilling.com/role/TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport","ParentId":"","Name":"1005 - Disclosure - Tags that must be applied if corresponding information is present in a report","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","ParentId":"http://awilcodrilling.com/role/TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport","Name":"esef_cor:NotesAccountingPoliciesAndMandatoryTags","Order":"","Label":"Notes, accounting policies and mandatory tags – this item MUST be used as a starting point for markups of disclosures in the notes to the financial statements","Documentation":"","PeriodType":"instant","Balance":"","Type":"xbrli:stringItemType","AbstractText":"TRUE","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","PreferredLabel":"","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_NameOfReportingEntityOrOtherMeansOfIdentification","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:NameOfReportingEntityOrOtherMeansOfIdentification","Order":"1","Label":"Name of reporting entity or other means of identification","Documentation":"The name of the reporting entity or other means of identification.","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_PrincipalPlaceOfBusiness","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:PrincipalPlaceOfBusiness","Order":"2","Label":"Principal place of business","Documentation":"The place where an entity principally conducts operations.","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_AddressOfRegisteredOfficeOfEntity","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:AddressOfRegisteredOfficeOfEntity","Order":"3","Label":"Address of entity's registered office","Documentation":"The address at which the entity's office is registered.","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_NameOfParentEntity","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:NameOfParentEntity","Order":"4","Label":"Name of parent entity","Documentation":"The name of the entity's parent. [Refer: Parent [member]]","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_CountryOfIncorporation","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:CountryOfIncorporation","Order":"5","Label":"Country of incorporation","Documentation":"The country in which the entity is incorporated.","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfNatureOfEntitysOperationsAndPrincipalActivities","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfNatureOfEntitysOperationsAndPrincipalActivities","Order":"6","Label":"Description of nature of entity's operations and principal activities","Documentation":"The description of the nature of the entity's operations and principal activities.","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DateOfEndOfReportingPeriod2013","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DateOfEndOfReportingPeriod2013","Order":"7","Label":"Date of end of reporting period","Documentation":"The date of the end of the reporting period.","PeriodType":"duration","Balance":"0","Type":"xbrli:dateItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DomicileOfEntity","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DomicileOfEntity","Order":"8","Label":"Domicile of entity","Documentation":"The country of domicile of the entity. [Refer: Country of domicile [member]]","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_LegalFormOfEntity","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:LegalFormOfEntity","Order":"9","Label":"Legal form of entity","Documentation":"Information about the legal structure under which the entity operates.","PeriodType":"duration","Balance":"0","Type":"xbrli:stringItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfAuthorisationOfFinancialStatementsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfAuthorisationOfFinancialStatementsExplanatory","Order":"10","Label":"Disclosure of authorisation of financial statements [text block]","Documentation":"The disclosure of the authorisation of financial statements for issue.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfNotesAndOtherExplanatoryInformationExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfNotesAndOtherExplanatoryInformationExplanatory","Order":"11","Label":"Disclosure of notes and other explanatory information [text block]","Documentation":"The disclosure of notes and other explanatory information as part of a complete set of financial statements.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfGeneralInformationAboutFinancialStatementsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfGeneralInformationAboutFinancialStatementsExplanatory","Order":"12","Label":"Disclosure of general information about financial statements [text block]","Documentation":"The entire disclosure for general information about financial statements.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfBasisOfPreparationOfFinancialStatementsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfBasisOfPreparationOfFinancialStatementsExplanatory","Order":"13","Label":"Disclosure of basis of preparation of financial statements [text block]","Documentation":"The disclosure of the basis used for the preparation of the financial statements.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_StatementOfIFRSCompliance","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:StatementOfIFRSCompliance","Order":"14","Label":"Statement of IFRS compliance [text block]","Documentation":"An explicit and unreserved statement of compliance with all the requirements of IFRSs.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfGoingConcernExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfGoingConcernExplanatory","Order":"15","Label":"Disclosure of going concern [text block]","Documentation":"The disclosure of the entity's ability to continue as a going concern.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfBasisOfConsolidationExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfBasisOfConsolidationExplanatory","Order":"16","Label":"Disclosure of basis of consolidation [text block]","Documentation":"The disclosure of the basis used for consolidation.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfAccountingJudgementsAndEstimatesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfAccountingJudgementsAndEstimatesExplanatory","Order":"17","Label":"Disclosure of accounting judgements and estimates [text block]","Documentation":"The disclosure of judgements that management has made in the process of applying the entity's accounting policies that have the most significant effect on amounts recognised in the financial statements along with information about the assumptions that the entity makes about the future, and other major sources of estimation uncertainty at the end of the reporting period, that have a significant risk of resulting in a material adjustment to the carrying amounts of assets and liabilities within the next year. [Refer: Carrying amount [member]]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfSummaryOfSignificantAccountingPoliciesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfSummaryOfSignificantAccountingPoliciesExplanatory","Order":"18","Label":"Disclosure of significant accounting policies [text block]","Documentation":"The entire disclosure for significant accounting policies applied by the entity.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfRevenueExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfRevenueExplanatory","Order":"19","Label":"Disclosure of revenue [text block]","Documentation":"The entire disclosure for revenue.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfRevenueFromContractsWithCustomersExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfRevenueFromContractsWithCustomersExplanatory","Order":"20","Label":"Disclosure of revenue from contracts with customers [text block]","Documentation":"The entire disclosure for revenue from contracts with customers.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfProfitLossFromOperatingActivitiesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfProfitLossFromOperatingActivitiesExplanatory","Order":"21","Label":"Disclosure of profit (loss) from operating activities [text block]","Documentation":"The disclosure of profit (loss) from operating activities. [Refer: Profit (loss) from operating activities]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfOtherOperatingExpenseExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfOtherOperatingExpenseExplanatory","Order":"22","Label":"Disclosure of other operating expense [text block]","Documentation":"The disclosure of other operating expense. [Refer: Other operating income (expense)]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfAuditorsRemunerationExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfAuditorsRemunerationExplanatory","Order":"23","Label":"Disclosure of auditors' remuneration [text block]","Documentation":"The disclosure of compensation to the entity's auditors.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfEmployeeBenefitsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfEmployeeBenefitsExplanatory","Order":"24","Label":"Disclosure of employee benefits [text block]","Documentation":"The entire disclosure for employee benefits.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfInformationAboutEmployeesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfInformationAboutEmployeesExplanatory","Order":"25","Label":"Disclosure of information about employees [text block]","Documentation":"The disclosure of information about employees.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfFinanceIncomeExpenseExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfFinanceIncomeExpenseExplanatory","Order":"26","Label":"Disclosure of finance income (cost) [text block]","Documentation":"The disclosure of finance income (cost). [Refer: Finance income (cost)]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfFinanceIncomeExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfFinanceIncomeExplanatory","Order":"27","Label":"Disclosure of finance income [text block]","Documentation":"The disclosure of finance income. [Refer: Finance income]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfFinanceCostExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfFinanceCostExplanatory","Order":"28","Label":"Disclosure of finance cost [text block]","Documentation":"The disclosure of finance cost. [Refer: Finance costs]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfInterestIncomeExpenseExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfInterestIncomeExpenseExplanatory","Order":"29","Label":"Disclosure of interest income (expense) [text block]","Documentation":"The disclosure of interest income and expense. [Refer: Interest income (expense)]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfInterestIncomeExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfInterestIncomeExplanatory","Order":"30","Label":"Disclosure of interest income [text block]","Documentation":"The disclosure of interest income. [Refer: Interest income]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfInterestExpenseExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfInterestExpenseExplanatory","Order":"31","Label":"Disclosure of interest expense [text block]","Documentation":"The disclosure of interest expense. [Refer: Interest expense]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfEffectOfChangesInForeignExchangeRatesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfEffectOfChangesInForeignExchangeRatesExplanatory","Order":"32","Label":"Disclosure of effect of changes in foreign exchange rates [text block]","Documentation":"The entire disclosure for the effect of changes in foreign exchange rates.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfIncomeTaxExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfIncomeTaxExplanatory","Order":"33","Label":"Disclosure of income tax [text block]","Documentation":"The entire disclosure for income taxes.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfDeferredTaxesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfDeferredTaxesExplanatory","Order":"34","Label":"Disclosure of deferred taxes [text block]","Documentation":"The disclosure of deferred taxes. [Refer: Deferred tax liabilities; Deferred tax assets]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfEarningsPerShareExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfEarningsPerShareExplanatory","Order":"35","Label":"Disclosure of earnings per share [text block]","Documentation":"The entire disclosure for earnings per share.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfGovernmentGrantsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfGovernmentGrantsExplanatory","Order":"36","Label":"Disclosure of government grants [text block]","Documentation":"The entire disclosure for government grants.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfPropertyPlantAndEquipmentExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfPropertyPlantAndEquipmentExplanatory","Order":"37","Label":"Disclosure of property, plant and equipment [text block]","Documentation":"The entire disclosure for property, plant and equipment.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfDepreciationAndAmortisationExpenseExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfDepreciationAndAmortisationExpenseExplanatory","Order":"38","Label":"Disclosure of depreciation and amortisation expense [text block]","Documentation":"The disclosure of depreciation and amortisation expense. [Refer: Depreciation and amortisation expense]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfImpairmentOfAssetsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfImpairmentOfAssetsExplanatory","Order":"39","Label":"Disclosure of impairment of assets [text block]","Documentation":"The entire disclosure for the impairment of assets.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfInvestmentsAccountedForUsingEquityMethodExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfInvestmentsAccountedForUsingEquityMethodExplanatory","Order":"40","Label":"Disclosure of investments accounted for using equity method [text block]","Documentation":"The disclosure of investments accounted for using the equity method. [Refer: Investments accounted for using equity method]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfSignificantInvestmentsInSubsidiariesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfSignificantInvestmentsInSubsidiariesExplanatory","Order":"41","Label":"Disclosure of subsidiaries [text block]","Documentation":"The disclosure of subsidiaries. [Refer: Subsidiaries [member]]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfTradeAndOtherReceivablesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfTradeAndOtherReceivablesExplanatory","Order":"42","Label":"Disclosure of trade and other receivables [text block]","Documentation":"The disclosure of trade and other receivables. [Refer: Trade and other receivables]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfPrepaymentsAndOtherAssetsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfPrepaymentsAndOtherAssetsExplanatory","Order":"43","Label":"Disclosure of prepayments and other assets [text block]","Documentation":"The disclosure of prepayments and other assets. [Refer: Other assets; Prepayments]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfCashAndCashEquivalentsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfCashAndCashEquivalentsExplanatory","Order":"44","Label":"Disclosure of cash and cash equivalents [text block]","Documentation":"The disclosure of cash and cash equivalents. [Refer: Cash and cash equivalents]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfDepositsFromBanksExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfDepositsFromBanksExplanatory","Order":"45","Label":"Disclosure of deposits from banks [text block]","Documentation":"The disclosure of deposits from banks. [Refer: Deposits from banks]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfRestrictedCashAndCashEquivalentsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfRestrictedCashAndCashEquivalentsExplanatory","Order":"46","Label":"Disclosure of restricted cash and cash equivalents [text block]","Documentation":"The disclosure of restricted cash and cash equivalents. [Refer: Restricted cash and cash equivalents]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfTradeAndOtherPayablesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfTradeAndOtherPayablesExplanatory","Order":"47","Label":"Disclosure of trade and other payables [text block]","Documentation":"The disclosure of trade and other payables. [Refer: Trade and other payables]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfAccruedExpensesAndOtherLiabilitiesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfAccruedExpensesAndOtherLiabilitiesExplanatory","Order":"48","Label":"Disclosure of accrued expenses and other liabilities [text block]","Documentation":"The disclosure of accrued expenses and other liabilities. [Refer: Accruals; Other liabilities]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfProvisionsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfProvisionsExplanatory","Order":"49","Label":"Disclosure of provisions [text block]","Documentation":"The disclosure of provisions. [Refer: Provisions]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfLeasesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfLeasesExplanatory","Order":"50","Label":"Disclosure of leases [text block]","Documentation":"The entire disclosure for leases.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfCommitmentsAndContingentLiabilitiesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfCommitmentsAndContingentLiabilitiesExplanatory","Order":"51","Label":"Disclosure of commitments and contingent liabilities [text block]","Documentation":"The disclosure of commitments and contingent liabilities. [Refer: Contingent liabilities [member]]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfCommitmentsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfCommitmentsExplanatory","Order":"52","Label":"Disclosure of commitments [text block]","Documentation":"The disclosure of commitments.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfContingentLiabilitiesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfContingentLiabilitiesExplanatory","Order":"53","Label":"Disclosure of contingent liabilities [text block]","Documentation":"The disclosure of contingent liabilities. [Refer: Contingent liabilities [member]]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfOtherProvisionsContingentLiabilitiesAndContingentAssetsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfOtherProvisionsContingentLiabilitiesAndContingentAssetsExplanatory","Order":"54","Label":"Disclosure of other provisions, contingent liabilities and contingent assets [text block]","Documentation":"The entire disclosure for other provisions, contingent liabilities and contingent assets.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfShareCapitalReservesAndOtherEquityInterestExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfShareCapitalReservesAndOtherEquityInterestExplanatory","Order":"55","Label":"Disclosure of share capital, reserves and other equity interest [text block]","Documentation":"The entire disclosure for share capital, reserves and other equity interest.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfIssuedCapitalExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfIssuedCapitalExplanatory","Order":"56","Label":"Disclosure of issued capital [text block]","Documentation":"The disclosure of issued capital. [Refer: Issued capital]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfRelatedPartyExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfRelatedPartyExplanatory","Order":"57","Label":"Disclosure of related party [text block]","Documentation":"The entire disclosure for related parties.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfInformationAboutKeyManagementPersonnelExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfInformationAboutKeyManagementPersonnelExplanatory","Order":"58","Label":"Disclosure of information about key management personnel [text block]","Documentation":"The disclosure of information about key management personnel. [Refer: Key management personnel of entity or parent [member]]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfObjectivesPoliciesAndProcessesForManagingCapitalExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfObjectivesPoliciesAndProcessesForManagingCapitalExplanatory","Order":"59","Label":"Disclosure of objectives, policies and processes for managing capital [text block]","Documentation":"The disclosure of information that enables users of financial statements to evaluate the entity's objectives, policies and processes for managing capital.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfFinancialRiskManagementExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfFinancialRiskManagementExplanatory","Order":"60","Label":"Disclosure of financial risk management [text block]","Documentation":"The disclosure of the entity's financial risk management practices and policies.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfMarketRiskExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfMarketRiskExplanatory","Order":"61","Label":"Disclosure of market risk [text block]","Documentation":"The disclosure of market risk. [Refer: Market risk [member]]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfCreditRiskExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfCreditRiskExplanatory","Order":"62","Label":"Disclosure of credit risk [text block]","Documentation":"The disclosure of credit risk. [Refer: Credit risk [member]]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfLiquidityRiskExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfLiquidityRiskExplanatory","Order":"63","Label":"Disclosure of liquidity risk [text block]","Documentation":"The disclosure of liquidity risk. [Refer: Liquidity risk [member]]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfSharebasedPaymentArrangementsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfSharebasedPaymentArrangementsExplanatory","Order":"64","Label":"Disclosure of share-based payment arrangements [text block]","Documentation":"The entire disclosure for share-based payment arrangements.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfEventsAfterReportingPeriodExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfEventsAfterReportingPeriodExplanatory","Order":"65","Label":"Disclosure of events after reporting period [text block]","Documentation":"The entire disclosure for events after the reporting period.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyToDetermineComponentsOfCashAndCashEquivalents","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyToDetermineComponentsOfCashAndCashEquivalents","Order":"66","Label":"Description of accounting policy for determining components of cash and cash equivalents [text block]","Documentation":"The description of the entity's accounting policy used to determine the components of cash and cash equivalents. [Refer: Cash and cash equivalents]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForPropertyPlantAndEquipmentExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForPropertyPlantAndEquipmentExplanatory","Order":"67","Label":"Description of accounting policy for property, plant and equipment [text block]","Documentation":"The description of the entity's accounting policy for property, plant and equipment. [Refer: Property, plant and equipment]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForDepreciationExpenseExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForDepreciationExpenseExplanatory","Order":"68","Label":"Description of accounting policy for depreciation expense [text block]","Documentation":"The description of the entity's accounting policy for depreciation expense. [Refer: Depreciation and amortisation expense]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForMeasuringInventories","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForMeasuringInventories","Order":"69","Label":"Description of accounting policy for measuring inventories [text block]","Documentation":"The description of the entity's accounting policy for measuring inventories. [Refer: Inventories]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForRecognitionOfRevenue","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForRecognitionOfRevenue","Order":"70","Label":"Description of accounting policy for recognition of revenue [text block]","Documentation":"The description of the entity's accounting policy for recognising revenue. [Refer: Revenue]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForFeeAndCommissionIncomeAndExpenseExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForFeeAndCommissionIncomeAndExpenseExplanatory","Order":"71","Label":"Description of accounting policy for fee and commission income and expense [text block]","Documentation":"The description of the entity's accounting policy for fee and commission income and expense. [Refer: Fee and commission income (expense)]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfCostOfSalesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfCostOfSalesExplanatory","Order":"72","Label":"Disclosure of cost of sales [text block]","Documentation":"The disclosure of the cost of sales. [Refer: Cost of sales]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForIncomeTaxExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForIncomeTaxExplanatory","Order":"73","Label":"Description of accounting policy for income tax [text block]","Documentation":"The description of the entity's accounting policy for income tax.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForDeferredIncomeTaxExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForDeferredIncomeTaxExplanatory","Order":"74","Label":"Description of accounting policy for deferred income tax [text block]","Documentation":"The description of the entity's accounting policy for deferred income tax. [Refer: Deferred tax expense (income)]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForForeignCurrencyTranslationExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForForeignCurrencyTranslationExplanatory","Order":"75","Label":"Description of accounting policy for foreign currency translation [text block]","Documentation":"The description of the entity's accounting policy for foreign currency translation.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForFunctionalCurrencyExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForFunctionalCurrencyExplanatory","Order":"76","Label":"Description of accounting policy for functional currency [text block]","Documentation":"The description of the entity's accounting policy for the currency of the primary economic environment in which the entity operates.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForEarningsPerShareExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForEarningsPerShareExplanatory","Order":"77","Label":"Description of accounting policy for earnings per share [text block]","Documentation":"The description of the entity's accounting policy for earnings per share.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForLeasesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForLeasesExplanatory","Order":"78","Label":"Description of accounting policy for leases [text block]","Documentation":"The description of the entity's accounting policy for leases. A lease is an agreement whereby the lessor conveys to the lessee in return for a payment or series of payments the right to use an asset for an agreed period of time.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfQuantitativeInformationAboutRightofuseAssetsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfQuantitativeInformationAboutRightofuseAssetsExplanatory","Order":"79","Label":"Disclosure of quantitative information about right-of-use assets [text block]","Documentation":"The disclosure of quantitative information about right-of-use assets. [Refer: Right-of-use assets]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForFinancialAssetsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForFinancialAssetsExplanatory","Order":"80","Label":"Description of accounting policy for financial assets [text block]","Documentation":"The description of the entity's accounting policy for financial assets. [Refer: Financial assets]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForImpairmentOfFinancialAssetsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForImpairmentOfFinancialAssetsExplanatory","Order":"81","Label":"Description of accounting policy for impairment of financial assets [text block]","Documentation":"The description of the entity's accounting policy for the impairment of financial assets. [Refer: Financial assets]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfAllowanceForCreditLossesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfAllowanceForCreditLossesExplanatory","Order":"82","Label":"Disclosure of allowance for credit losses [text block]","Documentation":"The disclosure of the allowance relating to impairments of financial assets due to credit losses. [Refer: Financial assets]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForTradeAndOtherReceivablesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForTradeAndOtherReceivablesExplanatory","Order":"83","Label":"Description of accounting policy for trade and other receivables [text block]","Documentation":"The description of the entity's accounting policy for trade and other receivables. [Refer: Trade and other receivables]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForTradeAndOtherPayablesExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForTradeAndOtherPayablesExplanatory","Order":"84","Label":"Description of accounting policy for trade and other payables [text block]","Documentation":"The description of the entity's accounting policy for trade and other payables. [Refer: Trade and other payables]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForDerecognitionOfFinancialInstrumentsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForDerecognitionOfFinancialInstrumentsExplanatory","Order":"85","Label":"Description of accounting policy for derecognition of financial instruments [text block]","Documentation":"The description of the entity's accounting policy for the derecognition of financial instruments. [Refer: Financial instruments, class [member]]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForSharebasedPaymentTransactionsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForSharebasedPaymentTransactionsExplanatory","Order":"86","Label":"Description of accounting policy for share-based payment transactions [text block]","Documentation":"The description of the entity's accounting policy for transactions in which the entity: (a) receives goods or services from the supplier of those goods or services (including an employee) in a share-based payment arrangement; or (b) incurs an obligation to settle the transaction with the supplier in a share-based payment arrangement when another group entity receives those goods or services. [Refer: Share-based payment arrangements [member]]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForEmployeeBenefitsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForEmployeeBenefitsExplanatory","Order":"87","Label":"Description of accounting policy for employee benefits [text block]","Documentation":"The description of the entity's accounting policy for employee benefits. Employee benefits are all forms of consideration given by an entity in exchange for services rendered by employees or for the termination of employment.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DescriptionOfAccountingPolicyForGovernmentGrants","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DescriptionOfAccountingPolicyForGovernmentGrants","Order":"88","Label":"Description of accounting policy for government grants [text block]","Documentation":"The description of the entity's accounting policy for government grants, including the methods of presentation adopted in the financial statements. [Refer: Government [member]; Government grants]","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_ifrs-full_DisclosureOfConsolidatedAndSeparateFinancialStatementsExplanatory","ParentId":"TagsThatMustBeAppliedIfCorrespondingInformationIsPresentInAReport_loc_esef_cor_NotesAccountingPoliciesAndMandatoryTags","Name":"ifrs-full:DisclosureOfConsolidatedAndSeparateFinancialStatementsExplanatory","Order":"89","Label":"Disclosure of separate financial statements [text block]","Documentation":"The entire disclosure for separate financial statements.","PeriodType":"duration","Balance":"0","Type":"nonnum:textBlockItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","PreferredLabel":"label","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0}];
  $scope.calculationData = [{"Id":"http://awilcodrilling.com/role/GroupStatementOfComprehensiveIncome","ParentId":"","Name":"1001 - Statement - Group statement of comprehensive income","Weight":"","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLoss","ParentId":"http://awilcodrilling.com/role/GroupStatementOfComprehensiveIncome","Name":"ifrs-full:ProfitLoss","Weight":"","Order":"","Label":"Profit (loss)","Documentation":"The total of income less expenses from continuing and discontinued operations, excluding the components of other comprehensive income. [Refer: Other comprehensive income]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossBeforeTax","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLoss","Name":"ifrs-full:ProfitLossBeforeTax","Weight":"1","Order":"1","Label":"Profit (loss) before tax","Documentation":"The profit (loss) before tax expense or income. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossFromOperatingActivities","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossBeforeTax","Name":"ifrs-full:ProfitLossFromOperatingActivities","Weight":"1","Order":"2","Label":"Profit (loss) from operating activities","Documentation":"The profit (loss) from operating activities of the entity. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GrossProfit","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossFromOperatingActivities","Name":"ifrs-full:GrossProfit","Weight":"1","Order":"3","Label":"Gross profit","Documentation":"The amount of revenue less cost of sales. [Refer: Cost of sales; Revenue]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_Revenue","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GrossProfit","Name":"ifrs-full:Revenue","Weight":"1","Order":"4","Label":"Revenue","Documentation":"The income arising in the course of an entity's ordinary activities. Income is increases in assets, or decreases in liabilities, that result in increases in equity, other than those relating to contributions from holders of equity claims.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_CostOfSales","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GrossProfit","Name":"ifrs-full:CostOfSales","Weight":"-1","Order":"5","Label":"Cost of sales","Documentation":"The amount of all expenses directly or indirectly attributed to the goods or services sold. Attributed expenses include, but are not limited to, costs previously included in the measurement of inventory that has now been sold, such as depreciation and maintenance of factory buildings and equipment used in the production process, unallocated production overheads, and abnormal amounts of production costs of inventories.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ImpairmentLoss","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GrossProfit","Name":"ifrs-full:ImpairmentLoss","Weight":"-1","Order":"6","Label":"Impairment loss","Documentation":"The amount recognised as a reduction of the carrying amount of an asset or cash-generating unit to its recoverable amount. [Refer: Carrying amount [member]]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GainsOnDisposalsOfPropertyPlantAndEquipment","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GrossProfit","Name":"ifrs-full:GainsOnDisposalsOfPropertyPlantAndEquipment","Weight":"1","Order":"7","Label":"Gains on disposals of property, plant and equipment","Documentation":"The gain on the disposal of property, plant and equipment. [Refer: Property, plant and equipment]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GeneralAndAdministrativeExpense","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossFromOperatingActivities","Name":"ifrs-full:GeneralAndAdministrativeExpense","Weight":"-1","Order":"8","Label":"General and administrative expense","Documentation":"The amount of expense relating to general and administrative activities of the entity.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_OtherExpenseByFunction","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossFromOperatingActivities","Name":"ifrs-full:OtherExpenseByFunction","Weight":"-1","Order":"9","Label":"Other expense, by function","Documentation":"The amount of expenses that the entity does not separately disclose in the same statement or note when the entity uses the 'function of expense' form for its analysis of expenses.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_FinanceIncome","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossBeforeTax","Name":"ifrs-full:FinanceIncome","Weight":"1","Order":"10","Label":"Finance income","Documentation":"The amount of income associated with interest and other financing activities of the entity.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_FinanceCosts","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossBeforeTax","Name":"ifrs-full:FinanceCosts","Weight":"-1","Order":"11","Label":"Finance costs","Documentation":"The amount of costs associated with financing activities of the entity.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_GainsLossesOnExchangeDifferencesOnTranslationRecognisedInProfitOrLoss","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLossBeforeTax","Name":"ifrs-full:GainsLossesOnExchangeDifferencesOnTranslationRecognisedInProfitOrLoss","Weight":"1","Order":"12","Label":"Foreign exchange gain (loss)","Documentation":"The amount of exchange differences recognised in profit or loss that arise from foreign currency transactions, excluding those arising on financial instruments measured at fair value through profit or loss in accordance with IFRS 9. [Refer: At fair value [member]; Financial instruments, class [member]]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_IncomeTaxExpenseContinuingOperations","ParentId":"GroupStatementOfComprehensiveIncome_loc_ifrs-full_ProfitLoss","Name":"ifrs-full:IncomeTaxExpenseContinuingOperations","Weight":"-1","Order":"13","Label":"Tax expense (income)","Documentation":"The aggregate amount included in the determination of profit (loss) for the period in respect of current tax and deferred tax. [Refer: Current tax expense (income); Deferred tax expense (income)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"http://awilcodrilling.com/role/GroupStatementOfFinancialPosition","ParentId":"","Name":"1002 - Statement - Group statement of financial position","Weight":"","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_Equity","ParentId":"http://awilcodrilling.com/role/GroupStatementOfFinancialPosition","Name":"ifrs-full:Equity","Weight":"","Order":"","Label":"Equity","Documentation":"The amount of residual interest in the assets of the entity after deducting all its liabilities.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_IssuedCapital","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_Equity","Name":"ifrs-full:IssuedCapital","Weight":"1","Order":"1","Label":"Issued capital","Documentation":"The nominal value of capital issued.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_SharePremium","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_Equity","Name":"ifrs-full:SharePremium","Weight":"1","Order":"2","Label":"Share premium","Documentation":"The amount received or receivable from the issuance of the entity's shares in excess of nominal value.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_RetainedEarnings","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_Equity","Name":"ifrs-full:RetainedEarnings","Weight":"1","Order":"3","Label":"Retained earnings","Documentation":"A component of equity representing the entity's cumulative undistributed earnings or deficit.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NetAssetsLiabilities","ParentId":"http://awilcodrilling.com/role/GroupStatementOfFinancialPosition","Name":"ifrs-full:NetAssetsLiabilities","Weight":"","Order":"","Label":"Assets (liabilities)","Documentation":"The amount of assets less the amount of liabilities.","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_Assets","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NetAssetsLiabilities","Name":"ifrs-full:Assets","Weight":"1","Order":"4","Label":"Assets","Documentation":"The amount of a present economic resource controlled by the entity as a result of past events. Economic resource is a right that has the potential to produce economic benefits.","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssets","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_Assets","Name":"ifrs-full:NoncurrentAssets","Weight":"1","Order":"5","Label":"Non-current assets","Documentation":"The amount of assets that do not meet the definition of current assets. [Refer: Current assets]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_PropertyPlantAndEquipment","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssets","Name":"ifrs-full:PropertyPlantAndEquipment","Weight":"1","Order":"6","Label":"Property, plant and equipment","Documentation":"The amount of tangible assets that: (a) are held for use in the production or supply of goods or services, for rental to others, or for administrative purposes; and (b) are expected to be used during more than one period.","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_RightofuseAssets","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentAssets","Name":"ifrs-full:RightofuseAssets","Weight":"1","Order":"7","Label":"Right-of-use assets","Documentation":"The amount of assets that represent a lessee's right to use an underlying asset for the lease term. Underlying asset is an asset that is the subject of a lease, for which the right to use that asset has been provided by a lessor to a lessee.","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssets","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_Assets","Name":"ifrs-full:CurrentAssets","Weight":"1","Order":"8","Label":"Current assets","Documentation":"The amount of assets that the entity (a) expects to realise or intends to sell or consume in its normal operating cycle; (b) holds primarily for the purpose of trading; (c) expects to realise within twelve months after the reporting period; or (d) classifies as cash or cash equivalents (as defined in IAS 7) unless the asset is restricted from being exchanged or used to settle a liability for at least twelve months after the reporting period. [Refer: Assets]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_Inventories","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssets","Name":"ifrs-full:Inventories","Weight":"1","Order":"9","Label":"Current inventories","Documentation":"The amount of current inventories. [Refer: Inventories]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_TradeAndOtherCurrentReceivables","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssets","Name":"ifrs-full:TradeAndOtherCurrentReceivables","Weight":"1","Order":"10","Label":"Trade and other current receivables","Documentation":"The amount of current trade receivables and current other receivables. [Refer: Current trade receivables; Other current receivables]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CashAndCashEquivalents","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentAssets","Name":"ifrs-full:CashAndCashEquivalents","Weight":"1","Order":"11","Label":"Cash and cash equivalents","Documentation":"The amount of cash on hand and demand deposits, along with short-term, highly liquid investments that are readily convertible to known amounts of cash and that are subject to an insignificant risk of changes in value. [Refer: Cash; Cash equivalents]","PeriodType":"instant","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_Liabilities","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NetAssetsLiabilities","Name":"ifrs-full:Liabilities","Weight":"-1","Order":"12","Label":"Liabilities","Documentation":"The amount of a present obligation of the entity to transfer an economic resource as a result of past events. Economic resource is a right that has the potential to produce economic benefits.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilities","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_Liabilities","Name":"ifrs-full:CurrentLiabilities","Weight":"1","Order":"13","Label":"Current liabilities","Documentation":"Expiry date 2023-01-01: The amount of liabilities that: (a) the entity expects to settle in its normal operating cycle; (b) the entity holds primarily for the purpose of trading; (c) are due to be settled within twelve months after the reporting period; or (d) the entity does not have an unconditional right to defer settlement for at least twelve months after the reporting period.\r\nEffective 2023-01-01: The amount of liabilities that: (a) the entity expects to settle in its normal operating cycle; (b) the entity holds primarily for the purpose of trading; (c) are due to be settled within twelve months after the reporting period; or (d) the entity does not have the right at the end of the reporting period to defer settlement for at least twelve months after the reporting period.","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_TradeAndOtherCurrentPayables","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilities","Name":"ifrs-full:TradeAndOtherCurrentPayables","Weight":"1","Order":"14","Label":"Trade and other current payables","Documentation":"The amount of current trade payables and current other payables. [Refer: Current trade payables; Other current payables]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentProvisions","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilities","Name":"ifrs-full:CurrentProvisions","Weight":"1","Order":"15","Label":"Current provisions","Documentation":"The amount of current provisions, including provisions for employee benefits. [Refer: Provisions]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_ShorttermBorrowings","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilities","Name":"ifrs-full:ShorttermBorrowings","Weight":"1","Order":"16","Label":"Current borrowings","Documentation":"The amount of current borrowings. [Refer: Borrowings]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentTaxLiabilitiesCurrent","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_CurrentLiabilities","Name":"ifrs-full:CurrentTaxLiabilitiesCurrent","Weight":"1","Order":"17","Label":"Current tax liabilities, current","Documentation":"The current amount of current tax liabilities. [Refer: Current tax liabilities]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentLiabilities","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_Liabilities","Name":"ifrs-full:NoncurrentLiabilities","Weight":"1","Order":"18","Label":"Non-current liabilities","Documentation":"The amount of liabilities that do not meet the definition of current liabilities. [Refer: Current liabilities]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentPayables","ParentId":"GroupStatementOfFinancialPosition_loc_ifrs-full_NoncurrentLiabilities","Name":"ifrs-full:NoncurrentPayables","Weight":"1","Order":"19","Label":"Trade and other non-current payables","Documentation":"The amount of non-current trade payables and non-current other payables. [Refer: Other non-current payables; Non-current trade payables]","PeriodType":"instant","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"http://awilcodrilling.com/role/GroupStatementOfCashFlows","ParentId":"","Name":"1004 - Statement - Group statement of cash flows","Weight":"","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_IncreaseDecreaseInCashAndCashEquivalents","ParentId":"http://awilcodrilling.com/role/GroupStatementOfCashFlows","Name":"ifrs-full:IncreaseDecreaseInCashAndCashEquivalents","Weight":"","Order":"","Label":"Increase (decrease) in cash and cash equivalents after effect of exchange rate changes","Documentation":"The increase (decrease) in cash and cash equivalents after the effect of exchange rate changes on cash and cash equivalents held in foreign currencies. [Refer: Cash and cash equivalents; Effect of exchange rate changes on cash and cash equivalents]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInInvestingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_IncreaseDecreaseInCashAndCashEquivalents","Name":"ifrs-full:CashFlowsFromUsedInInvestingActivities","Weight":"1","Order":"1","Label":"Cash flows from (used in) investing activities","Documentation":"The cash flows from (used in) investing activities, which are the acquisition and disposal of long-term assets and other investments not included in cash equivalents.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_PurchaseOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInInvestingActivities","Name":"ifrs-full:PurchaseOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","Weight":"-1","Order":"2","Label":"Purchase of property, plant and equipment, classified as investing activities","Documentation":"The cash outflow for the purchases of property, plant and equipment, classified as investing activities. [Refer: Property, plant and equipment]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_ProceedsFromSalesOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInInvestingActivities","Name":"ifrs-full:ProceedsFromSalesOfPropertyPlantAndEquipmentClassifiedAsInvestingActivities","Weight":"1","Order":"3","Label":"Proceeds from sales of property, plant and equipment, classified as investing activities","Documentation":"The cash inflow from sales of property, plant and equipment, classified as investing activities. [Refer: Property, plant and equipment]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_IncreaseDecreaseInCashAndCashEquivalents","Name":"ifrs-full:CashFlowsFromUsedInOperatingActivities","Weight":"1","Order":"4","Label":"Cash flows from (used in) operating activities","Documentation":"The cash flows from (used in) operating activities, which are the principal revenue-producing activities of the entity and other activities that are not investing or financing activities. [Refer: Revenue]","PeriodType":"duration","Balance":"0","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_ProfitLossBeforeTax","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:ProfitLossBeforeTax","Weight":"1","Order":"5","Label":"Profit (loss) before tax","Documentation":"The profit (loss) before tax expense or income. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForDepreciationExpense","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForDepreciationExpense","Weight":"1","Order":"6","Label":"Adjustments for depreciation expense","Documentation":"Adjustments for depreciation expense to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","Weight":"1","Order":"7","Label":"Adjustments for impairment loss (reversal of impairment loss) recognised in profit or loss","Documentation":"Adjustments for impairment loss (reversal of impairment loss) recognised in profit or loss to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Impairment loss (reversal of impairment loss) recognised in profit or loss]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForFinanceIncomeCost","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForFinanceIncomeCost","Weight":"-1","Order":"8","Label":"Adjustments for finance income (cost)","Documentation":"Adjustments for net finance income or cost to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Finance income (cost); Profit (loss)]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForSharebasedPayments","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForSharebasedPayments","Weight":"1","Order":"9","Label":"Adjustments for share-based payments","Documentation":"Adjustments for share-based payments to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_AWLCF_AdjustmentsForInventoryWriteOff","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"awlcf:AdjustmentsForInventoryWriteOff","Weight":"1","Order":"10","Label":"Adjustments For Inventory Write Off","Documentation":"Adjustments For Inventory Write Off.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"false","Nillable":"true","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":1},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForGainLossOnDisposalsPropertyPlantAndEquipment","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForGainLossOnDisposalsPropertyPlantAndEquipment","Weight":"-1","Order":"11","Label":"Adjustments for gain (loss) on disposals, property, plant and equipment","Documentation":"Adjustments for gain (loss) on disposals of property, plant and equipment to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss); Property, plant and equipment; Disposals, property, plant and equipment]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForDecreaseIncreaseInTradeAndOtherReceivables","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForDecreaseIncreaseInTradeAndOtherReceivables","Weight":"1","Order":"12","Label":"Adjustments for decrease (increase) in trade and other receivables","Documentation":"Adjustments for decrease (increase) in trade and other receivables to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Trade and other receivables; Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForDecreaseIncreaseInInventories","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForDecreaseIncreaseInInventories","Weight":"1","Order":"13","Label":"Adjustments for decrease (increase) in inventories","Documentation":"Adjustments for decrease (increase) in inventories to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Inventories; Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForDecreaseIncreaseInOtherOperatingReceivables","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForDecreaseIncreaseInOtherOperatingReceivables","Weight":"1","Order":"14","Label":"Adjustments for decrease (increase) in other operating receivables","Documentation":"Adjustments for decrease (increase) in other operating receivables to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_AdjustmentsForIncreaseDecreaseInTradeAccountPayable","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:AdjustmentsForIncreaseDecreaseInTradeAccountPayable","Weight":"1","Order":"15","Label":"Adjustments for increase (decrease) in trade accounts payable","Documentation":"Adjustments for increase (decrease) in trade accounts payable to reconcile profit (loss) to net cash flow from (used in) operating activities. [Refer: Profit (loss)]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_InterestPaidClassifiedAsOperatingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:InterestPaidClassifiedAsOperatingActivities","Weight":"-1","Order":"16","Label":"Interest paid, classified as operating activities","Documentation":"The cash outflow for interest paid, classified as operating activities.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_InterestReceivedClassifiedAsOperatingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:InterestReceivedClassifiedAsOperatingActivities","Weight":"1","Order":"17","Label":"Interest received, classified as operating activities","Documentation":"The cash inflow from interest received, classified as operating activities.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_IncomeTaxesPaidClassifiedAsOperatingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInOperatingActivities","Name":"ifrs-full:IncomeTaxesPaidClassifiedAsOperatingActivities","Weight":"-1","Order":"18","Label":"Income taxes paid, classified as operating activities","Documentation":"The cash outflow for income taxes paid, classified as operating activities.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_IncreaseDecreaseInCashAndCashEquivalents","Name":"ifrs-full:CashFlowsFromUsedInFinancingActivities","Weight":"1","Order":"19","Label":"Cash flows from (used in) financing activities","Documentation":"The cash flows from (used in) financing activities, which are activities that result in changes in the size and composition of the contributed equity and borrowings of the entity.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_ProceedsFromIssuingShares","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivities","Name":"ifrs-full:ProceedsFromIssuingShares","Weight":"1","Order":"20","Label":"Proceeds from issuing shares","Documentation":"The cash inflow from issuing shares.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_PaymentsOfLeaseLiabilitiesClassifiedAsFinancingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivities","Name":"ifrs-full:PaymentsOfLeaseLiabilitiesClassifiedAsFinancingActivities","Weight":"-1","Order":"21","Label":"Payments of lease liabilities, classified as financing activities","Documentation":"The cash outflow for payment of lease liabilities, classified as financing activities. [Refer: Lease liabilities]","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_PaymentsForShareIssueCosts","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivities","Name":"ifrs-full:PaymentsForShareIssueCosts","Weight":"-1","Order":"22","Label":"Payments for share issue costs","Documentation":"The cash outflow for share issue costs.","PeriodType":"duration","Balance":"credit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"GroupStatementOfCashFlows_loc_ifrs-full_ProceedsFromBorrowingsClassifiedAsFinancingActivities","ParentId":"GroupStatementOfCashFlows_loc_ifrs-full_CashFlowsFromUsedInFinancingActivities","Name":"ifrs-full:ProceedsFromBorrowingsClassifiedAsFinancingActivities","Weight":"1","Order":"23","Label":"Proceeds from borrowings, classified as financing activities","Documentation":"The cash inflow from borrowings obtained. [Refer: Borrowings]","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0}];
  $scope.periodData = ["2022-01-01 - 2022-12-31","2021-01-01 - 2021-12-31","2022-12-31","2021-12-31","2020-12-31 (ifrs-full:IssuedCapitalMember)","2020-12-31 (ifrs-full:SharePremiumMember)","2020-12-31 (ifrs-full:RetainedEarningsMember)","2020-12-31","2021-12-31 (ifrs-full:IssuedCapitalMember)","2021-12-31 (ifrs-full:SharePremiumMember)","2021-12-31 (ifrs-full:RetainedEarningsMember)","2022-12-31 (ifrs-full:IssuedCapitalMember)","2022-12-31 (ifrs-full:SharePremiumMember)","2022-12-31 (ifrs-full:RetainedEarningsMember)"];
  $scope.periodValueData = [["-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[-145356000,-145356000,0,-72229000,-72229000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[-145335000,-145335000,0,-62963000,-62963000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[-145101000,-145101000,0,-61268000,-61268000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[-2380000,-2380000,0,-49029000,-49029000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-",0,33077000,33077000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,5363000,5363000,0,33986000,33986000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,205000,205000,0,48120000,48120000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,3188000,3188000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,20153000,20153000,0,12235000,12235000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,122568000,122568000,0,4000,4000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,53000,53000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,168000,168000,0,1441000,1441000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,-119000,-119000,0,-254000,-254000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,21000,21000,0,9266000,9266000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",-126955000,-126955000,0,10899000,10899000,0,0,525000,525000,0,218381000,218381000,0,-135778000,-135778000,0,83128000,83128000,0,525000,525000,0,218381000,218381000,0,-208007000,-208007000,0,3581000,3581000,0,222827000,222827000,0,-353363000,-353363000],["-","-","-","-","-","-",0,3581000,3581000,0,525000,525000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,222827000,222827000,0,218381000,218381000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,-353363000,-353363000,0,-208007000,-208007000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",-126955000,-126955000,0,10899000,10899000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",11515000,11515000,0,26226000,26226000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-","-","-","-",15764000,15764000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-","-","-","-",0,15764000,15764000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",11515000,11515000,0,10462000,10462000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-","-","-","-",0,115000,115000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,2635000,2635000,0,662000,662000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,8880000,8880000,0,9685000,9685000,"-","-","-","-","-","-","-","-","-",0,14738000,14738000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",138470000,138470000,0,15327000,15327000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",138324000,138324000,0,14901000,14901000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,118372000,118372000,0,4550000,4550000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,9278000,9278000,0,1100000,1100000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,1500000,1500000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,9174000,9174000,0,9251000,9251000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",146000,146000,0,426000,426000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-",0,146000,146000,0,426000,426000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[-671000,-671000,0,-5053000,-5053000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[18328000,18328000,0,-2229000,-2229000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,205000,205000,0,2229000,2229000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,18533000,18533000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[-27756000,-27757000,-1000,-2352000,-2352000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[-145335000,-145335000,0,-62963000,-62963000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,419000,419000,0,6241000,6241000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,205000,205000,0,48120000,48120000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,-115000,-115000,0,-1441000,-1441000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-",0,-114000,-114000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],["-","-","-",0,3026000,3026000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,3188000,3188000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,34000,34000,0,3486000,3486000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,115000,115000,0,-115000,-115000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,-2006000,-2006000,0,2249000,2249000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,122098000,122098000,0,-3605000,-3605000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,168000,168000,0,53000,53000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,53000,53000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,98000,98000,0,65000,65000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[8758000,8758000,0,-472000,-472000,0,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,7852000,7852000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,244000,244000,0,472000,472000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,350000,350000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"],[0,1500000,1500000,"-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-","-"]];
  $scope.definitionData = [{"Id":"http://awilcodrilling.com/role/Anchoring","ParentId":"","Name":"Anchoring","Order":"","Label":"","Documentation":"","PeriodType":"","Balance":"","Type":"","AbstractText":"","Nillable":"","SubstitutionGroup":"","IsReferenceExist":"0","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"Anchoring_CashFlowsFromUsedInOperatingActivities","ParentId":"http://awilcodrilling.com/role/Anchoring","Name":"ifrs-full:CashFlowsFromUsedInOperatingActivities","Order":"","Label":"Cash flows from (used in) operating activities","Documentation":"The cash flows from (used in) operating activities, which are the principal revenue-producing activities of the entity and other activities that are not investing or financing activities. [Refer: Revenue]","PeriodType":"duration","Balance":"0","Type":"xbrli:monetaryItemType","AbstractText":"0","Nillable":"TRUE","SubstitutionGroup":"xbrli:item","IsReferenceExist":"1","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0},{"Id":"Anchoring_AdjustmentsForInventoryWriteOff","ParentId":"Anchoring_CashFlowsFromUsedInOperatingActivities","Name":"awlcf:AdjustmentsForInventoryWriteOff","Order":"1.0","Label":"Adjustments For Inventory Write Off","Documentation":"Adjustments For Inventory Write Off.","PeriodType":"duration","Balance":"debit","Type":"xbrli:monetaryItemType","AbstractText":"false","Nillable":"true","SubstitutionGroup":"xbrli:item","IsReferenceExist":"0","SecondaryLabel":"","SecondaryDocumentation":"","IsExtendedElement":0}];
  // $scope.pageData = <!PAGE DATA!>;
  $scope.referenceData = [{"ElementName":"DividendsProposedOrDeclaredBeforeFinancialStatementsAuthorisedForIssueButNotRecognisedAsDistributionToOwners","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"137","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_137_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DeferredTaxLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_o&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DeferredTaxLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"56","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_56&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DeferredTaxAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_o&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DeferredTaxAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"56","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_56&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxExpenseContinuingOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"82","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_82_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyPlantAndEquipment","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReversalOfImpairmentLossRecognisedInProfitOrLossPropertyPlantAndEquipment","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ImpairmentLossRecognisedInProfitOrLossPropertyPlantAndEquipment","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"MaturityAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"61","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_61&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AggregatedTimeBandsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"61","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_61&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NotLaterThanOneYearMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"61","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_61_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"Revenue","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"82","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_82_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"Revenue","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"103","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_103&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"Revenue","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"102","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_102&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProvisionsForEmployeeBenefits","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"EmployeeBenefitsExpense","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"102","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_102&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"EmployeeBenefitsExpense","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"99","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_99&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"EmployeeBenefitsExpense","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"104","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_104&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IntangibleAssetsOtherThanGoodwill","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"Goodwill","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"BiologicalAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_f&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DepreciationAndAmortisationExpense","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"102","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_102&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DepreciationAndAmortisationExpense","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"99","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_99&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DepreciationAndAmortisationExpense","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"104","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_104&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"66","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_66&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"Assets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLossBeforeTax","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"103","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_103&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLossBeforeTax","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"102","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_102&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnCashFlowHedgesNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"92","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_92&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnCashFlowHedgesBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"92","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_92&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfShareCapitalReservesAndOtherEquityInterestExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfNotesAndOtherExplanatoryInformationExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReservesAndOtherEquityInterestExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"EquityAndLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfGeneralInformationAboutFinancialStatementsExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"51","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_51&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"Equity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"Equity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DistributionCosts","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"103","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_103&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DistributionCosts","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"99","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_99&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GrossProfit","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"103","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_103&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherExpenseByFunction","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"103","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_103&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherExpenseByFunction","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"99","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_99&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherIncome","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"103","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_103&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherIncome","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"102","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_102&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdministrativeExpense","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"103","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_103&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdministrativeExpense","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"99","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_99&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CostOfSales","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"99","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_99&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CostOfSales","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"103","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_103&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherExpenseByNature","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"102","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_102&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherExpenseByNature","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"99","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_99&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ChangesInInventoriesOfFinishedGoodsAndWorkInProgress","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"102","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_102&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ChangesInInventoriesOfFinishedGoodsAndWorkInProgress","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"99","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_99&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RawMaterialsAndConsumablesUsed","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"102","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_102&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RawMaterialsAndConsumablesUsed","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"99","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_99&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"99","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_99&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherShorttermProvisions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentProvisionsForEmployeeBenefits","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherProvisions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherLongtermProvisions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentProvisionsForEmployeeBenefits","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughTransfersAndOtherChangesEquity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ChangesInEquity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LegalFormOfEntity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"138","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_138_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CountryOfIncorporation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"138","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_138_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DomicileOfEntity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"138","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_138_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AddressOfRegisteredOfficeOfEntity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"138","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_138_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfPresentationCurrency","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"51","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_51_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NameOfUltimateParentOfGroup","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"138","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_138_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NameOfParentEntity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"138","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_138_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherReceivables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_h&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherReceivables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentReceivables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_h&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentReceivables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherCurrentReceivables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_h&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherCurrentReceivables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"ii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d_ii&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughOtherContributionsByOwners","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"iii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d_iii&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IssueOfEquity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"iii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d_iii&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughOtherDistributionsToOwners","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"iii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d_iii&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ComprehensiveIncomeAttributableToNoncontrollingInterests","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ComprehensiveIncomeAttributableToOwnersOfParent","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsPaid","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"107","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_107&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"StatementOfIFRSCompliance","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"16","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_16&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfMeasurementBasesUsedInPreparingFinancialStatements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfOtherAccountingPoliciesRelevantToUnderstandingOfFinancialStatements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfManagementJudgementsInApplyingEntitysAccountingPoliciesWithSignificantEffectOnRecognisedAmounts","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"122","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_122&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfAssumptionAboutFutureWithSignificantRiskOfResultingInMaterialAdjustments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"125","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_125&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfAssumptionAboutFutureWithSignificantRiskOfResultingInMaterialAdjustments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"14","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=14&code=ifrs-tx-2021-en-r&anchor=para_10&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureOfEntitysOperationsAndPrincipalActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"138","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_138_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfDepartureFromIFRS","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"20","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_20_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfDepartureFromIFRS","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"20","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_20_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ManagementConclusionOnFairPresentationAsConsequenceOfDeparture","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"20","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_20_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfUncertaintiesOfEntitysAbilityToContinueAsGoingConcern","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"25","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_25&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationWhyFinancialStatementsNotPreparedOnGoingConcernBasis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"25","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_25&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfReasonForUsingLongerOrShorterReportingPeriod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"36","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_36_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfReasonWhyFinancialStatementsAreNotEntirelyComparable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"36","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_36_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfReasonForReclassificationOrChangesInPresentation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"41","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_41_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureOfReclassificationOrChangesInPresentation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"41","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_41_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfReasonWhyReclassificationOfComparativeAmountsIsImpracticable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"42","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_42_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LevelOfRoundingUsedInFinancialStatements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"51","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_51_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NameOfReportingEntityOrOtherMeansOfIdentification","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"51","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_51_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfChangeInNameOfReportingEntityOrOtherMeansOfIdentificationFromEndOfPrecedingReportingPeriod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"51","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_51_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureOfFinancialStatements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"51","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_51_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncontrollingInterests","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_q&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"SharePremium","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"EquityAttributableToOwnersOfParent","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_r&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RetainedEarnings","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherReserves","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TreasuryShares","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TreasuryShares","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"32","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"34","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=32&code=ifrs-tx-2021-en-r&anchor=para_34&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherEquityInterest","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IssuedCapital","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"Inventories","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_g&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"Inventories","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"68","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_68&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherFinancialAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNoncurrentFinancialAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentFinancialAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentFinancialLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_m&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNoncurrentFinancialLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_m&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherFinancialLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_m&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentProperty","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashAndCashEquivalents","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_i&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPayables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_k&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherPayables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_k&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherCurrentPayables","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_k&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentTaxLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_n&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentTaxAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_n&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"66","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_66&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"69","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_69&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"69","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_69&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfClassesOfShareCapitalExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureAndPurposeOfReservesWithinEquity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfOtherEquityInterest","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"80","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_80&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d_i&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShareOfProfitLossOfAssociatesAndJointVenturesAccountedForUsingEquityMethod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"82","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_82_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"PeriodCoveredByFinancialStatements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"51","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_51_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinanceCosts","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"82","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_82_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherGainsLosses","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"102","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_102&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherGainsLosses","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"103","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_103&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"SharesInEntityHeldByEntityOrByItsSubsidiariesOrAssociates","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"vi","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a_vi&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NumberOfSharesAuthorised","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a_i&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NumberOfSharesIssuedButNotFullyPaid","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"ii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a_ii&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NumberOfSharesIssuedAndFullyPaid","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"ii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a_ii&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ParValuePerShare","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"iii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a_iii&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RightsPreferencesAndRestrictionsAttachingToClassOfShareCapital","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"v","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a_v&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"SharesReservedForIssueUnderOptionsAndContractsForSaleOfShares","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"vii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a_vii&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"StatementOfChangesInEquityTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ComponentsOfEquityAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"EquityAttributableToOwnersOfParentMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IssuedCapitalMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"SharePremiumMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TreasurySharesMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherEquityInterestMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RetainedEarningsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncontrollingInterestsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"EquityMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfClassesOfShareCapitalTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ClassesOfShareCapitalAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ClassesOfShareCapitalMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReservesWithinEquityTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReservesWithinEquityAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NumberOfSharesOutstanding","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"iv","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a_iv&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfFactThatSharesHaveNoParValue","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"iii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a_iii&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentProvisions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_l&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentProvisions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_l&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"Provisions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_l&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughChangesInOwnershipInterestsInSubsidiariesThatDoNotResultInLossOfControl","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"iii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d_iii&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"Accruals","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AccrualsClassifiedAsCurrent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AccrualsClassifiedAsNoncurrent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPayablesToRelatedParties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPayablesToTradeSuppliers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentReceivablesDueFromRelatedParties","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherCurrentPayablesToRelatedParties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherCurrentPayablesToTradeSuppliers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherCurrentPayablesToTradeSuppliers","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"70","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_70&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherCurrentReceivablesDueFromRelatedParties","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherPayablesToRelatedParties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherPayablesToTradeSuppliers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeAndOtherReceivablesDueFromRelatedParties","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfNatureOfRequirementInIFRSAndConclusionWhyRequirementIsInConflictWithFairPresentation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"23","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_23_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfAdjustmentsThatWouldBeNecessaryToAchieveFairPresentation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"23","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_23_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"PrincipalPlaceOfBusiness","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"138","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_138_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfFactAndBasisForPreparationOfFinancialStatementsWhenNotGoingConcernBasis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"25","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_25&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"Liabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentTaxAssetsNoncurrent","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_n&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentTaxLiabilitiesNoncurrent","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_n&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughSharebasedPaymentTransactions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"iii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d_iii&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentTaxAssetsCurrent","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_n&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentTaxLiabilitiesCurrent","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_n&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherReservesMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherReservesMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReclassificationsOrChangesInPresentationExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"41","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_41&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReclassificationsOrChangesInPresentationTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"41","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_41&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassifiedItemsAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"41","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_41&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassifiedItemsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"41","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_41&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AmountOfReclassificationsOrChangesInPresentation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"41","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_41_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentAccountedForUsingEquityMethod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnExchangeDifferencesOnTranslationBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"92","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_92&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnExchangeDifferencesOnTranslationNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"92","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_92&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShorttermMiscellaneousOtherProvisions","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LongtermMiscellaneousOtherProvisions","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"MiscellaneousOtherProvisions","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LiabilitiesIncludedInDisposalGroupsClassifiedAsHeldForSale","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_p&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AssetsAndLiabilitiesAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"125","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_125&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AssetsAndLiabilitiesMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"125","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_125&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentInventories","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_g&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InventoriesTotal","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_g&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InventoryWritedown2011","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReversalOfInventoryWritedown","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAssetsAndLiabilitiesWithSignificantRiskOfMaterialAdjustmentExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"125","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_125&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureOfAssetsWithSignificantRiskOfMaterialAdjustmentsWithinNextFinancialYear","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"125","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_125_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureOfLiabilitiesWithSignificantRiskOfMaterialAdjustmentsWithinNextFinancialYear","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"125","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_125_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AssetsWithSignificantRiskOfMaterialAdjustmentsWithinNextFinancialYear","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"125","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_125_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LiabilitiesWithSignificantRiskOfMaterialAdjustmentsWithinNextFinancialYear","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"125","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_125_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RestatedMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"20","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_20_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RestatedMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanOneYearMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"61","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_61_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAssetsAndLiabilitiesWithSignificantRiskOfMaterialAdjustmentTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"125","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_125&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"PreviouslyStatedMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RetrospectiveApplicationAndRetrospectiveRestatementAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseDueToChangesInAccountingPolicyAndCorrectionsOfPriorPeriodErrorsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseInNumberOfSharesOutstanding","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"iv","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a_iv&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LengthOfLifeOfLimitedLifeEntity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"138","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_138_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CumulativePreferenceDividendsNotRecognised","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"137","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_137_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfFinancialEffectOfDepartureFromIFRS","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"20","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_20_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureOfNecessaryAdjustmentToProvideComparativeInformation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"42","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_42_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentAssetsOrDisposalGroupsClassifiedAsHeldForSaleOrAsHeldForDistributionToOwners","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_j&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherReversalsOfProvisions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_g&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnLitigationSettlements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_f&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExpenseOfRestructuringActivities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnDisposalsOfInvestments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnDisposalsOfPropertyPlantAndEquipment","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfObjectivesPoliciesAndProcessesForManagingCapitalExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"134","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_134&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainLossArisingFromDifferenceBetweenCarryingAmountOfFinancialLiabilityExtinguishedAndConsiderationPaid","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"19","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"11","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=19&code=ifrs-tx-2021-en-r&anchor=para_11&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseInDividendsPayableThroughChangeInFairValueOfNoncashAssetsHeldForDistributionToOwners","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"17","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"16","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=17&code=ifrs-tx-2021-en-r&anchor=para_16_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncashAssetsDeclaredForDistributionToOwnersBeforeFinancialStatementsAuthorisedForIssue","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"17","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"17","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=17&code=ifrs-tx-2021-en-r&anchor=para_17_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsPayable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"17","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"16","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=17&code=ifrs-tx-2021-en-r&anchor=para_16_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfNatureOfNoncashAssetsHeldForDistributionToOwnersDeclaredBeforeFinancialStatementsAuthorisedForIssue","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"17","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"17","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=17&code=ifrs-tx-2021-en-r&anchor=para_17_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncashAssetsDeclaredForDistributionToOwnersBeforeFinancialStatementsAuthorisedForIssueAtFairValue","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"17","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"17","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=17&code=ifrs-tx-2021-en-r&anchor=para_17_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"QualitativeInformationAboutEntitysObjectivesPoliciesAndProcessesForManagingCapital","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"135","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_135_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"SummaryOfQuantitativeDataAboutWhatEntityManagesAsCapital","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"135","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_135_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfChangesInEntitysObjectivesPoliciesAndProcessesForManagingCapitalAndWhatEntityManagesAsCapital","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"135","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_135_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InformationWhetherEntityCompliedWithAnyExternallyImposedCapitalRequirements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"135","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_135_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InformationAboutConsequencesOfNoncomplianceWithExternallyImposedCapitalRequirements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"135","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_135_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"SummaryQuantitativeDataAboutPuttableFinancialInstrumentsClassifiedAsEquityInstruments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"136A","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_136A_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InformationAboutObjectivesPoliciesAndProcessesForManagingEntitysObligationToRepurchaseOrRedeemPuttableFinancialInstruments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"136A","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_136A_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExpectedCashOutflowOnRedemptionOrRepurchaseOfPuttableFinancialInstruments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"136A","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_136A_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InformationAboutHowExpectedCashOutflowOnRedemptionOrRepurchaseWasDetermined","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"136A","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_136A_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfObjectivesPoliciesAndProcessesForManagingCapitalTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"136","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_136&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"FairValueHedgesMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"86","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2021-en-r&anchor=para_86_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashFlowHedgesMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"86","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2021-en-r&anchor=para_86_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"HedgesOfNetInvestmentInForeignOperationsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"86","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2021-en-r&anchor=para_86_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnDisposalsOfOtherNoncurrentAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"EquityReclassifiedIntoFinancialLiabilities","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"80A","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_80A&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnHedgesOfNetInvestmentsInForeignOperationsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"92","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_92&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnHedgesOfNetInvestmentsInForeignOperationsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"102","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2021-en-r&anchor=para_102&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxHedgesOfNetInvestmentsInForeignOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"102","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2021-en-r&anchor=para_102_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxHedgesOfNetInvestmentsInForeignOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"102","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2021-en-r&anchor=para_102_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnHedgesOfNetInvestmentsInForeignOperationsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"92","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_92&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReclassificationAdjustmentsOnHedgesOfNetInvestmentsInForeignOperationsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"102","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2021-en-r&anchor=para_102&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAnalysisOfOtherComprehensiveIncomeByItemExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106A","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106A&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLossFromOperatingActivities","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"32","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"IE33","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=32&code=ifrs-tx-2021-en-r&anchor=para_IE33&doctype=Illustrative%20Examples","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsClassifiedAsExpense","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"32","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"40","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=32&code=ifrs-tx-2021-en-r&anchor=para_40&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DifferenceBetweenCarryingAmountOfDividendsPayableAndCarryingAmountOfNoncashAssetsDistributed","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"17","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"15","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=17&code=ifrs-tx-2021-en-r&anchor=para_15&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnHedgesOfNetInvestmentsInForeignOperationsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"102","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2021-en-r&anchor=para_102_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnHedgesOfNetInvestmentsInForeignOperationsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"39","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"102","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=39&code=ifrs-tx-2021-en-r&anchor=para_102_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentTradeReceivables","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentTradeReceivables","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"68","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_68&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainLossArisingFromDerecognitionOfFinancialAssetsMeasuredAtAmortisedCost","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"82","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_82_aa&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsProposedOrDeclaredBeforeFinancialStatementsAuthorisedForIssueButNotRecognisedAsDistributionToOwnersPerShare","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"137","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_137_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"WritedownsReversalsOfPropertyPlantAndEquipment","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"WritedownsReversalsOfInventories","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAmountsToBeRecoveredOrSettledAfterTwelveMonthsForClassesOfAssetsAndLiabilitiesThatContainAmountsToBeRecoveredOrSettledBothNoMoreAndMoreThanTwelveMonthsAfterReportingDateExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"61","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_61&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAmountsToBeRecoveredOrSettledAfterTwelveMonthsForClassesOfAssetsAndLiabilitiesThatContainAmountsToBeRecoveredOrSettledBothNoMoreAndMoreThanTwelveMonthsAfterReportingDateTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"61","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_61&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExpenseByNature","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"99","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_99&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentBiologicalAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_f&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentBiologicalAssets","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"54","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_54_f&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentAssetsOtherThanAssetsOrDisposalGroupsClassifiedAsHeldForSaleOrAsHeldForDistributionToOwners","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"66","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_66&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsRecognisedAsDistributionsToOwnersPerShare","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"107","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_107&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentLiabilitiesOtherThanLiabilitiesIncludedInDisposalGroupsClassifiedAsHeldForSale","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"69","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_69&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfTermsOfSharesReservedForIssueUnderOptionsAndContractsForSaleOfShares","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"vii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a_vii&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DepartureFromRequirementOfIFRSAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"20","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_20_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseDueToDepartureFromRequirementOfIFRSMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"20","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_20_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsOnLitigationSettlements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_f&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LossesOnLitigationSettlements","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_f&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReversalOfProvisionsForCostOfRestructuring","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsOnDisposalsOfInvestments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LossesOnDisposalsOfInvestments","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsOnDisposalsOfPropertyPlantAndEquipment","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LossesOnDisposalsOfPropertyPlantAndEquipment","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"98","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_98_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CapitalRequirementsAxis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"136","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_136&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CapitalRequirementsMember","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"136","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_136&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinancialLiabilitiesReclassifiedIntoEquity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"80A","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_80A&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfTimingAndReasonOfReclassificationBetweenFinancialLiabilitiesAndEquity","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"80A","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_80A&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAnalysisOfOtherComprehensiveIncomeByItemTable","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106A","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106A&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentTradeReceivables","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPrepayments","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNoncurrentReceivables","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentPrepayments","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradeReceivables","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentReceivables","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"Prepayments","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherReceivables","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReportedIfInComplianceWithRequirementOfIFRSMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"20","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_20_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdditionalPaidinCapitalMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"108","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_108&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfGoodwillExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"StatutoryReserveMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"108","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_108&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CapitalReserveMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"108","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_108&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CapitalRedemptionReserveMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"108","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_108&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"MergerReserveMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"108","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_108&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"MiscellaneousOtherReservesMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"108","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_108&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfEquityComponentOfConvertibleInstrumentsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"108","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_108&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AccumulatedOtherComprehensiveIncomeMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"108","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_108&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfIntangibleAssetsAndGoodwillExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfProvisionsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfIssuedCapitalExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfBorrowingsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfCommitmentsAndContingentLiabilitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfCommitmentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDerivativeFinancialInstrumentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfBasisOfPreparationOfFinancialStatementsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDeferredTaxesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfExpensesByNatureExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfExpensesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherOperatingIncomeExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherOperatingIncomeExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherOperatingExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfGeneralAndAdministrativeExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfLeasePrepaymentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDividendsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinanceIncomeExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinanceIncomeExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinanceCostExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfCashAndCashEquivalentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInformationAboutEmployeesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherCurrentAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherNoncurrentAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherCurrentLiabilitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherNoncurrentLiabilitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfOtherLiabilitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDiscontinuedOperationsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfNoncurrentAssetsOrDisposalGroupsClassifiedAsHeldForSaleExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInvestmentsAccountedForUsingEquityMethodExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfTradeAndOtherReceivablesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfTradeAndOtherPayablesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfResearchAndDevelopmentExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAuditorsRemunerationExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInformationAboutKeyManagementPersonnelExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfTaxReceivablesAndPayablesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAuthorisationOfFinancialStatementsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfTreasurySharesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDepreciationAndAmortisationExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInterestExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfPrepaymentsAndOtherAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAccruedExpensesAndOtherLiabilitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfGoingConcernExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAccountingJudgementsAndEstimatesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInvestmentsOtherThanInvestmentsAccountedForUsingEquityMethodExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDeferredIncomeExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfRestrictedCashAndCashEquivalentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfNoncontrollingInterestsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfProfitLossFromOperatingActivitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfCostOfSalesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfBasisOfConsolidationExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfChangesInAccountingPoliciesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInvestmentContractsLiabilitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDeferredAcquisitionCostsArisingFromInsuranceContractsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReinsuranceExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfClaimsAndBenefitsPaidExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfNetAssetValueAttributableToUnitholdersExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInsurancePremiumRevenueExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfSubordinatedLiabilitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinancialInstrumentsAtFairValueThroughProfitOrLossExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinancialInstrumentsDesignatedAtFairValueThroughProfitOrLossExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinancialRiskManagementExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfLoansAndAdvancesToCustomersExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfLoansAndAdvancesToBanksExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFairValueOfFinancialInstrumentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinancialAssetsHeldForTradingExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinancialLiabilitiesHeldForTradingExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFinancialInstrumentsHeldForTradingExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfFeeAndCommissionIncomeExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDepositsFromCustomersExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfTradingIncomeExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfCollateralExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfCashAndBankBalancesAtCentralBanksExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfCreditRiskExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfMarketRiskExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfLiquidityRiskExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDebtSecuritiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfDepositsFromBanksExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInterestIncomeExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReclassificationOfFinancialInstrumentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfInterestIncomeExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAllowanceForCreditLossesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfRepurchaseAndReverseRepurchaseAgreementsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_10_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughTreasuryShareTransactions","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfAdditionalInformationExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentReceivablesFromTaxesOtherThanIncomeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfMethodsUsedToMeasureFairValueOfNoncashAssetsDeclaredForDistributionToOwnersBeforeFinancialStatementsAuthorisedForIssue","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRIC","Topic":null,"SubTopic":null,"Number":"17","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"17","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRIC&num=17&code=ifrs-tx-2021-en-r&anchor=para_17_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentReceivablesFromTaxesOtherThanIncomeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReceivablesFromTaxesOtherThanIncomeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentValueAddedTaxReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentValueAddedTaxReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ValueAddedTaxReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentPayablesOnSocialSecurityAndTaxesOtherThanIncomeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPayablesOnSocialSecurityAndTaxesOtherThanIncomeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"PayablesOnSocialSecurityAndTaxesOtherThanIncomeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentValueAddedTaxPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentValueAddedTaxPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ValueAddedTaxPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShorttermEmployeeBenefitsAccruals","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"81A","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_81A_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ComprehensiveIncomeAttributableToNoncontrollingInterests","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"81B","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_81B_b_i&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ComprehensiveIncomeAttributableToOwnersOfParent","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"81B","SubParagraph":null,"Clause":"ii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_81B_b_ii&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"81A","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_81A_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLossAttributableToNoncontrollingInterests","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"81B","SubParagraph":null,"Clause":"i","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_81B_a_i&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLossAttributableToOwnersOfParent","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"81B","SubParagraph":null,"Clause":"ii","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_81B_a_ii&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLossFromDiscontinuedOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"82","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_82_ea&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfBreakdownOfAssetsAndLiabilitiesAggregatedIntoSingleLineInvestmentBalanceTransitionFromProportionateConsolidationToEquityMethodExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"11","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"C5","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=11&code=ifrs-tx-2021-en-r&anchor=para_C5&doctype=Appendix&subtype=C","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReconciliationBetweenInvestmentDerecognisedAndAssetsAndLiabilitiesRecognisedTransitionFromAccountingForInvestmentAtCostOrInAccordanceWithIFRS9ToAccountingForAssetsAndLiabilitiesExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"11","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"C12","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=11&code=ifrs-tx-2021-en-r&anchor=para_C12_b&doctype=Appendix&subtype=C","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DisclosureOfReconciliationBetweenInvestmentDerecognisedAndAssetsAndLiabilitiesRecognisedTransitionFromEquityMethodToAccountingForAssetsAndLiabilitiesExplanatory","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"11","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"C10","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=11&code=ifrs-tx-2021-en-r&anchor=para_C10&doctype=Appendix&subtype=C","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncontrollingInterests","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"10","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"22","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=10&code=ifrs-tx-2021-en-r&anchor=para_22&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToRemeasurementsOfDefinedBenefitPlansOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"90","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_90&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToComponentsOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"90","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_90&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToCashFlowHedgesOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"90","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_90&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToExchangeDifferencesOnTranslationOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"90","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_90&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToChangesInRevaluationSurplusOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"90","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_90&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToHedgesOfNetInvestmentsInForeignOperationsOfOtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"90","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_90&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToShareOfOtherComprehensiveIncomeOfAssociatesAndJointVenturesAccountedForUsingEquityMethod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"90","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_90&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfRemeasurementsOfDefinedBenefitPlansMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"108","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_108&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevaluationSurplusMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"108","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_108&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RetainedEarningsMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"108","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_108&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfExchangeDifferencesOnTranslationMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"108","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_108&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfCashFlowHedgesMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"108","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_108&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfSharebasedPaymentsMember","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"108","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_108&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentsInAssociatesAccountedForUsingEquityMethod","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentAssetsLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LiabilitiesDueToCentralBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RecognisedLiabilitiesDefinedBenefitPlan","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RecognisedAssetsDefinedBenefitPlan","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNonfinancialLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentNonfinancialLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNonfinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNoncurrentNonfinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentNonfinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNoncurrentNonfinancialLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentPortionOfLongtermBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"Borrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LongtermBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShorttermBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IntangibleAssetsAndGoodwill","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentBorrowingsAndCurrentPortionOfNoncurrentBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentLeasePrepayments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentRecognisedAssetsDefinedBenefitPlan","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentRestrictedCashAndCashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentDerivativeFinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentInvestmentsOtherThanInvestmentsAccountedForUsingEquityMethod","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNoncurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentRestrictedCashAndCashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentDerivativeFinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentPrepaymentsAndOtherCurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentInvestments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentRecognisedAssetsDefinedBenefitPlan","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RestrictedCashAndCashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DerivativeFinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LoansAndAdvancesToBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LoansAndAdvancesToCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CashAndBankBalancesAtCentralBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentsOtherThanInvestmentsAccountedForUsingEquityMethod","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReverseRepurchaseAgreementsAndCashCollateralOnSecuritiesBorrowed","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentsForRiskOfPolicyholders","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentDerivativeFinancialLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentRecognisedLiabilitiesDefinedBenefitPlan","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentGovernmentGrants","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNoncurrentLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherNoncurrentPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentAdvances","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentDividendPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentDerivativeFinancialLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentRecognisedLiabilitiesDefinedBenefitPlan","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentAccruedExpensesAndOtherCurrentLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentAdvances","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentDividendPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentGovernmentGrants","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DerivativeFinancialLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DepositsFromBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DepositsFromCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"SubordinatedLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DebtSecurities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RepurchaseAgreementsAndCashCollateralOnSecuritiesLent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendPayables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentContractsLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CapitalReserve","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfEquityComponentOfConvertibleInstruments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AccumulatedOtherComprehensiveIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CapitalRedemptionReserve","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"MergerReserve","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"StatutoryReserve","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AdditionalPaidinCapital","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"Advances","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ItemsInCourseOfCollectionFromOtherBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ItemsInCourseOfTransmissionToOtherBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentsInJointVenturesAccountedForUsingEquityMethod","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShorttermDepositsNotClassifiedAsCashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LongtermDeposits","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"EquityInstrumentsHeld","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DebtInstrumentsHeld","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxGainsLossesOnRemeasurementsOfDefinedBenefitPlans","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnCashFlowHedgesBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxCashFlowHedges","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxExchangeDifferencesOnTranslation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShareOfOtherComprehensiveIncomeOfAssociatesAndJointVenturesAccountedForUsingEquityMethodBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxGainsLossesOnRevaluation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxHedgesOfNetInvestmentsInForeignOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnHedgesOfNetInvestmentsInForeignOperationsBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnExchangeDifferencesOnTranslationBeforeTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxGainsLossesOnRemeasurementsOfDefinedBenefitPlans","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnCashFlowHedgesNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxCashFlowHedges","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxExchangeDifferencesOnTranslation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncome","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShareOfOtherComprehensiveIncomeOfAssociatesAndJointVenturesAccountedForUsingEquityMethod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxGainsLossesOnRevaluation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxHedgesOfNetInvestmentsInForeignOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnHedgesOfNetInvestmentsInForeignOperationsNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnExchangeDifferencesOnTranslationNetOfTax","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeThatWillBeReclassifiedToProfitOrLossNetOfTax","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"IG6","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_IG6&doctype=Implementation%20Guidance","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeThatWillNotBeReclassifiedToProfitOrLossNetOfTax","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"IG6","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_IG6&doctype=Implementation%20Guidance","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherWorkPerformedByEntityAndCapitalised","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"IG6","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_IG6&doctype=Implementation%20Guidance","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RetainedEarnings","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"IG6","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_IG6&doctype=Implementation%20Guidance","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxGainsLossesOnRemeasurementsOfDefinedBenefitPlans","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"7","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_7&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxGainsLossesOnRemeasurementsOfDefinedBenefitPlans","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"7","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_7&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxCashFlowHedges","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"7","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_7&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxExchangeDifferencesOnTranslation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"7","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_7&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxCashFlowHedges","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"7","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_7&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxExchangeDifferencesOnTranslation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"7","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_7&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeBeforeTaxGainsLossesOnRevaluation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"7","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_7&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeNetOfTaxGainsLossesOnRevaluation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"7","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_7&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfRemeasurementsOfDefinedBenefitPlans","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfCashFlowHedges","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReserveOfSharebasedPayments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_e&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsOnChangeInFairValueOfDerivatives","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LossesOnChangeInFairValueOfDerivatives","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RoyaltyExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ServicesExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RentalExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinanceIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherIncomeExpenseFromSubsidiariesJointlyControlledEntitiesAndAssociates","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinanceIncomeCost","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RepairsAndMaintenanceExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherOperatingIncomeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DistributionAndAdministrativeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RevenueAndOperatingIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OperatingExpenseExcludingCostOfSales","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"SalesAndMarketingExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TaxExpenseOtherThanIncomeTaxExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnChangeInFairValueOfDerivatives","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherFinanceIncomeCost","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"FeeAndCommissionIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"FeeAndCommissionExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"FeeAndCommissionIncomeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradingIncomeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseInAccumulatedDeferredTaxRecognisedInOtherComprehensiveIncomeDueToChangeInTaxRate","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeAttributableToOwnersOfParent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeAttributableToNoncontrollingInterests","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherIndividuallyImmaterialComponentsOfOtherComprehensiveIncomeNetOfTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherIndividuallyImmaterialComponentsOfOtherComprehensiveIncomeBeforeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToOtherIndividuallyImmaterialComponentsOfOtherComprehensiveIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InvestmentIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughExerciseOfWarrantsEquity","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsRecognisedAsDistributionsToNoncontrollingInterests","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughChangeInEquityOfSubsidiaries","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughAcquisitionOfSubsidiary","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughDisposalOfSubsidiary","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughTransferBetweenRevaluationReserveAndRetainedEarnings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughTransferToStatutoryReserve","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughAppropriationOfRetainedEarnings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughExerciseOfOptions","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughConversionOfConvertibleInstruments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IssueOfConvertibleInstruments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DecreaseIncreaseThroughTaxOnSharebasedPaymentTransactions","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseThroughTransactionsWithOwners","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"PurchaseOfTreasuryShares","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"SaleOrIssueOfTreasuryShares","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CancellationOfTreasuryShares","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReductionOfIssuedCapital","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShareIssueRelatedCost","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NumberOfSharesIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDecommissioningRestorationAndRehabilitationProvisionsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForMiningRightsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForMiningAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForStrippingCostsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForOilAndGasAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForEmployeeBenefitsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForSegmentReportingExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForForeignCurrencyTranslationExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForPropertyPlantAndEquipmentExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForIntangibleAssetsOtherThanGoodwillExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForIntangibleAssetsAndGoodwillExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForInvestmentPropertyExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForConstructionInProgressExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForBusinessCombinationsAndGoodwillExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForGoodwillExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForBusinessCombinationsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForEarningsPerShareExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForIncomeTaxExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForLeasesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForTradeAndOtherReceivablesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForTradeAndOtherPayablesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForSubsidiariesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForTransactionsWithRelatedPartiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForIssuedCapitalExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForTreasurySharesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDividendsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForProvisionsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForImpairmentOfAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForImpairmentOfFinancialAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForImpairmentOfNonfinancialAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForBorrowingsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForBorrowingCostsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForResearchAndDevelopmentExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFinancialAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFinancialLiabilitiesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFinancialInstrumentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDerivativeFinancialInstrumentsAndHedgingExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDerivativeFinancialInstrumentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForHedgingExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForNoncurrentAssetsOrDisposalGroupsClassifiedAsHeldForSaleExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDiscontinuedOperationsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForNoncurrentAssetsOrDisposalGroupsClassifiedAsHeldForSaleAndDiscontinuedOperationsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForInvestmentsOtherThanInvestmentsAccountedForUsingEquityMethodExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForInvestmentInAssociatesAndJointVenturesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForRestrictedCashAndCashEquivalentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForExpensesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFinanceIncomeAndCostsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFinanceCostsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForSharebasedPaymentTransactionsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFairValueMeasurementExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForCashFlowsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDepreciationExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFunctionalCurrencyExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForTransactionsWithNoncontrollingInterestsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForEnvironmentRelatedExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForBiologicalAssetsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForReinsuranceExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDeferredAcquisitionCostsArisingFromInsuranceContractsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFinancialInstrumentsAtFairValueThroughProfitOrLossExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFinancialGuaranteesExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForOffsettingOfFinancialInstrumentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForDerecognitionOfFinancialInstrumentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForFeeAndCommissionIncomeAndExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForRepurchaseAndReverseRepurchaseAgreementsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForCollateralExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForInterestIncomeAndExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForTradingIncomeAndExpenseExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForReclassificationOfFinancialInstrumentsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForInvestmentInAssociates","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForInvestmentsInJointVentures","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForTerminationBenefits","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"FuelAndEnergyExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TransportationExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InsuranceExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanFiveYearsAndNotLaterThanTenYearsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanTenYearsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DirectorsRemunerationExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfessionalFeesExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ContractualCapitalCommitments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AuthorisedCapitalCommitmentsButNotContractedFor","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CapitalCommitments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanOneYearAndNotLaterThanTwoYearsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanTwoYearsAndNotLaterThanThreeYearsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanThreeYearsAndNotLaterThanFourYearsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanFourYearsAndNotLaterThanFiveYearsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanTwoYearsAndNotLaterThanFiveYearsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPortionOfNoncurrentLoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentLoansReceivedAndCurrentPortionOfNoncurrentLoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPortionOfNoncurrentSecuredBankLoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentSecuredBankLoansReceivedAndCurrentPortionOfNoncurrentSecuredBankLoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"SecuredBankLoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPortionOfNoncurrentUnsecuredBankLoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentUnsecuredBankLoansReceivedAndCurrentPortionOfNoncurrentUnsecuredBankLoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"UnsecuredBankLoansReceived","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPortionOfNoncurrentBondsIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentBondsIssuedAndCurrentPortionOfNoncurrentBondsIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"BondsIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPortionOfOtherNoncurrentBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherCurrentBorrowingsAndCurrentPortionOfOtherNoncurrentBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPortionOfNoncurrentNotesAndDebenturesIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentNotesAndDebenturesIssuedAndCurrentPortionOfNoncurrentNotesAndDebenturesIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NotesAndDebenturesIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentPortionOfNoncurrentCommercialPapersIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentCommercialPapersIssuedAndCurrentPortionOfNoncurrentCommercialPapersIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CommercialPapersIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentAdvancesToSuppliers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentPrepaidExpenses","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentInterestReceivable","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentInterestReceivable","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestReceivable","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentInterestPayable","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentInterestPayable","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestPayable","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AuditorsRemuneration","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AuditorsRemunerationForAuditServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AuditorsRemunerationForTaxServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AuditorsRemunerationForOtherServices","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnDisposalsOfNoncurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsOnDisposalsOfNoncurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LossesOnDisposalsOfNoncurrentAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"MiscellaneousOtherOperatingIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"MiscellaneousOtherOperatingExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RentalIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeFromReimbursementsUnderInsurancePolicies","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherFinanceCost","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherFinanceIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnCashAndCashEquivalents","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnBorrowings","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnBankLoansAndOverdrafts","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnBonds","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExpenseDueToUnwindingOfDiscountOnProvisions","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncreaseDecreaseInNumberOfOrdinarySharesIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DepreciationExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AmortisationExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ClosingForeignExchangeRate","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AverageForeignExchangeRate","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NumberOfEmployees","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AverageNumberOfEmployees","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExpenseFromSharebasedPaymentTransactionsWithEmployees","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExpenseFromCashsettledSharebasedPaymentTransactionsInWhichGoodsOrServicesReceivedDidNotQualifyForRecognitionAsAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherDebtInstrumentsHeld","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GovernmentDebtInstrumentsHeld","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CorporateDebtInstrumentsHeld","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"BankDebtInstrumentsHeld","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"AssetbackedDebtInstrumentsHeld","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ConsumerLoans","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CorporateLoans","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"BankBalancesAtCentralBanksOtherThanMandatoryReserveDeposits","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"MandatoryReserveDepositsAtCentralBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DatedSubordinatedLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"UndatedSubordinatedLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"BalancesOnCurrentAccountsFromCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"BalancesOnTermDepositsFromCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"BalancesOnDemandDepositsFromCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"BalancesOnOtherDepositsFromCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OptionContractMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"FuturesContractMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"SwapContractMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ForwardContractMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnDepositsFromBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnDepositsFromCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnDebtInstrumentsIssued","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnOtherFinancialLiabilities","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnFinancialLiabilitiesHeldForTrading","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnFinancialLiabilitiesDesignatedAtFairValueThroughProfitOrLoss","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnRepurchaseAgreementsAndCashCollateralOnSecuritiesLent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnCashAndBankBalancesAtCentralBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnLoansAndAdvancesToBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnLoansAndAdvancesToCustomers","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnDebtInstrumentsHeld","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnOtherFinancialAssets","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnFinancialAssetsHeldForTrading","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnFinancialAssetsDesignatedAtFairValueThroughProfitOrLoss","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestIncomeOnReverseRepurchaseAgreementsAndCashCollateralOnSecuritiesBorrowed","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"BrokerageFeeIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"PortfolioAndOtherManagementFeeIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CreditrelatedFeeAndCommissionIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherFeeAndCommissionIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"BrokerageFeeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherFeeAndCommissionExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradingIncomeExpenseOnForeignExchangeContracts","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradingIncomeExpenseOnDerivativeFinancialInstruments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradingIncomeExpenseOnEquityInstruments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"TradingIncomeExpenseOnDebtInstruments","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherTradingIncomeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ShorttermEmployeeBenefitsExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CorporateLoansMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanOneMonthAndNotLaterThanTwoMonthsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanTwoMonthsAndNotLaterThanThreeMonthsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LaterThanSixMonthsMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NotionalAmount","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OnDemandMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToComponentsOfOtherComprehensiveIncomeThatWillNotBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToShareOfOtherComprehensiveIncomeOfAssociatesAndJointVenturesAccountedForUsingEquityMethodThatWillBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToShareOfOtherComprehensiveIncomeOfAssociatesAndJointVenturesAccountedForUsingEquityMethodThatWillNotBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeTaxRelatingToComponentsOfOtherComprehensiveIncomeThatWillBeReclassifiedToProfitOrLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"91","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_91&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeThatWillNotBeReclassifiedToProfitOrLossBeforeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"IG6","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_IG6&doctype=Implementation%20Guidance","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OtherComprehensiveIncomeThatWillBeReclassifiedToProfitOrLossBeforeTax","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"IG6","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_IG6&doctype=Implementation%20Guidance","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLossFromContinuingOperations","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"81A","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_81A_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProfitLoss","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"81A","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_81A_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfFactThatEntityDoesNotHaveLegalOrConstructiveObligationToNegativeNetAssetsTransitionFromProportionateConsolidationToEquityMethod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"11","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"C4","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=11&code=ifrs-tx-2021-en-r&anchor=para_C4&doctype=Appendix&subtype=C","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CumulativeUnrecognisedShareOfLossesOfJointVenturesTransitionFromProportionateConsolidationToEquityMethod","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"11","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"C4","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=11&code=ifrs-tx-2021-en-r&anchor=para_C4&doctype=Appendix&subtype=C","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"StatementThatUnadjustedComparativeInformationHasBeenPreparedOnDifferentBasis","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"10","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"C6B","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=10&code=ifrs-tx-2021-en-r&anchor=para_C6B&doctype=Appendix&subtype=C","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ExplanationOfBasisOfPreparationOfUnadjustedComparativeInformation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"10","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"C6B","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=10&code=ifrs-tx-2021-en-r&anchor=para_C6B&doctype=Appendix&subtype=C","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IdentificationOfUnadjustedComparativeInformation","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IFRS","Topic":null,"SubTopic":null,"Number":"10","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"C6B","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IFRS&num=10&code=ifrs-tx-2021-en-r&anchor=para_C6B&doctype=Appendix&subtype=C","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"OrdinarySharesMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"PreferenceSharesMember","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"79","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_79_a&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RawMaterials","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"Merchandise","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ProductionSupplies","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"WorkInProgress","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinishedGoods","Type":"exampleRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"78","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_78_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsRecognisedAsDistributionsToOwnersOfParent","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsRecognisedAsDistributionsToOwnersOfParentRelatingToPriorYears","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DividendsRecognisedAsDistributionsToOwnersOfParentRelatingToCurrentYear","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"106","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_106_d&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"InterestExpenseOnLiabilitiesDueToCentralBanks","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GovernmentGrants","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DateOfEndOfReportingPeriod2013","Type":"disclosureRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"51","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_51_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"IncomeFromFinesAndPenalties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DescriptionOfAccountingPolicyForCustomerAcquisitionCostsExplanatory","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"117","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_117_b&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"FinanceLeaseReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"CurrentFinanceLeaseReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"NoncurrentFinanceLeaseReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_55&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"DepreciationAmortisationAndImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLoss","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsOnDisposalsOfInvestmentProperties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"LossesOnDisposalsOfInvestmentProperties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"GainsLossesOnDisposalsOfInvestmentProperties","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyServiceChargeIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyServiceChargeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyServiceChargeIncomeExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyManagementExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyDevelopmentAndProjectManagementIncome","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyDevelopmentAndProjectManagementExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"RentalIncomeFromInvestmentPropertyNetOfDirectOperatingExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"BankAndSimilarCharges","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyTaxExpense","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"85","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_85&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ImpairmentLossRecognisedInProfitOrLossTradeReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ReversalOfImpairmentLossRecognisedInProfitOrLossTradeReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"ImpairmentLossReversalOfImpairmentLossRecognisedInProfitOrLossTradeReceivables","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"112","SubParagraph":null,"Clause":"","URI":"http://eifrs.ifrs.org/eifrs/xifrs-link?type=IAS&num=1&code=ifrs-tx-2021-en-r&anchor=para_112_c&doctype=Standard","URIDate":"24/03/2021","Part":null,"Schedule":null,"Year":null},{"ElementName":"PropertyIntendedForSaleInOrdinaryCourseOfBusiness","Type":"commonPracticeRef","Reference":null,"Publisher":null,"Name":"IAS","Topic":null,"SubTopic":null,"Number":"1","Section":"","Footnote":null,"Subsection":null,"IssueDate":"1/1/2021","Paragraph":"55","SubParagraph":null,"Clause":"","URI":"http://eifrs.i